/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.model.QuotaType;
import kd.wtc.wtes.business.quota.model.QuotaTypeTable;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitQTTypeForQuota
implements QuotaParamInitializer {
    private static final String[] SELECTS = new String[]{"id", "name", "number"};

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        List<Long> regQtTypeIds;
        ArrayList qtTypeIds = Lists.newArrayListWithExpectedSize((int)16);
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        if (!CollectionUtils.isEmpty(dyQtTypeIds)) {
            qtTypeIds.addAll(dyQtTypeIds);
        }
        if (!CollectionUtils.isEmpty(regQtTypeIds = initRequest.getRequest().getRegQtTypeIds())) {
            qtTypeIds.addAll(regQtTypeIds);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)qtTypeIds)};
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)qtTypeIds.size());
        Map roundDyMap = BusinessDataServiceHelper.loadFromCache((String)"wtp_qttype", (String)String.join((CharSequence)",", SELECTS), (QFilter[])qFilters);
        for (Map.Entry entry : roundDyMap.entrySet()) {
            DynamicObject dy = (DynamicObject)entry.getValue();
            QuotaType quotaType = new QuotaType();
            quotaType.setName(dy.getString("name"));
            quotaType.setNumber(dy.getString("number"));
            map.put(dy.getLong("id"), quotaType);
        }
        QuotaTypeTable quotaTypeTable = new QuotaTypeTable(map);
        return QuotaInitParamResult.success(quotaTypeTable);
    }

    @Override
    public String category() {
        return "QT_TYPE";
    }
}

