/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailSingle;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailTable;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;

public class TieInitializerAttRecordDetailForQuota {
    private static final Log log = LogFactory.getLog(TieInitializerAttRecordDetailForQuota.class);
    private static final int QUERY_MAX = 450000;
    private Set<Long> attItems;
    private AttRecordDetailHolder holder;
    private QuotaInitParamRequest initRequest;
    private static final String[] SELECTS = new String[]{"attmain.id", "attitemid.id", "owndate", "attitemvid.id", "value", "valuesecond", "valuelong", "valuestring", "attitemvid.unit", "attitemvid.datatype"};

    public static TieInitializerAttRecordDetailForQuota of(Set<Long> attItems, AttRecordDetailHolder holder, QuotaInitParamRequest initRequest) {
        TieInitializerAttRecordDetailForQuota init = new TieInitializerAttRecordDetailForQuota();
        init.attItems = attItems;
        init.holder = holder;
        init.initRequest = initRequest;
        return init;
    }

    public AttRecordDetailTable doInit() {
        Date cycMaxDate;
        String callBy = (String)this.initRequest.getExtAttribute("KEY_CALL_BY");
        if ("CALL_BY_MS_FOR_INSERT_QT_DETAIL".equals(callBy)) {
            return new AttRecordDetailTable(Collections.emptyMap(), Collections.emptyMap());
        }
        if (null == this.holder || WTCCollections.isEmpty(this.holder.getCycSetMap()) || WTCCollections.isEmpty(this.attItems)) {
            return new AttRecordDetailTable(Collections.emptyMap(), Collections.emptyMap());
        }
        if (null != this.attItems && this.attItems.size() == 1 && this.attItems.contains(0L)) {
            return new AttRecordDetailTable(Collections.emptyMap(), Collections.emptyMap());
        }
        Date cycMinDate = this.holder.getCycMinDate();
        if (null == cycMinDate) {
            cycMinDate = WTCDateUtils.toDate((LocalDate)this.initRequest.getStartDate());
        }
        if (null == (cycMaxDate = this.holder.getCycMaxDate())) {
            cycMaxDate = WTCDateUtils.toDate((LocalDate)this.initRequest.getStartDate());
        }
        List<AttPersonRange> attPersonRanges = this.initRequest.getAttSubjects();
        HashSet<Long> attFileBoIds = new HashSet<Long>();
        for (AttPersonRange attPersonRange : attPersonRanges) {
            attFileBoIds.addAll(attPersonRange.getAllFileBoIdList());
        }
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        String selectStr = "id,personid.id,perattperiodid.id,attfileid";
        QFilter[] qFilters = new QFilter[]{new QFilter("attfileid", "in", attFileBoIds), new QFilter("owndate", ">=", (Object)cycMinDate), new QFilter("owndate", "<=", (Object)cycMaxDate)};
        DynamicObject[] baseDys = baseHelper.query(selectStr, qFilters);
        if (baseDys.length < 1) {
            return new AttRecordDetailTable(Collections.emptyMap(), Collections.emptyMap());
        }
        Map baseMap = Arrays.stream(baseDys).collect(Collectors.toMap(base -> base.getLong("id"), Function.identity(), (key1, key2) -> key2));
        List<Long> baseIds = Arrays.stream(baseDys).map(base -> base.getLong("id")).collect(Collectors.toList());
        log.warn("TieInitializerAttRecordDetailForQuota_version_{}_attitem.size_{}_baseIds_{}", new Object[]{this.initRequest.getRequest().getVersion(), this.attItems.size(), baseIds.size()});
        List<AttRecordDetailSingle> singleList = this.selectBatchData(baseIds, cycMinDate, cycMaxDate);
        log.warn("TieInitializerAttRecordDetailForQuota_version_{}_singleList_{}", (Object)this.initRequest.getRequest().getVersion(), (Object)singleList.size());
        HashMap attRecordDetailTableMap = Maps.newHashMapWithExpectedSize((int)singleList.size());
        HashMap attRecordDetailTableMapByBid = Maps.newHashMapWithExpectedSize((int)singleList.size());
        for (AttRecordDetailSingle detailSingle : singleList) {
            HashMap<Long, AttRecordDetailSingle> mapByBoId;
            HashMap<Long, AttRecordDetailSingle> map;
            Long baseId = detailSingle.getAttMainId();
            Long attItemId = detailSingle.getAttItemId();
            DynamicObject baseDy = (DynamicObject)baseMap.get(baseId);
            if (null == baseDy) continue;
            Long bid = baseDy.getLong("attfileid");
            Long attPersonId = baseDy.getLong("personid.id");
            LocalDate ownDate = WTCDateUtils.toLocalDate((Date)detailSingle.getOwnDate());
            HashMap dateMap = (HashMap)attRecordDetailTableMap.get(attPersonId);
            HashMap dateByBoIdMap = (HashMap)attRecordDetailTableMapByBid.get(bid);
            if (MapUtils.isEmpty((Map)dateMap)) {
                dateMap = new HashMap(4);
            }
            if (MapUtils.isEmpty((Map)(map = (HashMap<Long, AttRecordDetailSingle>)dateMap.get(ownDate)))) {
                map = new HashMap<Long, AttRecordDetailSingle>(4);
            }
            if (MapUtils.isEmpty((Map)dateByBoIdMap)) {
                dateByBoIdMap = new HashMap(4);
            }
            if (MapUtils.isEmpty((Map)(mapByBoId = (HashMap<Long, AttRecordDetailSingle>)dateByBoIdMap.get(ownDate)))) {
                mapByBoId = new HashMap<Long, AttRecordDetailSingle>(4);
            }
            AttRecordDetailSingle single = new AttRecordDetailSingle();
            single.setAttPersonId(attPersonId);
            single.setAttItemId(detailSingle.getAttItemId());
            single.setAttItemFid(detailSingle.getAttItemFid());
            single.setValue(detailSingle.getValue());
            single.setValueSecond(detailSingle.getValueSecond());
            single.setValueLong(detailSingle.getValueLong());
            single.setValueString(detailSingle.getValueString());
            single.setPerAttPeriodId(baseDy.getLong("perattperiodid.id"));
            single.setDateType(detailSingle.getDateType());
            map.put(attItemId, single);
            dateMap.put(ownDate, map);
            mapByBoId.put(attItemId, single);
            dateByBoIdMap.put(ownDate, mapByBoId);
            attRecordDetailTableMap.put(attPersonId, dateMap);
            attRecordDetailTableMapByBid.put(bid, dateByBoIdMap);
        }
        return new AttRecordDetailTable(attRecordDetailTableMap, attRecordDetailTableMapByBid);
    }

    private List<AttRecordDetailSingle> getDetails(List<Long> baseIds, Date startDate, Date endDate) {
        ArrayList detailDys = Lists.newArrayListWithExpectedSize((int)(baseIds.size() * 4));
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("attmain.id", "in", baseIds), new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate), new QFilter("attitemid", "in", this.attItems)};
        long start = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = detailHelper.query(String.join((CharSequence)",", SELECTS), qFilters);
        long end = System.currentTimeMillis();
        log.warn("TieInitCycleSetForQuota_init_version\uff3fqueryTime{}", (Object)this.initRequest.getRequest().getVersion(), (Object)(end - start));
        for (DynamicObject dyn : dynamicObjects) {
            AttRecordDetailSingle single = this.rowToSingle(dyn);
            detailDys.add(single);
        }
        long buildEnd = System.currentTimeMillis();
        log.warn("TieInitCycleSetForQuota_init_version\uff3fqueryTime{}", (Object)this.initRequest.getRequest().getVersion(), (Object)(buildEnd - end));
        return detailDys;
    }

    private AttRecordDetailSingle rowToSingle(DynamicObject dyn) {
        AttRecordDetailSingle single = new AttRecordDetailSingle();
        single.setAttMainId(dyn.getLong("attmain.id"));
        single.setAttItemId(dyn.getLong("attitemid.id"));
        single.setOwnDate(dyn.getDate("owndate"));
        single.setAttItemFid(dyn.getLong("attitemvid.id"));
        single.setValue(dyn.getBigDecimal("value"));
        single.setValueSecond(dyn.getBigDecimal("valuesecond"));
        single.setValueLong(dyn.getBigDecimal("valuelong"));
        single.setValueString(dyn.getString("valuestring"));
        single.setDateType(dyn.getString("attitemvid.datatype"));
        return single;
    }

    public List<AttRecordDetailSingle> selectBatchData(List<Long> dataList, Date startDate, Date endDate) {
        Integer size = dataList.size();
        int delCount = size / 450000;
        if (size % 450000 != 0) {
            ++delCount;
        }
        ArrayList detailDys = Lists.newArrayListWithExpectedSize((int)(dataList.size() * 4));
        for (int i = 0; i < delCount; ++i) {
            ArrayList copyList = Lists.newArrayListWithExpectedSize((int)450000);
            if (i == delCount - 1) {
                copyList.addAll(WTCCollections.subList(dataList, (int)0, (int)dataList.size()));
            } else {
                copyList.addAll(WTCCollections.subList(dataList, (int)0, (int)450000));
                WTCCollections.subList(dataList, (int)0, (int)450000).clear();
            }
            detailDys.addAll(this.getDetails(copyList, startDate, endDate));
        }
        return detailDys;
    }
}

