/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTAdjustDetailInfo;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjust;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjustTable;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;

public class TieInitializerMdfyDetailForQuota
implements QuotaParamInitializer {
    private static final String[] SELECTS = new String[]{"attfileid.boid", "crossday", "mdfymethod", "mdfyvalue", "periodcircleid.id", "periodnum", "qtdetailid", "qttypeid.id", "source", "createtime", "id", "isdpconvert", "modifytime"};

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        int size;
        List<QTDetailAdjust> adjusts;
        if (QTAccountModeHelper.isDeductChain((String)initRequest.getRequest().getAccountMode())) {
            return QuotaInitParamResult.success(new QTDetailAdjustTable());
        }
        List<Long> regQtTypeIds = initRequest.getRequest().getRegQtTypeIds();
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        ArrayList qtTypes = Lists.newArrayListWithExpectedSize((int)16);
        if (WTCCollections.isNotEmpty(regQtTypeIds)) {
            qtTypes.addAll(regQtTypeIds);
        }
        if (WTCCollections.isNotEmpty(dyQtTypeIds)) {
            qtTypes.addAll(dyQtTypeIds);
        }
        List<AttPersonRange> attPersonRanges = initRequest.getAttSubjects();
        HashSet<Long> attFileBoIds = new HashSet<Long>();
        for (AttPersonRange attPersonRange : attPersonRanges) {
            attFileBoIds.addAll(attPersonRange.getAllFileBoIdList());
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("attfileid.boid", "in", attFileBoIds), new QFilter("qttypeid", "in", (Object)qtTypes), new QFilter("status", "=", (Object)"C")};
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtte_quotadetailmdfy");
        DynamicObject[] baseDys = baseHelper.query(String.join((CharSequence)",", SELECTS), qFilters);
        ArrayList<QTDetailAdjust> qtDetailAdjusts = new ArrayList<QTDetailAdjust>();
        if (baseDys != null && baseDys.length > 0) {
            for (DynamicObject dy : baseDys) {
                QTDetailAdjust qtDetailAdjust = this.buildQTDetailAdjust(dy);
                qtDetailAdjusts.add(qtDetailAdjust);
            }
        }
        Map<Long, List<QTDetailAdjust>> map = qtDetailAdjusts.stream().collect(Collectors.groupingBy(QTAdjustDetailInfo::getAttFileBoId));
        Map<String, List<QTDetailAdjust>> sysMap = qtDetailAdjusts.stream().filter(adjust -> QuotaDetailType.CUR_PERIOD_GEN.getCode().equals(adjust.getSource())).collect(Collectors.groupingBy(adjust -> this.getRuleKey((QTDetailAdjust)adjust)));
        Map<Long, List<QTDetailAdjust>> detailIdMap = qtDetailAdjusts.stream().collect(Collectors.groupingBy(QTAdjustDetailInfo::getQtDetailId));
        HashMap detailConvertById = Maps.newHashMapWithExpectedSize((int)16);
        HashMap detailConvertByRule = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<QTDetailAdjust>> entry : sysMap.entrySet()) {
            adjusts = entry.getValue();
            adjusts = adjusts.stream().sorted(Comparator.comparing(QTDetailAdjust::getModfyTime)).collect(Collectors.toList());
            size = adjusts.size();
            detailConvertByRule.put(entry.getKey(), adjusts.get(size - 1).isDpConvert());
        }
        for (Map.Entry<Object, List<QTDetailAdjust>> entry : detailIdMap.entrySet()) {
            adjusts = entry.getValue();
            adjusts = adjusts.stream().sorted(Comparator.comparing(QTDetailAdjust::getModfyTime)).collect(Collectors.toList());
            size = adjusts.size();
            detailConvertById.put(entry.getKey(), adjusts.get(size - 1).isDpConvert());
        }
        QTDetailAdjustTable qtDetailAdjustTable = new QTDetailAdjustTable();
        qtDetailAdjustTable.setQtDetailAdjustMap(map);
        qtDetailAdjustTable.setDetailConvertById(detailConvertById);
        qtDetailAdjustTable.setDetailConvertByRule(detailConvertByRule);
        return QuotaInitParamResult.success(qtDetailAdjustTable);
    }

    @Override
    public String category() {
        return "QT_DETAIL_ADJUST";
    }

    private QTDetailAdjust buildQTDetailAdjust(DynamicObject dynamicObject) {
        QTDetailAdjust qtDetailAdjust = new QTDetailAdjust();
        qtDetailAdjust.setId(dynamicObject.getLong("id"));
        qtDetailAdjust.setAttFileBoId(dynamicObject.getLong("attfileid.boid"));
        qtDetailAdjust.setCrossDay(dynamicObject.getDate("crossday"));
        qtDetailAdjust.setMdfyMethod(dynamicObject.getString("mdfymethod"));
        qtDetailAdjust.setMdfyValue(dynamicObject.getBigDecimal("mdfyvalue"));
        qtDetailAdjust.setPeriodCircle(dynamicObject.getLong("periodcircleid.id"));
        qtDetailAdjust.setPeriodNum(dynamicObject.getLong("periodnum"));
        qtDetailAdjust.setQtDetailId(dynamicObject.getLong("qtdetailid.id"));
        qtDetailAdjust.setQttype(dynamicObject.getLong("qttypeid.id"));
        qtDetailAdjust.setSource(dynamicObject.getString("source"));
        qtDetailAdjust.setCreateTime(dynamicObject.getDate("createtime"));
        qtDetailAdjust.setModfyTime(dynamicObject.getDate("modifytime"));
        qtDetailAdjust.setDpConvert(dynamicObject.getBoolean("isdpconvert"));
        return qtDetailAdjust;
    }

    private String getRuleKey(QTDetailAdjust adjust) {
        String crossDayStr = "";
        if (adjust.getCrossDay() != null) {
            crossDayStr = WTCDateUtils.date2Str((Date)adjust.getCrossDay(), (String)"yyyy.mm.dd");
        }
        String key = adjust.getAttFileBoId() + "_" + adjust.getQttype() + "_" + adjust.getPeriodCircle() + "_" + adjust.getPeriodNum();
        key = StringUtils.isEmpty((CharSequence)crossDayStr) ? key : key + "_" + crossDayStr;
        return key;
    }
}

