/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.model;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtp.business.cumulate.calculate.model.QTDeductRule;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class DeductEnv {
    private Map<Long, Long> itemVid2ItemBoIdMap;
    private final Map<Long, Map<Long, QTCalRule>> fileBo2LineRuleMap = new ConcurrentHashMap<Long, Map<Long, QTCalRule>>(16);
    private Map<Long, List<QTBillDeal>> fileBo2BillDealMap;
    private Set<Long> billSetExistRepeatBillDeal;
    private Map<Long, List<QTBillDeal>> useToRepairLineBDMap;
    private Map<Long, QTDeductRule> deductRuleMap;
    private Map<Long, String> failAttFileBoMap;
    private Map<Long, List<BillApply>> fileBo2BillMap;
    private Map<Long, List<QTLineDetail>> fileBo2LineMap;
    private Date minLineStartDate;
    private Date maxLineEndDate;

    public List<QTBillDeal> getRepairLineBDByFileBoId(long fileBoId) {
        return this.useToRepairLineBDMap.getOrDefault(fileBoId, WTCCollections.modifiableEmptyList());
    }

    public List<QTBillDeal> getBillDealListByFileBoId(long fileBoId) {
        return this.getFileBo2BillDealMap().getOrDefault(fileBoId, WTCCollections.modifiableEmptyList());
    }

    public List<QTBillDeal> handOverBillDealListByFileBoId(long fileBoId) {
        List<QTBillDeal> remove = this.getFileBo2BillDealMap().remove(fileBoId);
        return remove == null ? WTCCollections.modifiableEmptyList() : remove;
    }

    public List<QTLineDetail> getLineDetailByFileBoId(Long fileBoId) {
        return this.fileBo2LineMap.getOrDefault(fileBoId, WTCCollections.modifiableEmptyList());
    }

    public List<BillApply> getBillsByFileBoId(Long fileBoId) {
        String errMsg = this.getFailAttFileBoMap().get(fileBoId);
        if (WTCStringUtils.isNotEmpty((String)errMsg)) {
            throw new WtesException(errMsg);
        }
        List<BillApply> bills = this.getFileBo2BillMap().get(fileBoId);
        return bills == null ? WTCCollections.modifiableEmptyList() : bills;
    }

    public List<BillApply> handOverBillsByFileBoId(Long fileBoId) {
        String errMsg = this.getFailAttFileBoMap().get(fileBoId);
        if (WTCStringUtils.isNotEmpty((String)errMsg)) {
            throw new WtesException(errMsg);
        }
        List<BillApply> bills = this.getFileBo2BillMap().remove(fileBoId);
        return bills == null ? WTCCollections.modifiableEmptyList() : bills;
    }

    public void initLineUseDateRange() {
        for (List<QTLineDetail> lineList : this.fileBo2LineMap.values()) {
            for (QTLineDetail line : lineList) {
                if (this.minLineStartDate == null || line.getGenStartDate().before(this.minLineStartDate)) {
                    this.minLineStartDate = line.getGenStartDate();
                }
                if (this.maxLineEndDate != null && !line.getGenEndDate().after(this.maxLineEndDate)) continue;
                this.maxLineEndDate = line.getGenEndDate();
            }
        }
    }

    public void putLineRuleMap(long fileBoId, Map<Long, QTCalRule> lineRuleMap) {
        this.fileBo2LineRuleMap.put(fileBoId, lineRuleMap);
    }

    public Map<Long, QTCalRule> getLineRuleMap(long fileBoId) {
        return this.fileBo2LineRuleMap.get(fileBoId);
    }

    public Map<Long, QTCalRule> handOverLineRuleMap(long fileBoId) {
        return this.fileBo2LineRuleMap.remove(fileBoId);
    }

    public boolean existRepeatBillDeal(long billId) {
        return this.billSetExistRepeatBillDeal.contains(billId);
    }

    public long getItemBoIdByVid(long itemVid) {
        return this.itemVid2ItemBoIdMap.getOrDefault(itemVid, 0L);
    }

    public Map<Long, Long> getItemVid2ItemBoIdMap() {
        return this.itemVid2ItemBoIdMap;
    }

    public void setItemVid2ItemBoIdMap(Map<Long, Long> itemVid2ItemBoIdMap) {
        this.itemVid2ItemBoIdMap = itemVid2ItemBoIdMap;
    }

    public Map<Long, QTDeductRule> getDeductRuleMap() {
        return this.deductRuleMap;
    }

    public void setDeductRuleMap(Map<Long, QTDeductRule> deductRuleMap) {
        this.deductRuleMap = deductRuleMap;
    }

    public Map<Long, String> getFailAttFileBoMap() {
        return this.failAttFileBoMap;
    }

    public void setFailAttFileBoMap(Map<Long, String> failAttFileBoMap) {
        this.failAttFileBoMap = failAttFileBoMap;
    }

    public Map<Long, List<BillApply>> getFileBo2BillMap() {
        return this.fileBo2BillMap;
    }

    public void setFileBo2BillMap(Map<Long, List<BillApply>> fileBo2BillMap) {
        this.fileBo2BillMap = fileBo2BillMap;
    }

    public Map<Long, List<QTLineDetail>> getFileBo2LineMap() {
        return this.fileBo2LineMap;
    }

    public void setFileBo2LineMap(Map<Long, List<QTLineDetail>> fileBo2LineMap) {
        this.fileBo2LineMap = fileBo2LineMap;
    }

    public Date getMinLineStartDate() {
        return this.minLineStartDate;
    }

    public Date getMaxLineEndDate() {
        return this.maxLineEndDate;
    }

    public Map<Long, List<QTBillDeal>> getFileBo2BillDealMap() {
        return this.fileBo2BillDealMap;
    }

    public void setFileBo2BillDealMap(Map<Long, List<QTBillDeal>> fileBo2BillDealMap) {
        this.fileBo2BillDealMap = fileBo2BillDealMap;
    }

    public Set<Long> getBillSetExistRepeatBillDeal() {
        return this.billSetExistRepeatBillDeal;
    }

    public void setBillSetExistRepeatBillDeal(Set<Long> billSetExistRepeatBillDeal) {
        this.billSetExistRepeatBillDeal = billSetExistRepeatBillDeal;
    }

    public Map<Long, List<QTBillDeal>> getUseToRepairLineBDMap() {
        return this.useToRepairLineBDMap;
    }

    public void setUseToRepairLineBDMap(Map<Long, List<QTBillDeal>> useToRepairLineBDMap) {
        this.useToRepairLineBDMap = useToRepairLineBDMap;
    }
}

