/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.model;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillCalResult;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.billcal.IBillCalService;
import kd.wtc.wtes.business.billcal.va.VaBillCalService;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.quotacal.va.QuotaCalBatchReq;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDeal;

public class QuotaBillCalInfo {
    private static final Log LOGGER = WTCLogFactory.getLog(QuotaBillCalInfo.class);
    private Map<String, Object> initParams;
    private List<AttPersonRange> attSubjects;
    private QuotaRequest quotaRequest;
    private Map<Long, List<BillApply>> billMap;
    private Map<Long, String> failAttFileMap;

    public QuotaBillCalInfo(List<AttPersonRange> attSubjects, Map<String, Object> initParams, QuotaRequest quotaRequest) {
        this.initParams = initParams;
        this.attSubjects = attSubjects;
        this.quotaRequest = quotaRequest;
        this.init();
    }

    private void init() {
        AttRecordDetailHolder holder = (AttRecordDetailHolder)this.initParams.get("QT_ATT_RECORD_DETAIL");
        if (null == this.attSubjects || null == holder || WTCCollections.isEmpty(holder.getCycSetMap()) || QTAccountModeHelper.isDeductChain((String)this.quotaRequest.getAccountMode()) || !this.quotaRequest.isRealTimeComputingBills()) {
            this.billMap = Collections.EMPTY_MAP;
            this.failAttFileMap = Collections.EMPTY_MAP;
            this.initParams.put("QT_BILL_CAL", this);
            LOGGER.debug("QuotaBillCalInfo_not_call_cal_service");
            return;
        }
        Date minDate = this.attSubjects.stream().map(item -> item.getAttFileInfoList().stream().map(AttFileInfo::getStartDate).collect(Collectors.toList())).collect(Collectors.toList()).stream().flatMap(Collection::stream).sorted(Comparator.comparing(Date::getTime)).findFirst().get();
        Date maxDate = this.attSubjects.stream().map(item -> item.getAttFileInfoList().stream().map(AttFileInfo::getEndDate).collect(Collectors.toList())).collect(Collectors.toList()).stream().flatMap(Collection::stream).sorted(Comparator.comparing(Date::getTime).reversed()).findFirst().get();
        Optional<CircleRestVo> minDateVo = holder.getCycSetMap().values().stream().filter(QuotaCycInfo::isSuccessFlag).map(cycSet -> cycSet.getRestVos().stream().filter(info -> info.getStartDate().compareTo(maxDate) <= 0 && info.getEndDate().compareTo(minDate) >= 0).min(Comparator.comparing(CircleRestVo::getStartDate)).orElse(null)).filter(Objects::nonNull).min(Comparator.comparing(CircleRestVo::getStartDate));
        Optional<CircleRestVo> maxDateVo = holder.getCycSetMap().values().stream().filter(QuotaCycInfo::isSuccessFlag).map(cycSet -> cycSet.getRestVos().stream().filter(info -> info.getStartDate().compareTo(maxDate) <= 0 && info.getEndDate().compareTo(minDate) >= 0).max(Comparator.comparing(CircleRestVo::getEndDate)).orElse(null)).filter(Objects::nonNull).max(Comparator.comparing(CircleRestVo::getEndDate));
        LocalDate expectStartDate = minDateVo.isPresent() ? WTCDateUtils.toLocalDate((Date)minDateVo.get().getStartDate()) : this.quotaRequest.getStartDate();
        LocalDate expectEndDate = maxDateVo.isPresent() ? WTCDateUtils.toLocalDate((Date)maxDateVo.get().getEndDate()) : this.quotaRequest.getEndDate();
        Map<Long, Map<DetailLogicKey, List<QTBillDeal>>> boDetailLKListMap = holder.getBoDetailLKListMap();
        if (boDetailLKListMap != null) {
            List bedList = boDetailLKListMap.values().stream().filter(Objects::nonNull).flatMap(ele -> ele.values().stream()).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).flatMap(ele -> ele.getEntryDealList().stream()).filter(Objects::nonNull).collect(Collectors.toList());
            Date tMinDate = null;
            Date tMaxDate = null;
            for (QTBillEntryDeal bed : bedList) {
                Date sDate = bed.getStartDate();
                Date eDate = bed.getEndDate();
                if (tMinDate == null) {
                    tMinDate = sDate;
                }
                if (sDate.before(tMinDate)) {
                    tMinDate = sDate;
                }
                if (tMaxDate == null) {
                    tMaxDate = eDate;
                }
                if (!eDate.after(tMaxDate)) continue;
                tMaxDate = eDate;
            }
            if (tMinDate != null) {
                LocalDate localMinDate = WTCDateUtils.toLocalDate(tMinDate);
                expectStartDate = expectStartDate == null ? localMinDate : expectStartDate;
                LocalDate localDate = expectEndDate = expectEndDate == null ? localMinDate : expectEndDate;
                if (localMinDate.isBefore(expectStartDate)) {
                    expectStartDate = localMinDate;
                }
                if (localMinDate.isAfter(expectEndDate)) {
                    expectEndDate = localMinDate;
                }
            }
            if (tMaxDate != null) {
                LocalDate localMaxDate = WTCDateUtils.toLocalDate(tMaxDate);
                if (localMaxDate.isBefore(expectStartDate)) {
                    expectStartDate = localMaxDate;
                }
                if (localMaxDate.isAfter(expectEndDate)) {
                    expectEndDate = localMaxDate;
                }
            }
        }
        LinkedHashMap personInfo = Maps.newLinkedHashMapWithExpectedSize((int)16);
        this.attSubjects.forEach(item -> item.getAttFileInfoList().forEach(attFileInfo -> personInfo.put(attFileInfo.getAttFileBaseBoId(), attFileInfo.getPersonId())));
        IBillCalService vaBillCalService = (IBillCalService)WTCAppContextHelper.getBean(VaBillCalService.class);
        QuotaCalBatchReq quotaReq = new QuotaCalBatchReq().setBillIds(Collections.emptyList()).setLoggingProcess(false).setPersonInfos(personInfo).setStartDate(expectStartDate).setEndDate(expectEndDate);
        quotaReq.setTiePlanId(this.quotaRequest.getTiePlanId());
        quotaReq.setInitParams(this.initParams);
        BillCalResult billCalResult = vaBillCalService.calBillDeductionBatch(quotaReq);
        this.failAttFileMap = WTCCollections.isEmpty((Map)billCalResult.getFailAttFileMap()) ? Collections.EMPTY_MAP : billCalResult.getFailAttFileMap();
        Map<Long, List<BillApply>> resultMap = billCalResult.getCalcBillApplies().stream().collect(Collectors.groupingBy(BillApply::getAttFileBoId));
        Map<Long, List<BillApply>> map = this.billMap = WTCCollections.isEmpty(resultMap) ? Collections.EMPTY_MAP : resultMap;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("QuotaBillCalInfo call bill cal res:{}, failMap:{}", resultMap, this.failAttFileMap);
        }
        this.initParams.put("QT_BILL_CAL", this);
    }

    public List<BillApply> billCalListByAttFileBoId(Long attFileBoId) {
        if (WTCStringUtils.isNotEmpty((String)this.failAttFileMap.get(attFileBoId))) {
            throw new WtesException(this.failAttFileMap.get(attFileBoId));
        }
        List<BillApply> billApplies = this.billMap.get(attFileBoId);
        if (WTCCollections.isEmpty(billApplies)) {
            return Collections.emptyList();
        }
        return billApplies;
    }
}

