/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.sdk.wtc.wtes.business.qte.init.BeforeQteCycSetInitEvent;
import kd.sdk.wtc.wtes.business.qte.init.QteCycSetInitExtPlugin;
import kd.sdk.wtc.wtes.business.qte.init.model.CircleConfig;
import kd.sdk.wtc.wtes.business.qte.init.model.CircleRest;
import kd.wtc.wtbs.business.cirenum.AssignTypeEnum;
import kd.wtc.wtbs.business.cirenum.AssignUnitEnum;
import kd.wtc.wtbs.business.cirenum.CircleUnitEnum;
import kd.wtc.wtbs.business.cirenum.WeekLoopDayEnum;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.model.CircleConfigVo;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.util.duringcycle.CircleCalHelper;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.model.rlqt.QTType;
import kd.wtc.wtes.business.model.rlqt.QTUseConfig;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.model.QuotaExtPluginHolder;
import kd.wtc.wtes.business.quota.model.QuotaType;
import kd.wtc.wtes.business.quota.model.QuotaTypeTable;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.util.RefDateUtils;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;

public class QuotaCycSetData {
    private static final Log LOGGER = WTCLogFactory.getLog(QuotaCycSetData.class);
    private static String KEY_APPEND = "_";
    private InitParam initRequest;
    private LocalDate endDate;
    private LocalDate startDate;
    private Map<Long, DynamicObject> cycleMap;
    private Map<Long, DynamicObject> cycleDateMap;

    public static QuotaCycSetData of(InitParam initRequest, Map<Long, DynamicObject> cycleMap, Map<Long, DynamicObject> cycleDateMap) {
        QuotaCycSetData quotaCycSetData = new QuotaCycSetData();
        quotaCycSetData.initRequest = initRequest;
        quotaCycSetData.startDate = initRequest.getStartDate();
        quotaCycSetData.endDate = initRequest.getEndDate();
        quotaCycSetData.cycleMap = cycleMap;
        quotaCycSetData.cycleDateMap = cycleDateMap;
        return quotaCycSetData;
    }

    public Map<String, QuotaCycInfo> getCycSetDataNew() {
        HashSet qtTypeIds = Sets.newHashSetWithExpectedSize((int)16);
        List<Long> dyQtTypeIds = ((QuotaRequest)this.initRequest.getRequest()).getDyQtTypeIds();
        qtTypeIds.addAll(dyQtTypeIds);
        List<Long> regQtTypeIds = ((QuotaRequest)this.initRequest.getRequest()).getRegQtTypeIds();
        qtTypeIds.addAll(regQtTypeIds);
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.initRequest.getInitParams().get("ATT_FILE");
        AttendPersonData attendPersonData = (AttendPersonData)((Object)this.initRequest.getInitParams().get("ATT_PERINFO"));
        QuotaTypeTable quotaTypeTable = (QuotaTypeTable)this.initRequest.getInitParams().get("QT_TYPE");
        List<AttPersonRange> attPersonRangeList = ((QuotaInitParamRequest)this.initRequest).getAttSubjects();
        HashMap maps = Maps.newHashMapWithExpectedSize((int)attPersonRangeList.size());
        for (AttPersonRange attPersonRange : attPersonRangeList) {
            for (AttFileInfo fileInfo : attPersonRange.getAttFileInfoList()) {
                this.processCycSetData(attFileCabinet, attendPersonData, fileInfo, qtTypeIds, maps, quotaTypeTable);
            }
            AttFileInfo attFileInfo = attPersonRange.getAttFileInfoList().get(0);
            LocalDate preFileBoEndDate = WTCDateUtils.toLocalDate((Date)WTCDateUtils.addDays((Date)attFileInfo.getStartDate(), (int)-1));
            this.setNextOrPreAttFileInfo(attFileCabinet, attendPersonData, attPersonRange, attFileInfo, preFileBoEndDate, qtTypeIds, maps, true, quotaTypeTable);
            AttFileInfo lastAttFileInfo = attPersonRange.getAttFileInfoList().get(attPersonRange.getAttFileInfoList().size() - 1);
            LocalDate nextFileBoStartDate = WTCDateUtils.toLocalDate((Date)WTCDateUtils.addDays((Date)lastAttFileInfo.getEndDate(), (int)1));
            this.setNextOrPreAttFileInfo(attFileCabinet, attendPersonData, attPersonRange, lastAttFileInfo, nextFileBoStartDate, qtTypeIds, maps, false, quotaTypeTable);
        }
        return maps;
    }

    private void setNextOrPreAttFileInfo(AttFileCabinet attFileCabinet, AttendPersonData attendPersonData, AttPersonRange attPersonRange, AttFileInfo attFileInfo, LocalDate date, Set<Long> qtTypeIds, Map<String, QuotaCycInfo> maps, boolean isPre, QuotaTypeTable quotaTypeTable) {
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate((long)attFileInfo.getPersonId(), date);
        if (attFileModel != null) {
            AttFileInfo newAttFileInfo = new AttFileInfo();
            newAttFileInfo.setPersonId(attFileInfo.getPersonId());
            newAttFileInfo.setAttFileBaseBoId(attFileModel.getBid());
            newAttFileInfo.setStartDate(attFileModel.getStartDateTime());
            newAttFileInfo.setEndDate(attFileModel.getEndDateTime());
            newAttFileInfo.setEmployeeId(attFileModel.getEmployeeId());
            this.processCycSetData(attFileCabinet, attendPersonData, attFileInfo, qtTypeIds, maps, quotaTypeTable);
            if (isPre) {
                attPersonRange.setPreAttFileInfo(newAttFileInfo);
            } else {
                attPersonRange.setNextAttFileInfo(newAttFileInfo);
            }
        }
    }

    private void processCycSetData(AttFileCabinet attFileCabinet, AttendPersonData attendPersonData, AttFileInfo fileInfo, Set<Long> qtTypeIds, Map<String, QuotaCycInfo> maps, QuotaTypeTable quotaTypeTable) {
        QTRule qtRule;
        Long attPersonId = fileInfo.getPersonId();
        Long fileBoId = fileInfo.getAttFileBaseBoId();
        LocalDate endDate = WTCDateUtils.toLocalDate((Date)fileInfo.getEndDate());
        AttFileModel byAttPersonIdAndDate = attFileCabinet.getByAttPersonIdAndDate((long)attPersonId, endDate);
        if (null == byAttPersonIdAndDate) {
            return;
        }
        AttendPersonModel byBidAndDate = attendPersonData.getByBidAndDate(byAttPersonIdAndDate, endDate);
        if (null == byBidAndDate) {
            return;
        }
        QTScheme attQtPackage = byAttPersonIdAndDate.getAttQtPackage(endDate);
        if (null == attQtPackage) {
            return;
        }
        QTRule qTRule = qtRule = attQtPackage.isRuleEngine() ? this.getQTRuleByEngine(attQtPackage, attPersonId, endDate, this.initRequest, fileBoId) : (QTRule)attQtPackage.getQtRule().getVersionByDate(endDate);
        if (null == qtRule) {
            if (attQtPackage.isRuleEngine()) {
                String errorMsg = ResManager.loadKDString((String)"\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u8003\u52e4\u6863\u6848\u4e2d\u7684\u5b9a\u989d\u65b9\u6848\u4e0b\u89c4\u5219\u5f15\u64ce\u7684\u89c4\u5219\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u5b9a\u989d\u65b9\u6848\u4e2d\u89c4\u5219\u5f15\u64ce\u76f8\u5173\u914d\u7f6e\u3002", (String)"QuotaCycSetData_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
                maps.put(String.valueOf(fileBoId), new QuotaCycInfo(errorMsg));
            }
            return;
        }
        for (QTCalRule rule : qtRule.getQtRules()) {
            QTType qtType;
            TimeSeqAvailableBo<QTGenConfig> genConfigSeq = rule.getGenConfig();
            if (null == genConfigSeq) continue;
            QTGenConfig genConfig = (QTGenConfig)genConfigSeq.getVersionByDate(endDate);
            TimeSeqAvailableBo<QTUseConfig> useConfigSeq = rule.getUseConfig();
            QTUseConfig qtUseConfig = null;
            if (null != useConfigSeq) {
                qtUseConfig = (QTUseConfig)useConfigSeq.getVersionByDate(endDate);
            }
            if (!qtTypeIds.contains((qtType = genConfig.getQtType()).getId())) continue;
            Long cycSetDate = genConfig.getCycDateSet();
            Long cycSet = genConfig.getCycSet();
            DynamicObject cydSetDy = this.cycleMap.get(cycSet);
            DynamicObject cycSetDateDy = this.cycleDateMap.get(cycSetDate);
            List<QTGenConfigEntry> qtGenConfigEntries = genConfig.getQtGenConfigEntries();
            long enjoyAttItem = 0L;
            long usableAttItem = 0L;
            if (WTCCollections.isNotEmpty(qtGenConfigEntries)) {
                QTGenConfigEntry configEntry = qtGenConfigEntries.get(0);
                enjoyAttItem = configEntry.getEnjoyAttItem();
                usableAttItem = configEntry.getUsableAttItem();
            }
            try {
                Map<Long, Date> refDateMap = this.getRefDateMap(byBidAndDate, cycSetDateDy, attPersonId, byAttPersonIdAndDate, endDate, this.initRequest.getInitParams());
                CircleConfigVo config = CircleCalHelper.getAndCheckConfig((DynamicObject)cydSetDy, (DynamicObject)cycSetDateDy, refDateMap, (Date)WTCDateUtils.toDate((LocalDate)this.endDate));
                QuotaExtPluginHolder pluginHolder = (QuotaExtPluginHolder)this.initRequest.getInitParams().get("QT_EXT_PLUGIN");
                WTCPluginProxy instance = (WTCPluginProxy)pluginHolder.getPlugin(QteCycSetInitExtPlugin.class.getName());
                BeforeQteCycSetInitEvent event = new BeforeQteCycSetInitEvent(attPersonId.longValue(), fileBoId.longValue(), QuotaCycSetData.ConfigVoToDto(config), this.initRequest.getInitParams());
                instance.invokeReplace(plugin -> plugin.beforeCycsetInit(event));
                List circleRestVos = !CollectionUtils.isEmpty((Collection)event.getCircleRestValues()) || event.isEmptyCircleTag() ? QuotaCycSetData.circleRestDtoToVo(event, config) : CircleCalHelper.getCircleByConfig((CircleConfigVo)config);
                List<CircleRestVo> restVos = this.initCycles(circleRestVos, attPersonId);
                maps.put(QuotaCycSetData.getMapKey(fileBoId, qtType.getId()), new QuotaCycInfo(restVos, enjoyAttItem, usableAttItem, qtUseConfig));
            }
            catch (Exception e) {
                maps.put(QuotaCycSetData.getMapKey(fileBoId, qtType.getId()), new QuotaCycInfo(e.getMessage()));
            }
        }
        for (Long qtTypeId : qtTypeIds) {
            QuotaType quotaType;
            QuotaCycInfo quotaCycInfo = maps.get(QuotaCycSetData.getMapKey(fileBoId, qtTypeId));
            if (quotaCycInfo != null || (quotaType = quotaTypeTable.getQuotaTypeById(qtTypeId)) == null) continue;
            String errorMsg = ResManager.loadKDString((String)"{0}\u65e0\u5bf9\u5e94\u8ba1\u7b97\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u6863\u6848\u4e0b\u5b9a\u989d\u89c4\u5219\u7684\u8ba1\u7b97\u89c4\u5219\u3002", (String)"QuotaCycSetData_2", (String)"wtc-wtes-business", (Object[])new Object[]{quotaType.getName()});
            maps.put(QuotaCycSetData.getMapKey(fileBoId, qtTypeId), new QuotaCycInfo(errorMsg));
        }
    }

    private static List<CircleRestVo> circleRestDtoToVo(BeforeQteCycSetInitEvent event, CircleConfigVo config) {
        if (event.isEmptyCircleTag()) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        ArrayList circleRestVos = Lists.newArrayListWithExpectedSize((int)event.getCircleRestValues().size());
        for (CircleRest circleRest : event.getCircleRestValues()) {
            CircleRestVo circleRestVo = new CircleRestVo();
            Date zeroEndDay = WTCDateUtils.getZeroDate((Date)circleRest.getEndDate());
            Date zeroStartDay = WTCDateUtils.getZeroDate((Date)circleRest.getStartDate());
            circleRestVo.setEndDate(WTCDateUtils.getDayLastDate((Date)circleRest.getEndDate()));
            circleRestVo.setIndex(circleRest.getIndex());
            circleRestVo.setStartDate(WTCDateUtils.getZeroDate((Date)circleRest.getStartDate()));
            circleRestVo.setInterval(circleRest.getInterval());
            circleRestVo.setAssign(config.getAssign());
            if (config.getAppointDate()) {
                if (CircleUnitEnum.CIRCLE_UNIT_WEEK == config.getCircleUnit()) {
                    circleRestVo.setAppointEndDate(WeekLoopDayEnum.getByKey((Integer)config.getWeekDate()).getName());
                } else if (CircleUnitEnum.CIRCLE_UNIT_MONTH == config.getCircleUnit()) {
                    String monthDate = config.getMonthDate() == -1 ? ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"QuotaCycSetData_3", (String)"wtc-wtes-business", (Object[])new Object[0]) : config.getMonthDate() + "";
                    circleRestVo.setAppointEndDate(monthDate);
                } else if (CircleUnitEnum.CIRCLE_UNIT_YEAR == config.getCircleUnit()) {
                    circleRestVo.setAppointEndDate(config.getYearDate());
                }
            }
            if (config.getAssign()) {
                circleRestVo.setAssignType(config.getAssignType().getNameCode());
                circleRestVo.setAssignUnit(config.getAssignUnit().getNameCode());
                Calendar seqBegin = Calendar.getInstance();
                seqBegin.setTime(zeroStartDay);
                Calendar seqEnd = Calendar.getInstance();
                seqEnd.setTime(zeroStartDay);
                Calendar calendar = AssignTypeEnum.getDateByType((AssignTypeEnum)config.getAssignType(), (Calendar)seqBegin, (Calendar)seqEnd);
                circleRestVo.setAssignDate(AssignUnitEnum.getAssignDate((Calendar)calendar, (AssignUnitEnum)config.getAssignUnit()));
            }
            circleRestVo.setCircleUnit(config.getCircleUnit().getNameCode());
            circleRestVo.setCirDay(Long.valueOf((zeroEndDay.getTime() - zeroStartDay.getTime()) / 86400000L + 1L));
            circleRestVo.setCirValue(circleRest.getCirValue());
            circleRestVo.setNumber(config.getName());
            circleRestVo.setCycSetId(config.getId());
            if (config.getIntervalUnit() != null) {
                circleRestVo.setIntervalUnit(config.getIntervalUnit().getNameCode());
            }
            circleRestVos.add(circleRestVo);
        }
        return circleRestVos;
    }

    private static CircleConfig ConfigVoToDto(CircleConfigVo configVo) {
        CircleConfig circleConfig = new CircleConfig();
        circleConfig.setAppointDate(configVo.getAppointDate());
        circleConfig.setBeginDate(configVo.getBeginDate());
        circleConfig.setBeginDateId(configVo.getBeginDateId().longValue());
        circleConfig.setCirValue(configVo.getCirValue());
        circleConfig.setCount(configVo.getCount());
        circleConfig.setDate(configVo.getDate());
        circleConfig.setEndDate(configVo.getEndDate());
        circleConfig.setId(configVo.getId());
        circleConfig.setInterval(configVo.getInterval());
        circleConfig.setIntervalStr(configVo.getIntervalStr());
        circleConfig.setMonth(configVo.getMonth());
        circleConfig.setMonthDate(configVo.getMonthDate());
        circleConfig.setName(configVo.getName());
        if (!CollectionUtils.isEmpty((Collection)configVo.getPerAttPeriods())) {
            ArrayList perAttPeriodDtos = Lists.newArrayListWithExpectedSize((int)configVo.getPerAttPeriods().size());
            for (PerAttPeriod perAttPeriod : configVo.getPerAttPeriods()) {
                kd.sdk.wtc.wtp.business.attperiod.PerAttPeriod perAttPeriodDto = QuotaCycSetData.getPerAttPeriodDto(perAttPeriod);
                perAttPeriodDtos.add(perAttPeriodDto);
            }
            circleConfig.setPerAttPeriods((List)perAttPeriodDtos);
        }
        circleConfig.setQtCalCall(configVo.isQtCalCall());
        circleConfig.setQtCalEndDate(configVo.getQtCalEndDate());
        if (configVo.getCircleUnit() != null) {
            circleConfig.setCircleUnitEnum(kd.sdk.wtc.wtes.business.qte.init.model.CircleUnitEnum.getByNameCode((String)configVo.getCircleUnit().getNameCode()));
        }
        if (configVo.getIntervalUnit() != null) {
            circleConfig.setCircleUnitEnum(kd.sdk.wtc.wtes.business.qte.init.model.CircleUnitEnum.getByNameCode((String)configVo.getIntervalUnit().getNameCode()));
        }
        circleConfig.setSelDate(configVo.getSelDate());
        circleConfig.setWeekDate(configVo.getWeekDate());
        circleConfig.setYearDate(configVo.getYearDate());
        return circleConfig;
    }

    private static kd.sdk.wtc.wtp.business.attperiod.PerAttPeriod getPerAttPeriodDto(PerAttPeriod attPeriodReport) {
        kd.sdk.wtc.wtp.business.attperiod.PerAttPeriod perAttPeriod = new kd.sdk.wtc.wtp.business.attperiod.PerAttPeriod();
        perAttPeriod.setPersonId(attPeriodReport.getPersonId().longValue());
        perAttPeriod.setFileBoId(attPeriodReport.getFileBoId().longValue());
        perAttPeriod.setFileId(attPeriodReport.getFileId().longValue());
        perAttPeriod.setAttPeriodId(attPeriodReport.getAttPeriodId().longValue());
        perAttPeriod.setPerAttPeriodStartDate(attPeriodReport.getPerAttBeginDate());
        perAttPeriod.setPerAttPeriodEndDate(attPeriodReport.getPerAttEndDate());
        perAttPeriod.setPeriodId(attPeriodReport.getPeriodId().longValue());
        return perAttPeriod;
    }

    public Map<String, QuotaCycInfo> getCycSetData() {
        return this.getCycSetDataNew();
    }

    private Map<Long, Date> getRefDateMap(AttendPersonModel byBidAndDate, DynamicObject cycSetDateDy, Long attPersonId, AttFileModel byAttPersonIdAndDate, LocalDate baseDate, Map<String, Object> initParams) {
        ArrayList<Long> expectRefDateIdList = new ArrayList<Long>(0);
        if (cycSetDateDy != null) {
            long refDateId = cycSetDateDy.getLong("cycrefdate.id");
            expectRefDateIdList = refDateId != 0L ? Collections.singletonList(refDateId) : expectRefDateIdList;
        }
        return RefDateUtils.getRefDateMap(byBidAndDate, byAttPersonIdAndDate, attPersonId, expectRefDateIdList, baseDate, initParams);
    }

    private List<CircleRestVo> initCycles(List<CircleRestVo> cycles, Long attPersonId) {
        int floorIdx;
        if (cycles.isEmpty()) {
            LOGGER.debug("\u8003\u52e4\u4eba{}\u671f\u95f4\u5faa\u73af\u4fe1\u606f\u4e3a\u7a7a", (Object)attPersonId);
            return Collections.emptyList();
        }
        long floorSecond = this.getMilliseconds(this.startDate);
        for (floorIdx = 1; floorIdx < cycles.size() && cycles.get(floorIdx).getEndDate().getTime() < floorSecond; ++floorIdx) {
        }
        return new ArrayList<CircleRestVo>(cycles.subList(--floorIdx, cycles.size()));
    }

    private long getMilliseconds(LocalDate date) {
        return WTCDateUtils.toDate((LocalDate)date).getTime();
    }

    public static String getMapKey(Long personId, Long quTypeId) {
        return personId + KEY_APPEND + quTypeId;
    }

    public static long getPersonId(String key) {
        return Long.parseLong(key.split(KEY_APPEND)[0]);
    }

    public static long getQtTypeId(String key) {
        return Long.parseLong(key.split(KEY_APPEND)[1]);
    }

    private QTRule getQTRuleByEngine(QTScheme qtScheme, long personId, LocalDate chainDate, InitParam initRequest, Long fileBoId) {
        RuleParam ruleParam = new RuleParam(RuleEngineEnum.qt.getSceneNumber(), RuleEngineEnum.qt.getBizApp(), qtScheme.getId(), personId, chainDate, initRequest.getInitParams());
        List<PolicyResult> policyResults = RuleEngineService.callQtRuleEngine(ruleParam, null, chainDate, fileBoId);
        LOGGER.debug("\u5b9a\u989d\u521d\u59cb\u5316\u5339\u914d\u7684\u89c4\u5219\u5f15\u64ce\u7ed3\u679c{}", policyResults);
        String qtRuleTag = "wtp_qtrule";
        Set<Long> ids = RuleEngineService.getRuleIdsByTag(policyResults, qtRuleTag);
        RuleEngineMetaData ruleEngineMetaData = (RuleEngineMetaData)initRequest.getInitParams().get("RULE_ENGINE");
        if (kd.wtc.wtes.common.util.CollectionUtils.isEmpty(ids)) {
            LOGGER.debug("qtrule is empty");
            return null;
        }
        List collect = ids.stream().map(id -> (QTRule)((TimeSeqBo)ruleEngineMetaData.getBizRuleById((Long)id)).getVersionByDate(chainDate)).filter(Objects::nonNull).collect(Collectors.toList());
        if (kd.wtc.wtes.common.util.CollectionUtils.isEmpty(collect)) {
            LOGGER.debug("qtrulepackage is empty");
            return null;
        }
        if (collect.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u989d\u65b9\u6848\u91cc\u7684\u89c4\u5219\u5f15\u64ce\u53ea\u80fd\u914d\u7f6e\u4e00\u4e2a\u89c4\u5219\u8fd4\u56de\u3002", (String)"QuotaCycSetData_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        return (QTRule)collect.get(0);
    }
}

