/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.util.QuotaDetailClearUtils;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QuotaRunTimeCache {
    private static final Log log = LogFactory.getLog(QuotaRunTimeCache.class);
    private static final HRBaseServiceHelper quotaDetailDao = new HRBaseServiceHelper("wtte_quotadetail");
    private Map<Long, QTRuntime> qtRuntimeMap;
    private Set<Long> needSaveBoIdSet;
    private String version;
    private final List<QuotaItemDebris> cacheQuotaItemDebrisList = new LinkedList<QuotaItemDebris>();
    private final Set<Long> singleDogFileBo = WTCCollections.modifiableEmptySet();

    public static QuotaRunTimeCache of(int initSize, String version, Collection<Long> needSaveBoIdColl) {
        QuotaRunTimeCache quotaRunTimeCache = new QuotaRunTimeCache();
        quotaRunTimeCache.qtRuntimeMap = new ConcurrentHashMap<Long, QTRuntime>(initSize);
        quotaRunTimeCache.version = version;
        quotaRunTimeCache.needSaveBoIdSet = new HashSet<Long>(needSaveBoIdColl);
        return quotaRunTimeCache;
    }

    public synchronized Set<Long> actPimp(Set<Long> fileBoIdList) {
        if (QuotaRuntimeCacheCTRLParam.useOldVersionStoreLogic()) {
            return WTCCollections.modifiableEmptySet();
        }
        Set lovers = WTCCollections.modifiableEmptySet();
        for (Long fileBo : fileBoIdList) {
            if (this.singleDogFileBo.remove(fileBo)) {
                lovers.add(fileBo);
                continue;
            }
            this.singleDogFileBo.add(fileBo);
        }
        log.info("actPimp for bo:{}, lovers bo:{}", fileBoIdList, (Object)lovers);
        return lovers;
    }

    public synchronized void cacheType2Id4FileBo(List<QuotaItemDebris> list) {
        if (QuotaRuntimeCacheCTRLParam.useOldVersionStoreLogic()) {
            return;
        }
        this.cacheQuotaItemDebrisList.addAll(list);
    }

    private synchronized Map<Long, List<QuotaItemDebris>> takeTmpData(Set<Long> fileBoIdList) {
        if (QuotaRuntimeCacheCTRLParam.useOldVersionStoreLogic()) {
            return WTCCollections.modifiableEmptyMap();
        }
        Iterator<QuotaItemDebris> iterator = this.cacheQuotaItemDebrisList.iterator();
        HashMap<Long, List<QuotaItemDebris>> res = new HashMap<Long, List<QuotaItemDebris>>(fileBoIdList.size());
        while (iterator.hasNext()) {
            QuotaItemDebris debris = iterator.next();
            if (!fileBoIdList.contains(debris.fileBoId)) continue;
            res.computeIfAbsent(debris.fileBoId, key -> WTCCollections.modifiableEmptyList()).add(debris);
            iterator.remove();
        }
        return res;
    }

    public void flushDB4FileBoAndRevTmpData(Set<Long> fileBoIdList) {
        if (QuotaRuntimeCacheCTRLParam.useOldVersionStoreLogic()) {
            return;
        }
        if (!fileBoIdList.isEmpty()) {
            Map<Long, List<QuotaItemDebris>> fileBo2DebrisMap = this.takeTmpData(fileBoIdList);
            Map<Long, List<QuotaItemDebris>> quotaItemClusterByBID = fileBo2DebrisMap.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(ele -> ((QuotaItemDebris)ele).bid, Collectors.toList()));
            Set notUseQuotaDetailIdSet = WTCCollections.modifiableEmptySet();
            Set needDelQuotaDetailId = WTCCollections.modifiableEmptySet();
            List needStoreRuntime = WTCCollections.modifiableEmptyList();
            for (Map.Entry<Long, List<QuotaItemDebris>> entry : fileBo2DebrisMap.entrySet()) {
                Long fileBo = entry.getKey();
                List<QuotaItemDebris> fileBoQuotaItemList = entry.getValue();
                notUseQuotaDetailIdSet.addAll(fileBoQuotaItemList.stream().map(ele -> ((QuotaItemDebris)ele).id).collect(Collectors.toList()));
                QTRuntime runtime = this.qtRuntimeMap.remove(fileBo);
                if (runtime == null || runtime.isDiscard()) continue;
                this.fillQuotaItemId4Cache(notUseQuotaDetailIdSet, quotaItemClusterByBID, needDelQuotaDetailId, runtime);
                needStoreRuntime.add(runtime);
            }
            if (!needStoreRuntime.isEmpty()) {
                this.flushQtRuntime(needStoreRuntime);
            }
            this.deleteQuotaDetail(notUseQuotaDetailIdSet, needDelQuotaDetailId);
        }
    }

    public QTRuntime getRunTimeByAttFileBoId(Long attFileBoId) {
        QTRuntime qtRuntime = this.qtRuntimeMap.get(attFileBoId);
        if (null != qtRuntime) {
            return qtRuntime;
        }
        QTRuntime runtime = new QTRuntime(attFileBoId.longValue(), new Date(), this.version);
        if (!this.needSaveBoIdSet.contains(attFileBoId)) {
            runtime.discard();
        }
        this.qtRuntimeMap.put(attFileBoId, runtime);
        return runtime;
    }

    public void flushDb() {
        this.cacheQuotaItemDebrisList.clear();
        this.singleDogFileBo.clear();
        if (WTCCollections.isEmpty(this.qtRuntimeMap)) {
            return;
        }
        Set lineBidSet = this.qtRuntimeMap.values().stream().flatMap(runtime -> runtime.getNewestDetail().stream()).map(QTLineDetail::getBid).collect(Collectors.toSet());
        QFilter filter = new QFilter("bid", "in", lineBidSet).and("version", "=", (Object)this.version);
        List quotaItemDebrisList = Arrays.stream(quotaDetailDao.loadDynamicObjectArray(filter.toArray())).map(QuotaItemDebris::newQuotaItemDebris).collect(Collectors.toList());
        Set<Long> notUseQuotaDetailIdSet = quotaItemDebrisList.stream().map(ele -> ((QuotaItemDebris)ele).id).collect(Collectors.toSet());
        Map<Long, List<QuotaItemDebris>> quotaItemClusterByBID = quotaItemDebrisList.stream().collect(Collectors.groupingBy(ele -> ((QuotaItemDebris)ele).bid, Collectors.toList()));
        Set needDelQuotaDetailId = WTCCollections.modifiableEmptySet();
        for (QTRuntime value : this.qtRuntimeMap.values()) {
            if (value.isDiscard()) continue;
            this.fillQuotaItemId4Cache(notUseQuotaDetailIdSet, quotaItemClusterByBID, needDelQuotaDetailId, value);
        }
        if (WTCCollections.isNotEmpty(this.qtRuntimeMap)) {
            this.flushQtRuntime(this.qtRuntimeMap.values());
        }
        this.deleteQuotaDetail(notUseQuotaDetailIdSet, needDelQuotaDetailId);
    }

    private void deleteQuotaDetail(Set<Long> notUseQuotaDetailIdSet, Set<Long> needDelQuotaDetailId) {
        needDelQuotaDetailId.addAll(notUseQuotaDetailIdSet);
        needDelQuotaDetailId.remove(0L);
        if (!needDelQuotaDetailId.isEmpty()) {
            quotaDetailDao.deleteByFilter(new QFilter("id", "in", needDelQuotaDetailId).toArray());
        }
    }

    private void flushQtRuntime(Collection<QTRuntime> qtRuntimeColl) {
        try (TXHandle txHandle = TX.required();){
            try {
                QTRuntime.flush(qtRuntimeColl);
            }
            catch (Exception exp) {
                txHandle.markRollback();
                throw exp;
            }
        }
        HashMap<Long, BillApply> usePackage = new HashMap<Long, BillApply>(this.qtRuntimeMap.size());
        HashSet needDelBillId = new HashSet(16);
        for (QTRuntime value : qtRuntimeColl) {
            if (value.isDiscard()) continue;
            List dirtyBillApplyPackage = value.getDirtyBillApplyPackage();
            needDelBillId.addAll(dirtyBillApplyPackage.stream().map(BillApply::getId).collect(Collectors.toList()));
            needDelBillId.addAll(dirtyBillApplyPackage.stream().map(BillApply::getParentId).collect(Collectors.toSet()));
            for (BillApply billApply : dirtyBillApplyPackage) {
                usePackage.put(billApply.getId(), billApply);
            }
        }
        QTDealRecordDBService.deleteBillApplyPackage(needDelBillId);
        QTDealRecordDBService.saveBillApplyPackage(usePackage.values());
    }

    private void fillQuotaItemId4Cache(Set<Long> notUseQuotaDetailIdSet, Map<Long, List<QuotaItemDebris>> quotaItemClusterByBID, Set<Long> needDelQuotaDetailId, QTRuntime value) {
        for (QTLineDetail qtLineDetail : value.getNewestDetail()) {
            QuotaDetailClearUtils.pourAllOldReferId(qtLineDetail, needDelQuotaDetailId);
            QuotaDetailClearUtils.pourDeductItem(qtLineDetail, needDelQuotaDetailId);
            List<QuotaItemDebris> quotaItemList = quotaItemClusterByBID.get(qtLineDetail.getBid());
            if (!WTCCollections.isNotEmpty(quotaItemList)) continue;
            for (QuotaItemDebris quotaItem : quotaItemList) {
                notUseQuotaDetailIdSet.remove(quotaItem.id);
                this.fillQuotaItemIdForLine(needDelQuotaDetailId, qtLineDetail, quotaItem);
            }
        }
    }

    private void fillQuotaItemIdForLine(Set<Long> needDelQuotaDetailId, QTLineDetail qtLineDetail, QuotaItemDebris quotaItem) {
        String type = quotaItem.type;
        long quotaItemId = quotaItem.id;
        if (QuotaAttItemType.STANDARD.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getGenValueId, qtLineDetail);
            qtLineDetail.setGenValueId(quotaItemId);
        } else if (QuotaAttItemType.DURATION_ENJOYMENT.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getOwnValueId, qtLineDetail);
            qtLineDetail.setOwnValueId(quotaItemId);
        } else if (QuotaAttItemType.OVERDRAW_STANDARD.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getOwnOdValueId, qtLineDetail);
            qtLineDetail.setOwnOdValueId(quotaItemId);
        } else if (QuotaAttItemType.EXCEEDING.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getNoUseGenValueId, qtLineDetail);
            qtLineDetail.setNoUseGenValueId(quotaItemId);
        } else if (QuotaAttItemType.QUIT_CODE.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getBalanceId, qtLineDetail);
            qtLineDetail.setBalanceId(quotaItemId);
        } else if (QuotaAttItemType.AVAILABLE.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getUsableValueId, qtLineDetail);
            qtLineDetail.setUsableValueId(quotaItemId);
        } else if (QuotaAttItemType.FREEZE.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getFreezeValueId, qtLineDetail);
            qtLineDetail.setFreezeValueId(quotaItemId);
        } else if (QuotaAttItemType.USING.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getUsedValueId, qtLineDetail);
            qtLineDetail.setUsedValueId(quotaItemId);
        } else if (QuotaAttItemType.OVERDRAW_AVAILABLE.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getCanBeOdValueId, qtLineDetail);
            qtLineDetail.setCanBeOdValueId(quotaItemId);
        } else if (QuotaAttItemType.OVERDRAWN.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getUseOdValueId, qtLineDetail);
            qtLineDetail.setUseOdValueId(quotaItemId);
        } else if (QuotaAttItemType.CARRYDOWN_DURATION.code.equals(type) || QuotaAttItemType.QUIT_DEPART.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getCarryDownedValueId, qtLineDetail);
            qtLineDetail.setCarryDownedValueId(quotaItemId);
        } else if (QuotaAttItemType.CARRYDOWN_EXPIRE.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getPastValueId, qtLineDetail);
            qtLineDetail.setPastValueId(quotaItemId);
        } else if (QuotaAttItemType.INVALID_VALUE_ITEM.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getInvalidValueId, qtLineDetail);
            qtLineDetail.setInvalidValueId(quotaItemId);
        } else if (QuotaAttItemType.QUIT_SETTLEMENT.code.equals(type)) {
            QuotaDetailClearUtils.addOldReferId(needDelQuotaDetailId, QTLineDetail::getSettlementValueId, qtLineDetail);
            qtLineDetail.setSettlementValueId(quotaItemId);
        }
    }

    @Deprecated
    public void flushDb(List<Long> needSaveBoIds) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static QuotaRunTimeCache of(Map<Long, QTRuntime> qtRunTime, String version) {
        throw new UnsupportedOperationException();
    }

    public Map<Long, QTRuntime> getQtRunTime() {
        return this.qtRuntimeMap;
    }

    private static class QuotaRuntimeCacheCTRLParam {
        private static final long updateIntervalMills = 600000L;
        private static volatile Date lastUpdateTime = null;
        private static volatile boolean useOldVersionStoreLogic = false;

        private QuotaRuntimeCacheCTRLParam() {
        }

        public static boolean useOldVersionStoreLogic() {
            QuotaRuntimeCacheCTRLParam.updateParamIfNeed();
            return useOldVersionStoreLogic;
        }

        private static boolean needUpdate() {
            Date tmp = lastUpdateTime;
            return tmp == null || tmp.getTime() + 600000L <= new Date().getTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void updateParamIfNeed() {
            if (!QuotaRuntimeCacheCTRLParam.needUpdate()) return;
            Class<QuotaRuntimeCacheCTRLParam> clazz = QuotaRuntimeCacheCTRLParam.class;
            synchronized (QuotaRuntimeCacheCTRLParam.class) {
                if (!QuotaRuntimeCacheCTRLParam.needUpdate()) return;
                HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbs_taskpara");
                DynamicObject[] query = helper.query("category", new QFilter("category", "=", (Object)"wtte_qttieoldstore").toArray());
                useOldVersionStoreLogic = query.length != 0;
                lastUpdateTime = new Date();
                log.info("QuotaRuntimeCacheCTRLParam update success: useOldVersionStoreLogic={},lastUpdateTime={}", (Object)useOldVersionStoreLogic, (Object)lastUpdateTime);
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }

    public static class QuotaItemDebris {
        private long id;
        private long bid;
        private long fileBoId;
        private String type;

        public QuotaItemDebris(DynamicObject quotaItem) {
            this.id = quotaItem.getLong("id");
            this.bid = quotaItem.getLong("bid");
            this.fileBoId = quotaItem.getLong("attfileid");
            this.type = quotaItem.getString("type");
        }

        public QuotaItemDebris() {
        }

        public static QuotaItemDebris newQuotaItemDebris(DynamicObject quotaItem) {
            QuotaItemDebris res = new QuotaItemDebris();
            res.id = quotaItem.getLong("id");
            res.bid = quotaItem.getLong("bid");
            res.fileBoId = quotaItem.getLong("attfileid.id");
            res.type = quotaItem.getString("type");
            return res;
        }
    }
}

