/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.std;

import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.service.IQuotaExporter;

public abstract class AbstractQuotaExporter
implements IQuotaExporter {
    private long firstStartTime = 0L;
    private long elapsedInNano;
    private long stateChangedElapsedInNano;

    @Override
    public void finishOneLine(AttPersonRange attSubject) {
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        long sTime = System.nanoTime();
        this.finishOneSubject(attSubject);
        this.elapsedInNano += System.nanoTime() - sTime;
    }

    protected abstract void finishOneSubject(AttPersonRange var1);

    @Override
    public void errorOneLine(AttPersonRange attSubject) {
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        long sTime = System.nanoTime();
        this.errorOneSubject(attSubject);
        this.elapsedInNano += System.nanoTime() - sTime;
    }

    protected abstract void errorOneSubject(AttPersonRange var1);

    @Override
    public void stateChanged(QuotaState oldState, QuotaState newState) {
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        long sTime = System.nanoTime();
        this.afterStateChanged(oldState, newState);
        this.stateChangedElapsedInNano += System.nanoTime() - sTime;
    }

    protected abstract void afterStateChanged(QuotaState var1, QuotaState var2);
}

