/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.quota.model.QuotaDataPackageInfo;
import kd.wtc.wtes.business.quota.storage.QuotaRecordAndPackageWrapper;
import kd.wtc.wtes.business.quota.storage.QuotaVersionDataPackageStore;
import kd.wtc.wtes.business.storage.VersionDataPackageStore;

@SingletonBean
public class QuotaDataPackageStoreManager {
    private static Log logger = LogFactory.getLog(QuotaDataPackageStoreManager.class);
    private final Map<String, QuotaVersionDataPackageStore> versionMap = new ConcurrentHashMap<String, QuotaVersionDataPackageStore>(16);
    private final Map<String, ExecutorService> poolMap = new ConcurrentHashMap<String, ExecutorService>(16);
    private final int ENGINE_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("tie.data.package.pool.size", Runtime.getRuntime().availableProcessors() + 1);
    private final String ENGINE_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("tie.data.package.pool.name", "QuotaDataPackagePool");
    private static final QuotaDataPackageStoreManager instance = (QuotaDataPackageStoreManager)WTCAppContextHelper.getBean(QuotaDataPackageStoreManager.class);

    public static QuotaDataPackageStoreManager getInstance() {
        return instance;
    }

    public void store(QuotaRecordAndPackageWrapper quotaRecordAndPackageWrapper) {
        QuotaDataPackageInfo packageInfo = quotaRecordAndPackageWrapper.getPackageInfo();
        QuotaVersionDataPackageStore versionDataPackageStore = this.getVersionDataPackageStore(packageInfo.getVersion(), packageInfo.getShardingIndex());
        versionDataPackageStore.store(quotaRecordAndPackageWrapper);
    }

    public void storeImmediately(String version, int shardingIndex) {
        QuotaVersionDataPackageStore versionDataPackageStore = this.getVersionDataPackageStore(version, shardingIndex);
        versionDataPackageStore.storeImmediately();
    }

    public void clearVersionStoreInstance(String version, int shardingIndex) {
        String key = this.getKey(version, shardingIndex);
        logger.debug("clearVersionStoreInstance key={}", (Object)key);
        this.versionMap.remove(key);
        ExecutorService executorService = this.poolMap.remove(key);
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    private String getKey(String version, int shardingIndex) {
        return RequestContext.get().getAccountId() + '_' + version + '_' + shardingIndex;
    }

    public QuotaVersionDataPackageStore getVersionDataPackageStore(String versionId, int shardingIndex) {
        String key = this.getKey(versionId, shardingIndex);
        logger.debug("getQuotaVersionDataPackageStore key={}", (Object)key);
        return this.versionMap.computeIfAbsent(key, value -> new QuotaVersionDataPackageStore());
    }

    public ExecutorService getExecutorService(String versionId, int shardingIndex) {
        String key = this.getKey(versionId, shardingIndex);
        logger.debug("getQuotaVersionDataPackageStore key={}", (Object)key);
        return this.poolMap.computeIfAbsent(key, value -> ThreadPools.newExecutorService((String)(this.ENGINE_POOL_NAME + key), (int)this.ENGINE_POOL_SIZE));
    }

    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        VersionDataPackageStore versionDataPackageStore = new VersionDataPackageStore();
        versionDataPackageStore.doCalDataClean(attSubjects, version);
    }
}

