/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOffsetMethodEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOffsetSeqEnum;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTCaryyOverUtils {
    public static void carryToNextOffset(QTCarryDown carryDown, List<QTLineDetail> qtDetails, QuotaAttItemValueStd attItemValueStd, List<QuotaAttItemValue> quotaDataNodeList, List<QuotaAttItemValueStd> availableStds) {
        String offsetMethod = carryDown.getOffsetMethod();
        Long qtDetailId = attItemValueStd.getAttItemInstance().getQtDetailId();
        if (QTOffsetMethodEnum.TO_CUR_PERIOD.getMethod().equals(offsetMethod)) {
            QTLineDetail qtLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == qtDetailId.longValue()).findFirst().orElse(null);
            if (qtLineDetail == null) {
                return;
            }
            if (BigDecimal.ZERO.compareTo(qtLineDetail.getUseOdValue()) >= 0) {
                return;
            }
            Map<Long, List<QuotaAttItemValueStd>> map = availableStds.stream().collect(Collectors.groupingBy(std -> std.getAttItemInstance().getQtDetailId()));
            List needQtLineDetails = qtDetails.stream().filter(qt -> qt.getBid() != qtDetailId.longValue() && BigDecimal.ZERO.compareTo(qt.getUsableValue()) < 0).collect(Collectors.toList());
            if (QTOffsetSeqEnum.OFFSET_USEENDDATE.getCode().equals(carryDown.getOffsetSeq())) {
                needQtLineDetails = needQtLineDetails.stream().sorted(Comparator.comparing(QTLineDetail::getUseEndDate).thenComparing(QTLineDetail::getCreateTime)).collect(Collectors.toList());
            } else if (QTOffsetSeqEnum.OFFSET_USESTARTDATE.getCode().equals(carryDown.getOffsetSeq())) {
                needQtLineDetails = needQtLineDetails.stream().sorted(Comparator.comparing(QTLineDetail::getUseStartDate).thenComparing(QTLineDetail::getCreateTime)).collect(Collectors.toList());
            }
            Map<Long, List<QuotaAttItemValue>> useMap = quotaDataNodeList.stream().map(QuotaAttItemValue.class::cast).collect(Collectors.groupingBy(dt -> dt.getAttItemInstance().getQtDetailId()));
            BigDecimal useOdValue = qtLineDetail.getUseOdValue();
            for (QTLineDetail useQtLineDetail : needQtLineDetails) {
                BigDecimal balanceValue;
                BigDecimal balanceUseOdValue = qtLineDetail.getBalanceUseOdValue();
                if (balanceUseOdValue.compareTo(useOdValue) == 0) break;
                Map<Object, Object> quotaMap = new HashMap();
                List<QuotaAttItemValue> quotaAttItemValueStds = useMap.get(useQtLineDetail.getBid());
                if (!WTCCollections.isEmpty(quotaAttItemValueStds)) {
                    quotaMap = quotaAttItemValueStds.stream().collect(Collectors.groupingBy(dt -> dt.getAttItemInstance().getQuotaAttItemType().code));
                }
                QuotaAttItemValueStd balanceAttItemValueStd = map.get(useQtLineDetail.getBid()).get(0);
                BigDecimal usableValue = useQtLineDetail.getUsableValue();
                if (usableValue.compareTo(useOdValue = useOdValue.subtract(balanceUseOdValue)) >= 0) {
                    balanceValue = useQtLineDetail.getUsableValue().subtract(useOdValue);
                    useQtLineDetail.setUsableValue(balanceValue);
                    BigDecimal balance = useQtLineDetail.getBalance().add(useOdValue);
                    useQtLineDetail.setBalance(balance);
                    qtLineDetail.setBalanceUseOdValue(qtLineDetail.getUseOdValue());
                    List avstds = (List)quotaMap.get(QuotaAttItemType.AVAILABLE.code);
                    balanceAttItemValueStd.getAttItemInstance().setItemValue(balanceValue);
                    if (WTCCollections.isEmpty((Collection)avstds)) {
                        quotaDataNodeList.add(QTCaryyOverUtils.bulidAttItem(balanceAttItemValueStd, balanceValue, carryDown, QuotaAttItemType.AVAILABLE));
                    } else {
                        ((QuotaAttItemValue)avstds.get(0)).getAttItemInstance().setItemValue(balanceValue);
                    }
                    List quitstds = (List)quotaMap.get(QuotaAttItemType.QUIT_CODE.code);
                    if (WTCCollections.isEmpty((Collection)quitstds)) {
                        quotaDataNodeList.add(QTCaryyOverUtils.bulidAttItem(balanceAttItemValueStd, balance, carryDown, QuotaAttItemType.QUIT_CODE));
                        break;
                    }
                    ((QuotaAttItemValue)quitstds.get(0)).getAttItemInstance().setItemValue(balance);
                    break;
                }
                balanceValue = useQtLineDetail.getBalance();
                balanceValue = balanceValue.add(usableValue);
                useQtLineDetail.setBalance(balanceValue);
                useQtLineDetail.setUsableValue(BigDecimal.ZERO);
                balanceUseOdValue = balanceUseOdValue.add(balanceValue);
                qtLineDetail.setBalanceUseOdValue(balanceUseOdValue);
                balanceAttItemValueStd.getAttItemInstance().setItemValue(balanceValue);
                List avstds = (List)quotaMap.get(QuotaAttItemType.AVAILABLE.code);
                balanceAttItemValueStd.getAttItemInstance().setItemValue(BigDecimal.ZERO);
                if (WTCCollections.isEmpty((Collection)avstds)) {
                    quotaDataNodeList.add(QTCaryyOverUtils.bulidAttItem(balanceAttItemValueStd, BigDecimal.ZERO, carryDown, QuotaAttItemType.AVAILABLE));
                } else {
                    ((QuotaAttItemValue)avstds.get(0)).getAttItemInstance().setItemValue(BigDecimal.ZERO);
                }
                List quitstds = (List)quotaMap.get(QuotaAttItemType.QUIT_CODE.code);
                if (WTCCollections.isEmpty((Collection)quitstds)) {
                    quotaDataNodeList.add(QTCaryyOverUtils.bulidAttItem(balanceAttItemValueStd, balanceValue, carryDown, QuotaAttItemType.QUIT_CODE));
                    continue;
                }
                ((QuotaAttItemValue)quitstds.get(0)).getAttItemInstance().setItemValue(balanceValue);
            }
        }
    }

    private static QuotaAttItemValue bulidAttItem(QuotaAttItemValueStd attItemValueStd, BigDecimal carryRoundResult, QTCarryDown carryDown, QuotaAttItemType quotaAttItemType) {
        QuotaAttItemInstance instance = attItemValueStd.getAttItemInstance();
        QuotaAttItemInstance carryInstance = new QuotaAttItemInstance(instance.getQtDetailId(), instance.getAttItemSpec(), carryRoundResult, instance.getUntil(), quotaAttItemType, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
        QuotaAttItemValue carryAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(carryInstance)).matchedRule(attItemValueStd.getMatchedRule())).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).appendParentDataNode(attItemValueStd)).build();
        carryAttItemValue.getAttItemInstance().setGenStartDate(instance.getGenStartDate());
        carryAttItemValue.getAttItemInstance().setGenEndDate(instance.getGenEndDate());
        carryAttItemValue.getAttItemInstance().setUseStartDate(instance.getUseStartDate());
        carryAttItemValue.getAttItemInstance().setUseEndDate(instance.getUseEndDate());
        carryAttItemValue.getAttItemInstance().setOrgEndDay(instance.getOrgEndDay());
        carryAttItemValue.getAttItemInstance().setAttFileVId(instance.getAttFileVId());
        carryAttItemValue.getAttItemInstance().setAttFileBoId(instance.getAttFileBoId());
        return carryAttItemValue;
    }
}

