/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.round.RoundCalCulateServiceImpl;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTDepartCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDateConfigTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDepartVestDayEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTUnitEnum;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.model.QuotaEmployeeData;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.common.enums.TiePhaseRusultEnum;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public final class QuotaContextUtil {
    private static final Log LOG = LogFactory.getLog(QuotaContextUtil.class);
    private static final Long DAY_QT_DEFAULT_ITEM = 2011734486974215168L;
    private static final Long HOUR_QT_DEFAULT_ITEM = 2011735134952226816L;

    public static Map<String, QuotaAttItemValue> getAllHandleResultAttItemValue(List<QuotaDataNodeStd> dataNodes) {
        HashMap attItemValueMap = Maps.newHashMapWithExpectedSize((int)16);
        QuotaContextUtil.setDataNodesHandleFlag(dataNodes);
        HashSet attItemIdSpliteSet = Sets.newHashSetWithExpectedSize((int)20);
        List<QuotaDataNodeStd> quotaDataNodeStdList = QuotaContextUtil.reverseNodeList(dataNodes);
        LinkedHashMap phaseDataNodes = quotaDataNodeStdList.stream().collect(Collectors.groupingBy(ob -> ob.getStepIdentity().getPhaseIdentity().getId(), LinkedHashMap::new, Collectors.toList()));
        phaseDataNodes.forEach((entry, dataNodeList) -> {
            int index = ((QuotaDataNodeStd)dataNodeList.get(0)).getStepIdentity().getPhaseIdentity().getIndex();
            List upNodeList = quotaDataNodeStdList.stream().filter(ob -> index >= ob.getStepIdentity().getPhaseIdentity().getIndex()).collect(Collectors.toList());
            dataNodeList.forEach(node -> {
                List<QuotaAttItemInstance> attItemInstances = node.getAttItemInstances();
                for (QuotaAttItemInstance itemInstance : attItemInstances) {
                    String attitemSpliteStr;
                    QuotaAttItemType quotaAttItemType;
                    AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
                    Long attItemId = attItemSpec.getBid();
                    if (attItemId == null || (quotaAttItemType = itemInstance.getQuotaAttItemType()) == null || attItemIdSpliteSet.contains(attitemSpliteStr = QuotaContextUtil.getSpliteStr(itemInstance)) || itemInstance.getHandleFlag() == null || !itemInstance.getHandleFlag().booleanValue()) continue;
                    attItemIdSpliteSet.add(attitemSpliteStr);
                    attItemValueMap.put(attitemSpliteStr, QuotaContextUtil.getAttItemValue(upNodeList, node, itemInstance));
                }
            });
        });
        return attItemValueMap;
    }

    public static List<QuotaDataNodeStd> reverseNodeList(List<QuotaDataNodeStd> dataNodeStdList) {
        ArrayList quotaDataNodeStdList = Lists.newArrayListWithExpectedSize((int)dataNodeStdList.size());
        for (int i = dataNodeStdList.size() - 1; i >= 0; --i) {
            quotaDataNodeStdList.add(dataNodeStdList.get(i));
        }
        return quotaDataNodeStdList;
    }

    private static QuotaDataNodeStd getFirstHandleFlagNode(List<QuotaDataNodeStd> dataNodes, QuotaAttItemInstance itemInstance) {
        AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
        for (QuotaDataNodeStd quotaDataNodeStd : dataNodes) {
            if (quotaDataNodeStd.getStepIdentity().getPhaseIdentity().getResult() != TiePhaseRusultEnum.OVERROAD) continue;
            List<QuotaAttItemInstance> attItemInstanceList = quotaDataNodeStd.getAttItemInstances();
            for (QuotaAttItemInstance attItemInstance : attItemInstanceList) {
                if (attItemInstance.getQuotaAttItemType() != itemInstance.getQuotaAttItemType() || !attItemInstance.getQtDetailId().equals(itemInstance.getQtDetailId()) || attItemInstance.getAttItemSpec() != attItemSpec || attItemInstance.getHandleFlag() != Boolean.TRUE || attItemInstance.getSource() != itemInstance.getSource()) continue;
                return quotaDataNodeStd;
            }
        }
        return null;
    }

    public static String getSpliteStr(QuotaAttItemInstance quotaAttItemInstance) {
        Long attItemId = quotaAttItemInstance.getAttItemSpec().getBid();
        Long detailId = quotaAttItemInstance.getQtDetailId();
        QuotaAttItemType quotaAttItemType = quotaAttItemInstance.getQuotaAttItemType();
        QuotaDetailType sourceType = quotaAttItemInstance.getSource();
        return quotaAttItemType.code + "&&" + sourceType.code + "&&" + attItemId + "&&" + detailId;
    }

    public static void setDataNodesHandleFlag(List<QuotaDataNodeStd> allDataNodes) {
        allDataNodes.stream().filter(QuotaDataNodeStd::isLeafInPhase).forEach(quotaDataNodeStd -> {
            HashSet itemInstanceSet = Sets.newHashSetWithExpectedSize((int)16);
            List<QuotaAttItemInstance> attItemInstances = quotaDataNodeStd.getAttItemInstances();
            for (QuotaAttItemInstance attItemInstance : attItemInstances) {
                attItemInstance.setHandleFlag(Boolean.TRUE);
                itemInstanceSet.add(QuotaContextUtil.getSpliteStr(attItemInstance));
            }
            String phaseNumber = quotaDataNodeStd.getStepIdentity().getPhaseIdentity().getNumber();
            List<QuotaDataNodeStd> parentNodes = quotaDataNodeStd.parentDataNodes();
            for (QuotaDataNodeStd parentNode : parentNodes) {
                QuotaContextUtil.setParentNodesHandleFlag(phaseNumber, parentNode, new HashSet<String>(itemInstanceSet));
            }
        });
    }

    private static void setParentNodesHandleFlag(String phaseNumber, QuotaDataNodeStd parentDataNode, Set<String> itemInstanceSet) {
        String parentNumber = parentDataNode.getStepIdentity().getPhaseIdentity().getNumber();
        if (HRStringUtils.equals((String)parentNumber, (String)phaseNumber)) {
            List<QuotaAttItemInstance> attItemInstances = parentDataNode.getAttItemInstances();
            for (QuotaAttItemInstance attItemInstance : attItemInstances) {
                HashSet<String> tempSet = new HashSet<String>();
                String specId = QuotaContextUtil.getSpliteStr(attItemInstance);
                if (itemInstanceSet.contains(specId)) {
                    attItemInstance.setHandleFlag(Boolean.FALSE);
                } else {
                    Boolean flag = attItemInstance.getHandleFlag();
                    if (Objects.isNull(flag)) {
                        attItemInstance.setHandleFlag(Boolean.TRUE);
                        tempSet.add(specId);
                    }
                }
                itemInstanceSet.addAll(tempSet);
            }
            List<QuotaDataNodeStd> tieDataNodes = parentDataNode.parentDataNodes();
            for (QuotaDataNodeStd quotaDataNodeStd : tieDataNodes) {
                QuotaContextUtil.setParentNodesHandleFlag(phaseNumber, quotaDataNodeStd, new HashSet<String>(itemInstanceSet));
            }
        }
    }

    private static List<QuotaDataNodeStd> getOverLoadNodeAttItemNodes(List<QuotaDataNodeStd> dataNodes, QuotaAttItemInstance itemInstance) {
        AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
        List<QuotaDataNodeStd> attItemDataNodes = dataNodes.stream().filter(ob -> ob.containsAttItem(attItemSpec)).collect(Collectors.toList());
        QuotaDataNodeStd firstQuotaDataNodeStd = QuotaContextUtil.getFirstHandleFlagNode(attItemDataNodes, itemInstance);
        if (firstQuotaDataNodeStd != null) {
            int index = firstQuotaDataNodeStd.getStepIdentity().getPhaseIdentity().getIndex();
            return attItemDataNodes.stream().filter(ob -> index <= ob.getStepIdentity().getPhaseIdentity().getIndex()).collect(Collectors.toList());
        }
        return attItemDataNodes;
    }

    private static QuotaAttItemValue getAttItemValue(List<QuotaDataNodeStd> dataNodes, QuotaDataNodeStd nodeStd, QuotaAttItemInstance itemInstance) {
        AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
        TiePhaseRusultEnum tiePhaseRusultEnum = nodeStd.getStepIdentity().getPhaseIdentity().getResult();
        List<Object> attItemDataNodes = Lists.newArrayListWithExpectedSize((int)16);
        if (TiePhaseRusultEnum.ADDALL == tiePhaseRusultEnum) {
            attItemDataNodes = QuotaContextUtil.getOverLoadNodeAttItemNodes(dataNodes, itemInstance);
        } else {
            int index = nodeStd.getStepIdentity().getPhaseIdentity().getIndex();
            for (QuotaDataNodeStd quotaDataNodeStd : dataNodes) {
                if (!quotaDataNodeStd.containsAttItem(attItemSpec) || index != quotaDataNodeStd.getStepIdentity().getPhaseIdentity().getIndex()) continue;
                List<QuotaAttItemInstance> attItemInstances = quotaDataNodeStd.getAttItemInstances();
                for (QuotaAttItemInstance quotaAttItemInstance : attItemInstances) {
                    if (quotaAttItemInstance.getQuotaAttItemType() != itemInstance.getQuotaAttItemType() || !quotaAttItemInstance.getQtDetailId().equals(itemInstance.getQtDetailId()) || quotaAttItemInstance.getAttItemSpec().getBid() != itemInstance.getAttItemSpec().getBid() || quotaAttItemInstance.getSource() != itemInstance.getSource()) continue;
                    attItemDataNodes.add(quotaDataNodeStd);
                }
            }
        }
        return QuotaContextUtil.getAttItemValue((List<QuotaDataNodeStd>)attItemDataNodes, itemInstance);
    }

    private static QuotaAttItemValue getAttItemValue(List<QuotaDataNodeStd> attItemDataNodes, QuotaAttItemInstance quotaAttItemInstance) {
        AttItemSpec attItemSpec = quotaAttItemInstance.getAttItemSpec();
        BigDecimal valueTimes = BigDecimal.ZERO;
        HashSet linkParentNodeSet = Sets.newHashSetWithExpectedSize((int)16);
        for (QuotaDataNodeStd quotaDataNodeStd : attItemDataNodes) {
            List<QuotaAttItemInstance> attItemInstances = quotaDataNodeStd.getAttItemInstances();
            for (QuotaAttItemInstance itemInstance : attItemInstances) {
                if (!((Object)((Object)itemInstance.getAttItemSpec())).equals((Object)attItemSpec) || !quotaAttItemInstance.getQtDetailId().equals(itemInstance.getQtDetailId()) || itemInstance.getHandleFlag() != Boolean.TRUE || quotaAttItemInstance.getQuotaAttItemType() != itemInstance.getQuotaAttItemType() || quotaAttItemInstance.getSource() != itemInstance.getSource()) continue;
                valueTimes = valueTimes.add(itemInstance.getItemValue());
                linkParentNodeSet.add(quotaDataNodeStd);
            }
        }
        QuotaAttItemInstance sumItemInstance = new QuotaAttItemInstance(quotaAttItemInstance.getQtDetailId(), attItemSpec, valueTimes, quotaAttItemInstance.getUntil(), quotaAttItemInstance.getQuotaAttItemType(), quotaAttItemInstance.getSource(), quotaAttItemInstance.getQttypeId(), quotaAttItemInstance.getPeriodcircleId(), quotaAttItemInstance.getPeriodNum(), quotaAttItemInstance.getPeriodAttribtion(), quotaAttItemInstance.getGenStartDate(), quotaAttItemInstance.getGenEndDate(), quotaAttItemInstance.getUseStartDate(), quotaAttItemInstance.getUseEndDate(), quotaAttItemInstance.getChangeSatrt(), quotaAttItemInstance.getChangeEnd());
        sumItemInstance.setVestDay(quotaAttItemInstance.getVestDay());
        sumItemInstance.setVestType(quotaAttItemInstance.getVestType());
        sumItemInstance.setAttFileVId(quotaAttItemInstance.getAttFileVId());
        sumItemInstance.setAttFileBoId(quotaAttItemInstance.getAttFileBoId());
        return (QuotaAttItemValue)((CleanableBuilder)((QuotaAttItemValue.Builder)QuotaAttItemValue.builder().parentDataNodes(linkParentNodeSet)).attItemInstance(sumItemInstance)).build();
    }

    public static BigDecimal roundValue(QuotaContextStd contextstd, long roundRuleId, BigDecimal roundValue) {
        if (roundRuleId == 0L) {
            return roundValue;
        }
        Map roundWrapperMap = (Map)contextstd.getInitParam("ROUND_SPEC");
        RoundWrapper roundWrapper = (RoundWrapper)roundWrapperMap.get(roundRuleId);
        return RoundCalCulateServiceImpl.getInstance().roundCalculate(roundWrapper, roundValue);
    }

    public static Date getBoStartDay(QuotaContextStd contextstd) {
        AttPersonRange attPersonRange = contextstd.getAttSubjectEntry();
        if (attPersonRange == null) {
            return contextstd.getCircleRestVo().getStartDate();
        }
        return attPersonRange.getCurrentChainAttFileInfo().getStartDate();
    }

    public static AttFileModel getAttFileModle(QuotaContextStd contextstd) {
        LocalDate endDate = contextstd.getChainDate();
        return QuotaContextUtil.getAttFileModle(contextstd, endDate);
    }

    public static AttFileModel getAttFileModle(QuotaContextStd contextstd, LocalDate chian) {
        AttFileCabinet attFileCabinet = contextstd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        Long curBoId = null;
        if (contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo() != null) {
            curBoId = contextstd.getAttSubjectEntry().getCurrentChainAttFileInfo().getAttFileBaseBoId();
        }
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(contextstd.getAttPersonId(), chian, curBoId);
        return attFileModel;
    }

    public static AttendPersonModel getAttendPersonData(QuotaContextStd contextStd) {
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        if (null == attFileModel) {
            return null;
        }
        AttendPersonData attendPersonData = contextStd.getInitParamMust("ATT_PERINFO", AttendPersonData.class);
        if (attendPersonData == null) {
            return null;
        }
        return attendPersonData.getByBidAndDate(attFileModel, contextStd.getChainDate());
    }

    public static AttendPersonModel getAttendPersonData(QuotaContextStd contextStd, LocalDate chian) {
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        if (null == attFileModel) {
            return null;
        }
        AttendPersonData attendPersonData = contextStd.getInitParamMust("ATT_PERINFO", AttendPersonData.class);
        if (attendPersonData == null) {
            return null;
        }
        return attendPersonData.getByBidAndDate(attFileModel, chian);
    }

    public static Date getDepartDate(QuotaContextStd contextstd) {
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextstd);
        if (null == attFileModel) {
            return null;
        }
        Long employeeId = attFileModel.getEmployeeId();
        QuotaEmployeeData quotaEmployeeData = contextstd.getInitParamMust("FIRST_EMPLOYEE_STARTDAY", QuotaEmployeeData.class);
        Map<Long, Date> map = quotaEmployeeData.getEmployeeEndDate();
        if (map == null) {
            return null;
        }
        Date departDay = map.get(employeeId);
        if (departDay == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("DepartDate{}", (Object)WTCDateUtils.date2Str((Date)departDay, (String)"yyyy.MM.dd"));
        }
        departDay = WTCDateUtils.getZeroDate((Date)departDay);
        Date endDay = WTCDateUtils.toDate((LocalDate)contextstd.getChainDate());
        if (departDay.compareTo(endDay = WTCDateUtils.getZeroDate((Date)endDay)) >= 0) {
            return departDay;
        }
        return null;
    }

    public static Date getJoinDate(QuotaContextStd contextstd) {
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextstd, contextstd.getChainDate());
        if (null == attFileModel) {
            return null;
        }
        QuotaEmployeeData quotaEmployeeData = contextstd.getInitParamMust("FIRST_EMPLOYEE_STARTDAY", QuotaEmployeeData.class);
        Map<Long, Date> map = quotaEmployeeData.getEarlistEmployeeStartDay();
        if (map != null) {
            return map.get(attFileModel.getBid());
        }
        return null;
    }

    public static List<QTLineDetail> getLineDetails(QuotaContextStd context, Long attFileBoId, int periodNum, long qtTypeId, long cycSet) {
        List<Object> qtLineDetails = new ArrayList();
        String preKey = DetailLogicKey.getIndexKey((long)attFileBoId, (long)qtTypeId, (long)cycSet, (long)periodNum);
        qtLineDetails = (List)context.getVariable(preKey, VScope.LINE);
        if (CollectionUtils.isEmpty(qtLineDetails)) {
            QTPoolHolder qtPoolHolder = context.getInitParamMust("QT_POOL", QTPoolHolder.class);
            qtLineDetails = qtPoolHolder.getQtPoolByFileBoId(attFileBoId, periodNum, qtTypeId);
            qtLineDetails = qtLineDetails.stream().filter(qt -> qt.getpCycleId() == cycSet).collect(Collectors.toList());
        }
        return qtLineDetails;
    }

    public static String getSettlementKey(Long attFileBoid, Long quotaTypleId) {
        return "settlement:" + attFileBoid + ":" + attFileBoid;
    }

    public static String getCalculatePeriodNums(Long attFileBoid, Long quotaTypleId) {
        return "calculate:" + attFileBoid + ":" + attFileBoid;
    }

    public static String getCrossCarryDwon(Long attFileBoid, Long quotaTypleId, int periodNum) {
        return "cross:" + attFileBoid + ":" + quotaTypleId + ":" + periodNum;
    }

    public static List<QTLineDetail> getBeforeCurPeriodNum(QuotaContextStd contextStd, Long attFileBoId, int periodNum, Long qtTypeId, Long cycleId) {
        QTPoolHolder qtPoolHolder = contextStd.getInitParamMust("QT_POOL", QTPoolHolder.class);
        ArrayList<QTLineDetail> berforPeriodNumDetails = new ArrayList<QTLineDetail>();
        List<Object> berforPeriodPoolDetails = qtPoolHolder.getBeforeCurPeriodNumQtPool(attFileBoId, periodNum, qtTypeId);
        String periodKey = QuotaContextUtil.getCalculatePeriodNums(attFileBoId, qtTypeId);
        List periodNums = (List)contextStd.getVariable(periodKey, VScope.LINE);
        berforPeriodPoolDetails = berforPeriodPoolDetails.stream().filter(qtLineDetail -> !periodNums.contains(qtLineDetail.getPeriodNum())).collect(Collectors.toList());
        berforPeriodNumDetails.addAll(berforPeriodPoolDetails);
        for (Integer num : periodNums) {
            String qtLineKey;
            List qtLineDetails;
            if (num >= periodNum || !CollectionUtils.isNotEmpty((Collection)(qtLineDetails = (List)contextStd.getVariable(qtLineKey = DetailLogicKey.getIndexKey((long)attFileBoId, (long)qtTypeId, (long)cycleId, (long)num.intValue()), VScope.LINE)))) continue;
            berforPeriodNumDetails.addAll(qtLineDetails);
        }
        return berforPeriodNumDetails;
    }

    public static void setEmptyDetailLineCache(long attFileBid, QuotaContextStd contextStd, QTCalRule qtCalRule, QTGenConfigEntry qtGenConfigEntry) {
        String qtLineKey = DetailLogicKey.getIndexKey((long)attFileBid, (long)contextStd.getQuotaTypeId(), (long)contextStd.getCircleRestVo().getCycSetId(), (long)contextStd.getCircleRestVo().getIndex().intValue());
        String rule = "rule" + qtLineKey;
        String configEntry = "configEntry" + qtLineKey;
        contextStd.setVariable(rule, qtCalRule, VScope.LINE);
        contextStd.setVariable(configEntry, qtGenConfigEntry, VScope.LINE);
    }

    public static List<QTLineDetail> getLineDetail(QuotaContextStd context) {
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        Long periodcircleId = context.getCircleRestVo().getCycSetId();
        int perNum = context.getCircleRestVo().getIndex();
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)context.getQuotaTypeId(), (long)periodcircleId, (long)perNum);
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        return qtDetails;
    }

    public static QTCalRule getMatchRule(QuotaContextStd context, List<QTCalRule> qtCalRules) {
        if (CollectionUtils.isEmpty(qtCalRules)) {
            return null;
        }
        for (QTCalRule qtCalRule : qtCalRules) {
            QTGenConfig genConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(context.getChainDate());
            if (!context.getQuotaTypeId().equals(genConfig.getQtType().getId())) continue;
            return qtCalRule;
        }
        return null;
    }

    public static Date getDepartVestDay(QTCarryDown carryDown, QuotaContextStd context) {
        Date vestDay = QuotaContextUtil.getDepartDate(context);
        QTDepartCarryDown departCarryDown = carryDown.getDepartCarryDown();
        String vestDayMethod = departCarryDown.getVestDayMethod();
        if (QTDepartVestDayEnum.QT_END_EMPLOYMENT.type.equals(vestDayMethod) && vestDay != null && departCarryDown.getDPDelay().booleanValue() && vestDay != null) {
            vestDay = QTFloatUnitEnum.NATURAL_DAY == departCarryDown.getVestDayFloatUnit() ? WTCDateUtils.addDays((Date)vestDay, (int)departCarryDown.getDepartCDDelay()) : WTCDateUtils.add((Date)vestDay, (int)2, (int)departCarryDown.getDepartCDDelay());
        }
        return vestDay;
    }

    public static Date getBusinessVestDay(Date referenDate, QTCarryDown carryDown) {
        if (Boolean.TRUE.equals(carryDown.getVDDelay())) {
            referenDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getVestDayFloatUnit() ? WTCDateUtils.addDays((Date)referenDate, (int)carryDown.getVestDayDelay()) : WTCDateUtils.add((Date)referenDate, (int)2, (int)carryDown.getVestDayDelay());
        }
        return referenDate;
    }

    public static Map<String, Date> getCdUseDate(QTCarryDown carryDown, QuotaAttItemInstance instance) {
        Date useEndDate;
        Date useStartDate = QTDateConfigTypeEnum.QT_DATE_START == carryDown.getCarryStartDate() ? instance.getUseStartDate() : instance.getUseEndDate();
        Date date = useEndDate = QTDateConfigTypeEnum.QT_DATE_START == carryDown.getCarryEndDate() ? instance.getUseStartDate() : instance.getUseEndDate();
        if (Boolean.TRUE.equals(carryDown.getStartDelay())) {
            useStartDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getStartFloatUnit() ? WTCDateUtils.addDays((Date)useStartDate, (int)carryDown.getsDelay()) : WTCDateUtils.add((Date)useStartDate, (int)2, (int)carryDown.getsDelay());
        }
        if (Boolean.TRUE.equals(carryDown.getEndDelay())) {
            useEndDate = QTFloatUnitEnum.NATURAL_DAY == carryDown.getEndFloatUnit() ? WTCDateUtils.addDays((Date)useEndDate, (int)carryDown.geteDelay()) : WTCDateUtils.add((Date)useEndDate, (int)2, (int)carryDown.geteDelay());
        }
        HashMap<String, Date> map = new HashMap<String, Date>(4);
        map.put("start", useStartDate);
        map.put("end", useEndDate);
        return map;
    }

    public static Long getQTDefaultItem(QTUnitEnum unit) {
        if (QTUnitEnum.DAY == unit) {
            return DAY_QT_DEFAULT_ITEM;
        }
        return HOUR_QT_DEFAULT_ITEM;
    }
}

