/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTOverDraw;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTCrossMangOrgEnum;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.model.VestTypeEnum;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaDetailClearUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QuotaCrossManageOrgUtils {
    private static final Log LOG = LogFactory.getLog(QuotaCrossManageOrgUtils.class);

    public static BigDecimal crossBoConVersion(QuotaContextStd context, QTGenConfig qtGenConfig, QTCalRule qtCalRule, List<QuotaAttItemValue> quotaAttItemValues) {
        Date boEndDate;
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        Date cycStartDate = context.getCircleRestVo().getStartDate();
        Date cycEndDate = context.getCircleRestVo().getEndDate();
        Date boStartDate = attFileModel.getStartDateTime().compareTo(cycStartDate) < 0 ? cycStartDate : attFileModel.getStartDateTime();
        Date date = boEndDate = attFileModel.getEndDateTime().compareTo(cycEndDate) < 0 ? attFileModel.getEndDateTime() : cycEndDate;
        if (QTCrossMangOrgEnum.CROSS_NONE.type.equals(qtGenConfig.getCrossMangOrg())) {
            return BigDecimal.ONE;
        }
        if (QTCrossMangOrgEnum.CROSS_DAY.type.equals(qtGenConfig.getCrossMangOrg())) {
            int days = WTCDateUtils.daysBetween((Date)cycStartDate, (Date)cycEndDate);
            int boDays = WTCDateUtils.daysBetween((Date)boStartDate, (Date)boEndDate);
            return BigDecimal.valueOf(++boDays).divide(BigDecimal.valueOf(++days), 6, RoundingMode.HALF_UP);
        }
        if (QTCrossMangOrgEnum.CROSS_CARYY_DOWN.type.equals(qtGenConfig.getCrossMangOrg())) {
            if (context.getCircleRestVo().getPreAttFileBoId() == null) {
                return BigDecimal.ONE;
            }
            if (!QuotaCrossManageOrgUtils.handleInhritDetail(context, qtGenConfig, qtCalRule, quotaAttItemValues)) {
                int days = WTCDateUtils.daysBetween((Date)cycStartDate, (Date)cycEndDate);
                int boDays = WTCDateUtils.daysBetween((Date)boStartDate, (Date)boEndDate);
                return BigDecimal.valueOf(++boDays).divide(BigDecimal.valueOf(++days), 6, RoundingMode.HALF_UP);
            }
        }
        return null;
    }

    public static boolean isCrossBo(QuotaContextStd context) {
        Long preAttFileBoId = context.getCircleRestVo().getPreAttFileBoId();
        Long nextAttFileBoId = context.getCircleRestVo().getNextAttFileBoId();
        return preAttFileBoId != null && preAttFileBoId != 0L || nextAttFileBoId != null && nextAttFileBoId != 0L;
    }

    private static boolean handleInhritDetail(QuotaContextStd context, QTGenConfig qtGenConfig, QTCalRule qtCalRule, List<QuotaAttItemValue> quotaAttItemValues) {
        String settlementKey;
        List prePreBoLineDetails;
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        Long preBoId = context.getCircleRestVo().getPreAttFileBoId();
        if (preBoId == null || preBoId == 0L) {
            return false;
        }
        Long preCycSet = context.getCircleRestVo().getPreCycSetId();
        if (preCycSet == null || preCycSet == 0L) {
            return false;
        }
        Integer prePeriodNum = context.getCircleRestVo().getPreIndex();
        if (LOG.isDebugEnabled()) {
            LOG.debug("QuotaCrossManageOrgUtils restVo {}", (Object)JSON.toJSONString((Object)context.getCircleRestVo()));
        }
        String preKey = DetailLogicKey.getIndexKey((long)preBoId, (long)context.getQuotaTypeId(), (long)preCycSet, (long)prePeriodNum.intValue());
        ArrayList<QTLineDetail> curOldQtDetails = new ArrayList<QTLineDetail>();
        ArrayList<QTLineDetail> curOldCdQtDetails = new ArrayList<QTLineDetail>();
        ArrayList preBoQtLineDetails = new ArrayList();
        List preBoAdjoinQtLineDetails = (List)context.getVariable(preKey, VScope.LINE);
        if (CollectionUtils.isNotEmpty((Collection)preBoAdjoinQtLineDetails)) {
            preBoQtLineDetails.addAll(preBoAdjoinQtLineDetails);
        }
        if (CollectionUtils.isNotEmpty((Collection)(prePreBoLineDetails = (List)context.getVariable(settlementKey = QuotaContextUtil.getSettlementKey(preBoId, context.getQuotaTypeId()), VScope.LINE)))) {
            preBoQtLineDetails.addAll(prePreBoLineDetails);
        }
        QTPoolHolder qtPoolHolder = context.getInitParamMust("QT_POOL", QTPoolHolder.class);
        boolean isExistenceCross = false;
        if (qtPoolHolder != null) {
            List<QTLineDetail> allQTLineDetails = qtPoolHolder.getQtPoolByFileBoId(attFileModel.getBid(), context.getCircleRestVo().getIndex(), qtGenConfig.getQtType().getId());
            for (QTLineDetail qtLineDetail : allQTLineDetails) {
                if (qtLineDetail.getpCycleId() == qtGenConfig.getCycSet() && QuotaDetailType.BO_SETTLEMENT.getCode().equals(qtLineDetail.getSource())) {
                    curOldQtDetails.add(qtLineDetail);
                    isExistenceCross = true;
                    continue;
                }
                if (qtLineDetail.getpCycleId() != qtGenConfig.getCycSet() || !QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(qtLineDetail.getSource())) continue;
                curOldCdQtDetails.add(qtLineDetail);
            }
        }
        if (!WTCCollections.isEmpty(preBoQtLineDetails)) {
            List<QTLineDetail> perBoList = preBoQtLineDetails.stream().filter(dt -> !QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(dt.getSource())).collect(Collectors.toList());
            QuotaCrossManageOrgUtils.handleSettlementDetail(perBoList, qtCalRule, context, attFileModel, qtGenConfig, quotaAttItemValues, curOldQtDetails);
        } else if (isExistenceCross && WTCCollections.isNotEmpty(qtGenConfig.getQtGenConfigEntries())) {
            QuotaContextUtil.setEmptyDetailLineCache(attFileModel.getBid(), context, qtCalRule, qtGenConfig.getQtGenConfigEntries().get(0));
        }
        if (!WTCCollections.isEmpty((Collection)preBoAdjoinQtLineDetails)) {
            List<QTLineDetail> effecteOrBoCdLinDetails = preBoAdjoinQtLineDetails.stream().filter(dt -> "0".equals(dt.getBusstatus()) || QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(dt.getSource())).collect(Collectors.toList());
            QuotaCrossManageOrgUtils.handleCrossBoCdDetail(effecteOrBoCdLinDetails, context, attFileModel, qtGenConfig, curOldCdQtDetails);
        }
        return true;
    }

    private static void handleCrossBoCdDetail(List<QTLineDetail> preBoQtLineDetails, QuotaContextStd context, AttFileModel attFileModel, QTGenConfig qtGenConfig, List<QTLineDetail> curOldCdQtDetails) {
        Date boStartDate = attFileModel.getStartDateTime();
        ArrayList curCdQtDetails = new ArrayList();
        Map<Object, Object> oldCdQtLineDetailMap = new HashMap();
        if (!WTCCollections.isEmpty(curOldCdQtDetails)) {
            oldCdQtLineDetailMap = curOldCdQtDetails.stream().collect(Collectors.groupingBy(QTLineDetail::getDetailSourceId, Collectors.collectingAndThen(Collectors.toList(), value -> (QTLineDetail)value.get(0))));
        }
        if (boStartDate.compareTo(context.getCircleRestVo().getStartDate()) != 0 && !WTCCollections.isEmpty(preBoQtLineDetails)) {
            curCdQtDetails.addAll(preBoQtLineDetails.stream().filter(dt -> BigDecimal.ZERO.compareTo(dt.getCarryDownedValue()) != 0).filter(dt -> !VestTypeEnum.BUSINESS_AREA.getCode().equals(dt.getVestType()) && !VestTypeEnum.DEPART.getCode().equals(dt.getVestType())).collect(Collectors.toList()));
        }
        if (WTCCollections.isEmpty(curCdQtDetails)) {
            return;
        }
        long[] ids = IDService.get().genLongIds(curCdQtDetails.size());
        ArrayList qtLineDetails = Lists.newArrayListWithCapacity((int)curCdQtDetails.size());
        for (int index = 0; index < curCdQtDetails.size(); ++index) {
            QTLineDetail qtLineDetail = (QTLineDetail)curCdQtDetails.get(index);
            QTLineDetail newCdQtLineDetail = (QTLineDetail)oldCdQtLineDetailMap.get(qtLineDetail.getBid());
            newCdQtLineDetail = newCdQtLineDetail == null ? new QTLineDetail() : newCdQtLineDetail;
            Date createTime = newCdQtLineDetail.getCreateTime();
            if (createTime == null) {
                newCdQtLineDetail.setCreateTime(new Date());
            }
            newCdQtLineDetail.rememberOriginalId();
            QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(newCdQtLineDetail);
            newCdQtLineDetail.setId(ids[index]);
            newCdQtLineDetail.setAttFileBoId(attFileModel.getBid());
            newCdQtLineDetail.setOrgId(attFileModel.getOrgId().longValue());
            newCdQtLineDetail.setAttFileVid(attFileModel.getId());
            newCdQtLineDetail.setQtTypeId(context.getQuotaTypeId().longValue());
            newCdQtLineDetail.setpCycleId(context.getCircleRestVo().getCycSetId().longValue());
            newCdQtLineDetail.setPeriodNum(context.getCircleRestVo().getIndex().intValue());
            newCdQtLineDetail.setSource(QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode());
            newCdQtLineDetail.setUseEndDate(qtLineDetail.getCarryDownedend());
            newCdQtLineDetail.setUseStartDate(qtLineDetail.getCarryDownedStart());
            newCdQtLineDetail.setGenStartDate(qtLineDetail.getGenStartDate());
            newCdQtLineDetail.setGenEndDate(qtLineDetail.getGenEndDate());
            newCdQtLineDetail.setCarryDownedValue(qtLineDetail.getCarryDownedValue());
            newCdQtLineDetail.setCarryDownedValueId(qtLineDetail.getCarryDownedValueId());
            newCdQtLineDetail.setGenValue(qtLineDetail.getGenValue());
            newCdQtLineDetail.setOwnValue(qtLineDetail.getOwnValue());
            if (BigDecimal.ZERO.compareTo(qtLineDetail.getCanBeOdValue()) != 0) {
                newCdQtLineDetail.setCanBeOdValue(qtLineDetail.getCanBeOdValue());
            }
            newCdQtLineDetail.setDetailSourceId(qtLineDetail.getBid());
            newCdQtLineDetail.setBusstatus("1");
            qtLineDetails.add(newCdQtLineDetail);
        }
        String corssCarryDownKey = QuotaContextUtil.getCrossCarryDwon(attFileModel.getBid(), context.getQuotaTypeId(), context.getCircleRestVo().getIndex());
        context.setVariable(corssCarryDownKey, qtLineDetails, VScope.LINE);
    }

    private static void handleSettlementDetail(List<QTLineDetail> preBoQtLineDetails, QTCalRule qtCalRule, QuotaContextStd context, AttFileModel attFileModel, QTGenConfig qtGenConfig, List<QuotaAttItemValue> quotaAttItemValues, List<QTLineDetail> curOldQtDetails) {
        List<QTGenConfigEntry> entries;
        LocalDate endDate = context.getChainDate();
        Date boStartDate = attFileModel.getStartDateTime();
        Date preBoEndDate = WTCDateUtils.addDays((Date)boStartDate, (int)-1);
        QTOverDraw qtOverConfig = null;
        if (qtCalRule.getOverDraw() != null) {
            qtOverConfig = (QTOverDraw)qtCalRule.getOverDraw().getVersionByDate(context.getChainDate());
        }
        if (WTCCollections.isEmpty(entries = qtGenConfig.getQtGenConfigEntries())) {
            return;
        }
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        Long attItemId = entries.get(0).getResultAttItem();
        AttItemSpec starAttItemSpec = attItemSpecData.getByBidAndDate(attItemId, endDate);
        ArrayList curQtDetails = new ArrayList();
        if (!WTCCollections.isEmpty(preBoQtLineDetails)) {
            QTOverDraw finalQtOverConfig = qtOverConfig;
            curQtDetails.addAll(preBoQtLineDetails.stream().filter(dt -> BigDecimal.ZERO.compareTo(dt.getSettlementValue()) <= 0 || BigDecimal.ZERO.compareTo(dt.getCdCanBeOdValue()) < 0 && finalQtOverConfig != null && dt.getSettlementValueId() != 0L).filter(dt -> BigDecimal.ZERO.compareTo(dt.getCarryDownedValue()) == 0 && BigDecimal.ZERO.compareTo(dt.getPastValue()) == 0).filter(dt -> dt.getUseEndDate().compareTo(preBoEndDate) >= 0).collect(Collectors.toList()));
        }
        Map<Object, Object> oldQtLineDetailMap = new HashMap();
        if (!WTCCollections.isEmpty(curOldQtDetails)) {
            oldQtLineDetailMap = curOldQtDetails.stream().collect(Collectors.groupingBy(QTLineDetail::getDetailSourceId, Collectors.collectingAndThen(Collectors.toList(), value -> (QTLineDetail)value.get(0))));
        }
        List<QTLineDetail> qtLineDetails = QuotaCrossManageOrgUtils.updateAndSetLineCache(attFileModel, qtGenConfig, context);
        if (!WTCCollections.isEmpty(curQtDetails)) {
            long[] ids = IDService.get().genLongIds(curQtDetails.size());
            for (int index = 0; index < curQtDetails.size(); ++index) {
                QTLineDetail qtLineDetail = (QTLineDetail)curQtDetails.get(index);
                if (QuotaCrossManageOrgUtils.isZeroManueDetail(qtLineDetail)) continue;
                QTLineDetail newQtLineDetail = (QTLineDetail)oldQtLineDetailMap.get(qtLineDetail.getBid());
                newQtLineDetail = newQtLineDetail == null ? new QTLineDetail() : newQtLineDetail;
                Date createTime = newQtLineDetail.getCreateTime();
                if (createTime == null) {
                    newQtLineDetail.setCreateTime(new Date());
                }
                newQtLineDetail.rememberOriginalId();
                QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(newQtLineDetail);
                newQtLineDetail.setId(ids[index]);
                newQtLineDetail.setAttFileBoId(attFileModel.getBid());
                newQtLineDetail.setOrgId(attFileModel.getOrgId().longValue());
                newQtLineDetail.setAttFileVid(attFileModel.getId());
                newQtLineDetail.setQtTypeId(context.getQuotaTypeId().longValue());
                newQtLineDetail.setpCycleId(context.getCircleRestVo().getCycSetId().longValue());
                newQtLineDetail.setPeriodNum(context.getCircleRestVo().getIndex().intValue());
                newQtLineDetail.setSource(QuotaDetailType.BO_SETTLEMENT.getCode());
                newQtLineDetail.setUseEndDate(qtLineDetail.getUseEndDate());
                newQtLineDetail.setUseStartDate(qtLineDetail.getUseStartDate());
                newQtLineDetail.setGenStartDate(qtLineDetail.getGenStartDate());
                newQtLineDetail.setGenEndDate(qtLineDetail.getGenEndDate());
                BigDecimal genvalue = BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(qtLineDetail.getSettlementValue()) != 0) {
                    genvalue = QuotaAttItemStatus.LOSE_EFFECT.getCode().equals(qtLineDetail.getBusstatus()) ? BigDecimal.ZERO : qtLineDetail.getSettlementValue();
                }
                newQtLineDetail.setGenValue(genvalue);
                newQtLineDetail.setOwnValue(genvalue);
                if (qtOverConfig != null && BigDecimal.ZERO.compareTo(qtLineDetail.getCdCanBeOdValue()) != 0) {
                    BigDecimal value2 = QuotaAttItemStatus.LOSE_EFFECT.getCode().equals(qtLineDetail.getBusstatus()) ? BigDecimal.ZERO : qtLineDetail.getCdCanBeOdValue();
                    newQtLineDetail.setCanBeOdValue(value2);
                }
                newQtLineDetail.setDetailSourceId(qtLineDetail.getBid());
                QuotaAttItemInstance starQuotaAttItemInstance = new QuotaAttItemInstance(newQtLineDetail.getBid(), starAttItemSpec, newQtLineDetail.getGenValue(), AttitemUnitEnum.of((String)starAttItemSpec.getUnit()), QuotaAttItemType.STANDARD, QuotaDetailType.BO_SETTLEMENT, qtGenConfig.getQtType().getId(), qtGenConfig.getCycSet(), context.getCircleRestVo().getIndex(), context.getCircleRestVo().getAssignDate());
                starQuotaAttItemInstance.setGenEndDate(newQtLineDetail.getGenEndDate());
                starQuotaAttItemInstance.setGenStartDate(newQtLineDetail.getGenStartDate());
                starQuotaAttItemInstance.setOrgEndDay(endDate);
                starQuotaAttItemInstance.setAttFileBoId(newQtLineDetail.getAttFileBoId());
                starQuotaAttItemInstance.setAttFileVId(newQtLineDetail.getAttFileVid());
                QuotaAttItemValue starAttItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(starQuotaAttItemInstance)).build();
                starAttItemValue.setMatchedRule(qtCalRule);
                starAttItemValue.setEvaluationRule(EvaluationRuleModel.of(qtGenConfig.getId(), "wtp_qtgenconfig"));
                starAttItemValue.setEvaluationRule(EvaluationRuleModel.of(qtGenConfig.getCycSet(), "wtbd_cycset"));
                quotaAttItemValues.add(starAttItemValue);
                qtGenConfig.putQtGenCfEntryByDetail(newQtLineDetail.getBid(), entries.get(0));
                qtLineDetails.add(newQtLineDetail);
            }
        }
        if (!WTCCollections.isEmpty(preBoQtLineDetails) && WTCCollections.isEmpty(quotaAttItemValues)) {
            QuotaContextUtil.setEmptyDetailLineCache(attFileModel.getBid(), context, qtCalRule, entries.get(0));
        }
    }

    private static boolean isZeroManueDetail(QTLineDetail qtLineDetail) {
        if (!QuotaDetailType.MANUAL_GIVE.getCode().equals(qtLineDetail.getSource())) {
            return false;
        }
        return BigDecimal.ZERO.compareTo(qtLineDetail.getUsableValue()) == 0 && BigDecimal.ZERO.compareTo(qtLineDetail.getPastValue()) == 0 && BigDecimal.ZERO.compareTo(qtLineDetail.getCarryDownedValue()) == 0 && BigDecimal.ZERO.compareTo(qtLineDetail.getSettlementValue()) == 0 && BigDecimal.ZERO.compareTo(qtLineDetail.getCdCanBeOdValue()) == 0;
    }

    private static List<QTLineDetail> updateAndSetLineCache(AttFileModel attFileModel, QTGenConfig qtGenConfig, QuotaContextStd context) {
        String qtLineKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)qtGenConfig.getQtType().getId(), (long)qtGenConfig.getCycSet(), (long)context.getCircleRestVo().getIndex().intValue());
        ArrayList qtLineDetails = (ArrayList)context.getVariable(qtLineKey, VScope.LINE);
        if (qtLineDetails == null) {
            qtLineDetails = new ArrayList();
            context.setVariable(qtLineKey, qtLineDetails, VScope.LINE);
        }
        return qtLineDetails;
    }

    public static void genSettlement(QuotaAttItemValueStd attItemValueStd, List<QuotaAttItemValue> quotaDataNodeList, QuotaContextStd contextStd, QuotaAttItemValueStd canBeOdStd) {
        QuotaAttItemInstance instance = attItemValueStd.getAttItemInstance();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)instance.getQttypeId(), (long)instance.getPeriodcircleId(), (long)instance.getPeriodNum().intValue());
        List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        QTCalRule qtCalRule = (QTCalRule)attItemValueStd.getMatchedRule();
        if (qtCalRule == null || qtCalRule.getCarryDown() == null || qtCalRule.getGenConfig() == null) {
            LOG.warn("QTCarryOverEvaluator not found qtCalRule");
            return;
        }
        QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(instance.getOrgEndDay());
        if (qtGenConfig == null) {
            LOG.warn("QTCarryOverEvaluator not found qtGenConfig version");
            return;
        }
        AttItemSpecData attItemSpecData = contextStd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        QTCarryDown carryDown = (QTCarryDown)qtCalRule.getCarryDown().getVersionByDate(instance.getOrgEndDay());
        if (carryDown == null) {
            LOG.warn("QTCarryOverEvaluator not found carryDown version");
            return;
        }
        long settlementId = carryDown.getSlmentAttItem();
        if (settlementId == 0L) {
            LOG.warn("QTCarryOverEvaluator not found settlementId ");
            return;
        }
        AttItemSpec slmentAttItemSpec = attItemSpecData.getByBidAndDate(settlementId, contextStd.getChainDate());
        if (null == slmentAttItemSpec) {
            LOG.warn("QTCarryOverEvaluator not found slmentAttItemSpec");
            return;
        }
        long qtDetailId = instance.getQtDetailId();
        BigDecimal settlementResult = instance.getItemValue();
        if (BigDecimal.ZERO.compareTo(settlementResult) > 0) {
            return;
        }
        QuotaAttItemInstance slemnetInstance = new QuotaAttItemInstance(qtDetailId, slmentAttItemSpec, settlementResult, AttitemUnitEnum.of((String)slmentAttItemSpec.getUnit()), QuotaAttItemType.QUIT_SETTLEMENT, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
        slemnetInstance.setGenStartDate(instance.getGenStartDate());
        slemnetInstance.setGenEndDate(instance.getGenEndDate());
        slemnetInstance.setUseStartDate(instance.getUseStartDate());
        slemnetInstance.setUseEndDate(instance.getUseEndDate());
        slemnetInstance.setOrgEndDay(instance.getOrgEndDay());
        slemnetInstance.setVestType(VestTypeEnum.SETTLEMENT.getCode());
        slemnetInstance.setAttFileVId(instance.getAttFileVId());
        slemnetInstance.setAttFileBoId(instance.getAttFileBoId());
        QuotaAttItemValue sdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(slemnetInstance)).matchedRule(attItemValueStd.getMatchedRule())).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
        quotaDataNodeList.add(sdtAttItemValue);
        QuotaAttItemInstance stdInstance = new QuotaAttItemInstance(qtDetailId, instance.getAttItemSpec(), BigDecimal.ZERO, AttitemUnitEnum.of((String)instance.getAttItemSpec().getUnit()), QuotaAttItemType.AVAILABLE, instance.getSource(), instance.getQttypeId(), instance.getPeriodcircleId(), instance.getPeriodNum(), instance.getPeriodAttribtion());
        stdInstance.setGenStartDate(instance.getGenStartDate());
        stdInstance.setGenEndDate(instance.getGenEndDate());
        stdInstance.setUseStartDate(instance.getUseStartDate());
        stdInstance.setUseEndDate(instance.getUseEndDate());
        stdInstance.setOrgEndDay(instance.getOrgEndDay());
        stdInstance.setAttFileVId(instance.getAttFileVId());
        stdInstance.setAttFileBoId(instance.getAttFileBoId());
        QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(stdInstance)).matchedRule(attItemValueStd.getMatchedRule())).parentDataNodes(Collections.singletonList(attItemValueStd))).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
        quotaDataNodeList.add(quotaSdtAttItemValue);
        if (canBeOdStd != null && canBeOdStd.getAttItemInstance() != null) {
            QuotaAttItemInstance canBeOdInstance = canBeOdStd.getAttItemInstance();
            QuotaAttItemInstance canBeOdstdInstance = new QuotaAttItemInstance(canBeOdInstance.getQtDetailId(), canBeOdInstance.getAttItemSpec(), BigDecimal.ZERO, AttitemUnitEnum.of((String)canBeOdInstance.getAttItemSpec().getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, canBeOdInstance.getSource(), canBeOdInstance.getQttypeId(), canBeOdInstance.getPeriodcircleId(), canBeOdInstance.getPeriodNum(), canBeOdInstance.getPeriodAttribtion());
            canBeOdstdInstance.setGenStartDate(canBeOdInstance.getGenStartDate());
            canBeOdstdInstance.setGenEndDate(canBeOdInstance.getGenEndDate());
            canBeOdstdInstance.setUseStartDate(canBeOdInstance.getUseStartDate());
            canBeOdstdInstance.setUseEndDate(canBeOdInstance.getUseEndDate());
            canBeOdstdInstance.setAttFileBoId(canBeOdInstance.getAttFileBoId());
            canBeOdstdInstance.setAttFileVId(canBeOdInstance.getAttFileVId());
            QuotaAttItemValue canBeOdSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(canBeOdstdInstance)).matchedRule(canBeOdStd.getMatchedRule())).parentDataNodes(Collections.singletonList(canBeOdStd))).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
            quotaDataNodeList.add(canBeOdSdtAttItemValue);
        }
        if (!CollectionUtils.isEmpty((Collection)qtDetails)) {
            qtDetails.forEach(qtLineDetail -> {
                if (qtLineDetail.getBid() == qtDetailId) {
                    if (slemnetInstance != null) {
                        qtLineDetail.setSettlementValue(slemnetInstance.getItemValue());
                    }
                    qtLineDetail.setUsableValue(BigDecimal.ZERO);
                    qtLineDetail.setCdCanBeOdValue(qtLineDetail.getCanBeOdValue());
                    qtLineDetail.setCanBeOdValue(BigDecimal.ZERO);
                    qtLineDetail.setSettlement(Boolean.TRUE.booleanValue());
                }
            });
        }
    }

    public static void genSettlement(QTLineDetail qtLineDetail, List<QuotaAttItemValue> quotaDataNodeList, QuotaContextStd contextStd, QTCalRule qtCalRule, List<QTLineDetail> needUpdateDetails, QTGenConfigEntry qtGenConfigEntry) {
        QTOverDraw qtOverDraw;
        AttItemSpec overAttItemSpec;
        BigDecimal cdCanBeOdValue;
        BigDecimal settlementResult;
        if (qtCalRule == null) {
            LOG.warn("QTCarryOverEvaluator not found qtCalRule");
            return;
        }
        AttItemSpecData attItemSpecData = contextStd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        QTCarryDown carryDown = (QTCarryDown)qtCalRule.getCarryDown().getVersionByDate(contextStd.getChainDate());
        if (carryDown == null) {
            LOG.warn("QTCarryOverEvaluator not found carryDown version");
            return;
        }
        long settlementId = carryDown.getSlmentAttItem();
        if (settlementId == 0L) {
            LOG.warn("QTCarryOverEvaluator not found settlementId ");
            return;
        }
        AttItemSpec slmentAttItemSpec = attItemSpecData.getByBidAndDate(settlementId, contextStd.getChainDate());
        if (null == slmentAttItemSpec) {
            LOG.warn("QTCarryOverEvaluator not found slmentAttItemSpec");
            return;
        }
        if (qtGenConfigEntry == null) {
            LOG.warn("QTCarryOverEvaluator not found qtGenConfigEntry");
            return;
        }
        AttItemSpec stdAttItemSpec = attItemSpecData.getByBidAndDate(qtGenConfigEntry.getUsableAttItem(), contextStd.getChainDate());
        if (null == stdAttItemSpec) {
            LOG.warn("QTCarryOverEvaluator not found stdAttItemSpec");
            return;
        }
        long qtDetailId = qtLineDetail.getBid();
        if (qtLineDetail.isSettlement()) {
            settlementResult = qtLineDetail.getSettlementValue();
        } else {
            BigDecimal bigDecimal = settlementResult = BigDecimal.ZERO.compareTo(qtLineDetail.getUsableValue()) == 0 && BigDecimal.ZERO.compareTo(qtLineDetail.getSettlementValue()) != 0 ? qtLineDetail.getSettlementValue() : qtLineDetail.getUsableValue();
        }
        if (BigDecimal.ZERO.compareTo(settlementResult) > 0) {
            return;
        }
        if (qtLineDetail.isSettlement()) {
            cdCanBeOdValue = qtLineDetail.getCdCanBeOdValue();
        } else {
            BigDecimal bigDecimal = cdCanBeOdValue = qtLineDetail.getSettlementValueId() != 0L && BigDecimal.ZERO.compareTo(qtLineDetail.getCanBeOdValue()) == 0 && BigDecimal.ZERO.compareTo(qtLineDetail.getCdCanBeOdValue()) != 0 ? qtLineDetail.getCdCanBeOdValue() : qtLineDetail.getCanBeOdValue();
        }
        if (BigDecimal.ZERO.compareTo(settlementResult) == 0 && BigDecimal.ZERO.compareTo(cdCanBeOdValue) == 0) {
            return;
        }
        QuotaAttItemInstance slemnetInstance = new QuotaAttItemInstance(qtDetailId, slmentAttItemSpec, settlementResult, AttitemUnitEnum.of((String)slmentAttItemSpec.getUnit()), QuotaAttItemType.QUIT_SETTLEMENT, QuotaDetailType.of(qtLineDetail.getSource()), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), contextStd.getCircleRestVo().getAssignDate());
        slemnetInstance.setGenStartDate(qtLineDetail.getGenStartDate());
        slemnetInstance.setGenEndDate(qtLineDetail.getGenEndDate());
        slemnetInstance.setUseStartDate(qtLineDetail.getUseStartDate());
        slemnetInstance.setUseEndDate(qtLineDetail.getUseEndDate());
        slemnetInstance.setOrgEndDay(contextStd.getChainDate());
        slemnetInstance.setVestType(VestTypeEnum.SETTLEMENT.getCode());
        slemnetInstance.setAttFileVId(qtLineDetail.getAttFileVid());
        slemnetInstance.setAttFileBoId(qtLineDetail.getAttFileBoId());
        QuotaAttItemValue sdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(slemnetInstance)).matchedRule(qtCalRule)).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
        quotaDataNodeList.add(sdtAttItemValue);
        QuotaAttItemInstance stdInstance = new QuotaAttItemInstance(qtDetailId, stdAttItemSpec, BigDecimal.ZERO, AttitemUnitEnum.of((String)stdAttItemSpec.getUnit()), QuotaAttItemType.AVAILABLE, QuotaDetailType.of(qtLineDetail.getSource()), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), contextStd.getCircleRestVo().getAssignDate());
        stdInstance.setGenStartDate(qtLineDetail.getGenStartDate());
        stdInstance.setGenEndDate(qtLineDetail.getGenEndDate());
        stdInstance.setUseStartDate(qtLineDetail.getUseStartDate());
        stdInstance.setUseEndDate(qtLineDetail.getUseEndDate());
        stdInstance.setOrgEndDay(contextStd.getChainDate());
        stdInstance.setAttFileVId(qtLineDetail.getAttFileVid());
        stdInstance.setAttFileBoId(qtLineDetail.getAttFileBoId());
        QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(stdInstance)).matchedRule(qtCalRule)).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
        quotaDataNodeList.add(quotaSdtAttItemValue);
        if (qtCalRule.getOverDraw() != null && qtCalRule.getOverDraw().getVersionByDate(contextStd.getChainDate()) != null && null != (overAttItemSpec = attItemSpecData.getByBidAndDate((qtOverDraw = (QTOverDraw)qtCalRule.getOverDraw().getVersionByDate(contextStd.getChainDate())).getCanOdValue(), contextStd.getChainDate()))) {
            QuotaAttItemInstance canBeOdstdInstance = new QuotaAttItemInstance(qtLineDetail.getBid(), overAttItemSpec, BigDecimal.ZERO, AttitemUnitEnum.of((String)overAttItemSpec.getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, QuotaDetailType.of(qtLineDetail.getSource()), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), contextStd.getCircleRestVo().getAssignDate());
            canBeOdstdInstance.setGenStartDate(qtLineDetail.getGenStartDate());
            canBeOdstdInstance.setGenEndDate(qtLineDetail.getGenEndDate());
            canBeOdstdInstance.setUseStartDate(qtLineDetail.getUseStartDate());
            canBeOdstdInstance.setUseEndDate(qtLineDetail.getUseEndDate());
            canBeOdstdInstance.setAttFileBoId(qtLineDetail.getAttFileBoId());
            canBeOdstdInstance.setAttFileVId(qtLineDetail.getAttFileVid());
            QuotaAttItemValue canBeOdSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(canBeOdstdInstance)).matchedRule(qtCalRule)).evaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"))).build();
            quotaDataNodeList.add(canBeOdSdtAttItemValue);
        }
        qtLineDetail.setSettlementValue(slemnetInstance.getItemValue());
        qtLineDetail.setUsableValue(BigDecimal.ZERO);
        qtLineDetail.setCdCanBeOdValue(cdCanBeOdValue);
        qtLineDetail.setCanBeOdValue(BigDecimal.ZERO);
        qtLineDetail.setSettlement(Boolean.TRUE.booleanValue());
        needUpdateDetails.add(qtLineDetail);
    }
}

