/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTAdjustDetailInfo;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTGenTypeEnum;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QuotaDetailAdjustUtils {
    public static <T extends QTAdjustDetailInfo> void matchQtDetailAdjust(Map<Long, List<T>> matchQTDetailAdjusts, List<T> allQTDetailAdjusts, List<QuotaAttItemValueStd> quotaAttItemValueStds, List<QuotaAttItemValueStd> starAttItemValueStds, List<QTLineDetail> qtDetails) {
        if (matchQTDetailAdjusts == null || WTCCollections.isEmpty(allQTDetailAdjusts) || WTCCollections.isEmpty(quotaAttItemValueStds) || WTCCollections.isEmpty(qtDetails)) {
            return;
        }
        List manuals = allQTDetailAdjusts.stream().filter(adjust -> QuotaDetailType.MANUAL_GIVE.getCode().equals(adjust.getSource())).collect(Collectors.toList());
        List boSettlements = allQTDetailAdjusts.stream().filter(adjust -> QuotaDetailType.BO_SETTLEMENT.getCode().equals(adjust.getSource())).collect(Collectors.toList());
        List sysLists = allQTDetailAdjusts.stream().filter(adjust -> QuotaDetailType.CUR_PERIOD_GEN.getCode().equals(adjust.getSource())).collect(Collectors.toList());
        Map<Long, List<T>> manualMap = manuals.stream().collect(Collectors.groupingBy(QTAdjustDetailInfo::getQtDetailId));
        Map<Long, List<T>> settlementMap = boSettlements.stream().collect(Collectors.groupingBy(QTAdjustDetailInfo::getQtDetailId));
        Map<String, List<T>> sysMap = sysLists.stream().collect(Collectors.groupingBy(adjust -> QuotaDetailAdjustUtils.groupByKey(adjust)));
        if (!WTCCollections.isEmpty(manualMap)) {
            QuotaDetailAdjustUtils.manualDetailMatch(matchQTDetailAdjusts, manualMap, quotaAttItemValueStds);
        }
        if (!WTCCollections.isEmpty(settlementMap)) {
            QuotaDetailAdjustUtils.settlementDetailMatch(matchQTDetailAdjusts, settlementMap, quotaAttItemValueStds);
        }
        if (!WTCCollections.isEmpty(sysMap)) {
            QuotaDetailAdjustUtils.sysDetailMatch(matchQTDetailAdjusts, sysMap, quotaAttItemValueStds, qtDetails, starAttItemValueStds);
        }
    }

    private static <T extends QTAdjustDetailInfo> void manualDetailMatch(Map<Long, List<T>> matchQTDetailAdjusts, Map<Long, List<T>> manualMap, List<QuotaAttItemValueStd> quotaAttItemValueStds) {
        List manualAttItemValueStds = quotaAttItemValueStds.stream().filter(std -> QuotaDetailType.MANUAL_GIVE == std.getAttItemInstance().getSource()).collect(Collectors.toList());
        for (QuotaAttItemValueStd attItemValueStd : manualAttItemValueStds) {
            Long qtLineDetailId = attItemValueStd.getAttItemInstance().getQtDetailId();
            List<T> qtDetailAdjusts = manualMap.get(qtLineDetailId);
            if (WTCCollections.isEmpty(qtDetailAdjusts)) continue;
            matchQTDetailAdjusts.put(qtLineDetailId, qtDetailAdjusts);
        }
    }

    private static <T extends QTAdjustDetailInfo> void settlementDetailMatch(Map<Long, List<T>> matchQTDetailAdjusts, Map<Long, List<T>> settlementMap, List<QuotaAttItemValueStd> quotaAttItemValueStds) {
        List manualAttItemValueStds = quotaAttItemValueStds.stream().filter(std -> QuotaDetailType.BO_SETTLEMENT == std.getAttItemInstance().getSource()).collect(Collectors.toList());
        for (QuotaAttItemValueStd attItemValueStd : manualAttItemValueStds) {
            Long qtLineDetailId = attItemValueStd.getAttItemInstance().getQtDetailId();
            List<T> qtDetailAdjusts = settlementMap.get(qtLineDetailId);
            if (WTCCollections.isEmpty(qtDetailAdjusts)) continue;
            matchQTDetailAdjusts.put(qtLineDetailId, qtDetailAdjusts);
        }
    }

    private static <T extends QTAdjustDetailInfo> void sysDetailMatch(Map<Long, List<T>> matchQTDetailAdjusts, Map<String, List<T>> sysyMap, List<QuotaAttItemValueStd> quotaAttItemValueStds, List<QTLineDetail> qtDetails, List<QuotaAttItemValueStd> starAttItemValueStds) {
        if (WTCCollections.isEmpty(starAttItemValueStds)) {
            return;
        }
        List sysAttItemValueStds = quotaAttItemValueStds.stream().filter(std -> QuotaDetailType.CUR_PERIOD_GEN == std.getAttItemInstance().getSource()).collect(Collectors.toList());
        for (QuotaAttItemValueStd attItemValueStd : sysAttItemValueStds) {
            List<T> qtDetailAdjusts;
            QTCalRule matchedRule = (QTCalRule)attItemValueStd.getMatchedRule();
            QTGenConfig qtGenConfig = (QTGenConfig)matchedRule.getGenConfig().getVersionByDate(attItemValueStd.getAttItemInstance().getOrgEndDay());
            String key = QuotaDetailAdjustUtils.getKey(attItemValueStd.getAttItemInstance());
            Long qtLineDetailId = attItemValueStd.getAttItemInstance().getQtDetailId();
            QTLineDetail qtLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == qtLineDetailId.longValue()).findFirst().orElse(null);
            QuotaAttItemValueStd startAttItemValueStd = starAttItemValueStds.stream().filter(qt -> qtLineDetailId.equals(qt.getAttItemInstance().getQtDetailId())).findFirst().orElse(null);
            if (qtLineDetail == null || startAttItemValueStd == null || WTCCollections.isEmpty(qtDetailAdjusts = sysyMap.get(key = qtLineDetail.getAttFileBoId() + "_" + key))) continue;
            if (QTGenTypeEnum.GEN_DYNAMIC == qtGenConfig.getQtType().getqTGenTypeEnum()) {
                qtDetailAdjusts = qtDetailAdjusts.stream().filter(qt -> qtLineDetail.getBid() == qt.getQtDetailId().longValue()).collect(Collectors.toList());
            }
            if (WTCCollections.isEmpty(qtDetailAdjusts)) continue;
            if (!startAttItemValueStd.getAttItemInstance().isCross()) {
                matchQTDetailAdjusts.put(qtLineDetailId, qtDetailAdjusts);
                continue;
            }
            QuotaDetailAdjustUtils.crossOrgMatch(startAttItemValueStd, matchQTDetailAdjusts, qtLineDetail, qtDetailAdjusts);
        }
    }

    private static <T extends QTAdjustDetailInfo> void crossOrgMatch(QuotaAttItemValueStd starAttItemValueStd, Map<Long, List<T>> matchQTDetailAdjusts, QTLineDetail qtLineDetail, List<T> qtDetailAdjusts) {
        List orderLitst = qtDetailAdjusts.stream().filter(adjust -> QuotaDetailAdjustUtils.filterCrossDay(adjust, starAttItemValueStd)).collect(Collectors.toList());
        if (!WTCCollections.isEmpty(orderLitst)) {
            matchQTDetailAdjusts.put(qtLineDetail.getBid(), orderLitst);
        }
    }

    private static <T extends QTAdjustDetailInfo> boolean filterCrossDay(T adjust, QuotaAttItemValueStd starAttItemValueStd) {
        boolean isSameChangeDay = adjust.getCrossDay() != null && adjust.getCrossDay().compareTo(starAttItemValueStd.getAttItemInstance().getChangeEnd()) == 0;
        return isSameChangeDay;
    }

    private static boolean isCrossOrg(List<QuotaAttItemValueStd> sysAttItemValueStds, List<QTLineDetail> qtDetails) {
        Set qtDetailIds = sysAttItemValueStds.stream().map(qt -> qt.getAttItemInstance().getQtDetailId()).collect(Collectors.toSet());
        List qtLineDetails = qtDetails.stream().filter(qtLineDetail -> qtDetailIds.contains(qtLineDetail.getBid())).collect(Collectors.toList());
        if (!WTCCollections.isEmpty(qtLineDetails)) {
            Set attFileVids = qtLineDetails.stream().map(QTLineDetail::getAttFileVid).collect(Collectors.toSet());
            if (!WTCCollections.isEmpty(qtLineDetails) && attFileVids.size() > 1) {
                return true;
            }
        }
        return false;
    }

    private static <T extends QTAdjustDetailInfo> String groupByKey(T adjust) {
        return adjust.getAttFileBoId() + "_" + adjust.getQttype() + "_" + adjust.getPeriodCircle() + "_" + adjust.getPeriodNum();
    }

    private static String getKey(QuotaAttItemInstance attItemValue) {
        return attItemValue.getQttypeId() + "_" + attItemValue.getPeriodcircleId() + "_" + attItemValue.getPeriodNum();
    }
}

