/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.math.BigDecimal;
import java.util.Set;
import java.util.function.Function;
import kd.wtc.wtes.business.quota.model.QTLineDetailItemRefer;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public final class QuotaDetailClearUtils {
    private static final String key_itemRefer = "key_itemRefer";

    public static void rememberOldReferAndClearNoGenValue(QTLineDetail line) {
        QTLineDetailItemRefer refer = new QTLineDetailItemRefer(line);
        line.setExtAttribute(key_itemRefer, (Object)refer);
        line.clearNoGenValue();
    }

    public static void pourAllOldReferId(QTLineDetail line, Set<Long> coll) {
        QTLineDetailItemRefer refer = (QTLineDetailItemRefer)line.getExtAttribute(key_itemRefer);
        if (refer != null) {
            refer.pourAllReferId(coll);
        }
    }

    public static void addOldReferId(Set<Long> coll, Function<QTLineDetail, Long> referIdGetter, QTLineDetail line) {
        Long referId = referIdGetter.apply(line);
        if (referId != null && referId != 0L) {
            coll.add(referId);
        }
    }

    public static void pourDeductItem(QTLineDetail line, Set<Long> needDelQuotaDetailId) {
        if (CheckUtils.isZero((BigDecimal)line.getFreezeValue())) {
            needDelQuotaDetailId.add(line.getFreezeValueId());
            line.setFreezeValueId(0L);
        }
        if (CheckUtils.isZero((BigDecimal)line.getUsedValue())) {
            needDelQuotaDetailId.add(line.getUsedValueId());
            line.setUsedValueId(0L);
        }
        if (CheckUtils.isZero((BigDecimal)line.getInvalidValue())) {
            needDelQuotaDetailId.add(line.getInvalidValueId());
            line.setInvalidValueId(0L);
        }
        if (CheckUtils.isZero((BigDecimal)line.getCanBeOdValue())) {
            needDelQuotaDetailId.add(line.getCanBeOdValueId());
            line.setCanBeOdValueId(0L);
        }
        if (CheckUtils.isZero((BigDecimal)line.getUseOdValue())) {
            needDelQuotaDetailId.add(line.getUseOdValueId());
            line.setUseOdValueId(0L);
        }
    }
}

