/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtes.business.qte.refdate.AfterQteResolveRefDateEvent;
import kd.sdk.wtc.wtes.business.qte.refdate.QteRefDateResolutionExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.common.enums.circle.CycRefDateEnum;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.attendperson.EffectAttendPersonData;
import kd.wtc.wtes.business.model.attendperson.EffectAttendPersonInfo;
import kd.wtc.wtes.business.quota.model.QuotaEmployeeData;
import kd.wtc.wtes.business.quota.model.QuotaExtPluginHolder;

public final class RefDateUtils {
    public static Map<Long, Date> getRefDateMap(AttendPersonModel attendPerson, AttFileModel attFileModel, long personBid, List<Long> expectRefDateIdList, LocalDate baseDate, Map<String, Object> initParams) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        EffectAttendPersonData effectAttendPersonData = (EffectAttendPersonData)initParams.get("EFF_ATT_PERINFO");
        QuotaEmployeeData employeeData = (QuotaEmployeeData)((Object)initParams.get("FIRST_EMPLOYEE_STARTDAY"));
        Date workBigDate = null;
        if (employeeData.getEarlistEmployeeStartDay() != null) {
            workBigDate = employeeData.getEarlistEmployeeStartDay().get(attFileModel.getBid());
        }
        if (null != attendPerson) {
            map.put(CycRefDateEnum.FIRST_WORKING_DATE.getId(), attendPerson.getEmpEntRel() == null ? null : attendPerson.getEmpEntRel().getFirstStartDate());
            map.put(CycRefDateEnum.WORKING_BEGIN_DATE.getId(), workBigDate);
            map.put(CycRefDateEnum.WORKING_END_DATE.getId(), attendPerson.getEmployee() == null ? null : attendPerson.getEmployee().getEndDate());
            map.put(CycRefDateEnum.EXIT_DATE.getId(), attendPerson.getEmployee() == null ? null : attendPerson.getEmployee().getSysEndDate());
            map.put(CycRefDateEnum.LAST_DATE.getId(), attendPerson.getEmployee() == null ? null : attendPerson.getEmployee().getLastWorkDate());
            map.put(CycRefDateEnum.REGULAR_DATE.getId(), attendPerson.getTrialPeriod() == null ? null : attendPerson.getTrialPeriod().getRegularDate());
            map.put(CycRefDateEnum.JOIN_WORK_DATE.getId(), attendPerson.getPerNonTsProp() == null ? null : attendPerson.getPerNonTsProp().getBeginServiceDate());
            map.put(CycRefDateEnum.MARRIED_DATE.getId(), attendPerson.getPerNonTsProp() == null ? null : attendPerson.getPerNonTsProp().getMarryDate());
            map.put(CycRefDateEnum.CHILD_BIRTH_DATE.getId(), attendPerson.getFertilityInfo() == null ? null : attendPerson.getFertilityInfo().getBirthday());
        }
        if (effectAttendPersonData != null) {
            Map<Long, EffectAttendPersonInfo> effectAttendPersonInfoMap = effectAttendPersonData.getEffectAttendPersonInfoMap();
            EffectAttendPersonInfo effectAttendPersonInfo = null;
            if (effectAttendPersonInfoMap != null) {
                effectAttendPersonInfo = effectAttendPersonInfoMap.get(personBid);
            }
            if (effectAttendPersonInfo != null) {
                map.put(CycRefDateEnum.SYS_GENG_END_DATE.getId(), effectAttendPersonInfo.getQtFirstEffectDate() == null ? null : effectAttendPersonInfo.getQtFirstEffectDate());
            }
        }
        QuotaExtPluginHolder pluginHolder = (QuotaExtPluginHolder)initParams.get("QT_EXT_PLUGIN");
        WTCPluginProxy instance = (WTCPluginProxy)pluginHolder.getPlugin(QteRefDateResolutionExtPlugin.class.getName());
        List expectRefDateIdSet = expectRefDateIdList.stream().distinct().filter(Objects::nonNull).filter(ele -> ele != 0L).collect(Collectors.toList());
        Object initDataExt = initParams.get("QT_EXT_PARAM");
        for (Long refDateId : expectRefDateIdSet) {
            Date srcRefDate = (Date)map.get(refDateId);
            Date refDate = null;
            if (srcRefDate != null) {
                refDate = new Date(srcRefDate.getTime());
            }
            AfterQteResolveRefDateEvent event = new AfterQteResolveRefDateEvent(personBid, attFileModel.getBid(), attFileModel.getId(), baseDate, refDateId.longValue(), refDate, initDataExt, WTCMaps.unmodifiableMap(initParams));
            instance.invokeReplace(plugin -> plugin.afterResolveRefDate(event));
            map.put(refDateId, event.getRefDate() != null ? event.getRefDate() : srcRefDate);
        }
        return map;
    }
}

