/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.sdk.wtc.wtes.business.qte.varcondition.AfterQteResolveVarConditionEvent;
import kd.sdk.wtc.wtes.business.qte.varcondition.QteVarConditionResolutionExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.model.attendperson.AttendPerson;
import kd.wtc.wtbs.business.model.attendperson.PerNonTsProp;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EmployeeDateRecorder;
import kd.wtc.wtes.business.quota.model.QuotaExtPluginHolder;
import kd.wtc.wtes.business.quota.model.QuotaVarCondition;
import kd.wtc.wtes.business.quota.util.QTConditionsUtils;

public class VarConditionUtils {
    public static Map<String, Object> getVarConditionValue(AttendPerson attendPerson, AttFileModel attFileModel, long personBid, Set<String> params, LocalDate baseDate, Map<String, Object> initParams, Date startDay, Date endDay) {
        return VarConditionUtils.getVarConditionValue(attendPerson, attFileModel, personBid, params, baseDate, initParams, startDay, endDay, null);
    }

    public static Map<String, Object> getVarConditionValue(AttendPerson attendPerson, AttFileModel attFileModel, long personBid, Set<String> params, LocalDate baseDate, Map<String, Object> initParams, Date startDay, Date endDay, EmployeeDateRecorder dateRecorder) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        HashMap varMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet<Long> varIds = new HashSet<Long>(16);
        for (String param : params) {
            BigDecimal value = null;
            QuotaVarCondition varCondition = QuotaVarCondition.of(Long.valueOf(param));
            switch (varCondition) {
                case AGE: {
                    PerNonTsProp perNonTsProp = attendPerson.getPerNonTsProp();
                    Date birthDay = perNonTsProp.getBirthDay();
                    int startAge = QTConditionsUtils.calculateAge(birthDay, endDay);
                    value = new BigDecimal(startAge);
                    map.put(param, value);
                    break;
                }
                case WORK_AGE: {
                    int startWorkAge = 0;
                    if (dateRecorder != null) {
                        startWorkAge = (int)dateRecorder.getTypeAgeInDate("socialWork", endDay);
                    }
                    value = new BigDecimal(startWorkAge);
                    map.put(param, value);
                    break;
                }
                case CMP_AGE: {
                    int startCmpAge = 0;
                    if (dateRecorder != null) {
                        startCmpAge = (int)dateRecorder.getTypeAgeInDate("companyWork", endDay);
                    }
                    value = new BigDecimal(startCmpAge);
                    map.put(param, value);
                }
            }
            varIds.add(Long.valueOf(param));
            varMap.put(Long.valueOf(param), value);
        }
        Object initDataExt = initParams.get("QT_EXT_PARAM");
        QuotaExtPluginHolder pluginHolder = (QuotaExtPluginHolder)initParams.get("QT_EXT_PLUGIN");
        WTCPluginProxy instance = (WTCPluginProxy)pluginHolder.getPlugin(QteVarConditionResolutionExtPlugin.class.getName());
        AfterQteResolveVarConditionEvent event = new AfterQteResolveVarConditionEvent(personBid, attFileModel.getBid(), attFileModel.getId(), baseDate, varIds, (Map)varMap, startDay, endDay, initDataExt, Collections.unmodifiableMap(initParams));
        instance.invokeReplace(plugin -> plugin.afterResolveVarValue(event));
        for (String param : params) {
            BigDecimal value = event.getVarValue(Long.valueOf(param));
            value = value == null ? BigDecimal.ZERO : value;
            map.put(param, value);
        }
        return map;
    }
}

