/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.validator;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.validator.TieLineValidatorException;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.validator.AbstractQuotaLineValidator;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttQuotaFileValidator
extends AbstractQuotaLineValidator {
    @Override
    public void validate() {
        Long personId = this.attSubject.getPersonId();
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.initParams.get("ATT_FILE");
        List<TimeSeqBo<AttFileModel>> attFileModelTimeSeqBoList = attFileCabinet.getByAttPersonId(personId);
        if (null == attFileModelTimeSeqBoList) {
            throw new TieLineValidatorException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5f53\u524d\u8003\u52e4\u4eba\u7684\u6863\u6848\u3002", (String)"AttQuotaFileValidator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        List<AttFileInfo> attFileInfoList = this.attSubject.getAttFileInfoList();
        List<Long> selectBoIds = this.quotaRequest.getAttFileBoids();
        AttRecordDetailHolder holder = (AttRecordDetailHolder)this.initParams.get("QT_ATT_RECORD_DETAIL");
        Map<String, QuotaCycInfo> holderMap = holder.getCycSetMap();
        for (AttFileInfo attFileInfo : attFileInfoList) {
            QuotaCycInfo quotaCycInfo;
            LocalDate chainDate = WTCDateUtils.toLocalDate((Date)attFileInfo.getEndDate());
            AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(personId, chainDate, attFileInfo.getAttFileBaseBoId());
            if (!QTAccountModeHelper.isDeductChain((String)this.getQuotaRequest().getAccountMode()) && (quotaCycInfo = holderMap.get(String.valueOf(attFileModel.getBid()))) != null) {
                attFileInfo.setLegal(Boolean.FALSE);
                attFileInfo.setMessage(quotaCycInfo.getErrorMsg());
                continue;
            }
            if (null != attFileModel && attFileModel.getAttQtPackage(chainDate) != null && selectBoIds.contains(attFileInfo.getAttFileBaseBoId())) continue;
            if (null == attFileModel) {
                attFileInfo.setLegal(Boolean.FALSE);
                attFileInfo.setMessage(ResManager.loadKDString((String)"\u201c\u8003\u52e4\u6863\u6848\u201d\u672a\u914d\u7f6e\u201c\u5b9a\u989d\u65b9\u6848\u201d\uff0c\u65e0\u6cd5\u6267\u884c\u5b9a\u989d\u8ba1\u7b97\uff0c\u8bf7\u524d\u5f80\u201c\u8003\u52e4\u6863\u6848\u201d\u6267\u884c\u201c\u5b9a\u989d\u65b9\u6848\u201d\u7684\u914d\u7f6e\u3002", (String)"AttQuotaFileValidator_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
                continue;
            }
            List<AttFileScheduleEntity<TimeSeqBo<QTScheme>>> attFileScheduleEntityList = attFileModel.getAttQtPackageList();
            if (CollectionUtils.isEmpty(attFileScheduleEntityList)) {
                attFileInfo.setLegal(Boolean.FALSE);
                attFileInfo.setMessage(ResManager.loadKDString((String)"\u201c\u8003\u52e4\u6863\u6848\u201d\u672a\u914d\u7f6e\u201c\u5b9a\u989d\u65b9\u6848\u201d\uff0c\u65e0\u6cd5\u6267\u884c\u5b9a\u989d\u8ba1\u7b97\uff0c\u8bf7\u524d\u5f80\u201c\u8003\u52e4\u6863\u6848\u201d\u6267\u884c\u201c\u5b9a\u989d\u65b9\u6848\u201d\u7684\u914d\u7f6e\u3002", (String)"AttQuotaFileValidator_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
                continue;
            }
            Date endDate = null;
            Date startDate = null;
            if (attFileModel.getAttQtPackage(chainDate) != null) continue;
            Date fileStartDate = attFileModel.getStartDateTime();
            Date fileEndDate = attFileModel.getEndDateTime();
            Date chainDay = WTCDateUtils.toDate((LocalDate)chainDate);
            attFileScheduleEntityList.sort(Comparator.comparing(sched -> sched.getStartDate()));
            if (attFileScheduleEntityList.size() > 1) {
                for (int i = 1; i < attFileScheduleEntityList.size(); ++i) {
                    AttFileScheduleEntity<TimeSeqBo<QTScheme>> preSche = attFileScheduleEntityList.get(i - 1);
                    LocalDate endLocalDate = preSche.getEndDate();
                    LocalDate preStartLocalDate = preSche.getStartDate();
                    LocalDate startLocalDate = attFileScheduleEntityList.get(i).getStartDate();
                    LocalDate curLocalDate = attFileScheduleEntityList.get(i).getEndDate();
                    Date startDay = WTCDateUtils.toDate((LocalDate)startLocalDate);
                    Date endDay = WTCDateUtils.toDate((LocalDate)endLocalDate);
                    Date preStartDay = WTCDateUtils.toDate((LocalDate)preStartLocalDate);
                    Date curEndDay = WTCDateUtils.toDate((LocalDate)curLocalDate);
                    if (endDay.compareTo(chainDay) < 0 && startDay.compareTo(chainDay) > 0) {
                        endDate = WTCDateUtils.addDays((Date)startDay, (int)-1);
                        startDate = WTCDateUtils.addDays((Date)endDay, (int)1);
                    } else if (curEndDay.compareTo(chainDay) < 0 && i == attFileScheduleEntityList.size() - 1) {
                        endDate = fileEndDate;
                        startDate = WTCDateUtils.addDays((Date)curEndDay, (int)1);
                    } else {
                        if (preStartDay.compareTo(chainDay) <= 0 || i != 1) continue;
                        endDate = WTCDateUtils.addDays((Date)preStartDay, (int)-1);
                        startDate = fileStartDate;
                    }
                    break;
                }
            } else if (attFileScheduleEntityList.size() == 1) {
                AttFileScheduleEntity<TimeSeqBo<QTScheme>> sched2 = attFileScheduleEntityList.get(0);
                LocalDate endLocalDate = sched2.getEndDate();
                LocalDate startLocalDate = sched2.getStartDate();
                Date startDay = WTCDateUtils.toDate((LocalDate)startLocalDate);
                Date endDay = WTCDateUtils.toDate((LocalDate)endLocalDate);
                if (endDay.compareTo(chainDay) < 0) {
                    endDate = fileEndDate;
                    startDate = WTCDateUtils.addDays((Date)endDay, (int)1);
                }
                if (startDay.compareTo(chainDay) > 0) {
                    endDate = WTCDateUtils.addDays((Date)startDay, (int)-1);
                    startDate = fileStartDate;
                }
            }
            if (startDate == null || endDate == null) continue;
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(startDate);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(endDate);
            attFileInfo.setLegal(Boolean.FALSE);
            String msg = String.format(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u4e2d%1$s\u5e74%2$s\u6708%3$s\u65e5-%4$s\u5e74%5$s\u6708%6$s\u65e5\u4e0d\u5b58\u5728\u5b9a\u989d\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u8003\u52e4\u6863\u6848\u4e2d\u5b9a\u989d\u65b9\u6848\u7684\u914d\u7f6e\u3002", (String)"AttQuotaFileValidator_2", (String)"wtc-wtes-business", (Object[])new Object[0]), startCalendar.get(1), startCalendar.get(2) + 1, startCalendar.get(5), endCalendar.get(1), endCalendar.get(2) + 1, endCalendar.get(5));
            attFileInfo.setMessage(msg);
        }
    }
}

