/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ruleengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.model.access.ConditionDto;
import kd.wtc.wtes.business.model.access.Result;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.ruleengine.RuleEngineConf;
import kd.wtc.wtes.business.ruleengine.init.IRuleInitializer;
import kd.wtc.wtes.business.ruleengine.init.RuleInitializerFactory;
import kd.wtc.wtes.common.lang.WtesBizException;

public class RuleEngineInitHelper {
    private static String RULE_HASH_KEY = "ruleHashKey";
    private static String RULE_CONFMAP_KEY = "confMapKey";
    private static String RULE_BUSINESS_KEY = "businessMapKey";

    private RuleEngineInitHelper() {
    }

    public static void initConf(InitParam initRequest, Map<Long, RuleEngineConf> confMap, Map<Long, Object> businessRuleMap) {
        Map dynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)"wtp_ruleassociation", (String)"planid,policyid", (QFilter[])new QFilter[0]);
        HashMap policyIdToPlanIdMap = Maps.newHashMapWithExpectedSize((int)dynamicObjectsMap.size());
        for (Map.Entry entry : dynamicObjectsMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            long policyId = dynamicObject.getLong("policyId");
            List list = policyIdToPlanIdMap.computeIfAbsent(policyId, k -> new ArrayList(10));
            list.add(dynamicObject.getLong("planid"));
        }
        Map policyDynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)"brm_policy_edit", (String)"id,results,entrybulist.entitybu,entryrulelist.filtercondition,entryrulelist.filterresult", (QFilter[])new QFilter[]{new QFilter("id", "in", policyIdToPlanIdMap.keySet())});
        ArrayList<String> resultList = new ArrayList<String>(10);
        if (policyDynamicObjectsMap == null) {
            return;
        }
        for (Map.Entry entry : policyDynamicObjectsMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            DynamicObjectCollection entryBuList = dynamicObject.getDynamicObjectCollection("entrybulist");
            RuleEngineConf ruleEngineConf = new RuleEngineConf();
            long policyId = dynamicObject.getLong("id");
            ruleEngineConf.setStrategyId(policyId);
            if (!entryBuList.isEmpty()) {
                ruleEngineConf.setBuNumber(((DynamicObject)entryBuList.get(0)).getString("entitybu.number"));
            }
            DynamicObjectCollection entryRuleList = dynamicObject.getDynamicObjectCollection("entryrulelist");
            ArrayList filterConditionList = Lists.newArrayListWithExpectedSize((int)entryRuleList.size());
            for (DynamicObject object : entryRuleList) {
                filterConditionList.add(object.getString("filtercondition"));
                resultList.add(object.getString("filterresult"));
            }
            String defaultResults = dynamicObject.getString("results");
            if (HRStringUtils.isNotEmpty((String)defaultResults)) {
                resultList.add(defaultResults);
            }
            ruleEngineConf.setFilterConditionList(filterConditionList);
            List list = (List)policyIdToPlanIdMap.get(policyId);
            if (null == list) continue;
            for (Long planVersionId : list) {
                confMap.put(planVersionId, ruleEngineConf);
            }
        }
        RuleEngineInitHelper.initResultRule(resultList, initRequest, businessRuleMap);
    }

    private static void initResultRule(List<String> resultList, InitParam initRequest, Map<Long, Object> businessRuleMap) {
        ArrayList<ConditionDto> resList = new ArrayList<ConditionDto>(10);
        for (String resultStr : resultList) {
            Result result;
            try {
                result = (Result)SerializationUtils.fromJsonString((String)resultStr, Result.class);
            }
            catch (Exception e) {
                throw new WtesBizException((Throwable)e, "parse error");
            }
            resList.addAll(result.getResultList());
        }
        HashMap<String, Set<Long>> modelNameToIdMap = new HashMap<String, Set<Long>>(16);
        for (ConditionDto conditionDto : resList) {
            if (!"dynamicObject".equals(conditionDto.getParamType())) continue;
            String param = conditionDto.getParam();
            String idStr = conditionDto.getValue();
            if (null == idStr) continue;
            String[] idSplit = idStr.split(",");
            String[] split = param.split("\\.");
            if (split.length < 3) {
                throw new WtesBizException(ResManager.loadKDString((String)"\u7ed3\u679c\u96c6\u6761\u4ef6\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"RuleEngineInitHelper_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            for (String id : idSplit) {
                Long value = Long.parseLong(id);
                String modelName = split[1];
                Set pkIds = modelNameToIdMap.computeIfAbsent(modelName, k -> new HashSet(16));
                pkIds.add(value);
            }
        }
        RuleEngineInitHelper.getAndCacheRule(modelNameToIdMap, initRequest, businessRuleMap);
    }

    private static void getAndCacheRule(Map<String, Set<Long>> modelNameToIdMap, InitParam initRequest, Map<Long, Object> businessRuleMap) {
        Object param;
        HashSet<Object> initRuleTypeSet;
        if (initRequest instanceof QuotaInitParamRequest) {
            List list;
            initRuleTypeSet = new HashSet();
            param = WTCAppContextHelper.getProjectParams().get("quota.init.att.rule.param");
            if (param != null && !(list = (List)param).isEmpty()) {
                initRuleTypeSet.addAll(list.stream().filter(modelNameToIdMap::containsKey).collect(Collectors.toSet()));
            }
        } else {
            List list;
            initRuleTypeSet = new HashSet<String>(modelNameToIdMap.keySet());
            param = WTCAppContextHelper.getProjectParams().get("quota.init.att.rule.param");
            if (param != null && !(list = (List)param).isEmpty()) {
                list.forEach(initRuleTypeSet::remove);
            }
        }
        for (String string : initRuleTypeSet) {
            Set<Long> ruleIds = modelNameToIdMap.get(string);
            Set<Long> collect = ruleIds.stream().filter(e -> !businessRuleMap.containsKey(e)).collect(Collectors.toSet());
            RuleEngineInitHelper.queryRuleByNameAndId(string, collect, initRequest, businessRuleMap);
        }
    }

    private static void queryRuleByNameAndId(String modelName, Set<Long> ids, InitParam initRequest, Map<Long, Object> businessRuleMap) {
        IRuleInitializer ruleInitializer = RuleInitializerFactory.getRuleInitializerByName(modelName);
        if (ruleInitializer != null) {
            businessRuleMap.putAll(ruleInitializer.initRule(ids, initRequest));
        }
    }
}

