/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ruleengine.init;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.OtCalcHelper;
import kd.wtc.wtes.business.ruleengine.init.IRuleInitializer;

public class OtRuleInitializer
implements IRuleInitializer {
    @Override
    public Map<Long, ? extends TimeSeqBo<? extends AbstractTimeSeqVersion>> initRule(Set<Long> ruleIds, InitParam initRequest) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        HashMap otRuleMap = Maps.newHashMapWithExpectedSize((int)ruleIds.size());
        DynamicObject[] otRuleHisList = InitHelper.getHisDyArr("wtp_overworkrule", ruleIds, startDate, endDate);
        Map<Long, List<DynamicObject>> otRuleHisMap = Arrays.stream(otRuleHisList).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (Long ruleId : ruleIds) {
            otRuleMap.put(ruleId, OtCalcHelper.getRule(ruleId, otRuleHisMap, startDate, endDate));
        }
        return otRuleMap;
    }
}

