/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ruleengine.init;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.rlva.VaCalHelper;
import kd.wtc.wtes.business.ruleengine.init.IRuleInitializer;

public class VaRuleInitializer
implements IRuleInitializer {
    @Override
    public Map<Long, ? extends TimeSeqBo<? extends AbstractTimeSeqVersion>> initRule(Set<Long> ruleIds, InitParam initParamRequest) {
        HashMap businessRuleMap = Maps.newHashMapWithExpectedSize((int)ruleIds.size());
        LocalDate startDate = initParamRequest.getStartDate();
        LocalDate endDate = initParamRequest.getEndDate();
        DynamicObject[] vaRuleHisList = VaCalHelper.getHisDyArr("wtp_varule", ruleIds, startDate, endDate);
        Map<Long, List<DynamicObject>> ruleHisListMap = Arrays.stream(vaRuleHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        Map<String, Set<Long>> f7IdMaps = VaCalHelper.getF7IdMaps(vaRuleHisList);
        Set<Long> vaBaseSetIds = f7IdMaps.get("vabasesetid");
        DynamicObject[] vaBaseSetHisList = VaCalHelper.getHisDyArr("wtp_vabaseset", vaBaseSetIds, startDate, endDate);
        Map<Long, List<DynamicObject>> baseSetHisListMap = Arrays.stream(vaBaseSetHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        Map<Object, Object> deductRuleHisMap = Maps.newHashMapWithExpectedSize((int)16);
        Set<Long> deductionRuleIds = f7IdMaps.get("deductrule");
        if (WTCCollections.isNotEmpty(deductionRuleIds)) {
            DynamicObject[] deductRuleHisList = VaCalHelper.getHisDyArr("wtp_qtdeducrule", deductionRuleIds, startDate, endDate);
            deductRuleHisMap = Arrays.stream(deductRuleHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        }
        for (Long ruleId : ruleIds) {
            HashMap<String, Map<Long, List<DynamicObject>>> f7Maps = new HashMap<String, Map<Long, List<DynamicObject>>>(16);
            f7Maps.put("vabasesetid", baseSetHisListMap);
            f7Maps.put("deductrule", deductRuleHisMap);
            businessRuleMap.put(ruleId, VaCalHelper.dealOneRule(ruleHisListMap, ruleId, f7Maps));
        }
        return businessRuleMap;
    }
}

