/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.init.IAttFilePlan;
import kd.wtc.wtes.business.model.rlfm.FormulaConfigPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaRulePackage;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;

public class AttFileFormulaPlanImpl
implements IAttFilePlan {
    public Map<Long, TimeSeqBo<FormulaPlanPackage>> getAttFilePlanSeq(Set<Long> planSetIds, InitParam initRequest) {
        List planIds = planSetIds.stream().filter(planId -> planId > 0L).collect(Collectors.toList());
        if (planIds.isEmpty()) {
            return Collections.emptyMap();
        }
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        DynamicObject[] plans = InitHelper.getHisDyArr("wtp_formulaplan", new HashSet<Long>(planIds), startDate, endDate);
        Set<Long> ruleIds = Arrays.stream(plans).filter(plan -> null != plan.getDynamicObject("formularule")).map(plan -> plan.getLong("formularule.id")).collect(Collectors.toSet());
        Map<Long, TimeSeqBo<FormulaRulePackage>> ruleMap = this.getFormulaRuleSeq(ruleIds, initRequest);
        return this.assemblePlanTimeSeqBoMap(plans, ruleMap);
    }

    private Map<Long, TimeSeqBo<FormulaConfigPackage>> assembleConfigSeqBoMap(LocalDate startDate, LocalDate endDate, Set<Long> configIds) {
        DynamicObject[] configs = InitHelper.getHisDyArr("wtp_formulaset", configIds, startDate, endDate);
        HashMap<Long, TimeSeqBo<FormulaConfigPackage>> configMap = new HashMap<Long, TimeSeqBo<FormulaConfigPackage>>(16);
        Arrays.stream(configs).collect(Collectors.groupingBy(entity -> entity.getLong("boid"))).forEach((boid, list) -> {
            List packages = list.stream().map(pack -> {
                TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(pack);
                return new FormulaConfigPackage((TimeSeqInfo)timeSeqEntity);
            }).collect(Collectors.toList());
            configMap.put((Long)boid, (TimeSeqBo<FormulaConfigPackage>)TimeSeqBo.ofMultiTimeSeq(packages));
        });
        return configMap;
    }

    private Map<Long, TimeSeqBo<FormulaRulePackage>> assembleRuleTimeSeqBoMap(DynamicObject[] rules, Map<Long, TimeSeqBo<FormulaConfigPackage>> configMap) {
        boolean isFormulaOpen = WTCGrayscaleUtils.isFormulaOpen();
        HashMap<Long, TimeSeqBo<FormulaRulePackage>> ruleMap = new HashMap<Long, TimeSeqBo<FormulaRulePackage>>(16);
        Arrays.stream(rules).collect(Collectors.groupingBy(entity -> entity.getLong("boid"))).forEach((boid, list) -> {
            List packages = list.stream().map(pack -> {
                TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(pack);
                FormulaRulePackage rulePackage = new FormulaRulePackage((TimeSeqInfo)timeSeqEntity);
                DynamicObjectCollection entities = pack.getDynamicObjectCollection("entryentity");
                List<TimeSeqBo<FormulaConfigPackage>> list2 = entities.stream().map(entity -> {
                    ArrayList<FormulaConfigPackage> copyConfPacks = new ArrayList<FormulaConfigPackage>(10);
                    TimeSeqBo configPackages = configMap.getOrDefault(entity.getLong("formulaconfig.id"), TimeSeqBo.empty());
                    if (!configPackages.isEmpty()) {
                        List sourceConfPacks = configPackages.getVersions();
                        for (FormulaConfigPackage sourcePack : sourceConfPacks) {
                            FormulaConfigPackage copyPack = new FormulaConfigPackage(sourcePack.getTimeSeqInfo());
                            copyConfPacks.add(copyPack);
                        }
                        copyConfPacks.forEach(version -> {
                            if (isFormulaOpen) {
                                version.setAccStepId(entity.getLong("accstep.id"));
                            }
                            version.setExecOrder(entity.getInt("execorder"));
                        });
                    }
                    return TimeSeqBo.ofMultiTimeSeq(copyConfPacks);
                }).collect(Collectors.toList());
                rulePackage.setConfigs(list2);
                rulePackage.setAccountPlanId(pack.getLong("accountplan.id"));
                return rulePackage;
            }).collect(Collectors.toList());
            ruleMap.put((Long)boid, (TimeSeqBo<FormulaRulePackage>)TimeSeqBo.ofMultiTimeSeq(packages));
        });
        return ruleMap;
    }

    private Map<Long, TimeSeqBo<FormulaPlanPackage>> assemblePlanTimeSeqBoMap(DynamicObject[] plans, Map<Long, TimeSeqBo<FormulaRulePackage>> ruleMap) {
        HashMap<Long, TimeSeqBo<FormulaPlanPackage>> result = new HashMap<Long, TimeSeqBo<FormulaPlanPackage>>(16);
        Arrays.stream(plans).collect(Collectors.groupingBy(config -> config.getLong("boid"))).forEach((boid, list) -> {
            List packages = list.stream().map(pack -> {
                TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(pack);
                FormulaPlanPackage planPackage = new FormulaPlanPackage((TimeSeqInfo)timeSeqEntity);
                String setRuleWay = pack.getString("setruleway");
                planPackage.setSetRuleWay(setRuleWay);
                DynamicObject rule = pack.getDynamicObject("formularule");
                if (null != rule && !HRStringUtils.equals((String)"2", (String)setRuleWay)) {
                    long ruleId = (Long)rule.getPkValue();
                    planPackage.setRule((TimeSeqBo<FormulaRulePackage>)((TimeSeqBo)ruleMap.get(ruleId)));
                }
                return planPackage;
            }).collect(Collectors.toList());
            result.put((Long)boid, (TimeSeqBo<FormulaPlanPackage>)TimeSeqBo.ofMultiTimeSeq(packages));
        });
        return result;
    }

    public Map<Long, TimeSeqBo<FormulaRulePackage>> getFormulaRuleSeq(Set<Long> ruleIds, InitParam initRequest) {
        DynamicObject[] rules = InitHelper.getHisDyArr("wtp_formularule", ruleIds, initRequest.getStartDate(), initRequest.getEndDate());
        HashSet<Long> configIds = new HashSet<Long>(16);
        for (DynamicObject rule : rules) {
            DynamicObjectCollection configs = rule.getDynamicObjectCollection("entryentity");
            for (DynamicObject config : configs) {
                DynamicObject formulaConfig = config.getDynamicObject("formulaconfig");
                if (formulaConfig == null) continue;
                configIds.add((Long)formulaConfig.getPkValue());
            }
        }
        Map<Long, TimeSeqBo<FormulaConfigPackage>> configMap = this.assembleConfigSeqBoMap(initRequest.getStartDate(), initRequest.getEndDate(), configIds);
        return this.assembleRuleTimeSeqBoMap(rules, configMap);
    }
}

