/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.OtCalcHelper;
import kd.wtc.wtes.business.init.IAttFilePlan;
import kd.wtc.wtes.business.model.OtAttPackage;

public class AttFileOtPlanImpl
implements IAttFilePlan {
    private static final String WTP_OTRULE = "wtp_overworkrule";

    public Map<Long, TimeSeqBo<OtAttPackage>> getAttFilePlanSeq(Set<Long> fileEntryIds, InitParam initRequest) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileEntryIds.size());
        DynamicObject[] otPlanList = InitHelper.getHisDyArr(AttFilePlanEnum.OTP.getEntityNumber(), fileEntryIds, startDate, endDate);
        Map<Long, List<DynamicObject>> planMap = Arrays.stream(otPlanList).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Set<Long> ruleIdList = this.getIdList(otPlanList, "overworkrule");
        Set<Long> timecutIdList = this.getIdList(otPlanList, "timecut");
        DynamicObject[] timecutDyms = new HRBaseServiceHelper("wtp_timecut").loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", timecutIdList)});
        Map<Long, List<DynamicObject>> timecutDyMap = Arrays.stream(timecutDyms).collect(Collectors.groupingBy(info -> info.getLong("id")));
        DynamicObject[] otRuleHisList = InitHelper.getHisDyArr(WTP_OTRULE, ruleIdList, startDate, endDate);
        Map<Long, List<DynamicObject>> ruleHisMap = Arrays.stream(otRuleHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        for (Long planId : fileEntryIds) {
            List<DynamicObject> dynamicObjectList = planMap.get(planId);
            if (null == dynamicObjectList) continue;
            resultMap.put(planId, new TimeSeqAvailableBo(OtCalcHelper.getPlanList(dynamicObjectList, ruleHisMap, timecutDyMap, startDate, endDate)));
        }
        return resultMap;
    }

    private Set<Long> getIdList(DynamicObject[] otPlanHisList, String fieldName) {
        HashSet idList = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject otPlanHis : otPlanHisList) {
            long id = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)otPlanHis, (String)fieldName);
            idList.add(id);
        }
        return idList;
    }
}

