/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.wtc.wtes.business.tie.init.configmix.TieConfigMixInitPlugin;
import kd.sdk.wtc.wtes.business.tie.init.configmix.TieConfigMixQueryEvent;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.ConfigMix;
import kd.wtc.wtes.business.model.DasoConf;
import kd.wtc.wtes.business.model.DasoConfData;
import kd.wtc.wtes.business.service.IConfigMixService;
import kd.wtc.wtes.business.service.impl.ConfigMixInitPluginDefault;

public class ConfigMixServiceImpl
implements IConfigMixService {
    private static Log LOGGER = LogFactory.getLog(ConfigMixServiceImpl.class);
    private static String OLD_HASH_KEY = "hashKey";
    private static String CONFIGMIX_KEY = "configMix";
    private static String OLD_DATASOURCEHASH_KEY = "dataSourceHashKey";
    private ConfigMixInitPluginDefault configMixInitExpServiceDefault = new ConfigMixInitPluginDefault();

    @Override
    public ConfigMix queryByCountry(LocalDate fromDate, LocalDate toDate, Long nationalityId) {
        WTCPluginProxy wtcPluginProxy = WTCPluginProxyFactory.create((Object)this.configMixInitExpServiceDefault, TieConfigMixInitPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.configmix.TieConfigMixInitPlugin");
        TieConfigMixQueryEvent tieConfigMixQueryEvent = new TieConfigMixQueryEvent(fromDate, toDate);
        wtcPluginProxy.invokeReplaceIfPresent(configMixInitExpService -> configMixInitExpService.onQuery(tieConfigMixQueryEvent));
        List dynamicObjects = tieConfigMixQueryEvent.getConfigMixResult();
        DynamicObject dynamicObject = null;
        if (WTCCollections.isNotEmpty((Collection)dynamicObjects)) {
            dynamicObject = (DynamicObject)dynamicObjects.get(0);
        }
        if (Objects.isNull(dynamicObject)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("issyspreset", "=", (Object)Boolean.TRUE)};
            dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"wtbd_confcombin", (String)"countryid.number,attitemmap.id,attstsmap.id,tbpcrelcnf.id,entryentity.biztype,entryentity.exattr,entryentity.attendattr,entryentity.datasource", (QFilter[])qFilters);
        }
        Tuple<Map<Long, String>, DasoConfData> dataTuple = this.getDataSourceMap();
        DasoConfData dasoConfData = (DasoConfData)dataTuple.getValue();
        Map dataSourceMap = (Map)dataTuple.getKey();
        return this.transForm2Dto(dynamicObject, dataSourceMap, dasoConfData);
    }

    private ConfigMix transForm2Dto(DynamicObject dynamicObject, Map<Long, String> dataSourceMap, DasoConfData dasoConfData) {
        ConfigMix configMix = new ConfigMix();
        if (dynamicObject != null) {
            configMix.setCountry(dynamicObject.getString("countryid.number"));
            configMix.setAttitemmap(dynamicObject.getLong("attitemmap.id"));
            configMix.setAttstsmap(dynamicObject.getLong("attstsmap.id"));
            configMix.setTbpcrelcnf(dynamicObject.getLong("tbpcrelcnf.id"));
            configMix.buildBizDataSourceList(dynamicObject.getDynamicObjectCollection("entryentity"), dataSourceMap, dasoConfData);
        }
        return configMix;
    }

    private Tuple<Map<Long, String>, DasoConfData> getDataSourceMap() {
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "=", (Object)"C")};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"wtbd_dasoconf", (String)"iscurrentversion,number,boid,id,conditions,bsed,bsled", (QFilter[])qFilters);
        HashMap dataSourceMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entrySet : map.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entrySet.getValue();
            dataSourceMap.put(dynamicObject.getLong("id"), dynamicObject.getString("conditions"));
        }
        LinkedList<Long> warnInfoList = new LinkedList<Long>();
        DasoConfData dasoConfData = this.dasoConfData(map.values(), warnInfoList);
        return new Tuple((Object)dataSourceMap, (Object)dasoConfData);
    }

    @Override
    public DasoConfData dasoConfData(Collection<DynamicObject> dynamicObjects, List<Long> warnInfoList) {
        List collect = dynamicObjects.stream().filter(dynamicObject -> !dynamicObject.getBoolean("iscurrentversion")).collect(Collectors.toList());
        ArrayList dasoConfs = Lists.newArrayListWithExpectedSize((int)collect.size());
        for (DynamicObject dynamicObject2 : collect) {
            TimeSeqInfoImpl timeSeqInfo = ConfigMixServiceImpl.getTimeSeqEntity(dynamicObject2);
            DasoConf.Builder<?, ?> builder = DasoConf.withTimeSeq((TimeSeqInfo)timeSeqInfo);
            DasoConf dasoConf = (DasoConf)builder.coditionStr(dynamicObject2.getString("conditions")).build();
            dasoConfs.add(dasoConf);
        }
        Map<Long, List<DasoConf>> bo2His = dasoConfs.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
        List<TimeSeqBo<DasoConf>> dasoConfsBo = this.listTimeSeqBo(bo2His, warnInfoList);
        return DasoConfData.of(dasoConfsBo);
    }

    private static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject dynamicObject) {
        LocalDate bsled = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsled"));
        LocalDate bsed = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsed"));
        return (TimeSeqInfoImpl)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().blsed(bsled).bsed(bsed).number(dynamicObject.getString("number"))).id(dynamicObject.getLong("id"))).bid(dynamicObject.getLong("boid")).build();
    }

    private List<TimeSeqBo<DasoConf>> listTimeSeqBo(Map<Long, List<DasoConf>> bo2His, List<Long> warnInfoList) {
        ArrayList<TimeSeqBo<DasoConf>> DasoConfs = new ArrayList<TimeSeqBo<DasoConf>>(bo2His.size());
        bo2His.forEach((bid, dasoConfs) -> {
            try {
                DasoConf dasoConf = (DasoConf)((Object)((Object)dasoConfs.get(0)));
                TimeSeqBo timeSeqBo = dasoConf.hasTimeSeqInfo() ? TimeSeqBo.ofMultiTimeSeq((Collection)dasoConfs) : TimeSeqBo.ofNonTimeSeq((TimeSeqVersion)dasoConf);
                DasoConfs.add(timeSeqBo);
            }
            catch (Exception e) {
                warnInfoList.add((Long)bid);
            }
        });
        return DasoConfs;
    }
}

