/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.builder.DetectableAndCleanableBuilder;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.business.util.WTESDateUtils;
import kd.wtc.wtes.common.enums.RefDateType;
import kd.wtc.wtes.common.enums.ShiftType;
import kd.wtc.wtes.common.lang.WtesException;

public class ShiftService {
    public static Map<Long, TimeSeqBo<ShiftSpec>> getShiftByIds(Set<Long> shiftIds, Date startDate, Date endDate) {
        HashMap<Long, TimeSeqBo<ShiftSpec>> map = new HashMap<Long, TimeSeqBo<ShiftSpec>>(shiftIds.size());
        HashMap shiftMaps = new HashMap(shiftIds.size());
        DynamicObject[] querys = InitHelper.getHisDyArr("wtbd_shift", shiftIds, WTCDateUtils.toLocalDate((Date)startDate), WTCDateUtils.toLocalDate((Date)endDate));
        if (querys != null && querys.length != 0) {
            for (DynamicObject dynamicObject : querys) {
                long bo = dynamicObject.getLong("boid");
                String shifttype = dynamicObject.getString("shifttype");
                String isoff = dynamicObject.getString("isoff");
                DynamicObject clockruleDy = dynamicObject.getDynamicObject("clockrule");
                Long clockrule = clockruleDy != null ? clockruleDy.getLong("id") : 0L;
                String name = dynamicObject.getString("name");
                String chineseName = dynamicObject.getLocaleString("name").getLocaleValue_zh_CN();
                boolean off = HRStringUtils.equals((String)"1", (String)isoff);
                boolean offNonPlan = HRStringUtils.equals((String)"1", (String)dynamicObject.getString("offnonplan"));
                String lastrefstartday = dynamicObject.getString("referencestartday");
                String lastrefendday = dynamicObject.getString("referenceendday");
                int lastshiftstartdate = dynamicObject.getInt("shiftstart");
                int lastshiftenddate = dynamicObject.getInt("shiftend");
                String refInOtStartDay = dynamicObject.getString("refinotstartday");
                String refInOtEndDay = dynamicObject.getString("refinotendday");
                int inOtStart = dynamicObject.getInt("inotstart");
                int inOtEnd = dynamicObject.getInt("inotend");
                if (Objects.isNull(lastrefstartday) || Objects.isNull(lastrefendday)) {
                    throw new WtesException(ResManager.loadKDString((String)"\u73ed\u6b21\u521d\u59cb\u5316\u5f02\u5e38,\u8bf7\u91cd\u65b0\u751f\u6210\u73ed\u6b21,\u4f7f\u7528\u65b0\u6570\u636e\u3002", (String)"ShiftService_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
                }
                ShiftMiddleRule rule = new ShiftMiddleRule();
                rule.setAllday(dynamicObject.getBigDecimal("allday"));
                rule.setAlldayhour(dynamicObject.getBigDecimal("alldayhour"));
                rule.setHalfday(dynamicObject.getBigDecimal("halfday"));
                rule.setHalfdayhour(dynamicObject.getBigDecimal("halfdayhour"));
                rule.setMiddleRefDate(kd.wtc.wtbs.common.model.shift.RefDateType.from((String)dynamicObject.getString("refmiddlepoint")));
                rule.setMiddlepoint(dynamicObject.getInt("middlepoint"));
                rule.setMiddleRefDate(kd.wtc.wtbs.common.model.shift.RefDateType.from((String)dynamicObject.getString("refmiddlepoint")));
                BigDecimal alldayhour = dynamicObject.getBigDecimal("alldayhour");
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                ArrayList<ShiftSession> shiftSessions = new ArrayList<ShiftSession>(entrys.size());
                int workTime = 0;
                int breakTime = 0;
                int otTime = 0;
                for (DynamicObject entry : entrys) {
                    long id = (Long)entry.getPkValue();
                    String outworktype = entry.getString("outworktype");
                    String refstartday = entry.getString("refstartday");
                    String refendday = entry.getString("refendday");
                    RefDateType startRef = RefDateType.from((String)refstartday);
                    RefDateType endRef = RefDateType.from((String)refendday);
                    int shiftstartdate = entry.getInt("shiftstartdate");
                    int shiftenddate = entry.getInt("shiftenddate");
                    LocalTime localShiftstartdate = LocalTime.ofSecondOfDay(shiftstartdate);
                    LocalTime localShiftenddate = LocalTime.ofSecondOfDay(shiftenddate);
                    boolean isworktimestart = entry.getBoolean("isworktimestart");
                    boolean isworktimeend = entry.getBoolean("isworktimeend");
                    int shiftstartdate1 = shiftstartdate;
                    int shiftenddate1 = shiftenddate;
                    if (startRef == RefDateType.NEXTDAY) {
                        shiftstartdate1 += 86400;
                    }
                    if (endRef == RefDateType.NEXTDAY) {
                        shiftenddate1 += 86400;
                    }
                    OutWorkType outWorkType = OutWorkType.from(outworktype);
                    switch (outWorkType) {
                        case WORK: {
                            workTime += shiftenddate1 - shiftstartdate1;
                            break;
                        }
                        case BREAK: {
                            breakTime += shiftenddate1 - shiftstartdate1;
                            break;
                        }
                        case OT: {
                            otTime += shiftenddate1 - shiftstartdate1;
                            break;
                        }
                    }
                    ShiftSession shiftSession = ShiftSession.with().id(id).startRefDateType(startRef).endRefDateType(endRef).startTime(localShiftstartdate).endTime(localShiftenddate).outWorkType(outWorkType).requiredPunchIn(isworktimestart).requiredPunchOut(isworktimeend).durationInSeconds(WTESDateUtils.durationBetweenRefTimePoints(localShiftstartdate, startRef, localShiftenddate, endRef)).build();
                    shiftSessions.add(shiftSession);
                }
                List<ShiftSession> workSession = shiftSessions.stream().filter(session -> session.getOutWorkType() == OutWorkType.CORE_TIME).collect(Collectors.toList());
                List<ShiftSession> breakSession = shiftSessions.stream().filter(session -> session.getOutWorkType() == OutWorkType.BREAK).collect(Collectors.toList());
                int shitfTime = workTime + breakTime + otTime;
                ShiftSpec shiftSpec = (ShiftSpec)((Object)((DetectableAndCleanableBuilder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)ShiftSpec.withTimeSeq((TimeSeqInfo)TimeSeqEntityGenerateUtils.getTimeSeqEntity(dynamicObject)).shiftType(ShiftType.from((String)shifttype))).shiftSessions(shiftSessions)).breakTime(breakTime)).otTime(otTime)).workTime(workTime)).shiftTime(shitfTime)).alldayhour(alldayhour)).standardTime(kd.wtc.wtbs.business.shift.ShiftService.getInstance().getStandardTime(dynamicObject))).name(name)).ormLocaleName((OrmLocaleValue)dynamicObject.get("name"))).chineseName(chineseName)).off(off)).clockruleId(clockrule)).offNonPlan(offNonPlan)).setShiftMiddleRule(rule)).setWorkSession(workSession)).firstRefDateType(RefDateType.from((String)lastrefstartday))).lastRefDateType(RefDateType.from((String)lastrefendday))).earliestShiftTime(lastshiftstartdate == -1 ? null : LocalTime.ofSecondOfDay(lastshiftstartdate))).lastShiftTime(lastshiftenddate == -1 ? null : LocalTime.ofSecondOfDay(lastshiftenddate))).inOtStartRefDateType(RefDateType.from((String)refInOtStartDay))).inOtEndRefDateType(RefDateType.from((String)refInOtEndDay))).inOtStartTime(inOtStart == -1 ? null : LocalTime.ofSecondOfDay(inOtStart))).inOtEndTime(inOtEnd == -1 ? null : LocalTime.ofSecondOfDay(inOtEnd))).breakSessions(breakSession)).build());
                List shiftSpecss = (List)shiftMaps.get(bo);
                if (shiftSpecss == null) {
                    ArrayList<ShiftSpec> shiftSpecs = new ArrayList<ShiftSpec>();
                    shiftSpecs.add(shiftSpec);
                    shiftMaps.put(bo, shiftSpecs);
                    continue;
                }
                shiftSpecss.add(shiftSpec);
            }
        }
        for (Map.Entry entry : shiftMaps.entrySet()) {
            Long bo = (Long)entry.getKey();
            List values = (List)entry.getValue();
            map.put(bo, (TimeSeqBo<ShiftSpec>)TimeSeqBo.ofMultiTimeSeq((Collection)values));
        }
        return map;
    }
}

