/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.subject.AttExcludeSubject;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.engine.TieRangeChecker;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.service.ClearAttHisDataService;
import kd.wtc.wtes.business.std.TieRequestStd;
import kd.wtc.wtes.business.util.AttCalTaskUtils;
import kd.wtc.wtes.common.util.Assert;

public class TieAttSubjectBuilder
implements TieRangeChecker {
    private static final Log LOGGER = LogFactory.getLog(TieAttSubjectBuilder.class);
    private TieRequest tieRequest;
    private String excludeMessage;
    private List<AttSubject> attSubjectList;
    private List<AttExcludeSubject> attExcludeSubjectList;
    private Map<Long, List<AttPersonRange>> personRangeMap;

    @Override
    public void setTieRequest(TieRequest tieRequest) {
        Assert.nonNull((Object)tieRequest, (String)"tieRequest");
        this.tieRequest = tieRequest;
    }

    @Override
    public void check() {
        List<Long> attPersonIds = this.tieRequest.getAttPersonIds();
        List<Long> attFileBoIds = this.tieRequest.getAttFileBoids();
        HashSet<Long> attFileBoIdSet = new HashSet<Long>(attFileBoIds);
        LOGGER.debug("attFileBoIds {}", attFileBoIds);
        try {
            Date startDate = null != this.tieRequest.getStartDate() ? WTCDateUtils.toDate((LocalDate)this.tieRequest.getStartDate()) : null;
            Date endDate = null != this.tieRequest.getEndDate() ? WTCDateUtils.toDate((LocalDate)this.tieRequest.getEndDate()) : null;
            TieRequestStd request = (TieRequestStd)this.tieRequest;
            List<AttPersonRange> rangerList = AttCalTaskUtils.getAttPersonRangeNew(attFileBoIds, startDate, endDate, request);
            this.personRangeMap = rangerList.stream().collect(Collectors.groupingBy(AttPersonRange::getAttFileBaseBoId));
            LOGGER.debug(ResManager.loadKDString((String)"\u67e5\u8be2\u4eba\u5458\u6570\u636e\u5b9e\u9645\u8ba1\u7b97\u8303\u56f4\u67e5\u8be2\u53c2\u6570{},\u8fd4\u56de\u7ed3\u679c{}\u3002", (String)"TieAttSubjectBuilder_0", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)JSONObject.toJSONString(attPersonIds), (Object)JSONObject.toJSONString(rangerList));
            HashMap boIdToAttFileVersionsMap = Maps.newHashMapWithExpectedSize((int)rangerList.size());
            HashMap excludeBoIdToAttFileVersionMap = Maps.newHashMapWithExpectedSize((int)rangerList.size());
            HashMap vidToPersonMap = Maps.newHashMapWithExpectedSize((int)rangerList.size());
            Map<Long, String> exBoIdMap = ClearAttHisDataService.getInstance().cleanHisData(this.tieRequest);
            Set concurrencyExcludeBoIdSet = TaskConcurrencyCtrlHelper.getInstance().getRunningKeyList("wtte_tie", attFileBoIds, Long.valueOf(this.tieRequest.getTaskId()), Long.valueOf(this.tieRequest.getSubTaskId()));
            for (AttPersonRange range : rangerList) {
                if (!attFileBoIdSet.contains(range.getAttFileBaseBoId())) continue;
                vidToPersonMap.put(range.getAttFileBaseId(), range);
                AttSubject.AttFileVersion attFileVersion = this.genAttFileVersion(range);
                if (range.getLegal().booleanValue() && null != range.getStartDate() && null != range.getEndDate() && range.getStartDate().compareTo(range.getEndDate()) <= 0 && !exBoIdMap.containsKey(range.getAttFileBaseBoId()) && this.concurrencyCtrl(concurrencyExcludeBoIdSet, range.getAttFileBaseBoId())) {
                    List attFileVersions = boIdToAttFileVersionsMap.computeIfAbsent(range.getAttFileBaseBoId(), k -> new ArrayList(10));
                    attFileVersions.add(attFileVersion);
                    continue;
                }
                excludeBoIdToAttFileVersionMap.put(range.getAttFileBaseBoId(), attFileVersion);
            }
            Map<Long, List<AttSubject.AttFileBo>> attFileBoListMap = this.dealAttFileVersions(boIdToAttFileVersionsMap, vidToPersonMap);
            this.attSubjectList = this.dealAttFileBos(attFileBoListMap);
            this.attExcludeSubjectList = this.dealExcludeSubject(excludeBoIdToAttFileVersionMap, vidToPersonMap, boIdToAttFileVersionsMap, exBoIdMap, concurrencyExcludeBoIdSet);
            if (this.attSubjectList.isEmpty()) {
                this.excludeMessage = ResManager.loadKDString((String)"\u6240\u6709\u6863\u6848\u7248\u672c\u4e0d\u5728\u6838\u7b97\u8303\u56f4\u5185\u3002", (String)"TieAttSubjectBuilder_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {
            LOGGER.warn(ResManager.loadKDString((String)"\u67e5\u8be2\u4eba\u5458\u6570\u636e\u5b9e\u9645\u8ba1\u7b97\u8303\u56f4\u67e5\u8be2\u53c2\u6570{},\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38{}\u3002", (String)"TieAttSubjectBuilder_2", (String)"wtc-wtes-business", (Object[])new Object[0]), attPersonIds, (Object)exception);
            throw exception;
        }
    }

    private boolean concurrencyCtrl(Set<Long> concurrencyExcludeBoIdSet, Long attFileBaseBoId) {
        if (concurrencyExcludeBoIdSet.isEmpty()) {
            return true;
        }
        return !concurrencyExcludeBoIdSet.contains(attFileBaseBoId);
    }

    private List<AttExcludeSubject> dealExcludeSubject(Map<Long, AttSubject.AttFileVersion> excludeBoIdToAttFileVersionMap, Map<Long, AttPersonRange> vidToPersonMap, Map<Long, List<AttSubject.AttFileVersion>> boIdToAttFileVersionsMap, Map<Long, String> exBoIdMap, Set<Long> concurrencyExcludeBoIdSet) {
        HashMap<Long, AttExcludeSubject> boIdToAttExcludeSubjectMap = new HashMap<Long, AttExcludeSubject>(16);
        for (Map.Entry<Long, AttSubject.AttFileVersion> attFileVersionEntry : excludeBoIdToAttFileVersionMap.entrySet()) {
            AttSubject.AttFileVersion attFileVersion = attFileVersionEntry.getValue();
            long attFileVid = attFileVersion.getAttFileVid();
            AttPersonRange attPersonRange = vidToPersonMap.get(attFileVid);
            Long attFileBaseBoId = attPersonRange.getAttFileBaseBoId();
            if (boIdToAttFileVersionsMap.containsKey(attFileBaseBoId) || boIdToAttExcludeSubjectMap.containsKey(attFileBaseBoId)) continue;
            String message = attPersonRange.getMessage();
            String exMessage = exBoIdMap.get(attFileBaseBoId);
            if (HRStringUtils.isNotEmpty((String)exMessage)) {
                message = exMessage;
            }
            if (message == null && concurrencyExcludeBoIdSet.contains(attFileBaseBoId)) {
                message = ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u6863\u6848\u6b63\u5728\u88ab\u5176\u4ed6\u64cd\u4f5c\u4eba\u6838\u7b97\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TieAttSubjectBuilder_3", (String)"wtc-wtes-business", (Object[])new Object[0]);
            }
            AttExcludeSubject attExcludeSubject = this.genAttExcludeSubject(attPersonRange.getPersonId(), attFileVersionEntry.getKey(), message);
            boIdToAttExcludeSubjectMap.put(attFileVersionEntry.getKey(), attExcludeSubject);
        }
        return new ArrayList<AttExcludeSubject>(boIdToAttExcludeSubjectMap.values());
    }

    private List<AttSubject> dealAttFileBos(Map<Long, List<AttSubject.AttFileBo>> attFileBoListMap) {
        ArrayList<AttSubject> attSubjectList = new ArrayList<AttSubject>(10);
        for (Map.Entry<Long, List<AttSubject.AttFileBo>> attFileBoListEntry : attFileBoListMap.entrySet()) {
            List<AttSubject.AttFileBo> value = attFileBoListEntry.getValue();
            Long personId = attFileBoListEntry.getKey();
            attSubjectList.add(this.genAttSubject(personId, value));
        }
        return attSubjectList;
    }

    private Map<Long, List<AttSubject.AttFileBo>> dealAttFileVersions(Map<Long, List<AttSubject.AttFileVersion>> boIdToAttFileVersionMap, Map<Long, AttPersonRange> vidToPersonMap) {
        HashMap boIdToAttFileBosMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, List<AttSubject.AttFileVersion>> attFileVersionEntry : boIdToAttFileVersionMap.entrySet()) {
            List<AttSubject.AttFileVersion> attFileVersions = attFileVersionEntry.getValue();
            Long boId = attFileVersionEntry.getKey();
            AttSubject.AttFileBo attFileBo = this.genAttFileBo(boId, attFileVersions);
            AttPersonRange attPersonRange = vidToPersonMap.get(attFileVersions.get(0).getAttFileVid());
            Long personId = attPersonRange.getPersonId();
            List attFileBos = boIdToAttFileBosMap.computeIfAbsent(personId, k -> new ArrayList(10));
            attFileBos.add(attFileBo);
        }
        return boIdToAttFileBosMap;
    }

    private AttExcludeSubject genAttExcludeSubject(Long personId, Long boId, String exMessage) {
        return new AttExcludeSubject(personId.longValue(), boId.longValue(), exMessage);
    }

    private AttSubject genAttSubject(Long personId, List<AttSubject.AttFileBo> attFileBos) {
        return new AttSubject(personId.longValue(), attFileBos);
    }

    private AttSubject.AttFileBo genAttFileBo(long attFileBoId, List<AttSubject.AttFileVersion> attFileVersions) {
        return new AttSubject.AttFileBo(attFileBoId, attFileVersions);
    }

    private AttSubject.AttFileVersion genAttFileVersion(AttPersonRange range) {
        LocalDate startDate = WTCDateUtils.toLocalDate((Date)range.getStartDate());
        LocalDate endDate = WTCDateUtils.toLocalDate((Date)range.getEndDate());
        return new AttSubject.AttFileVersion(range.getAttFileBaseId().longValue(), startDate, endDate, range.getLegal().booleanValue());
    }

    @Override
    public String getExcludeMessage() {
        return this.excludeMessage;
    }

    @Override
    public List<AttSubject> getAttSubjects() {
        return this.attSubjectList;
    }

    @Override
    public List<AttExcludeSubject> getAttExcludeSubject() {
        return this.attExcludeSubjectList;
    }

    @Override
    public Map<Long, List<AttPersonRange>> getPersonRangeMap() {
        return this.personRangeMap;
    }
}

