/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.attconfig;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.ruleengine.RuleEngineQueryServiceImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.attconfig.AttCustomDuration;
import kd.wtc.wtes.business.model.attconfig.AttPlan;
import kd.wtc.wtes.business.model.attconfig.AttRule;
import kd.wtc.wtes.business.model.attconfig.AttRuleCal;
import kd.wtc.wtes.business.model.attconfig.AttendConfig;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;

public class AttPlanInitService {
    private static final Log LOG = LogFactory.getLog(AttPlanInitService.class);
    private static final AttPlanInitService INS = new AttPlanInitService();
    private static final HRBaseServiceHelper PLAN_HELPER = new HRBaseServiceHelper("wtp_attendplan");
    private static final HRBaseServiceHelper RULE_HELPER = new HRBaseServiceHelper("wtp_attendrule");
    private static final HRBaseServiceHelper CUSTOM_DURATION_HELPER = new HRBaseServiceHelper("wtp_attcustime");
    private static final HRBaseServiceHelper ATTEND_CONFIG_HELPER = new HRBaseServiceHelper("wtp_attendconfig");
    private static final String PLAN_FIELDS = "id,name,boid,number,bsled,bsed,setruleway,attdencerule";
    private static final String RULE_FIELDS = "id,name,boid,number,bsled,bsed,attitem1010,attitem1020,attendruleentity," + WTCStringUtils.joinOnDot((String[])new String[]{"attendruleentity", "attcustimes"}) + "," + WTCStringUtils.joinOnDot((String[])new String[]{"attendruleentity", "attcustimes", "fbasedataid_id"}) + "," + "attendconfigrule" + "," + WTCStringUtils.joinOnDot((String[])new String[]{"attendruleentity", "daterangecondition"}) + "," + "attendancedayrule" + "," + "attendancetimerule" + "," + "iscontainovertime" + "," + "ismultiallow" + "," + WTCStringUtils.joinOnDot((String[])new String[]{"attendruleentity", "limitscopecondition"});
    private static final String CUSTOM_DURATION_FIELDS = "id,name,boid,number,bsled,bsed,attcustimeattentity.attitemcus,attcustimeattentity.calcmethod,condentity.existatt,condentity.nocountatt,attitem";

    public static AttPlanInitService getInstance() {
        return INS;
    }

    private AttPlanInitService() {
    }

    private DynamicObject[] queryAttendancePlanHisVersions(Collection<Long> planBoIdSet, LocalDate startDate, LocalDate endDate) {
        LOG.debug("queryAttendancePlanHisVersions.params:{},{},{}", new Object[]{planBoIdSet, startDate, endDate});
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(planBoIdSet, startDate, endDate);
        return PLAN_HELPER.query(PLAN_FIELDS, qFilters);
    }

    public DynamicObject[] queryAttendanceRuleHisVersions(Collection<Long> ruleBoIdSet, LocalDate startDate, LocalDate endDate) {
        LOG.debug("queryAttendanceRuleHisVersions.params:{},{},{}", new Object[]{ruleBoIdSet, startDate, endDate});
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(ruleBoIdSet, startDate, endDate);
        return RULE_HELPER.query(RULE_FIELDS, qFilters);
    }

    public Map<Long, List<DynamicObject>> queryRuleVidAndRuleCal(DynamicObject[] attRuleDys) {
        if (attRuleDys == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(attRuleDys.length);
        for (DynamicObject attRuleDy : attRuleDys) {
            DynamicObjectCollection dynamicObjectCollection = attRuleDy.getDynamicObjectCollection("attendruleentity");
            ArrayList attRuleCalDyList = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
            attRuleCalDyList.addAll(dynamicObjectCollection);
            result.put(attRuleDy.getLong("id"), attRuleCalDyList);
        }
        return result;
    }

    public DynamicObject[] queryAttendConfigHisVersions(Set<Long> attendConfigBoIdSet, LocalDate startDate, LocalDate endDate) {
        LOG.debug("queryAttendConfigHisVersions.params:{},{},{}", new Object[]{attendConfigBoIdSet, startDate, endDate});
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(attendConfigBoIdSet, startDate, endDate);
        return ATTEND_CONFIG_HELPER.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] queryCustomDurationHisVersions(Collection<Long> cusDurationBoIdSet, LocalDate startDate, LocalDate endDate) {
        LOG.debug("queryCustomDurationHisVersions.params:{},{},{}", new Object[]{cusDurationBoIdSet, startDate, endDate});
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(cusDurationBoIdSet, startDate, endDate);
        return CUSTOM_DURATION_HELPER.query(CUSTOM_DURATION_FIELDS, qFilters);
    }

    public Set<Long> getAttRuleBoIdSetByAttPlan(DynamicObject[] attPlanDys) {
        return Arrays.stream(attPlanDys).map(dyo -> dyo.getLong("attdencerule.id")).collect(Collectors.toSet());
    }

    public Set<Long> getAttendConfigDysBoId(List<DynamicObject> ruleCalDys) {
        return ruleCalDys.stream().map(dyo -> dyo.getLong("attendconfigrule.id")).collect(Collectors.toSet());
    }

    public Set<Long> getAttCusBoIdSetByAttPlan(List<DynamicObject> attRuleCalDys) {
        return attRuleCalDys.stream().flatMap(dyo -> dyo.getDynamicObjectCollection("attcustimes").stream()).map(dyo -> dyo.getLong("fbasedataid_id")).collect(Collectors.toSet());
    }

    public Map<Long, TimeSeqBo<AttendConfig>> getAttendConfigTimeBoMap(DynamicObject[] attendConfigDys) {
        Map<Long, List<DynamicObject>> groupMap = Arrays.stream(attendConfigDys).collect(Collectors.groupingBy(dyo -> dyo.getLong("boid")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)groupMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> cusDurationHisVersionDys = entry.getValue();
            resultMap.put(entry.getKey(), this.attendConfigHisVersionDys2TimeBo(cusDurationHisVersionDys));
        }
        LOG.debug("getAttendConfigTimeBoMap.result:{}", resultMap.keySet());
        return resultMap;
    }

    public Map<Long, TimeSeqBo<AttCustomDuration>> getAttCustomDurationTimeBoMap(DynamicObject[] cusDurationDys) {
        Map<Long, List<DynamicObject>> groupMap = Arrays.stream(cusDurationDys).collect(Collectors.groupingBy(dyo -> dyo.getLong("boid")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)groupMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> cusDurationHisVersionDys = entry.getValue();
            resultMap.put(entry.getKey(), this.customDurationHisVersionDys2TimeBo(cusDurationHisVersionDys));
        }
        LOG.debug("getAttCustomDurationTimeBoMap.result:{}", resultMap.keySet());
        return resultMap;
    }

    private Map<Long, List<AttRuleCal>> getRuleVidAndAttRuleCalMap(Map<Long, List<DynamicObject>> rulePkIdAndRuleCalDy, Map<Long, TimeSeqBo<AttCustomDuration>> cusDurationTimeBoMap, Map<Long, TimeSeqBo<AttendConfig>> attendConfigTimeBoMap) {
        if (CollectionUtils.isEmpty(rulePkIdAndRuleCalDy)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)rulePkIdAndRuleCalDy.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : rulePkIdAndRuleCalDy.entrySet()) {
            List<DynamicObject> ruleCalCollect = entry.getValue();
            ArrayList<AttRuleCal> attRuleCalList = new ArrayList<AttRuleCal>(ruleCalCollect.size());
            if (!CollectionUtils.isEmpty(ruleCalCollect)) {
                for (DynamicObject ruleCalDy : ruleCalCollect) {
                    List<TimeSeqBo<AttCustomDuration>> attCustomDurations = this.getAttCusByRuleCalDy(ruleCalDy, cusDurationTimeBoMap);
                    String condition = ruleCalDy.getString("daterangecondition");
                    String limitCondition = ruleCalDy.getString("limitscopecondition");
                    AttRuleCal attRuleCal = AttRuleCal.create().setAttCustomDurations(attCustomDurations).setConditionJson(condition).setLimitConditionJson(limitCondition).build();
                    attRuleCalList.add(attRuleCal);
                }
            }
            result.put(entry.getKey(), attRuleCalList);
        }
        return result;
    }

    private List<TimeSeqBo<AttCustomDuration>> getAttCusByRuleCalDy(DynamicObject ruleCalDy, Map<Long, TimeSeqBo<AttCustomDuration>> cusDurationTimeBoMap) {
        ArrayList attCustomDurations = Lists.newArrayListWithExpectedSize((int)10);
        DynamicObjectCollection attCustomCollect = ruleCalDy.getDynamicObjectCollection("attcustimes");
        for (DynamicObject customDy : attCustomCollect) {
            long id = customDy.getLong("fbasedataid_id");
            TimeSeqBo<AttCustomDuration> attCustomDurationTimeSeqBo = cusDurationTimeBoMap.get(id);
            if (attCustomDurationTimeSeqBo == null) continue;
            attCustomDurations.add(attCustomDurationTimeSeqBo);
        }
        return attCustomDurations;
    }

    private Map<Long, TimeSeqBo<AttRule>> getAttRuleTimeBoMap(DynamicObject[] attRuleDys, Map<Long, List<AttRuleCal>> attRuleCalMap, Map<Long, TimeSeqBo<AttendConfig>> attendConfigTimeBoMap) {
        Map<Long, List<DynamicObject>> groupMap = Arrays.stream(attRuleDys).collect(Collectors.groupingBy(dyo -> dyo.getLong("boid")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)groupMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> attRuleHisVersionDys = entry.getValue();
            ArrayList attRuleHisVersionTimeBos = Lists.newArrayListWithExpectedSize((int)attRuleHisVersionDys.size());
            for (DynamicObject attRuleHisVersionDy : attRuleHisVersionDys) {
                Long attendConfigBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attRuleHisVersionDy, (String)"attendconfigrule");
                TimeSeqBo<AttendConfig> attendConfigTimeSeqBo = attendConfigTimeBoMap.get(attendConfigBoId);
                Long attendDay = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attRuleHisVersionDy, (String)"attendancedayrule");
                Long attendHour = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attRuleHisVersionDy, (String)"attendancetimerule");
                Long id = attRuleHisVersionDy.getLong("id");
                TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(attRuleHisVersionDy);
                List<AttRuleCal> attendConfigList = attRuleCalMap.get(id);
                attendConfigList = attendConfigList == null ? Collections.emptyList() : attendConfigList;
                attRuleHisVersionTimeBos.add(AttRule.create().setTimeSeqEntity((TimeSeqInfo)timeSeqEntity).setAttendConfigs(attendConfigList).setAttendConfigTimeSeqBo(attendConfigTimeSeqBo).setShouldAttendDay(attendDay).setShouldAttendHour(attendHour).setContainOverTime(attRuleHisVersionDy.getBoolean("iscontainovertime")).setMultiAllow(attRuleHisVersionDy.getBoolean("ismultiallow")).setId(id).build());
            }
            resultMap.put(entry.getKey(), new TimeSeqAvailableBo((Collection)attRuleHisVersionTimeBos));
        }
        LOG.debug("getAttRuleTimeBoMap.result:{}", resultMap.keySet());
        return resultMap;
    }

    private Map<Long, TimeSeqBo<AttPlan>> getAttPlanTimeBoMap(DynamicObject[] attPlanDys, Map<Long, TimeSeqBo<AttRule>> attRuleTimeBoMap) {
        Map<Long, List<DynamicObject>> groupMap = Arrays.stream(attPlanDys).collect(Collectors.groupingBy(dyo -> dyo.getLong("boid")));
        List planVersionIds = Arrays.stream(attPlanDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map ruleSetMap = RuleEngineQueryServiceImpl.getInstance().queryRuleEngineAssociation(planVersionIds);
        LOG.debug("getAttPlanTimeBoMap.params:{},result:{}", planVersionIds, (Object)ruleSetMap);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)groupMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> attPlanHisVersionDys = entry.getValue();
            ArrayList attPlanHisVersionTimeBos = Lists.newArrayListWithExpectedSize((int)attPlanHisVersionDys.size());
            for (DynamicObject attPlanHisVersionDy : attPlanHisVersionDys) {
                TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(attPlanHisVersionDy);
                String setRuleWay = (String)ruleSetMap.get(timeSeqEntity.getId());
                Long ruleBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attPlanHisVersionDy, (String)"attdencerule");
                TimeSeqBo<AttRule> attRuleTime = "2".equals(setRuleWay) ? null : attRuleTimeBoMap.get(ruleBoId);
                attPlanHisVersionTimeBos.add(AttPlan.create().setTimeSeqEntity((TimeSeqInfo)timeSeqEntity).setSutRuleWay(setRuleWay).setAttRule(attRuleTime).build());
            }
            resultMap.put(entry.getKey(), new TimeSeqAvailableBo((Collection)attPlanHisVersionTimeBos));
        }
        LOG.debug("getAttPlanTimeBoMap.result:{}", resultMap.keySet());
        return resultMap;
    }

    private TimeSeqAvailableBo<AttendConfig> attendConfigHisVersionDys2TimeBo(List<DynamicObject> attendConfigHisVersionDys) {
        if (CollectionUtils.isEmpty(attendConfigHisVersionDys)) {
            return new TimeSeqAvailableBo(Collections.emptyList());
        }
        ArrayList attendConfigHisVersionTimeBo = Lists.newArrayListWithExpectedSize((int)attendConfigHisVersionDys.size());
        for (DynamicObject configDy : attendConfigHisVersionDys) {
            TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(configDy);
            AttendConfig config = AttendConfig.create().setShiftConditionJsonTag(configDy.getString("shiftconditionjson_tag")).setCustomPlugin(configDy.getString("customplugin")).setTimeSeqInfo((TimeSeqInfo)timeSeqEntity).build();
            attendConfigHisVersionTimeBo.add(config);
        }
        return new TimeSeqAvailableBo((Collection)attendConfigHisVersionTimeBo);
    }

    private TimeSeqAvailableBo<AttCustomDuration> customDurationHisVersionDys2TimeBo(List<DynamicObject> cusDurationHisVersionDys) {
        ArrayList cusDurationHisVersionTimeBos = Lists.newArrayListWithExpectedSize((int)cusDurationHisVersionDys.size());
        for (DynamicObject cusDurationHisVersionDy : cusDurationHisVersionDys) {
            TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(cusDurationHisVersionDy);
            List<Tuple<Long, String>> durationEntryList = cusDurationHisVersionDy.getDynamicObjectCollection("attcustimeattentity").stream().map(dy -> Tuple.create((Object)dy.getLong("attitemcus.id"), (Object)dy.getString("calcmethod"))).collect(Collectors.toList());
            List<Tuple<Long, Long>> condEntryList = cusDurationHisVersionDy.getDynamicObjectCollection("condentity").stream().map(dy -> Tuple.create((Object)dy.getLong("existatt.id"), (Object)dy.getLong("nocountatt.id"))).collect(Collectors.toList());
            String attItemNumber = cusDurationHisVersionDy.getString("attitem.number");
            Long attItemId = cusDurationHisVersionDy.getLong("attitem.id");
            cusDurationHisVersionTimeBos.add(AttCustomDuration.create().setTimeSeqInfo((TimeSeqInfo)timeSeqEntity).setDurationEntryList(durationEntryList).setCondEntryList(condEntryList).setAttItemNumber(attItemNumber).setAttItemBid(attItemId).build());
        }
        return new TimeSeqAvailableBo((Collection)cusDurationHisVersionTimeBos);
    }

    public Map<Long, TimeSeqBo<AttPlan>> buildPlan(Set<Long> fileEntryIds, LocalDate startDate, LocalDate endDate) {
        DataPrepare dataQuery = this.queryPlanDataPrepare(fileEntryIds, startDate, endDate);
        HashSet ruleBoId = Sets.newHashSetWithExpectedSize((int)dataQuery.getAttPlanDys().length);
        for (DynamicObject attPlan : dataQuery.getAttPlanDys()) {
            ruleBoId.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attPlan, (String)"attdencerule"));
        }
        Map<Long, TimeSeqBo<AttRule>> attRuleTimeBoMap = this.buildRule(ruleBoId, startDate, endDate);
        return this.getAttPlanTimeBoMap(dataQuery.getAttPlanDys(), attRuleTimeBoMap);
    }

    public Map<Long, TimeSeqBo<AttRule>> buildRule(Set<Long> fileEntryIds, LocalDate startDate, LocalDate endDate) {
        DataPrepare dataQuery = this.queryRuleDataPrepare(fileEntryIds, startDate, endDate);
        Map<Long, TimeSeqBo<AttCustomDuration>> attCustomDurationTimeBoMap = this.getAttCustomDurationTimeBoMap(dataQuery.getAttCustomDurations());
        Map<Long, TimeSeqBo<AttendConfig>> attConfigTimeBoMap = this.getAttendConfigTimeBoMap(dataQuery.getAttendConfigDys());
        Map<Long, List<AttRuleCal>> ruleVidAndRuleCalHis = this.getRuleVidAndAttRuleCalMap(dataQuery.getRulePkIdAndRuleCalDy(), attCustomDurationTimeBoMap, attConfigTimeBoMap);
        return this.getAttRuleTimeBoMap(dataQuery.getAttRuleDys(), ruleVidAndRuleCalHis, attConfigTimeBoMap);
    }

    private DataPrepare queryPlanDataPrepare(Set<Long> fileEntryIds, LocalDate startDate, LocalDate endDate) {
        DynamicObject[] attPlanDys = this.queryAttendancePlanHisVersions(fileEntryIds, startDate, endDate);
        Set<Long> attRuleBoIds = this.getAttRuleBoIdSetByAttPlan(attPlanDys);
        DataPrepare dataPrepare = this.queryRuleDataPrepare(attRuleBoIds, startDate, endDate);
        dataPrepare.setAttPlanDys(attPlanDys);
        return dataPrepare;
    }

    private DataPrepare queryRuleDataPrepare(Set<Long> fileEntryIds, LocalDate startDate, LocalDate endDate) {
        DynamicObject[] attRuleDys = this.queryAttendanceRuleHisVersions(fileEntryIds, startDate, endDate);
        Map<Long, List<DynamicObject>> rulePkIdAndRuleCalDy = this.queryRuleVidAndRuleCal(attRuleDys);
        ArrayList<DynamicObject> ruleCalDys = new ArrayList<DynamicObject>(10);
        for (List<DynamicObject> value : rulePkIdAndRuleCalDy.values()) {
            ruleCalDys.addAll(value);
        }
        Set<Long> attendConfigBoIdSet = this.getAttendConfigDysBoId(Arrays.asList(attRuleDys));
        DynamicObject[] attendConfigDys = this.queryAttendConfigHisVersions(attendConfigBoIdSet, startDate, endDate);
        Set<Long> attCusBoIds = this.getAttCusBoIdSetByAttPlan(ruleCalDys);
        DynamicObject[] attCustomDurations = this.queryCustomDurationHisVersions(attCusBoIds, startDate, endDate);
        DataPrepare dataPrepare = new DataPrepare();
        dataPrepare.setAttRuleDys(attRuleDys);
        dataPrepare.setRulePkIdAndRuleCalDy(rulePkIdAndRuleCalDy);
        dataPrepare.setAttendConfigDys(attendConfigDys);
        dataPrepare.setAttCustomDurations(attCustomDurations);
        return dataPrepare;
    }

    private static class DataPrepare {
        private DynamicObject[] attPlanDys;
        private DynamicObject[] attRuleDys;
        private Map<Long, List<DynamicObject>> rulePkIdAndRuleCalDy;
        private DynamicObject[] attendConfigDys;
        private DynamicObject[] attCustomDurations;

        private DataPrepare() {
        }

        public DynamicObject[] getAttPlanDys() {
            return this.attPlanDys;
        }

        public void setAttPlanDys(DynamicObject[] attPlanDys) {
            this.attPlanDys = attPlanDys;
        }

        public DynamicObject[] getAttRuleDys() {
            return this.attRuleDys;
        }

        public void setAttRuleDys(DynamicObject[] attRuleDys) {
            this.attRuleDys = attRuleDys;
        }

        public Map<Long, List<DynamicObject>> getRulePkIdAndRuleCalDy() {
            return this.rulePkIdAndRuleCalDy;
        }

        public void setRulePkIdAndRuleCalDy(Map<Long, List<DynamicObject>> rulePkIdAndRuleCalDy) {
            this.rulePkIdAndRuleCalDy = rulePkIdAndRuleCalDy;
        }

        public DynamicObject[] getAttendConfigDys() {
            return this.attendConfigDys;
        }

        public void setAttendConfigDys(DynamicObject[] attendConfigDys) {
            this.attendConfigDys = attendConfigDys;
        }

        public DynamicObject[] getAttCustomDurations() {
            return this.attCustomDurations;
        }

        public void setAttCustomDurations(DynamicObject[] attCustomDurations) {
            this.attCustomDurations = attCustomDurations;
        }
    }
}

