/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtes.business.log.TieLogFactory;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.access.ConditionDto;
import kd.wtc.wtes.business.model.rlra.AttStatusEnum;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEnum;
import kd.wtc.wtes.business.service.IAccessService;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

@SingletonBean
public class AccessServiceImpl
implements IAccessService {
    protected static final Log log = TieLogFactory.getLog(AccessServiceImpl.class);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("wtbd_dasoconf");
    private static final Map<String, Function<ITimeBucket, Object>> MAPPING = new HashMap<String, Function<ITimeBucket, Object>>();

    @Override
    public List<TieDataNodeStd> accessFilter(List<TieDataNodeStd> rawtimeList, Long pk) {
        DynamicObject dynamicObject = SERVICE_HELPER.queryOne("conditions", (Object)pk);
        if (dynamicObject == null) {
            log.warn("---\u4e0d\u5b58\u5728\u5bf9\u5e94\u53d6\u6570\u914d\u7f6e!---");
            throw new WtesException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u53d6\u6570\u914d\u7f6e\u3002", (String)"AccessServiceImpl_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        String conditions = dynamicObject.getString("conditions");
        rawtimeList = this.accessFilterByCondition1(rawtimeList, conditions);
        return rawtimeList;
    }

    private List<TieDataNodeStd> accessFilterByCondition1(List<TieDataNodeStd> rawtimeList, String conditions) {
        AccessDto accessDto;
        try {
            accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditions, AccessDto.class);
        }
        catch (Exception e) {
            throw new WtesException((Throwable)e, ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u8fc7\u6ee4\u8868\u8fbe\u5f0f:", (String)"AccessServiceImpl_1", (String)"wtc-wtes-business", (Object[])new Object[]{conditions}));
        }
        return this.accessFilterByCondition(rawtimeList, accessDto);
    }

    @Override
    public List<TieDataNodeStd> accessFilterByCondition(List<TieDataNodeStd> rawtimeList, AccessDto conditions) {
        List<ConditionDto> conditionList = conditions.getConditionList();
        String[] condiToken = conditions.getConditionExpressToken();
        HashMap map = new HashMap(16);
        List<TieDataNodeStd> filterList = rawtimeList.stream().filter(rawtime -> {
            if (rawtime instanceof TimeBucketStd) {
                TimeBucketStd timeBucket = (TimeBucketStd)rawtime;
                for (ConditionDto dto : conditionList) {
                    String param = dto.getParam();
                    Object invoke = MAPPING.get(param).apply(timeBucket);
                    if (invoke instanceof List) {
                        List bucketProps = (List)invoke;
                        if (CollectionUtils.isEmpty((Collection)bucketProps)) {
                            this.putMap(dto, "", (Map<String, Boolean>)map);
                            continue;
                        }
                        this.putMap(dto, bucketProps, (Map<String, Boolean>)map);
                        continue;
                    }
                    if (!(invoke instanceof String)) continue;
                    String bucketProp = (String)invoke;
                    this.putMap(dto, bucketProp, (Map<String, Boolean>)map);
                }
                if (log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(rawtime);
                    String str = ResManager.loadKDString((String)"\u8fc7\u6ee4\u8868\u8fbe\u5f0f", (String)"AccessServiceImpl_2", (String)"wtc-wtes-business", (Object[])new Object[0]);
                    sb.append("---");
                    sb.append(str);
                    sb.append(":");
                    sb.append(map);
                    log.debug("AccessServiceImpl filter: {}", (Object)sb);
                }
                return this.getResultWithOptimization(condiToken, map);
            }
            return false;
        }).collect(Collectors.toList());
        return filterList;
    }

    @Override
    public List<TimeBucket> accessFilterByConditionI(List<TimeBucket> rawtimeList, AccessDto conditions) {
        List<ConditionDto> conditionList = conditions.getConditionList();
        String[] condiToken = conditions.getConditionExpressToken();
        HashMap map = new HashMap(16);
        List<TimeBucket> filterList = rawtimeList.stream().filter(rawtime -> this.accessFilterByCondition(conditionList, (TimeBucket)rawtime, map, condiToken)).collect(Collectors.toList());
        return filterList;
    }

    private boolean accessFilterByCondition(List<ConditionDto> conditionList, TimeBucket rawtime, Map<String, Boolean> map, String[] condiToken) {
        for (ConditionDto dto : conditionList) {
            String param = dto.getParam();
            Object invoke = MAPPING.get(param).apply(rawtime);
            if (invoke instanceof List) {
                List bucketProps = (List)invoke;
                if (CollectionUtils.isEmpty((Collection)bucketProps)) {
                    this.putMap(dto, "", map);
                    continue;
                }
                this.putMap(dto, bucketProps, map);
                continue;
            }
            if (!(invoke instanceof String)) continue;
            String bucketProp = (String)invoke;
            this.putMap(dto, bucketProp, map);
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(rawtime);
            String str = ResManager.loadKDString((String)"\u8fc7\u6ee4\u8868\u8fbe\u5f0f", (String)"AccessServiceImpl_2", (String)"wtc-wtes-business", (Object[])new Object[0]);
            sb.append("---");
            sb.append(str);
            sb.append(":");
            sb.append(map);
            log.debug("AccessServiceImpl filter: {}", (Object)sb);
        }
        return this.getResultWithOptimization(condiToken, map);
    }

    private void putMap(ConditionDto dto, List<String> bucketProp, Map<String, Boolean> map) {
        String name = dto.getName();
        String operators = dto.getOperators();
        RuleOperatorEnum ruleOperatorEnum = RuleOperatorEnum.getEnum((String)operators);
        switch (ruleOperatorEnum) {
            case EQUAL: {
                map.put(name, bucketProp.contains(dto.getValue()));
                break;
            }
            case NOT_EQUAL: {
                map.put(name, !bucketProp.contains(dto.getValue()));
                break;
            }
            case IN: {
                List<String> list = dto.getValueList();
                map.put(name, this.equalsAnyOne(bucketProp, list));
                break;
            }
            case NOT_IN: {
                List<String> list = dto.getValueList();
                map.put(name, !this.equalsAnyOne(bucketProp, list));
                break;
            }
            case IS_NULL: {
                map.put(name, CollectionUtils.isEmpty(bucketProp));
                break;
            }
            case IS_NOT_NULL: {
                map.put(name, CollectionUtils.isNotEmpty(bucketProp));
            }
        }
    }

    private boolean equalsAnyOne(List<String> bucketProp, List<String> list) {
        for (String bucketOne : bucketProp) {
            for (String target : list) {
                if (!HRStringUtils.equals((String)target, (String)bucketOne)) continue;
                return true;
            }
        }
        return false;
    }

    private void putMap(ConditionDto dto, String bucketProp, Map<String, Boolean> map) {
        String operators;
        String name = dto.getName();
        switch (operators = dto.getOperators()) {
            case "==": {
                map.put(name, HRStringUtils.equals((String)dto.getValue(), (String)bucketProp));
                break;
            }
            case "!=": {
                map.put(name, !HRStringUtils.equals((String)dto.getValue(), (String)bucketProp));
                break;
            }
            case "in": {
                List<String> list = dto.getValueList();
                map.put(name, list.contains(bucketProp));
                break;
            }
            case "not_in": {
                List<String> list = dto.getValueList();
                map.put(name, !list.contains(bucketProp));
                break;
            }
            case "is_null": {
                map.put(name, HRStringUtils.isEmpty((String)bucketProp));
                break;
            }
            case "is_not_null": {
                map.put(name, HRStringUtils.isNotEmpty((String)bucketProp));
            }
        }
    }

    @Deprecated
    private List<String> transformer2List(String value) {
        String[] split = value.split(",");
        return Arrays.stream(split).collect(Collectors.toList());
    }

    @Deprecated
    public boolean getResult(String str, Map<String, Boolean> params) {
        str = str.replaceAll(" +", "").replaceAll("and", "&").replace("or", "|");
        Set<Map.Entry<String, Boolean>> entrySet = params.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            str = str.replace(entry.getKey(), entry.getValue() != false ? "1" : "0");
        }
        int pro = this.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    private boolean getResultWithOptimization(String[] tokens, Map<String, Boolean> params) {
        CharSequence[] changeTokens = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            Boolean value;
            String token = tokens[i];
            changeTokens[i] = token.equals("and") ? "&" : (token.equals("or") ? "|" : ((value = params.get(token)) != null ? (value != false ? "1" : "0") : token));
        }
        String str = String.join((CharSequence)"", changeTokens);
        int pro = this.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    public boolean get(String str) {
        int pro = this.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    private int pro(char[] arr, int beginIdx) {
        int idx;
        int culResult = 0x8000000;
        int preSign = 38;
        int len = arr.length;
        for (idx = beginIdx; idx < len; ++idx) {
            int ch = arr[idx];
            if (ch == 41) {
                return idx | culResult;
            }
            if (ch == 40) {
                int pro = this.pro(arr, idx + 1);
                int subAns = pro & 0x8000000;
                int newIdx = pro & 0xF7FFFFFF;
                ch = subAns == 0 ? 48 : 49;
                idx = newIdx;
            }
            if (ch == 124) {
                preSign = ch;
                if (culResult == 0) continue;
                idx = this.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (ch == 38) {
                preSign = ch;
                if (culResult != 0) continue;
                idx = this.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (ch == 49) {
                if (preSign != 124) continue;
                culResult = 0x8000000;
                continue;
            }
            if (ch != 48 || preSign != 38) continue;
            culResult = 0;
        }
        return idx | culResult;
    }

    private int getIdx4CurLevel(char[] arr, int beginIdx) {
        int idx;
        int len = arr.length;
        int count = 0;
        for (idx = beginIdx; idx < len; ++idx) {
            char ch = arr[idx];
            if (ch == '(') {
                ++count;
                continue;
            }
            if (ch != ')') continue;
            if (count == 0) {
                return idx;
            }
            --count;
        }
        return idx;
    }

    static {
        MAPPING.put("dateattribute", tb -> Objects.isNull(tb.getDateAttribute()) ? "" : tb.getDateAttribute().code);
        MAPPING.put("off", tb -> String.valueOf(tb.getShiftSpec().isOff()));
        MAPPING.put("shifttimebucketproperty", tb -> Objects.isNull((Object)tb.getShiftTimeBucketProperty()) ? "" : tb.getShiftTimeBucketProperty().code);
        MAPPING.put("timebucketposition", tb -> tb.getTimeBucketPosition().code);
        MAPPING.put("attendancebilltag", tb -> {
            ArrayList<String> result = new ArrayList<String>();
            if (tb.getAttendanceBillTag().isOnBusiness()) {
                result.add("1030_S");
            }
            if (tb.getAttendanceBillTag().isOnVacation()) {
                result.add("1020_S");
            }
            if (tb.getAttendanceBillTag().isOverTime()) {
                result.add("1010_S");
            }
            return result;
        });
        MAPPING.put("punchcardtag.id", tb -> PunchCardTagEnum.getByCode(tb.getPunchCardTag()).getId().toString());
        MAPPING.put("attstatuslist.id", tb -> tb.getAttendanceStatusList().stream().map(element -> AttStatusEnum.getByCode(element).getId().toString()).collect(Collectors.toList()));
        MAPPING.put("absencebillstate", ITimeBucket::getAbsenceBillState);
        MAPPING.put("travelbillstate", ITimeBucket::getTravelBillState);
        MAPPING.put("shifttimebucketseq", tb -> tb.getShiftTimeBucketSeqId().toString());
        MAPPING.put("datetype.id", tb -> tb.getDateType().getId().toString());
        for (String key : new ArrayList<String>(MAPPING.keySet())) {
            MAPPING.put("bucket.wtte_buckettime." + key, MAPPING.get(key));
        }
    }
}

