/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.storage.AttSpliteRecordSaveServiceImpl;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttPeriodSumServiceImpl
implements IDataPackageStoreService {
    private static HRBaseServiceHelper attPeriodSummaryService = WtesHRBaseTimeWatchUtil.create(AttPeriodSumServiceImpl.class.getName() + "." + "wtctd_atttotalbase", "wtctd_atttotalbase");
    private static HRBaseServiceHelper attPeriodDetailSummaryService = WtesHRBaseTimeWatchUtil.create(AttPeriodSumServiceImpl.class.getName() + "." + "wtdtd_attrecorddetail", "wtctd_atttotaldetail");
    private static HRBaseServiceHelper periodMoveDetailService = WtesHRBaseTimeWatchUtil.create(AttSpliteRecordSaveServiceImpl.class.getName() + "." + "wtte_periodmovedetail", "wtte_periodmovedetail");
    private static final String QUERY_PROP = "id,personid.id,perattperiodid.id";
    private static final String PERATTPERIOD_ID = "perattperiodid.id";
    private static final String PERSON_ID = "personid.id";

    @Override
    public void storeBatch(List<RecordAndPackageWrapper> recordAndPackageWrapperList) {
    }

    @Override
    @Deprecated
    public void deleteRecoredAfterErrorDate(Long attPersonId, Date errorDate) {
    }

    @Override
    public void deleteRecordByAttFileBoIdAfterErrorDate(Long attFileBoId, Date errorDate) {
    }

    @Override
    public String getServiceReportNodeName() {
        return CalcReportConstants.ATT_PERIOD_CLEAN_TIME;
    }

    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        QFilter qFilter = this.genQFilter(attSubjects, "perperiodbegindate", "perperiodenddate", "attfileid");
        DynamicObject[] periodTotal = attPeriodSummaryService.query(QUERY_PROP, new QFilter[]{qFilter});
        if (null == periodTotal || periodTotal.length == 0) {
            return;
        }
        List attmainIdList = Arrays.asList(periodTotal).stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
        attPeriodSummaryService.deleteByFilter(new QFilter[]{new QFilter("id", "in", attmainIdList)});
        attPeriodDetailSummaryService.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", attmainIdList)});
        this.deleteAdjustResult(periodTotal, attSubjects);
    }

    private Set<Long> getAttFileBoidByPersonId(List<AttSubject> attSubjects, Set<Long> personIdSet) {
        HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        for (AttSubject attSubject : attSubjects) {
            if (!personIdSet.contains(attSubject.getAttPersonId())) continue;
            Set addBoIdSet = attSubject.getAttFileBos().stream().map(AttSubject.AttFileBo::getAttFileBoid).collect(Collectors.toSet());
            attFileBoIds.addAll(addBoIdSet);
        }
        return attFileBoIds;
    }

    private void deleteAdjustResult(DynamicObject[] periodTotal, List<AttSubject> attSubjects) {
        Map<Long, List<DynamicObject>> periodMap = Arrays.stream(periodTotal).collect(Collectors.groupingBy(ob -> ob.getLong(PERATTPERIOD_ID)));
        QFilter deleteCondition = null;
        for (Map.Entry<Long, List<DynamicObject>> entry : periodMap.entrySet()) {
            QFilter tmpDelete = new QFilter("attperiodid", "=", (Object)entry.getKey());
            Set<Long> personIdSet = entry.getValue().stream().map(ob -> ob.getLong(PERSON_ID)).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(personIdSet)) {
                Set<Long> attFileBoIds = this.getAttFileBoidByPersonId(attSubjects, personIdSet);
                tmpDelete.and("attfilebase", "in", attFileBoIds);
                tmpDelete.and(new QFilter("revisionhisid.datastatus", "=", (Object)"1"));
            }
            if (deleteCondition != null) {
                deleteCondition.or(tmpDelete);
                continue;
            }
            deleteCondition = tmpDelete;
        }
        periodMoveDetailService.deleteByFilter(new QFilter[]{deleteCondition});
    }

    private QFilter genQFilter(List<AttSubject> attSubjects, String startDateKey, String endDateKey, String attFileBidKey) {
        QFilter qFilter = null;
        List<QFilter> qFilterList = this.genQFilterList(attSubjects, startDateKey, endDateKey, attFileBidKey);
        for (QFilter filter : qFilterList) {
            if (null == qFilter) {
                qFilter = filter;
                continue;
            }
            qFilter.or(filter);
        }
        return qFilter;
    }

    private List<QFilter> genQFilterList(List<AttSubject> attSubjects, String startDateKey, String endDateKey, String attFileBidKey) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        HashMap<String, Tuple> qFilterListMap = new HashMap<String, Tuple>(16);
        for (AttSubject attSubject : attSubjects) {
            QFilter qFilterKey = new QFilter(startDateKey, "<=", (Object)attSubject.getEndDate()).and(endDateKey, ">=", (Object)attSubject.getStartDate());
            Tuple personIdList = (Tuple)qFilterListMap.get(qFilterKey.toString());
            if (personIdList == null) {
                personIdList = new Tuple((Object)qFilterKey, new ArrayList());
            }
            for (AttSubject.AttFileBo attFileBo : attSubject.getAttFileBos()) {
                ((List)personIdList.getValue()).add(attFileBo.getAttFileBoid());
            }
            qFilterListMap.put(qFilterKey.toString(), personIdList);
        }
        for (Map.Entry entry : qFilterListMap.entrySet()) {
            QFilter result = ((List)((Tuple)entry.getValue()).getValue()).size() == 1 ? new QFilter(attFileBidKey, "=", ((List)((Tuple)entry.getValue()).getValue()).get(0)).and((QFilter)((Tuple)entry.getValue()).getKey()) : new QFilter(attFileBidKey, "in", ((Tuple)entry.getValue()).getValue()).and((QFilter)((Tuple)entry.getValue()).getKey());
            qFilterList.add(result);
        }
        return qFilterList;
    }
}

