/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCLocalDateTimeUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaLactationTimeStorage;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.business.service.IBillTimeBuckSplitService;
import kd.wtc.wtes.business.service.impl.BillTimeBuckSplitEnum;
import kd.wtc.wtes.business.util.TimeBucketUtil;
import kd.wtc.wtes.common.enums.BillNonPlanEnum;
import kd.wtc.wtes.common.enums.BillTimeBucketType;
import kd.wtc.wtes.common.enums.RefDateType;
import kd.wtc.wtes.common.util.CollectionUtils;

public class BillTimeBuckSplitServiceImpl
implements IBillTimeBuckSplitService {
    private final String GENERATE_WAY = WTCAppContextHelper.getSysParams().getString("wtc.wtabm.breastfeedingleave.generateway", "1");
    private static final Log LOGGER = LogFactory.getLog(BillTimeBuckSplitServiceImpl.class);
    private List<AttBillTimeBucket> rowSplitResult;
    private long personId;
    private LocalDate ascription;
    private LocalDate startDate;
    private LocalDate endDate;
    private ShiftTableSingle shiftTableSingle;
    private AttBillTimeBucket.Builder builder;

    public static Date getDate(Date date, Integer integer) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, integer);
        return cal.getTime();
    }

    @Override
    public List<AttBillTimeBucket> splitTimeBucket4Bustrip(ShiftTable shiftTable, Iterable<DynamicObject> billSplitList, BillTimeBuckSplitEnum timeBuckSplitEnum) {
        List<AttBillTimeBucket> result = new ArrayList<AttBillTimeBucket>(16);
        for (DynamicObject dynamicObject : billSplitList) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryEntity) {
                List<AttBillTimeBucket> rowSplitResult = this.splitOneRow(shiftTable, dynamicObject, entryRow, timeBuckSplitEnum);
                result.addAll(rowSplitResult);
            }
        }
        if (BillTimeBuckSplitEnum.VA_BILL_PRAM == timeBuckSplitEnum) {
            result = this.dealOverlapTimeBucket(result);
        }
        return result;
    }

    private List<AttBillTimeBucket> dealOverlapTimeBucket(List<AttBillTimeBucket> timeBuckets) {
        if (WTCCollections.isEmpty(timeBuckets)) {
            return timeBuckets;
        }
        List result = WTCCollections.modifiableListWithCap((int)timeBuckets.size());
        Map<Long, LinkedList> groupedTimeBuckets = timeBuckets.stream().collect(Collectors.groupingBy(AttBillTimeBucket::getAttPersonId, Collectors.toCollection(LinkedList::new)));
        for (Map.Entry<Long, LinkedList> personTimeBucketEntries : groupedTimeBuckets.entrySet()) {
            LinkedList personTimeBuckets = personTimeBucketEntries.getValue();
            personTimeBuckets.sort((o1, o2) -> {
                if (o1.getRosterDate().equals(o2.getRosterDate())) {
                    if (o1.isNonTime()) {
                        return 1;
                    }
                    if (o2.isNonTime()) {
                        return -1;
                    }
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
                return o1.getRosterDate().compareTo(o2.getRosterDate());
            });
            for (AttBillTimeBucket attBillTimeBucket : this.dealAttBillTimeBucket(personTimeBuckets)) {
                if (attBillTimeBucket == null) continue;
                result.add(attBillTimeBucket);
            }
        }
        return result;
    }

    private List<AttBillTimeBucket> dealAttBillTimeBucket(List<AttBillTimeBucket> personTimeBuckets) {
        for (int prefix = 0; prefix < personTimeBuckets.size(); ++prefix) {
            AttBillTimeBucket preTimeBucket;
            for (int postfix = prefix + 1; postfix < personTimeBuckets.size() && (preTimeBucket = personTimeBuckets.get(prefix)) != null; ++postfix) {
                Tuple<List<AttBillTimeBucket>, Boolean> tuple;
                AttBillTimeBucket postTimeBucket = personTimeBuckets.get(postfix);
                if (postTimeBucket == null || (tuple = this.doDealAttBillTimeBucket(preTimeBucket, postTimeBucket)) == null) continue;
                List timeBuckets = (List)tuple.getKey();
                if (Boolean.TRUE.equals(tuple.getValue())) {
                    personTimeBuckets.set(prefix, null);
                } else {
                    personTimeBuckets.set(postfix, null);
                }
                personTimeBuckets.addAll(timeBuckets);
            }
        }
        return personTimeBuckets;
    }

    private Tuple<List<AttBillTimeBucket>, Boolean> doDealAttBillTimeBucket(AttBillTimeBucket preTimeBucket, AttBillTimeBucket postTimeBucket) {
        if (WTCStringUtils.equals((String)preTimeBucket.getEntryRowDy().getString("specialvatype"), (String)SpecialVaTypeEnum.LACTATION_TYPE.vaType) || SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(postTimeBucket.getEntryRowDy().getString("specialvatype"))) {
            boolean hasIntersection = this.hasIntersection(preTimeBucket, postTimeBucket);
            if (!hasIntersection) {
                return null;
            }
            List timeBuckets = WTCCollections.modifiableEmptyList();
            Boolean flag = Boolean.FALSE;
            if (SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(preTimeBucket.getEntryRowDy().getString("specialvatype"))) {
                flag = Boolean.TRUE;
            } else {
                AttBillTimeBucket temp = preTimeBucket;
                preTimeBucket = postTimeBucket;
                postTimeBucket = temp;
            }
            if (!postTimeBucket.isNonTime() && !preTimeBucket.isNonTime()) {
                LocalDateTime start;
                LocalDateTime end = WTCLocalDateTimeUtils.getMin((LocalDateTime[])new LocalDateTime[]{preTimeBucket.getEndTime(), postTimeBucket.getStartTime()});
                if (end.isAfter(preTimeBucket.getStartTime())) {
                    AttBillTimeBucket timeBucket = preTimeBucket.buildWith().endTime(end).build();
                    timeBuckets.add(timeBucket);
                }
                if ((start = WTCLocalDateTimeUtils.getMax((LocalDateTime[])new LocalDateTime[]{preTimeBucket.getStartTime(), postTimeBucket.getEndTime()})).isBefore(preTimeBucket.getEndTime())) {
                    AttBillTimeBucket timeBucket = preTimeBucket.buildWith().startTime(start).build();
                    timeBuckets.add(timeBucket);
                }
            }
            return new Tuple((Object)timeBuckets, (Object)flag);
        }
        return null;
    }

    private boolean hasIntersection(AttBillTimeBucket left, AttBillTimeBucket right) {
        if (left == null || right == null) {
            return false;
        }
        if (!left.isNonTime() && !right.isNonTime()) {
            if (left.getStartTime() != null && left.getEndTime() != null && right.getStartTime() != null && right.getEndTime() != null) {
                return right.getStartTime().isBefore(left.getEndTime()) && right.getEndTime().isAfter(left.getStartTime());
            }
            LOGGER.warn("\u62c6\u51fa\u65f6\u95f4\u5bf9\u4e3a\u6709\u65f6\u6bb5\u65f6\u95f4\u5bf9\uff0c\u4f46\u662f\u53d6\u5230\u5f00\u59cb\u65e5\u671f\u6216\u8005\u7ed3\u675f\u65e5\u671f\u5b58\u5728null\u3002left:{}, right :{}", (Object)JSON.toJSONString((Object)left), (Object)JSON.toJSONString((Object)right));
            return false;
        }
        LocalDate lftRoster = left.getRosterDate();
        LocalDate rightRoster = right.getRosterDate();
        if (lftRoster == null || rightRoster == null) {
            LOGGER.warn("\u62c6\u51fa\u65f6\u95f4rosterDate\u5b58\u5728null\u503c\u3002left:{}, right:{}", (Object)JSON.toJSONString((Object)left), (Object)JSON.toJSONString((Object)right));
            return false;
        }
        return lftRoster.equals(rightRoster);
    }

    private List<AttBillTimeBucket> splitOneRow(ShiftTable shiftTable, DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum) {
        block11: {
            block12: {
                String unitType;
                block10: {
                    if (shiftTable == null) {
                        return Collections.emptyList();
                    }
                    this.doInit(shiftTable, dynamic, entryRow, timeBuckSplitEnum);
                    if (null == this.shiftTableSingle || null == this.shiftTableSingle.getRosterSpecMap()) {
                        return Collections.emptyList();
                    }
                    unitType = entryRow.getString(timeBuckSplitEnum.startUnitType);
                    if (BillTimeBuckSplitEnum.VA_BILL_PRAM != timeBuckSplitEnum || !BillTimeBuckSplitServiceImpl.isLactationType(entryRow)) break block10;
                    this.getVaLactationBill(dynamic, entryRow, timeBuckSplitEnum);
                    break block11;
                }
                if (!"3".equals(unitType)) break block12;
                switch (timeBuckSplitEnum) {
                    case VA_BILL_PRAM: {
                        LocalDateTime realStartDate = WTCDateUtils.toLocalDateTime((Date)entryRow.getDate(timeBuckSplitEnum.startDate));
                        LocalDateTime realEndDate = WTCDateUtils.toLocalDateTime((Date)entryRow.getDate(timeBuckSplitEnum.endDate));
                        LocalDate start = realStartDate.toLocalDate().plusDays(-1L);
                        LocalDate end = realEndDate.toLocalDate().plusDays(1L);
                        while (start.compareTo(end) <= 0) {
                            this.getVaOptionalBill(dynamic, entryRow, null, timeBuckSplitEnum, realStartDate, realEndDate, start);
                            start = start.plusDays(1L);
                        }
                        break block11;
                    }
                    case TL_BILL_PRAM: {
                        this.getTlOptionalBill(dynamic, entryRow, timeBuckSplitEnum);
                        break;
                    }
                }
                break block11;
            }
            LOGGER.debug("startDate{},endDate{}", (Object)this.startDate, (Object)this.endDate);
            if (this.startDate.isEqual(this.endDate)) {
                this.splitProcess(dynamic, entryRow, timeBuckSplitEnum, this.correctUnitType(timeBuckSplitEnum, entryRow, true), this.startDate);
            } else {
                this.splitProcess(dynamic, entryRow, timeBuckSplitEnum, this.correctUnitType(timeBuckSplitEnum, entryRow, true), this.startDate);
                LocalDate temp = this.startDate.plusDays(1L);
                while (temp.isBefore(this.endDate)) {
                    LOGGER.debug("nowtemp is {}", (Object)temp);
                    this.getAllDayBill(dynamic, entryRow, timeBuckSplitEnum, temp);
                    temp = temp.plusDays(1L);
                }
                this.splitProcess(dynamic, entryRow, timeBuckSplitEnum, this.correctUnitType(timeBuckSplitEnum, entryRow, false), this.endDate);
            }
        }
        return this.rowSplitResult;
    }

    private static boolean isLactationType(DynamicObject entryRow) {
        String spVaType = entryRow.getString("specialvatype");
        return SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(spVaType);
    }

    private String correctUnitType(BillTimeBuckSplitEnum timeBuckSplitEnum, DynamicObject entryRow, boolean isStart) {
        String startType = entryRow.getString(timeBuckSplitEnum.startUnitType);
        String endType = entryRow.getString(timeBuckSplitEnum.endUnitType);
        String result = this.startDate.isEqual(this.endDate) ? (startType.equals(endType) ? startType : "2") : (isStart ? ("0".equals(startType) ? "2" : startType) : ("1".equals(endType) ? "2" : endType));
        return result;
    }

    private void splitProcess(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum, String unitType, LocalDate targetDate) {
        switch (unitType) {
            case "0": {
                this.getHalfUpDayBill(dynamic, entryRow, timeBuckSplitEnum, targetDate);
                break;
            }
            case "1": {
                this.getHalfDownDayBill(dynamic, entryRow, timeBuckSplitEnum, targetDate);
                break;
            }
            case "2": {
                this.getAllDayBill(dynamic, entryRow, timeBuckSplitEnum, targetDate);
                break;
            }
        }
    }

    private void getHalfDownDayBill(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum, LocalDate targetDate) {
        Roster roster = this.shiftTableSingle.getRoster(targetDate);
        if (Objects.nonNull(roster)) {
            ShiftSpec shiftSpec = roster.getShiftSpec();
            if (shiftSpec == null) {
                return;
            }
            if (shiftSpec.getOffNonPlan()) {
                this.builder = this.buildBaseInfo(dynamic, entryRow, timeBuckSplitEnum);
                Long id = (Long)entryRow.getPkValue();
                this.builder.rosterDate(targetDate).id(id);
                this.builder.billNonPlanEnum(BillNonPlanEnum.HALF_DAY);
                this.rowSplitResult.add(this.builder.build());
                return;
            }
            if (timeBuckSplitEnum == BillTimeBuckSplitEnum.VA_BILL_PRAM) {
                this.splitWithOutRest(dynamic, entryRow, timeBuckSplitEnum, targetDate, LocalDateTime.of(shiftSpec.getShiftMiddleRule().getMiddleRefDate() == kd.wtc.wtbs.common.model.shift.RefDateType.NEXTDAY ? targetDate.plusDays(1L) : targetDate, LocalTime.ofSecondOfDay(shiftSpec.getShiftMiddleRule().getMiddlepoint())), shiftSpec.getRealLastShiftTime(targetDate), (Long)entryRow.getPkValue());
            } else if (timeBuckSplitEnum == BillTimeBuckSplitEnum.TL_BILL_PRAM) {
                this.builder = this.buildBaseInfo(dynamic, entryRow, timeBuckSplitEnum);
                Long id = (Long)entryRow.getPkValue();
                this.builder.rosterDate(targetDate).id(id);
                LocalDateTime startTime = LocalDateTime.of(shiftSpec.getShiftMiddleRule().getMiddleRefDate() == kd.wtc.wtbs.common.model.shift.RefDateType.NEXTDAY ? targetDate.plusDays(1L) : targetDate, LocalTime.ofSecondOfDay(shiftSpec.getShiftMiddleRule().getMiddlepoint()));
                this.builder.startTime(startTime).endTime(shiftSpec.getRealLastShiftTime(targetDate));
                this.rowSplitResult.add(this.builder.build());
            }
        }
    }

    private void getHalfUpDayBill(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum, LocalDate targetDate) {
        Roster roster = this.shiftTableSingle.getRoster(targetDate);
        if (Objects.nonNull(roster)) {
            ShiftSpec shiftSpec = roster.getShiftSpec();
            if (shiftSpec == null) {
                return;
            }
            if (shiftSpec.getOffNonPlan()) {
                this.builder = this.buildBaseInfo(dynamic, entryRow, timeBuckSplitEnum);
                Long id = (Long)entryRow.getPkValue();
                this.builder.rosterDate(targetDate).id(id);
                this.builder.billNonPlanEnum(BillNonPlanEnum.HALF_DAY);
                this.rowSplitResult.add(this.builder.build());
                return;
            }
            if (timeBuckSplitEnum == BillTimeBuckSplitEnum.VA_BILL_PRAM) {
                this.splitWithOutRest(dynamic, entryRow, timeBuckSplitEnum, targetDate, shiftSpec.getRealEarliestShiftTime(targetDate), LocalDateTime.of(shiftSpec.getShiftMiddleRule().getMiddleRefDate() == kd.wtc.wtbs.common.model.shift.RefDateType.NEXTDAY ? targetDate.plusDays(1L) : targetDate, LocalTime.ofSecondOfDay(shiftSpec.getShiftMiddleRule().getMiddlepoint())), (Long)entryRow.getPkValue());
            } else if (timeBuckSplitEnum == BillTimeBuckSplitEnum.TL_BILL_PRAM) {
                this.builder = this.buildBaseInfo(dynamic, entryRow, timeBuckSplitEnum);
                Long id = (Long)entryRow.getPkValue();
                this.builder.rosterDate(targetDate).id(id);
                this.builder.endTime(LocalDateTime.of(shiftSpec.getShiftMiddleRule().getMiddleRefDate() == kd.wtc.wtbs.common.model.shift.RefDateType.NEXTDAY ? targetDate.plusDays(1L) : targetDate, LocalTime.ofSecondOfDay(shiftSpec.getShiftMiddleRule().getMiddlepoint()))).startTime(shiftSpec.getRealEarliestShiftTime(targetDate));
                this.rowSplitResult.add(this.builder.build());
            }
        }
    }

    private void getAllDayBill(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum, LocalDate targetDate) {
        Roster roster = this.shiftTableSingle.getRoster(targetDate);
        if (Objects.nonNull(roster)) {
            ShiftSpec shiftSpec = roster.getShiftSpec();
            if (shiftSpec == null) {
                return;
            }
            if (shiftSpec.getOffNonPlan()) {
                this.builder = this.buildBaseInfo(dynamic, entryRow, timeBuckSplitEnum);
                this.builder.billNonPlanEnum(BillNonPlanEnum.ALL_DAY);
                Long id = (Long)entryRow.getPkValue();
                this.builder.rosterDate(targetDate).id(id).vaBillDyn(dynamic);
                this.rowSplitResult.add(this.builder.build());
                return;
            }
            if (timeBuckSplitEnum == BillTimeBuckSplitEnum.VA_BILL_PRAM) {
                this.splitWithOutRest(dynamic, entryRow, timeBuckSplitEnum, targetDate, shiftSpec.getRealEarliestShiftTime(targetDate), shiftSpec.getRealLastShiftTime(targetDate), (Long)entryRow.getPkValue());
            } else if (timeBuckSplitEnum == BillTimeBuckSplitEnum.TL_BILL_PRAM) {
                this.builder = this.buildBaseInfo(dynamic, entryRow, timeBuckSplitEnum);
                Long id = (Long)entryRow.getPkValue();
                this.builder.rosterDate(targetDate).id(id);
                LocalDateTime startTime = shiftSpec.getRealEarliestShiftTime(targetDate);
                this.builder.startTime(startTime).endTime(shiftSpec.getRealLastShiftTime(targetDate));
                this.rowSplitResult.add(this.builder.build());
            }
        }
    }

    private void splitWithOutRest(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum, LocalDate targetDate, LocalDateTime start, LocalDateTime end, Long id) {
        Roster roster = this.shiftTableSingle.getRoster(targetDate);
        ShiftSpec shiftSpec = roster.getShiftSpec();
        LinkedList<ShiftSession> shiftSessions = new LinkedList<ShiftSession>(shiftSpec.getShiftSessions());
        if (CollectionUtils.isEmpty(shiftSessions)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("shiftSessions is empty,\u5355\u636e\u4e0d\u62c6\u5bf9\uff0c entryRow:{}", (Object)SerializationUtils.toJsonString((Object)entryRow));
            }
            return;
        }
        for (int index = 0; index < shiftSessions.size(); ++index) {
            ShiftSession shiftSession = shiftSessions.get(index);
            LocalDateTime absoluteShiftStartDate = shiftSession.getAbsoluteShiftStartDate(targetDate);
            LocalDateTime absoluteShiftEndDate = shiftSession.getAbsoluteShiftEndDate(targetDate);
            if (shiftSession.getOutWorkType() == OutWorkType.BREAK || !absoluteShiftEndDate.isAfter(start)) continue;
            if (!absoluteShiftStartDate.isBefore(end)) break;
            LocalDateTime startTime = absoluteShiftStartDate.isBefore(start) ? start : absoluteShiftStartDate;
            LocalDateTime endTime = absoluteShiftEndDate.isAfter(end) ? end : absoluteShiftEndDate;
            AttBillTimeBucket.Builder billTimeBucketBuilder = this.buildBaseInfo(dynamic, entryRow, timeBuckSplitEnum);
            billTimeBucketBuilder.rosterDate(targetDate).id(id).startTime(startTime).endTime(endTime);
            this.rowSplitResult.add(billTimeBucketBuilder.build());
        }
    }

    private void doInit(ShiftTable shiftTable, DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum) {
        this.rowSplitResult = new ArrayList<AttBillTimeBucket>(16);
        this.personId = dynamic.getLong(timeBuckSplitEnum.personId);
        Object date = entryRow.get(timeBuckSplitEnum.ownDate);
        if (date != null) {
            this.ascription = WTCDateUtils.toLocalDate((Date)((Date)date));
        }
        this.startDate = WTCDateUtils.toLocalDate((Date)entryRow.getDate(timeBuckSplitEnum.startDate));
        this.endDate = WTCDateUtils.toLocalDate((Date)entryRow.getDate(timeBuckSplitEnum.endDate));
        this.shiftTableSingle = shiftTable.getByAttPersonId(this.personId);
    }

    private void getVaOptionalBill(DynamicObject dynamic, DynamicObject entryRow, DynamicObject subEntryRow, BillTimeBuckSplitEnum timeBuckSplitEnum, LocalDateTime realStartDate, LocalDateTime realEndDate, LocalDate ascription) {
        LocalDate prevAscription = ascription.plusDays(-1L);
        Roster roster = this.shiftTableSingle.getRoster(ascription);
        if (Objects.nonNull(roster)) {
            ShiftSpec shiftSpec = roster.getShiftSpec();
            if (shiftSpec == null) {
                return;
            }
            Long pkValue = (Long)entryRow.getPkValue();
            AttBillTimeBucket.Builder builder = AttBillTimeBucket.with().attPersonId(this.personId).vaBillDyn(dynamic).entryRowDy(entryRow).billId((Long)dynamic.getPkValue()).billTypeBig("VA").id(pkValue).number(dynamic.getString("billno")).rosterDate(ascription).billType(entryRow.getLong(timeBuckSplitEnum.billType)).type(BillTimeBucketType.BILL_ONE_SHIFT);
            if (shiftSpec.getOffNonPlan()) {
                LocalDateTime realLastShiftTime;
                ShiftSpec prevShiftSpec;
                LocalDateTime realEarliestShiftTime = ascription.atStartOfDay();
                Roster prevRoster = this.shiftTableSingle.getRoster(prevAscription);
                if (prevRoster != null && (prevShiftSpec = prevRoster.getShiftSpec()) != null && !prevShiftSpec.getOffNonPlan() && RefDateType.NEXTDAY == prevShiftSpec.getLastRefDateType()) {
                    realEarliestShiftTime = ascription.atTime(prevShiftSpec.getLastShiftTime());
                }
                if (TimeBucketUtil.hasIntersection(realStartDate, realEndDate, realEarliestShiftTime, realLastShiftTime = ascription.plusDays(1L).atStartOfDay())) {
                    LocalDateTime realStart = realStartDate;
                    LocalDateTime realEnd = realEndDate;
                    if (realStartDate.isBefore(realEarliestShiftTime)) {
                        realStart = realEarliestShiftTime;
                    }
                    if (realEndDate.isAfter(realLastShiftTime)) {
                        realEnd = realLastShiftTime;
                    }
                    this.rowSplitResult.add(builder.endTime(realEnd).startTime(realStart).build());
                }
            } else {
                this.splitWithOutRest(dynamic, entryRow, timeBuckSplitEnum, ascription, realStartDate, realEndDate, pkValue);
            }
        }
    }

    private void getVaLactationBill(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum) {
        DynamicObjectCollection dynamicObjectCollection = entryRow.getDynamicObjectCollection("vadetailentry");
        long specialVaMethodId = entryRow.getLong("specialvamethod.id");
        if (specialVaMethodId == BaseSetTimeBreastDayTypeEnum.COME_LATE.id || specialVaMethodId == BaseSetTimeBreastDayTypeEnum.GO_EARLY.id) {
            LocalDate storageToLocalDate = WTCDateUtils.toLocalDate((Date)entryRow.getDate("storageto"));
            this.generateSubEntry(dynamic, entryRow, dynamicObjectCollection, storageToLocalDate);
        } else if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            for (DynamicObject subEntryRow : dynamicObjectCollection) {
                LocalDateTime realStartDate = WTCDateUtils.toLocalDateTime((Date)subEntryRow.getDate("vaentrystarttime"));
                LocalDateTime realEndDate = WTCDateUtils.toLocalDateTime((Date)subEntryRow.getDate("vaentryendtime"));
                LocalDate start = realStartDate.toLocalDate().plusDays(-1L);
                LocalDate end = realEndDate.toLocalDate().plusDays(1L);
                while (start.compareTo(end) <= 0) {
                    this.getVaOptionalBill(dynamic, entryRow, subEntryRow, timeBuckSplitEnum, realStartDate, realEndDate, start);
                    start = start.plusDays(1L);
                }
            }
        }
    }

    private void generateSubEntry(DynamicObject dynamic, DynamicObject entryRow, DynamicObjectCollection subEntryRows, LocalDate storageTo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u91cd\u65b0\u62c6\u5f00\u59cb\uff0centryRow.pkvalue:{}, storageTo:{}, GENERATE_WAY:{}", new Object[]{entryRow.getPkValue(), storageTo, this.GENERATE_WAY});
        }
        long specialVaMethodId = entryRow.getLong("specialvamethod.id");
        String specialExtJson = entryRow.getString("specialextjson");
        Date entryStartDate = entryRow.getDate("entrystartdate");
        Date entryEndDate = entryRow.getDate("entryenddate");
        VaLactationTimeStorage timeStorage = (VaLactationTimeStorage)JSON.parseObject((String)specialExtJson, VaLactationTimeStorage.class);
        BigDecimal offTimePerDay = timeStorage.getOffTimePerDay();
        long offTimeSecondPerDay = offTimePerDay.multiply(BigDecimal.valueOf(3600L)).longValue();
        LocalDate generateBeginDate = WTCStringUtils.equals((String)this.GENERATE_WAY, (String)"0") ? WTCDateUtils.toLocalDate((Date)WTCDateUtils.addDays((Date)entryEndDate, (int)1)) : (WTCStringUtils.equals((String)this.GENERATE_WAY, (String)"2") || storageTo == null ? WTCDateUtils.toLocalDate((Date)entryStartDate) : (storageTo.isAfter(WTCDateUtils.toLocalDate((Date)entryStartDate)) ? storageTo.plusDays(1L) : WTCDateUtils.toLocalDate((Date)entryStartDate)));
        for (DynamicObject subEntryRow : subEntryRows) {
            LocalDate rosterDate = WTCDateUtils.toLocalDate((Date)subEntryRow.getDate("vaentrydate"));
            if (!generateBeginDate.isAfter(rosterDate)) continue;
            LocalDateTime realStartDate = WTCDateUtils.toLocalDateTime((Date)subEntryRow.getDate("vaentrystarttime"));
            LocalDateTime realEndDate = WTCDateUtils.toLocalDateTime((Date)subEntryRow.getDate("vaentryendtime"));
            LocalDate start = realStartDate.toLocalDate().plusDays(-1L);
            LocalDate end = realEndDate.toLocalDate().plusDays(1L);
            while (start.compareTo(end) <= 0) {
                this.getVaOptionalBill(dynamic, entryRow, subEntryRow, BillTimeBuckSplitEnum.VA_BILL_PRAM, realStartDate, realEndDate, start);
                start = start.plusDays(1L);
            }
        }
        LocalDate rosterDate = generateBeginDate;
        while (!rosterDate.isAfter(WTCDateUtils.toLocalDate((Date)entryEndDate))) {
            ShiftSpec shiftSpec = this.shiftTableSingle.getShiftSpec(rosterDate);
            if (shiftSpec != null) {
                if (shiftSpec.getOffNonPlan()) {
                    AttBillTimeBucket.Builder builder = this.buildBaseInfo(dynamic, entryRow, BillTimeBuckSplitEnum.VA_BILL_PRAM);
                    Long id = (Long)entryRow.getPkValue();
                    builder.rosterDate(rosterDate).id(id);
                    builder.billNonPlanEnum(BillNonPlanEnum.SELF_DURATION);
                    builder.duration(offTimeSecondPerDay);
                    this.rowSplitResult.add(builder.build());
                } else {
                    LocalDateTime earliestShiftTime = shiftSpec.getRealEarliestShiftTime(rosterDate);
                    LocalDateTime lastShiftTime = shiftSpec.getRealLastShiftTime(rosterDate);
                    LocalDateTime startDateTime = earliestShiftTime;
                    LocalDateTime endDateTime = lastShiftTime;
                    if (specialVaMethodId == BaseSetTimeBreastDayTypeEnum.GO_EARLY.id) {
                        startDateTime = lastShiftTime.plusSeconds(-offTimeSecondPerDay);
                        if (earliestShiftTime.isAfter(startDateTime)) {
                            startDateTime = earliestShiftTime;
                        }
                    } else {
                        endDateTime = startDateTime.plusSeconds(offTimeSecondPerDay);
                        if (endDateTime.isAfter(lastShiftTime)) {
                            endDateTime = lastShiftTime;
                        }
                    }
                    this.getVaOptionalBill(dynamic, entryRow, null, BillTimeBuckSplitEnum.VA_BILL_PRAM, startDateTime, endDateTime, rosterDate);
                }
            }
            rosterDate = rosterDate.plusDays(1L);
        }
    }

    private void getTlOptionalBill(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum) {
        LocalDateTime realStartDate = WTCDateUtils.toLocalDateTime((Date)entryRow.getDate(timeBuckSplitEnum.startDate));
        LocalDateTime realEndDate = WTCDateUtils.toLocalDateTime((Date)entryRow.getDate(timeBuckSplitEnum.endDate));
        this.rowSplitResult.add(AttBillTimeBucket.with().attPersonId(this.personId).billId((Long)dynamic.getPkValue()).billTypeBig("BT").endTime(realEndDate).id((Long)entryRow.getPkValue()).number(dynamic.getString("billno")).rosterDate(this.ascription).startTime(realStartDate).billType(entryRow.getLong(timeBuckSplitEnum.billType)).type(BillTimeBucketType.BILL_ONE_SHIFT).entryRowDy(entryRow).build());
    }

    private AttBillTimeBucket.Builder buildBaseInfo(DynamicObject dynamic, DynamicObject entryRow, BillTimeBuckSplitEnum timeBuckSplitEnum) {
        return AttBillTimeBucket.with().attPersonId(dynamic.getLong(timeBuckSplitEnum.personId)).billId((Long)dynamic.getPkValue()).billTypeBig(BillTimeBuckSplitEnum.TL_BILL_PRAM == timeBuckSplitEnum ? "BT" : "VA").id((Long)entryRow.getPkValue()).number(dynamic.getString("billno")).billType(entryRow.getLong(timeBuckSplitEnum.billType)).type(BillTimeBucketType.BILL_ONE_SHIFT).entryRowDy(entryRow).vaBillDyn(dynamic);
    }
}

