/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.impl;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.datarange.OnResolveDateRangeEvent;
import kd.sdk.wtc.wtbs.common.access.ConditionDtoExt;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionCommonService;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.access.ConditionDtoExtBridge;
import kd.wtc.wtes.business.service.IDateRangeService;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.BillTieRetrievalUtil;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class DateRangeServiceImpl
implements IDateRangeService {
    private static final Log logger = LogFactory.getLog(DateRangeServiceImpl.class);
    private static final Map<String, Function<ITimeBucket, Object>> FUNCTION_MAPPING;
    private static final HRBaseServiceHelper serviceHelper;
    private static final HRBaseServiceHelper service;
    private static final Set<String> WITH_TIME_RESERVED_ACCESSDTO;

    static void putMap(kd.wtc.wtes.business.model.access.ConditionDto dto, String bucketProp, Map<String, Boolean> map) {
        String name = dto.getName();
        String operators = dto.getOperators();
        String value = dto.getValue();
        switch (operators) {
            case "==": {
                map.put(name, HRStringUtils.equals((String)value, (String)bucketProp));
                break;
            }
            case "!=": {
                map.put(name, !HRStringUtils.equals((String)value, (String)bucketProp));
                break;
            }
            case "in": {
                List<String> list = DateRangeServiceImpl.transformer2List(value);
                map.put(name, list.contains(bucketProp));
                break;
            }
            case "not_in": {
                List<String> list = DateRangeServiceImpl.transformer2List(value);
                map.put(name, !list.contains(bucketProp));
                break;
            }
            case "is_null": {
                map.put(name, HRStringUtils.isEmpty((String)bucketProp));
                break;
            }
            case "is_not_null": {
                map.put(name, HRStringUtils.isNotEmpty((String)bucketProp));
            }
        }
    }

    private static List<String> transformer2List(String value) {
        String[] split = value.split(",");
        return Arrays.stream(split).collect(Collectors.toList());
    }

    public static boolean getResult(String str, Map<String, Boolean> params) {
        str = str.replaceAll(" +", "").replaceAll("and", "&").replace("or", "|");
        Set<Map.Entry<String, Boolean>> entrySet = params.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            str = str.replace(entry.getKey(), entry.getValue() != false ? "1" : "0");
        }
        int pro = DateRangeServiceImpl.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    public static boolean get(String str) {
        int pro = DateRangeServiceImpl.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    private static int pro(char[] arr, int beginIdx) {
        int idx;
        int culResult = 0x8000000;
        int preSign = 38;
        int len = arr.length;
        for (idx = beginIdx; idx < len; ++idx) {
            int character = arr[idx];
            if (character == 41) {
                return idx | culResult;
            }
            if (character == 40) {
                int pro = DateRangeServiceImpl.pro(arr, idx + 1);
                int subAns = pro & 0x8000000;
                int newIdx = pro & 0xF7FFFFFF;
                character = subAns == 0 ? 48 : 49;
                idx = newIdx;
            }
            if (character == 124) {
                preSign = character;
                if (culResult == 0) continue;
                idx = DateRangeServiceImpl.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (character == 38) {
                preSign = character;
                if (culResult != 0) continue;
                idx = DateRangeServiceImpl.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (character == 49) {
                if (preSign != 124) continue;
                culResult = 0x8000000;
                continue;
            }
            if (character != 48 || preSign != 38) continue;
            culResult = 0;
        }
        return idx | culResult;
    }

    private static int getIdx4CurLevel(char[] arr, int beginIdx) {
        int idx;
        int len = arr.length;
        int count = 0;
        for (idx = beginIdx; idx < len; ++idx) {
            char character = arr[idx];
            if (character == '(') {
                ++count;
                continue;
            }
            if (character != ')') continue;
            if (count == 0) {
                return idx;
            }
            --count;
        }
        return idx;
    }

    @Override
    public List<TimeBucket> filterDataNode(WTCDateRangeSource wtcDateRangeSource, TieContextStd context, TimeBucketStd std, String metaNumber, Long pk) {
        DynamicObject dynamicObject = serviceHelper.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metaNumber), new QFilter("basedataid", "=", (Object)pk)});
        String conditionJson = dynamicObject.getString("conditions");
        AccessDto accessDto = null;
        if (HRStringUtils.isNotEmpty((String)conditionJson)) {
            try {
                accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class);
            }
            catch (Exception e) {
                logger.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return this.filterDataNode(wtcDateRangeSource, context, std, accessDto);
    }

    @Override
    public List<TimeBucket> filterDataNodes(WTCDateRangeSource wtcDateRangeSource, TieContextStd context, List<TimeBucketStd> list, String metaNumber, Long pk) {
        DynamicObject dynamicObject = serviceHelper.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metaNumber), new QFilter("basedataid", "=", (Object)pk)});
        String conditionJson = dynamicObject.getString("conditions");
        AccessDto accessDto = null;
        if (HRStringUtils.isNotEmpty((String)conditionJson)) {
            try {
                accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class);
            }
            catch (Exception e) {
                logger.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return this.filterDataNodes(wtcDateRangeSource, context, list, accessDto);
    }

    @Override
    public List<TimeBucket> filterDataNode(WTCDateRangeSource wtcDateRangeSource, TieContextStd context, TimeBucketStd std, AccessDto accessDto) {
        return this.filterDataNode(wtcDateRangeSource, context, std, accessDto, null);
    }

    @Override
    public List<TimeBucket> filterDataNode(WTCDateRangeSource wtcDateRangeSource, TieContextStd context, TimeBucketStd std, AccessDto accessDto, RuleConditionValues retrievalDimension) {
        if (accessDto == null) {
            String tip = ResManager.loadKDString((String)"\u6838\u7b97\u4e2d\u5339\u914d\u7684\u65e5\u671f\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DateRangeServiceImpl_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
            logger.warn("accessDto can not be null");
            throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{tip});
        }
        ArrayList<TimeBucket> resultList = new ArrayList<TimeBucket>();
        List<kd.wtc.wtes.business.model.access.ConditionDto> conditionList = accessDto.getConditionList();
        String conditionExpressStr = accessDto.getConditionExpressStr();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        boolean continsInternal = false;
        for (kd.wtc.wtes.business.model.access.ConditionDto conditionDto : conditionList) {
            String param = conditionDto.getParam();
            if (!param.contains("datetypepattern")) continue;
            continsInternal = true;
            break;
        }
        boolean flag = false;
        ArrayList<TimeSection> sectionList = new ArrayList<TimeSection>();
        WTCPluginProxy pluginProxy = (WTCPluginProxy)ContextExtUtil.getExtPlugin(context, "kd.sdk.wtc.wtbs.business.datarange.DateRangeRuleExpPlugin");
        for (kd.wtc.wtes.business.model.access.ConditionDto conditionDto : conditionList) {
            String substring;
            String retrievalWay = conditionDto.getRetrievalWay();
            if (HRStringUtils.isNotEmpty((String)retrievalWay) && "1".equals(retrievalWay)) {
                ConditionDto conditionDto2 = BillTieRetrievalUtil.wtesDtoToWtbsDto(conditionDto);
                RuleConditionCommonService.configItemRetrieval((ConditionDto)conditionDto2, map, (RuleConditionValues)retrievalDimension);
                continue;
            }
            String param = conditionDto.getParam();
            String paramType = conditionDto.getParamType();
            if (HRStringUtils.equals((String)paramType, (String)"dynamicObject")) {
                param = param.replace(".id", "");
            }
            if (HRStringUtils.equals((String)(substring = param.substring(param.lastIndexOf(46) + 1)), (String)"datetypepattern")) {
                flag = this.partternDatetype(map, conditionDto, std, flag, sectionList);
                continue;
            }
            Function<ITimeBucket, Object> fo = FUNCTION_MAPPING.get(substring);
            if (fo == null) {
                if (WTCDateRangeSource.OTP.equals((Object)wtcDateRangeSource)) {
                    OnResolveDateRangeEvent onResolveDateRangeEvent = new OnResolveDateRangeEvent(ContextExtUtil.getTieContextExt(context), ContextExtUtil.covertTimeBucketExt(std), (ConditionDtoExt)new ConditionDtoExtBridge(conditionDto), wtcDateRangeSource);
                    pluginProxy.callReplace(locationService -> {
                        locationService.onResolveDateRange(onResolveDateRangeEvent);
                        return null;
                    });
                    if (onResolveDateRangeEvent.getResult() != null) {
                        map.put(conditionDto.getName(), onResolveDateRangeEvent.getResult());
                        continue;
                    }
                }
                logger.debug("wtes.DateRangeServiceImpl not support,{}", (Object)substring);
                TimeBucket timeBucket = std.unwrapAndCopy();
                timeBucket.setParentDataNodes(Collections.singletonList(std));
                resultList.add(timeBucket);
                return resultList;
            }
            Object invoke = fo.apply(std);
            if (invoke instanceof List) {
                List bucketProps = (List)invoke;
                if (CollectionUtils.isEmpty((Collection)bucketProps)) {
                    DateRangeServiceImpl.putMap(conditionDto, "", map);
                    continue;
                }
                for (String bucketProp : bucketProps) {
                    DateRangeServiceImpl.putMap(conditionDto, bucketProp, map);
                }
                continue;
            }
            if (!(invoke instanceof String)) continue;
            String bucketProp = (String)invoke;
            DateRangeServiceImpl.putMap(conditionDto, bucketProp, map);
        }
        boolean conditionResult = DateRangeServiceImpl.getResult(conditionExpressStr, map);
        if (conditionResult) {
            if (continsInternal && flag) {
                for (TimeSection timeSection : sectionList) {
                    LocalDateTime startDate = timeSection.getStartDate();
                    LocalDateTime endDate = timeSection.getEndDate();
                    if (startDate == null || endDate == null) continue;
                    TimeBucket timeBucket = std.unwrapAndCopy();
                    timeBucket.setParentDataNodes(Collections.singletonList(std));
                    timeBucket.setStartTime(startDate);
                    timeBucket.setEndTime(endDate);
                    resultList.add(timeBucket);
                }
            } else {
                TimeBucket timeBucket = std.unwrapAndCopy();
                timeBucket.setParentDataNodes(Collections.singletonList(std));
                resultList.add(timeBucket);
            }
        }
        return resultList;
    }

    private Boolean partternDatetype(Map<String, Boolean> map, kd.wtc.wtes.business.model.access.ConditionDto dto, TimeBucketStd std, boolean flag, List<TimeSection> sectionList) {
        block12: {
            DynamicObject currentWeekDay;
            LocalDate shiftDate;
            LocalDateTime endTime;
            LocalDateTime startTime;
            block13: {
                LocalDateTime enableEnd;
                String datatype;
                DynamicObject dynamicObject;
                block11: {
                    map.put(dto.getName(), Boolean.FALSE);
                    startTime = std.getStartTime();
                    endTime = std.getEndTime();
                    if (startTime == null || endTime == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("DateRangeServiceImpl_partternDatetype  startTime = {},endTime = {}", (Object)startTime, (Object)endTime);
                        }
                        return Boolean.FALSE;
                    }
                    shiftDate = std.getShiftDate();
                    String value = dto.getValue();
                    dynamicObject = service.loadDynamicObject(new QFilter("id", "=", (Object)Long.parseLong(value)));
                    if (dynamicObject == null) {
                        return Boolean.FALSE;
                    }
                    datatype = dynamicObject.getString("datatype");
                    if (!HRStringUtils.equals((String)datatype, (String)"2")) break block11;
                    DynamicObjectCollection fixtimeentity = dynamicObject.getDynamicObjectCollection("fixtimeentity");
                    for (DynamicObject fixtime : fixtimeentity) {
                        TimeSection section;
                        String stagdate = fixtime.getString("stagdate");
                        int begintime = fixtime.getInt("begintime");
                        String etagdate = fixtime.getString("etagdate");
                        int endtime = fixtime.getInt("endtime");
                        LocalDateTime enableStart = shiftDate.atTime(begintime / 3600, begintime % 3600 / 60, begintime % 3600 % 60);
                        LocalDateTime enableEnd2 = shiftDate.atTime(endtime / 3600, endtime % 3600 / 60, endtime % 3600 % 60);
                        if ("C".equals(stagdate)) {
                            enableStart = enableStart.plusDays(1L);
                        } else if ("Q".equals(stagdate)) {
                            enableStart = enableStart.minusDays(1L);
                        }
                        if ("C".equals(etagdate)) {
                            enableEnd2 = enableEnd2.plusDays(1L);
                        } else if ("Q".equals(etagdate)) {
                            enableEnd2 = enableEnd2.minusDays(1L);
                        }
                        if (!Objects.nonNull(section = this.generateSection(new TimeSection(startTime, endTime), new TimeSection(enableStart, enableEnd2)))) continue;
                        sectionList.add(section);
                        flag = true;
                        map.put(dto.getName(), Boolean.TRUE);
                    }
                    break block12;
                }
                if (!HRStringUtils.equals((String)datatype, (String)"3")) break block12;
                DayOfWeek dayOfWeek = shiftDate.getDayOfWeek();
                DynamicObjectCollection weekentry = dynamicObject.getDynamicObjectCollection("weekentry");
                List dayenable = weekentry.stream().filter(object -> object.getBoolean("dayenable") && object.getString("weekday").equals(String.valueOf(dayOfWeek.getValue()))).collect(Collectors.toList());
                if (dayenable.size() <= 0) break block12;
                currentWeekDay = (DynamicObject)dayenable.get(0);
                String timetype = currentWeekDay.getString("timetype");
                if (!"1".equals(timetype)) break block13;
                LocalDateTime enableStart = shiftDate.atTime(0, 0, 0);
                TimeSection section = this.generateSection(new TimeSection(startTime, endTime), new TimeSection(enableStart, enableEnd = shiftDate.atTime(23, 59, 59)));
                if (!Objects.nonNull(section)) break block12;
                sectionList.add(section);
                flag = true;
                map.put(dto.getName(), Boolean.TRUE);
                break block12;
            }
            for (int i = 1; i <= 5; ++i) {
                LocalDateTime enableEnd;
                LocalDateTime enableStart;
                TimeSection section;
                int startSecond = currentWeekDay.getInt("start" + i);
                int endSecond = currentWeekDay.getInt("end" + i);
                if (startSecond <= 0 && endSecond <= 0 || !Objects.nonNull(section = this.generateSection(new TimeSection(startTime, endTime), new TimeSection(enableStart = shiftDate.atTime(startSecond / 3600, startSecond % 3600 / 60, startSecond % 3600 % 60), enableEnd = shiftDate.atTime(endSecond / 3600, endSecond % 3600 / 60, endSecond % 3600 % 60))))) continue;
                sectionList.add(section);
                flag = true;
                map.put(dto.getName(), Boolean.TRUE);
            }
        }
        return flag;
    }

    private TimeSection generateSection(TimeSection sectiona, TimeSection sectionb) {
        LocalDateTime startDate = sectiona.getStartDate();
        LocalDateTime endDate = sectiona.getEndDate();
        if (startDate.isBefore(sectionb.getStartDate())) {
            startDate = sectionb.getStartDate();
        }
        if (endDate.isAfter(sectionb.getEndDate())) {
            endDate = sectionb.getEndDate();
        }
        if (startDate.isBefore(endDate)) {
            return new TimeSection(startDate, endDate);
        }
        return null;
    }

    @Override
    public List<TimeBucket> filterDataNodes(WTCDateRangeSource wtcDateRangeSource, TieContextStd context, List<TimeBucketStd> stds, AccessDto accessDto) {
        ArrayList<TimeBucket> timeBuckets = new ArrayList<TimeBucket>();
        for (TimeBucketStd timeBucketStd : stds) {
            List<TimeBucket> oneList = this.filterDataNode(wtcDateRangeSource, context, timeBucketStd, accessDto);
            timeBuckets.addAll(oneList);
        }
        return timeBuckets;
    }

    @Override
    public boolean filterDataNodesWithoutTimeArr(WTCDateRangeSource wtcDateRangeSource, TieContextStd context, AccessDto accessDto, ShiftTableSingle shiftTableSingle, LocalDate chainLocalDate) {
        if (accessDto == null) {
            return true;
        }
        if (!this.withoutTimeArr(accessDto)) {
            logger.debug("DateRangeServiceImpl_filterDataNodesWithoutTimeArr withoutTimeArr");
            return false;
        }
        if (shiftTableSingle == null || chainLocalDate == null) {
            return false;
        }
        Roster roster = shiftTableSingle.getRoster(chainLocalDate);
        TimeBucket timeBucket = (TimeBucket)((CleanableBuilder)((TimeBucket.Builder)((TimeBucket.Builder)TimeBucket.builder().roster(roster)).dateType(roster.getDateType())).dateAttribute(roster.getDateAttribute())).build();
        List<kd.wtc.wtes.business.model.access.ConditionDto> conditionList = accessDto.getConditionList();
        String conditionExpressStr = accessDto.getConditionExpressStr();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        WTCPluginProxy pluginProxy = (WTCPluginProxy)ContextExtUtil.getExtPlugin(context, "kd.sdk.wtc.wtbs.business.datarange.DateRangeRuleExpPlugin");
        for (kd.wtc.wtes.business.model.access.ConditionDto dto : conditionList) {
            String name = this.getDateMatchKey(dto);
            Function<ITimeBucket, Object> fo = FUNCTION_MAPPING.get(name);
            if (fo == null) {
                if (WTCDateRangeSource.OTP.equals((Object)wtcDateRangeSource)) {
                    OnResolveDateRangeEvent onResolveDateRangeEvent = new OnResolveDateRangeEvent(ContextExtUtil.getTieContextExt(context), null, (ConditionDtoExt)new ConditionDtoExtBridge(dto), wtcDateRangeSource);
                    pluginProxy.callReplace(locationService -> {
                        locationService.onResolveDateRange(onResolveDateRangeEvent);
                        return null;
                    });
                    if (onResolveDateRangeEvent.getResult() != null) {
                        map.put(dto.getName(), onResolveDateRangeEvent.getResult());
                        continue;
                    }
                }
                logger.debug("DateRangeServiceImpl_DateRangeServiceImpl not support,{}", (Object)name);
                return false;
            }
            Object invoke = fo.apply(timeBucket);
            if (invoke instanceof List) {
                List bucketProps = (List)invoke;
                if (CollectionUtils.isEmpty((Collection)bucketProps)) {
                    DateRangeServiceImpl.putMap(dto, "", map);
                    continue;
                }
                for (String bucketProp : bucketProps) {
                    DateRangeServiceImpl.putMap(dto, bucketProp, map);
                }
                continue;
            }
            if (!(invoke instanceof String)) continue;
            String bucketProp = (String)invoke;
            DateRangeServiceImpl.putMap(dto, bucketProp, map);
        }
        boolean matchResult = DateRangeServiceImpl.getResult(conditionExpressStr, map);
        if (logger.isDebugEnabled()) {
            logger.debug("DateRangeServiceImpl_filterDataNodesWithoutTimeArr matchResult = {},condtion={}", (Object)matchResult, (Object)accessDto.toString());
        }
        return matchResult;
    }

    private boolean withoutTimeArr(AccessDto accessDto) {
        if (accessDto == null) {
            return true;
        }
        List<kd.wtc.wtes.business.model.access.ConditionDto> conditionList = accessDto.getConditionList();
        if (CollectionUtils.isEmpty(conditionList)) {
            return true;
        }
        for (kd.wtc.wtes.business.model.access.ConditionDto conditionDto : conditionList) {
            String name = this.getDateMatchKey(conditionDto);
            if (WITH_TIME_RESERVED_ACCESSDTO.contains(name)) continue;
            logger.debug("DateRangeServiceImpl_withoutTimeArr not contains :{}", (Object)name);
            return false;
        }
        return true;
    }

    private String getDateMatchKey(kd.wtc.wtes.business.model.access.ConditionDto dto) {
        String param = dto.getParam();
        String paramType = dto.getParamType();
        if (HRStringUtils.equals((String)paramType, (String)"dynamicObject")) {
            param = param.replace(".id", "");
        }
        return param.substring(param.lastIndexOf(46) + 1);
    }

    static {
        serviceHelper = new HRBaseServiceHelper("wtbd_daterange");
        service = new HRBaseServiceHelper("wtbd_datetypeper");
        WITH_TIME_RESERVED_ACCESSDTO = Sets.newHashSet((Object[])new String[]{"dateattribute", "datetype", "shiftspec", "off"});
        FUNCTION_MAPPING = new HashMap<String, Function<ITimeBucket, Object>>();
        FUNCTION_MAPPING.put("dateattribute", tb -> Objects.isNull(tb.getDateAttribute()) ? "" : tb.getDateAttribute().code);
        FUNCTION_MAPPING.put("datetype", tb -> Objects.isNull(tb.getDateType()) ? "" : String.valueOf(tb.getDateType().getId()));
        FUNCTION_MAPPING.put("shifttimebucketproperty", tb -> Objects.isNull((Object)tb.getShiftTimeBucketProperty()) ? "" : tb.getShiftTimeBucketProperty().code);
        FUNCTION_MAPPING.put("timebucketposition", tb -> tb.getTimeBucketPosition().code);
        FUNCTION_MAPPING.put("off", tb -> Objects.isNull((Object)tb.getShiftSpec()) ? "" : String.valueOf(tb.getShiftSpec().isOff()));
        FUNCTION_MAPPING.put("shiftspec", tb -> Objects.isNull((Object)tb.getShiftSpec()) ? "" : String.valueOf(tb.getShiftSpec().getBid()));
    }

    private static class TimeSection {
        private LocalDateTime startDate;
        private LocalDateTime endDate;

        public TimeSection(LocalDateTime startDate, LocalDateTime endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public LocalDateTime getStartDate() {
            return this.startDate;
        }

        public void setStartDate(LocalDateTime startDate) {
            this.startDate = startDate;
        }

        public LocalDateTime getEndDate() {
            return this.endDate;
        }

        public void setEndDate(LocalDateTime endDate) {
            this.endDate = endDate;
        }
    }
}

