/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtbs.wtte.common.enums.ExConfirmOperateTypeEnum;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.DataPackageInfo;
import kd.wtc.wtes.business.model.ExAttPackage;
import kd.wtc.wtes.business.model.ExConfirmInfo;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.exrecord.ExRecordDTO;
import kd.wtc.wtes.business.model.rlex.ExConfig;
import kd.wtc.wtes.business.model.rlex.ExConfigEntry;
import kd.wtc.wtes.business.model.rlex.ExRuleEntry;
import kd.wtc.wtes.business.model.rlex.ExRulePackage;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.std.datanode.AttItemValueStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.storage.StorageUtil;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.enums.AccountStepEnum;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.LabelSet;

public class ExRecordServiceImpl
implements IDataPackageStoreService {
    private static final String WTTE_EXURGINGRECORD = "wtte_exurgingrecord";
    private static final String WTTE_EXRECORDCONFIRM = "wtte_exrecordconfirm";
    private static final String WTTE_EXRECORD = "wtte_exrecord";
    private static final String WTTE_EXRECORDHIS = "wtte_exrecordhis";
    private static final String ORG = "org";
    private static final String PERSON_ID = "personid";
    private static final String COMPANY = "company";
    private static final String COMPANY_VID = "companyvid";
    private static final String ADMINORG = "adminorg";
    private static final String ADMINORG_VID = "adminorgvid";
    private static final String POSITION = "position";
    private static final String POSITION_VID = "positionvid";
    private static final String JOB = "job";
    private static final String JOB_VID = "jobvid";
    private static final String SHIFT_ID = "shiftid";
    private static final String SHIFT_VID = "shiftvid";
    private static final String EXATTRIBUTE_ID = "exattributeid";
    private static final String ATT_ITEM_ID = "attitemid";
    private static final String ATT_ITEM_VID = "attitemvid";
    private static final String ATT_ITEM_VALUE = "attitemvalue";
    private static final String CAL_VERSION = "calversion";
    private static final String RECORD_DATE = "recorddate";
    private static final String CONFIRM_STATUS = "confirmstatus";
    private static final String CONFIRM_PEOPLE = "confirmpeople";
    private static final String CONFIRM_TIME = "confirmtime";
    private static final String UNCONFIRMED = "0";
    private static final String CONFIRMED = "1";
    private static final String EX_PROCESS = "exprocessid";
    private static final String AFFILIATE_ADMINORG = "affiliateadminorg";
    private static final String AFFILIATE_ADMINORGVID = "affiliateadminorgvid";
    private static final String EMP_GROUP = "empgroup";
    private static final String PUNCH_CARDPAIR = "punchcardpair";
    private static final String ORIGIN_ITEMVID = "originitemvid";
    private static final String ORIGIN_ITEMID = "originitemid";
    private static final String ATTITEM_ORVALUE = "attitemorvalue";
    private static final String TB_POSITION = "tbposition";
    private static final String TIME_UNIT = "timeunit";
    private static final String PUNCH_POINT = "punchcardpoint";
    private static final String EXURGING_RECORD = "exurgingrecord";
    private static final String CMPEMP = "cmpemp";
    private static final String CMPEMP_VID = "cmpempvid";
    private static final String MANAGINGSCOPE = "managingscope";
    private static final String DEPENDENCY = "dependency";
    private static final String DEPENDENCY_TYPE = "dependencytype";
    private static final String AGREED_LOCATION = "agreedlocation";
    private static final String WORK_PLACE = "workplace";
    private static final String ATTFILEID = "attfileid";
    private static final String ATTFILEVID = "attfilevid";
    private static final String SHIFTDATE = "shiftdate";
    private static final String FILTERTYPE = "filtertype";
    private static final String EX_RECORD_CONFIRM_ID = "exrecordconfirmid";
    private static final String APP_ID = AppMetadataCache.getAppInfo((String)"wtte").getId();
    private static final HRBaseServiceHelper SERVICE_HELPER = WtesHRBaseTimeWatchUtil.create(ExRecordServiceImpl.class.getName() + "." + "wtte_exrecord", "wtte_exrecord");
    private static final HRBaseServiceHelper HIS_SERVICE_HELPER = WtesHRBaseTimeWatchUtil.create(ExRecordServiceImpl.class.getName() + "." + "wtte_exrecordhis", "wtte_exrecordhis");
    private static final Log log = LogFactory.getLog(ExRecordServiceImpl.class);
    private static final HRBaseServiceHelper CONFIRM_HELPER = WtesHRBaseTimeWatchUtil.create(ExRecordServiceImpl.class.getName() + "." + "wtte_exrecordconfirm", "wtte_exrecordconfirm");
    private static final HRBaseServiceHelper URGINGCOUNT_HELPER = WtesHRBaseTimeWatchUtil.create(ExRecordServiceImpl.class.getName() + "." + "wtte_exurgingrecord", "wtte_exurgingrecord");

    public void batchSaveExRecords(List<ExRecordDTO> list, Map<String, List<ExConfirmInfo>> exConfirmInfoMap) {
        DynamicObjectCollection exRecord = new DynamicObjectCollection();
        DynamicObjectCollection exRecordHis = new DynamicObjectCollection();
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)list.size());
        Date startDate = null;
        Date endDate = null;
        HashMap map = Maps.newHashMapWithExpectedSize((int)list.size());
        HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)1);
        ignoreKeys.add(EXURGING_RECORD);
        int index = 0;
        long[] ids = ID.genLongIds((int)list.size());
        for (ExRecordDTO vo : list) {
            personIdSet.add(vo.getPersonId());
            if (startDate == null || vo.getRecordDate() != null && startDate.compareTo(vo.getRecordDate()) >= 0) {
                startDate = vo.getRecordDate();
            }
            if (endDate == null || vo.getRecordDate() != null && endDate.compareTo(vo.getRecordDate()) <= 0) {
                endDate = vo.getRecordDate();
            }
            DynamicObject dynamicObject = SERVICE_HELPER.generateEmptyDynamicObject();
            dynamicObject.set(ORG, (Object)vo.getExOrgId());
            dynamicObject.set(PERSON_ID, (Object)vo.getPersonId());
            dynamicObject.set(COMPANY_VID, (Object)vo.getCompanyVid());
            dynamicObject.set(ADMINORG_VID, (Object)vo.getDepartmentVid());
            dynamicObject.set(POSITION_VID, (Object)vo.getPositionVid());
            dynamicObject.set(JOB_VID, (Object)vo.getJobVid());
            dynamicObject.set(SHIFT_ID, (Object)vo.getShiftId());
            dynamicObject.set(SHIFT_VID, (Object)vo.getShiftVid());
            dynamicObject.set(EXATTRIBUTE_ID, (Object)vo.getExattributeId());
            dynamicObject.set(ATT_ITEM_ID, (Object)vo.getAttItemId());
            dynamicObject.set(ATT_ITEM_VID, (Object)vo.getAttItemVid());
            dynamicObject.set(ATT_ITEM_VALUE, (Object)vo.getAttItemValue());
            dynamicObject.set(CAL_VERSION, (Object)vo.getCalVersion());
            dynamicObject.set(RECORD_DATE, (Object)vo.getRecordDate());
            dynamicObject.set(CONFIRM_STATUS, (Object)UNCONFIRMED);
            dynamicObject.set(EX_PROCESS, (Object)vo.getExProcess());
            dynamicObject.set(AFFILIATE_ADMINORGVID, (Object)vo.getAffiliateAdminorgVid());
            dynamicObject.set(PUNCH_CARDPAIR, (Object)vo.getPunchCardPair());
            dynamicObject.set(TB_POSITION, (Object)vo.getTbPosition());
            dynamicObject.set(ORIGIN_ITEMID, vo.getOriginItemId() != null ? this.setMultiBaseData(dynamicObject, vo.getOriginItemId(), ORIGIN_ITEMID) : null);
            dynamicObject.set(ORIGIN_ITEMVID, vo.getOriginItemVid() != null ? this.setMultiBaseData(dynamicObject, vo.getOriginItemVid(), ORIGIN_ITEMVID) : null);
            dynamicObject.set(ATTITEM_ORVALUE, (Object)vo.getAttItemOrValue());
            dynamicObject.set(TIME_UNIT, (Object)vo.getTimeUnit());
            dynamicObject.set(PUNCH_POINT, (Object)vo.getPunchCardPoint());
            dynamicObject.set(ATTFILEID, (Object)vo.getAttFileId());
            dynamicObject.set(ATTFILEVID, (Object)vo.getAttFileVid());
            dynamicObject.set(SHIFTDATE, (Object)vo.getShiftDate());
            dynamicObject.set(FILTERTYPE, (Object)vo.getExFilterType());
            this.setConfirmInfo(dynamicObject, exConfirmInfoMap);
            DynamicObject history = HIS_SERVICE_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)history, (Set)ignoreKeys);
            String key = this.getKey(vo);
            long id = ids[index];
            map.put(key, id);
            dynamicObject.set("id", (Object)id);
            exRecord.add((Object)dynamicObject);
            exRecordHis.add((Object)history);
            ++index;
        }
        this.updateUrgingCount(personIdSet, startDate, endDate, exRecord, map);
        SERVICE_HELPER.save(exRecord);
        if (this.checkSaveHis().booleanValue()) {
            HIS_SERVICE_HELPER.save(exRecordHis);
        }
    }

    private String getKey(ExRecordDTO vo) {
        String exRecordDateStr = DateUtils.formatDate((Date)vo.getRecordDate(), (Object[])new Object[]{"yyyy-MM-dd"});
        return String.valueOf(vo.getAttFileVid()) + vo.getAttItemId() + vo.getPunchCardPair() + vo.getPunchCardPoint() + exRecordDateStr;
    }

    private void updateUrgingCount(Set<Long> personIdSet, Date startDate, Date endDate, DynamicObjectCollection exRecord, Map<String, Long> keyToRecordMap) {
        String key;
        String exRecordDateStr;
        QFilter personQf = new QFilter(PERSON_ID, "in", personIdSet);
        QFilter startDateQf = new QFilter(RECORD_DATE, ">=", (Object)startDate);
        QFilter endDateQf = new QFilter(RECORD_DATE, "<=", (Object)endDate);
        String select = "id,personid.id,attfilevid.id,recorddate,attitemid.id,attitemvalue,punchcardpair.id,punchcardpoint";
        DynamicObject[] urgingRecords = URGINGCOUNT_HELPER.query(select, new QFilter[]{personQf, startDateQf, endDateQf});
        HashMap refMap = Maps.newHashMapWithExpectedSize((int)exRecord.size());
        HashSet exitKeySet = Sets.newHashSetWithExpectedSize((int)exRecord.size());
        if (urgingRecords != null && urgingRecords.length > 0) {
            for (DynamicObject urgingDy : urgingRecords) {
                exRecordDateStr = DateUtils.formatDate((Date)urgingDy.getDate(RECORD_DATE), (Object[])new Object[]{"yyyy-MM-dd"});
                key = urgingDy.getString("attfilevid.id") + urgingDy.getString("attitemid.id") + urgingDy.getString("punchcardpair.id") + urgingDy.getString(PUNCH_POINT) + exRecordDateStr;
                Long exRecordId = keyToRecordMap.get(key);
                if (exRecordId == null) continue;
                exitKeySet.add(key);
                refMap.put(exRecordId, urgingDy.getLong("id"));
            }
        }
        ArrayList insertUrgingList = Lists.newArrayListWithExpectedSize((int)exRecord.size());
        long[] ids = ID.genLongIds((int)exRecord.size());
        for (int index = 0; index < exRecord.size(); ++index) {
            DynamicObject exRecordDy = (DynamicObject)exRecord.get(index);
            exRecordDateStr = DateUtils.formatDate((Date)exRecordDy.getDate(RECORD_DATE), (Object[])new Object[]{"yyyy-MM-dd"});
            key = exRecordDy.getString(ATTFILEVID) + exRecordDy.getString(ATT_ITEM_ID) + exRecordDy.getString(PUNCH_CARDPAIR) + exRecordDy.getString(PUNCH_POINT) + exRecordDateStr;
            if (!exitKeySet.contains(key)) {
                long id = ids[index];
                DynamicObject urgingDy = URGINGCOUNT_HELPER.generateEmptyDynamicObject();
                urgingDy.set("id", (Object)id);
                urgingDy.set(PERSON_ID, exRecordDy.get(PERSON_ID));
                urgingDy.set(ATTFILEVID, exRecordDy.get(ATTFILEVID));
                urgingDy.set(RECORD_DATE, exRecordDy.get(RECORD_DATE));
                urgingDy.set(ATT_ITEM_ID, exRecordDy.get(ATT_ITEM_ID));
                urgingDy.set(ATT_ITEM_VALUE, exRecordDy.get(ATT_ITEM_VALUE));
                urgingDy.set(PUNCH_CARDPAIR, exRecordDy.get(PUNCH_CARDPAIR));
                urgingDy.set(PUNCH_POINT, exRecordDy.get(PUNCH_POINT));
                urgingDy.set("urgingcount", (Object)0);
                insertUrgingList.add(urgingDy);
                exRecordDy.set(EXURGING_RECORD, (Object)id);
                continue;
            }
            exRecordDy.set(EXURGING_RECORD, refMap.get(exRecordDy.getLong("id")));
        }
        URGINGCOUNT_HELPER.save(insertUrgingList.toArray(new DynamicObject[0]));
    }

    private void setConfirmInfo(DynamicObject dynamicObject, Map<String, List<ExConfirmInfo>> strToDyn) {
        String selectedKeys = dynamicObject.getString(PERSON_ID) + Timestamp.valueOf(WTCDateUtils.toLocalDateTime((Date)dynamicObject.getDate(RECORD_DATE))) + dynamicObject.get(PUNCH_CARDPAIR) + dynamicObject.get(ATT_ITEM_ID);
        List<ExConfirmInfo> dynList = strToDyn.get(selectedKeys);
        if (CollectionUtils.isNotEmpty(dynList)) {
            for (ExConfirmInfo dyn : dynList) {
                if (dyn.getAttItemValue().compareTo(dynamicObject.getBigDecimal(ATT_ITEM_VALUE)) != 0) continue;
                dynamicObject.set(EX_RECORD_CONFIRM_ID, (Object)dyn.getId());
                if (HRStringUtils.equals((String)ExConfirmOperateTypeEnum.CONFIRM.getCode(), (String)dyn.getExConfirmOperateTypeEnum().getCode())) {
                    dynamicObject.set(CONFIRM_STATUS, (Object)CONFIRMED);
                    continue;
                }
                dynamicObject.set(CONFIRM_STATUS, (Object)UNCONFIRMED);
            }
        }
    }

    private DynamicObjectCollection setMultiBaseData(DynamicObject dynamicObject, List<Long> basedataIds, String number) {
        DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection(number);
        DynamicObjectType type = coll.getDynamicObjectType();
        for (int i = 0; i < basedataIds.size(); ++i) {
            DynamicObject dyn = new DynamicObject(type);
            dyn.set("fbasedataid", (Object)basedataIds.get(i));
            coll.add((Object)dyn);
        }
        return coll;
    }

    @Override
    public void storeBatch(List<RecordAndPackageWrapper> recordAndPackageWrapperList) {
        if (recordAndPackageWrapperList.isEmpty()) {
            return;
        }
        ArrayList exRecord = Lists.newArrayList();
        HashMap exConfirmInfoMap = Maps.newHashMap();
        for (RecordAndPackageWrapper recordAndPackageWrapper : recordAndPackageWrapperList) {
            Map exConfirmInfo;
            Object exChange;
            ArrayList exRecordTemp = Lists.newArrayList();
            ArrayList dataNodes = Lists.newArrayList();
            Object exCal = recordAndPackageWrapper.getExtendDataInfo().getExtendParams().get(AccountStepEnum.EX_1020_S.getCode());
            if (null != exCal) {
                dataNodes.addAll((List)exCal);
            }
            if (null != (exChange = recordAndPackageWrapper.getExtendDataInfo().getExtendParams().get(AccountStepEnum.EX_1030_S.getCode()))) {
                dataNodes.addAll((List)exChange);
            }
            if (WTCCollections.isNotEmpty((Map)(exConfirmInfo = (Map)recordAndPackageWrapper.getPackageInfo().getInitParams().get("EX_CONFIG_STATUS")))) {
                exConfirmInfoMap.putAll(exConfirmInfo);
            }
            if (CollectionUtils.isNotEmpty((Collection)dataNodes)) {
                this.packageData(dataNodes, exRecordTemp, recordAndPackageWrapper);
            }
            exRecord.addAll(this.mergeAttItem(exRecordTemp, recordAndPackageWrapper));
        }
        log.debug("ExRecordServiceImpl storeBatch startTime:{}", (Object)System.currentTimeMillis());
        this.batchSaveExRecords(exRecord, exConfirmInfoMap);
        log.debug("ExRecordServiceImpl storeBatch endTime:{}", (Object)System.currentTimeMillis());
    }

    private Set<Long> coverItem(List<TieDataNodeStd> dataNodeStdList) {
        HashSet coverItems = Sets.newHashSet();
        for (TieDataNodeStd nodeStd : dataNodeStdList) {
            for (TieDataNodeStd parentDataNode : nodeStd.parentDataNodes()) {
                for (AttItemInstance parentItemInstance : parentDataNode.getAttItemInstances()) {
                    coverItems.addAll(nodeStd.getAttItemInstances().stream().filter(childItem -> childItem.getSpecId() == parentItemInstance.getSpecId()).collect(Collectors.toSet()));
                }
            }
        }
        return coverItems.stream().map(item -> item.getAttItemSpec().getBid()).collect(Collectors.toSet());
    }

    public List<ExRecordDTO> mergeAttItem(List<ExRecordDTO> exRecord, RecordAndPackageWrapper recordAndPackageWrapper) {
        HashSet coverItems = Sets.newHashSet();
        Map<String, Object> extendParams = recordAndPackageWrapper.getExtendDataInfo().getExtendParams();
        ArrayList<AttItemInstance> otherAttItemInstances = new ArrayList<AttItemInstance>();
        for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
            if (AccountStepEnum.EX_1020_S.getCode().equals(entry.getKey()) || AccountStepEnum.EX_1030_S.getCode().equals(entry.getKey()) || AccountStepEnum.EX_1010_S.getCode().equals(entry.getKey())) continue;
            coverItems.addAll(this.coverItem((List)entry.getValue()));
            for (TieDataNodeStd nodeStd : (List)entry.getValue()) {
                otherAttItemInstances.addAll(nodeStd.getAttItemInstances());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("ExRecordServiceImpl.mergeAttItem.otherAttItemInstances:{}", otherAttItemInstances);
        }
        if (otherAttItemInstances.size() <= 0) {
            return exRecord;
        }
        LocalDate localDate = WTCDateUtils.toLocalDate((Date)recordAndPackageWrapper.getPackageInfo().getOwnDate());
        AttFileCabinet fileCabinet = (AttFileCabinet)recordAndPackageWrapper.getPackageInfo().getInitParams().get("ATT_FILE");
        AttFileModel attFileModel = fileCabinet.getByAttPersonIdAndDate((long)recordAndPackageWrapper.getPackageInfo().getAttPersonId(), localDate);
        ExAttPackage exAttPackage = attFileModel.getAttExPackage(localDate);
        if (exAttPackage == null || exAttPackage.getExRule() == null) {
            return Lists.newArrayList();
        }
        ExRulePackage exRule = (ExRulePackage)exAttPackage.getExRule().getVersionByDate(localDate);
        if (exAttPackage == null || exAttPackage.getExRule() == null) {
            return Lists.newArrayList();
        }
        Map<Long, List<AttItemInstance>> attItemInstanceMap = otherAttItemInstances.stream().collect(Collectors.groupingBy(node -> node.getAttItemSpec().getBid()));
        HashMap attItemMap = Maps.newHashMapWithExpectedSize((int)attItemInstanceMap.size());
        HashMap attItemSpecMap = Maps.newHashMapWithExpectedSize((int)attItemInstanceMap.size());
        for (Map.Entry<Long, List<AttItemInstance>> listEntry : attItemInstanceMap.entrySet()) {
            BigDecimal itemValue = BigDecimal.ZERO;
            for (AttItemInstance itemInstance : listEntry.getValue()) {
                itemValue = itemValue.add(itemInstance.getItemValue());
                attItemSpecMap.put(listEntry.getKey(), itemInstance.getAttItemSpec());
            }
            attItemMap.put(listEntry.getKey(), itemValue);
        }
        Map<Long, Long> exTypeAndAttItemMapping = this.exTypeAndAttItemMapping(exRule, localDate);
        HashMap attItemMapTemp = new HashMap(attItemMap);
        ArrayList exRecordDTOS = Lists.newArrayListWithExpectedSize((int)exRecord.size());
        List exRecordtemp = exRecord.stream().filter(rec -> rec.getAttItemId() == null).collect(Collectors.toList());
        exRecordDTOS.addAll(exRecordtemp);
        exRecord.removeAll(exRecordtemp);
        Map<Long, List<ExRecordDTO>> recordDTOMap = exRecord.stream().collect(Collectors.groupingBy(ExRecordDTO::getAttItemId));
        for (Map.Entry<Long, List<ExRecordDTO>> entry : recordDTOMap.entrySet()) {
            if (attItemMap.get(entry.getKey()) != null && entry.getValue().size() > 0) {
                BigDecimal recordValue = BigDecimal.ZERO;
                BigDecimal finalAttItemValue = BigDecimal.ZERO;
                for (ExRecordDTO exRecordDTO : entry.getValue()) {
                    recordValue = recordValue.add(exRecordDTO.getAttItemValue());
                }
                finalAttItemValue = recordValue.add((BigDecimal)attItemMap.get(entry.getKey()));
                if (coverItems.contains(entry.getKey())) {
                    finalAttItemValue = (BigDecimal)attItemMap.get(entry.getKey());
                }
                if (finalAttItemValue.compareTo(BigDecimal.ZERO) == 0) {
                    attItemMapTemp.remove(entry.getKey());
                    continue;
                }
                if (finalAttItemValue.compareTo(recordValue) == 0) {
                    exRecordDTOS.addAll((Collection)entry.getValue());
                    attItemMapTemp.remove(entry.getKey());
                    continue;
                }
                ExRecordDTO recordDTO = entry.getValue().get(0);
                if (entry.getValue().size() > 1) {
                    recordDTO.setAttItemValue(finalAttItemValue);
                    recordDTO.setOriginItemId(null);
                    recordDTO.setAttItemOrValue(null);
                    recordDTO.setOriginItemVid(null);
                    recordDTO.setPunchCardPair(0L);
                    recordDTO.setPunchCardPoint(null);
                    recordDTO.setTbPosition(null);
                    recordDTO.setExFilterType("4");
                } else {
                    recordDTO.setAttItemValue(finalAttItemValue);
                    recordDTO.setExFilterType("4");
                }
                exRecordDTOS.add(recordDTO);
                attItemMapTemp.remove(entry.getKey());
                continue;
            }
            exRecordDTOS.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Long, List<ExRecordDTO>> entry : attItemMapTemp.entrySet()) {
            if (!exTypeAndAttItemMapping.containsKey(entry.getKey()) || ((BigDecimal)((Object)entry.getValue())).compareTo(BigDecimal.ZERO) == 0) continue;
            ExRecordDTO exRecordDTO = this.setpackageInfo(recordAndPackageWrapper.getPackageInfo(), recordAndPackageWrapper.getPackageInfo().getAttPersonId(), WTCDateUtils.toDate((LocalDate)localDate));
            exRecordDTO.setAttItemId(entry.getKey());
            exRecordDTO.setAttItemValue((BigDecimal)((Object)entry.getValue()));
            exRecordDTO.setAttItemVid(attItemSpecMap.get(entry.getKey()) != null ? Long.valueOf(((AttItemSpec)((Object)attItemSpecMap.get(entry.getKey()))).getId()) : null);
            exRecordDTO.setExFilterType("4");
            exRecordDTO.setExattributeId(exTypeAndAttItemMapping.get(entry.getKey()));
            exRecordDTO.setExProcess(exAttPackage.getExProcess());
            exRecordDTO.setShiftDate(WTCDateUtils.toDate((LocalDate)localDate));
            exRecordDTOS.add(exRecordDTO);
        }
        return exRecordDTOS;
    }

    public List<ExRecordDTO> mergeExRecords(List<ExRecordDTO> list) {
        ArrayList res = Lists.newArrayListWithCapacity((int)list.size());
        Map<String, List<ExRecordDTO>> map = list.stream().collect(Collectors.groupingBy(item -> "" + item.getRecordDate() + item.getShiftDate() + item.getPunchCardPoint() + item.getPunchCardPair() + item.getAttItemId()));
        for (Map.Entry<String, List<ExRecordDTO>> entry : map.entrySet()) {
            BigDecimal attItemValue = BigDecimal.ZERO;
            for (ExRecordDTO recordDTO : entry.getValue()) {
                attItemValue = attItemValue.add(recordDTO.getAttItemValue());
            }
            entry.getValue().get(0).setAttItemValue(attItemValue);
            res.add(entry.getValue().get(0));
        }
        return res;
    }

    private Map<Long, Long> exTypeAndAttItemMapping(ExRulePackage exRule, LocalDate localDate) {
        HashMap exTypeAndAttItemMapping = Maps.newHashMapWithExpectedSize((int)16);
        for (TimeSeqAvailableBo<ExConfig> seqAvailableBo : exRule.getConfigList()) {
            ExConfig config = (ExConfig)seqAvailableBo.getVersionByDate(localDate);
            for (ExConfigEntry configEntry : config.getEntryList()) {
                for (Long resultAttItem : configEntry.getResultAttItems()) {
                    exTypeAndAttItemMapping.put(resultAttItem, config.getExTypeId());
                }
            }
        }
        for (ExRuleEntry ruleEntry : exRule.getEntryPackageList()) {
            exTypeAndAttItemMapping.put(ruleEntry.getResAttItem(), ruleEntry.getExAttribute());
        }
        return exTypeAndAttItemMapping;
    }

    private Set<LocalDate> getShiftDate(TieDataNodeStd model) {
        String shiftDateStr;
        HashSet<LocalDate> set = new HashSet<LocalDate>(2);
        if (model instanceof AttItemValueStd && WTCStringUtils.isNotEmpty((String)(shiftDateStr = ((AttItemValueStd)model).getAttItemInstance().getExtraLabels().getValue("ex_shiftDate")))) {
            LocalDate shiftDate = LocalDate.parse(shiftDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            set.add(shiftDate);
            return set;
        }
        if (model instanceof TimeBucketStd && WTCCollections.isEmpty(model.parentDataNodes())) {
            set.add(((TimeBucketStd)model).getShiftDate());
        }
        if (WTCCollections.isNotEmpty(model.parentDataNodes())) {
            for (TieDataNodeStd dataNode : model.parentDataNodes()) {
                set.addAll(this.getShiftDate(dataNode));
            }
        }
        return set;
    }

    private void packageData(List<TieDataNodeStd> dataNodes, List<ExRecordDTO> exRecord, RecordAndPackageWrapper recordAndPackageWrapper) {
        DataPackageInfo packageInfo = recordAndPackageWrapper.getPackageInfo();
        Long attPersonId = packageInfo.getAttPersonId();
        Date ownDate = packageInfo.getOwnDate();
        ShiftTable shiftTable = (ShiftTable)packageInfo.getInitParams().get("ROSTER");
        HashMap exRecordDTOMap = new HashMap(dataNodes.size());
        for (TieDataNodeStd model : dataNodes) {
            List<AttItemInstance> attItems = model.getAttItemInstances();
            Set<LocalDate> shiftDateSet = this.getShiftDate(model);
            attItems.forEach(attItem -> {
                LabelSet<ILabel> extraLabels = attItem.getExtraLabels();
                if (!HRStringUtils.equals((String)extraLabels.getValue("ex_no_export"), (String)Boolean.TRUE.toString())) {
                    AttItemSpec attItemSpec;
                    String exFilterType = "3";
                    if ("exGeneral".equals(extraLabels.getValue("exFilterType"))) {
                        exFilterType = CONFIRMED;
                    } else if ("exConvert".equals(extraLabels.getValue("exFilterType"))) {
                        exFilterType = "2";
                    } else if ("5".equals(extraLabels.getValue("exFilterType"))) {
                        exFilterType = "5";
                    }
                    ExRecordDTO exRecordDTO = this.setpackageInfo(packageInfo, attPersonId, ownDate);
                    exRecordDTO.setExattributeId(Long.valueOf(extraLabels.getValue("ex_attr")));
                    String processValue = extraLabels.getValue("exProcess");
                    exRecordDTO.setExProcess(HRStringUtils.isEmpty((String)processValue) ? 0L : Long.parseLong(processValue));
                    String shitCardValue = extraLabels.getValue("ex_shitCard");
                    exRecordDTO.setTbPosition(HRStringUtils.isEmpty((String)shitCardValue) ? 0L : Long.parseLong(shitCardValue));
                    String punchCardValue = extraLabels.getValue("ex_punchCard");
                    exRecordDTO.setPunchCardPair(HRStringUtils.isEmpty((String)punchCardValue) ? 0L : Long.parseLong(punchCardValue));
                    String punchPointValue = extraLabels.getValue("ex_punchPoint");
                    exRecordDTO.setPunchCardPoint(punchPointValue);
                    if (shiftDateSet.size() > 1) {
                        exRecordDTO.setShiftDate(ownDate);
                    } else if (shiftDateSet.size() == 1) {
                        exRecordDTO.setShiftDate(WTCDateUtils.toDate((LocalDate)((LocalDate)shiftDateSet.iterator().next())));
                    } else if (shiftDateSet.isEmpty()) {
                        log.warn("shiftDateSet isEmpty, attItem:{}", (Object)(attItem.getAttItemSpec().getName() + attItem.getAttItemSpec().getNumber()));
                    }
                    String exOrigAtt = extraLabels.getValue("origAttItem");
                    String origAttItem = extraLabels.getValue("ex_origAttItem_v");
                    BigDecimal secondOR = WTCStringUtils.isNotEmpty((String)origAttItem) ? new BigDecimal(origAttItem) : BigDecimal.ZERO;
                    ShiftSpec shift = shiftTable.getByAttPersonId(attPersonId).getShiftSpec(WTCDateUtils.toLocalDate((Date)ownDate));
                    if (HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)exOrigAtt)) {
                        attItemSpec = attItem.getAttItemSpec();
                        exRecordDTO.setOriginItemId(Collections.singletonList(attItemSpec.getBid()));
                        exRecordDTO.setOriginItemVid(Collections.singletonList(attItemSpec.getId()));
                        if (HRStringUtils.equals((String)attItemSpec.getUnit(), (String)"day")) {
                            exRecordDTO.setAttItemOrValue(attItem.getDay());
                        } else if (HRStringUtils.equals((String)attItemSpec.getUnit(), (String)"time")) {
                            exRecordDTO.setAttItemValue(attItem.getItemValue());
                        } else {
                            exRecordDTO.setAttItemOrValue(new BigDecimal(ExRecordServiceImpl.getValueString(CONFIRMED, attItem.getSecondDecimal(), attItemSpec.getUnit(), attItemSpec.getDataAccuracy(), attItemSpec.getPrecisionTail())));
                        }
                    } else {
                        attItemSpec = attItem.getAttItemSpec();
                        exRecordDTO.setAttItemId(attItemSpec.getBid());
                        exRecordDTO.setAttItemVid(attItemSpec.getId());
                        if (HRStringUtils.equals((String)attItemSpec.getUnit(), (String)"day")) {
                            exRecordDTO.setAttItemValue(attItem.getDay());
                        } else if (HRStringUtils.equals((String)attItemSpec.getUnit(), (String)"time")) {
                            exRecordDTO.setAttItemValue(attItem.getItemValue());
                        } else {
                            exRecordDTO.setAttItemValue(new BigDecimal(ExRecordServiceImpl.getValueString(CONFIRMED, attItem.getSecondDecimal(), attItemSpec.getUnit(), attItemSpec.getDataAccuracy(), attItemSpec.getPrecisionTail())));
                        }
                        AttItemSpecData attItemSpecData = (AttItemSpecData)packageInfo.getInitParams().get("ATT_ITEM_SPEC");
                        List originItemId = JSON.parseArray((String)extraLabels.getValue("ex_origAttItem"), Long.class);
                        if (WTCCollections.isNotEmpty((Collection)originItemId)) {
                            exRecordDTO.setOriginItemId(originItemId);
                            exRecordDTO.setOriginItemVid(originItemId.stream().map(attId -> attItemSpecData.getByBidAndDate((long)attId, WTCDateUtils.toLocalDate((Date)ownDate)).getId()).collect(Collectors.toList()));
                            String timeunit = this.getTimeUintOfMutliItem(originItemId.stream().map(attId -> attItemSpecData.getByBidAndDate((long)attId, WTCDateUtils.toLocalDate((Date)ownDate))).collect(Collectors.toList()));
                            if (HRStringUtils.equals((String)timeunit, (String)"day")) {
                                exRecordDTO.setAttItemOrValue(shift.secondsToDays(secondOR));
                            } else {
                                exRecordDTO.setAttItemOrValue(new BigDecimal(ExRecordServiceImpl.getValueString(CONFIRMED, secondOR, timeunit, 6, "2")));
                            }
                        }
                    }
                    if (exRecordDTO.getAttItemId() == null) {
                        exRecordDTO.setExFilterType("3");
                    } else {
                        exRecordDTO.setExFilterType(exFilterType);
                    }
                    if (HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)exOrigAtt)) {
                        exRecord.add(exRecordDTO);
                    } else {
                        String key = this.genKey(exRecordDTO);
                        ExRecordDTO exRecordDTOPrev = (ExRecordDTO)exRecordDTOMap.get(key);
                        if (exRecordDTOPrev == null) {
                            exRecordDTOMap.put(key, exRecordDTO);
                            exRecord.add(exRecordDTO);
                        } else {
                            this.merge2Prev(exRecordDTOPrev, exRecordDTO);
                        }
                    }
                }
            });
        }
        exRecord.removeIf(exRecordDTO -> exRecordDTO.getAttItemValue() != null && exRecordDTO.getAttItemValue().compareTo(BigDecimal.ZERO) == 0);
    }

    private void merge2Prev(ExRecordDTO exRecordDTOPrev, ExRecordDTO exRecordDTO) {
        HashSet<Long> originItemSet;
        if (exRecordDTOPrev.getAttItemValue() == null && exRecordDTO.getAttItemValue() != null) {
            exRecordDTOPrev.setAttItemValue(exRecordDTO.getAttItemValue());
        } else if (exRecordDTOPrev.getAttItemValue() != null && exRecordDTO.getAttItemValue() != null) {
            exRecordDTOPrev.setAttItemValue(exRecordDTOPrev.getAttItemValue().add(exRecordDTO.getAttItemValue()));
        }
        if (exRecordDTOPrev.getOriginItemId() == null && exRecordDTO.getOriginItemId() != null) {
            exRecordDTOPrev.setOriginItemId(exRecordDTO.getOriginItemId());
        } else if (exRecordDTOPrev.getOriginItemId() != null && exRecordDTO.getOriginItemId() != null) {
            originItemSet = new HashSet<Long>(2);
            originItemSet.addAll(exRecordDTOPrev.getOriginItemId());
            originItemSet.addAll(exRecordDTO.getOriginItemId());
            exRecordDTOPrev.setOriginItemId(new ArrayList<Long>(originItemSet));
        }
        if (exRecordDTOPrev.getOriginItemVid() == null && exRecordDTO.getOriginItemVid() != null) {
            exRecordDTOPrev.setOriginItemVid(exRecordDTO.getOriginItemVid());
        } else if (exRecordDTOPrev.getOriginItemVid() != null && exRecordDTO.getOriginItemVid() != null) {
            originItemSet = new HashSet(2);
            originItemSet.addAll(exRecordDTOPrev.getOriginItemVid());
            originItemSet.addAll(exRecordDTO.getOriginItemVid());
            exRecordDTOPrev.setOriginItemVid(new ArrayList<Long>(originItemSet));
        }
        if (exRecordDTOPrev.getAttItemOrValue() == null && exRecordDTO.getAttItemOrValue() != null) {
            exRecordDTOPrev.setAttItemOrValue(exRecordDTO.getAttItemOrValue());
        } else if (exRecordDTOPrev.getAttItemOrValue() != null && exRecordDTO.getAttItemOrValue() != null) {
            exRecordDTOPrev.setAttItemOrValue(exRecordDTOPrev.getAttItemOrValue().add(exRecordDTO.getAttItemOrValue()));
        }
        exRecordDTOPrev.setExFilterType("5");
        if (exRecordDTOPrev.getTbPosition() == null || exRecordDTOPrev.getTbPosition() == 0L) {
            exRecordDTOPrev.setTbPosition(exRecordDTO.getTbPosition());
        }
        if (WTCStringUtils.isEmpty((String)exRecordDTOPrev.getPunchCardPoint())) {
            exRecordDTOPrev.setPunchCardPoint(exRecordDTO.getPunchCardPoint());
        }
    }

    private String genKey(ExRecordDTO exRecordDTO) {
        String shiftDateStr = "";
        if (exRecordDTO.getShiftDate() != null) {
            shiftDateStr = new SimpleDateFormat("yyyy-MM-dd").format(exRecordDTO.getShiftDate());
        }
        return WTCStringUtils.joinOnDot((String[])new String[]{shiftDateStr, String.valueOf(exRecordDTO.getPunchCardPair()), String.valueOf(exRecordDTO.getAttItemVid()), String.valueOf(exRecordDTO.getExattributeId()), String.valueOf(exRecordDTO.getExProcess())});
    }

    private ExRecordDTO setpackageInfo(DataPackageInfo packageInfo, Long attPersonId, Date ownDate) {
        ExRecordDTO exRecordDTO = new ExRecordDTO();
        exRecordDTO.setAttFileId(packageInfo.getAttFileid());
        exRecordDTO.setAttFileVid(packageInfo.getAttFileVid());
        exRecordDTO.setExOrgId(packageInfo.getOrg());
        exRecordDTO.setPersonId(attPersonId);
        exRecordDTO.setCompanyVid(packageInfo.getCompanyVid());
        exRecordDTO.setDepartmentVid(packageInfo.getDepartmentVid());
        exRecordDTO.setPositionVid(packageInfo.getPositionVid());
        exRecordDTO.setJobVid(packageInfo.getJobVid());
        exRecordDTO.setShiftId(packageInfo.getShiftId());
        exRecordDTO.setShiftVid(packageInfo.getShiftFid());
        exRecordDTO.setCalVersion(packageInfo.getVersion());
        exRecordDTO.setAffiliateAdminorgVid(packageInfo.getAffiliateadminorgvid());
        exRecordDTO.setRecordDate(ownDate);
        return exRecordDTO;
    }

    private static String getValueString(String dataType, BigDecimal valueSecond, String unit, int dataAccuracy, String precisionTail) {
        String result = "";
        if (HRStringUtils.equals((String)dataType, (String)CONFIRMED)) {
            switch (unit) {
                case "hour": {
                    result = ExRecordServiceImpl.scale(valueSecond, dataAccuracy, 3600, precisionTail);
                    break;
                }
                case "minute": {
                    result = ExRecordServiceImpl.scale(valueSecond, dataAccuracy, 60, precisionTail);
                    break;
                }
                case "second": {
                    result = String.valueOf(valueSecond);
                    break;
                }
            }
        } else {
            result = HRStringUtils.equals((String)dataType, (String)UNCONFIRMED) && HRStringUtils.equals((String)unit, (String)"time") ? String.valueOf(valueSecond) : "";
        }
        return result;
    }

    private static String scale(BigDecimal value, int dataaccuracy, int scale, String precisionTail) {
        int precision = 4;
        switch (precisionTail) {
            case "1": {
                precision = 4;
                break;
            }
            case "2": {
                precision = 1;
                break;
            }
            case "3": {
                precision = 0;
                break;
            }
        }
        return value.divide(new BigDecimal(scale), dataaccuracy, precision).toString();
    }

    private String getTimeUintOfMutliItem(List<AttItemSpec> attItemSpecs) {
        Set units = attItemSpecs.stream().map(AttItemSpec::getUnit).collect(Collectors.toSet());
        if (units.contains(AttitemUnitEnum.SECOND.getUnit())) {
            return AttitemUnitEnum.SECOND.getUnit();
        }
        if (units.contains(AttitemUnitEnum.MINUTE.getUnit())) {
            return AttitemUnitEnum.MINUTE.getUnit();
        }
        if (units.contains(AttitemUnitEnum.HOUR.getUnit())) {
            return AttitemUnitEnum.HOUR.getUnit();
        }
        return AttitemUnitEnum.DAY.getUnit();
    }

    @Override
    @Deprecated
    public void deleteRecoredAfterErrorDate(Long attPersonId, Date errorDate) {
        QFilter qFilter = StorageUtil.generalErrorDateSql(attPersonId, errorDate, PERSON_ID, RECORD_DATE);
        if (qFilter != null) {
            SERVICE_HELPER.deleteByFilter(new QFilter[]{qFilter});
        }
    }

    @Override
    public void deleteRecordByAttFileBoIdAfterErrorDate(Long attFileBoId, Date errorDate) {
        QFilter qFilter = StorageUtil.generalErrorDateSql(attFileBoId, errorDate, ATTFILEID, RECORD_DATE);
        if (qFilter != null) {
            SERVICE_HELPER.deleteByFilter(new QFilter[]{qFilter});
        }
    }

    @Override
    public String getServiceReportNodeName() {
        return CalcReportConstants.EXRECORD_STORE_TIME;
    }

    private Boolean checkSaveHis() {
        return (Boolean)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)"exrecordhis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        QFilter[] filters = StorageUtil.transferClearQFilter(version, attSubjects, ATTFILEID, RECORD_DATE, CAL_VERSION);
        if (filters != null) {
            try (TXHandle tx = TX.required();){
                for (QFilter filter : filters) {
                    SERVICE_HELPER.deleteByFilter(new QFilter[]{filter});
                }
            }
        }
    }
}

