/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.std.chain;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.chain.TieContext;
import kd.wtc.wtes.business.core.chain.TieVariable;
import kd.wtc.wtes.business.core.datanode.DataPackage;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.TieContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieContextStd
implements TieContext<TieDataNodeStd> {
    private final TieContext<TieDataNodeStd> context;

    public TieContextStd(TieContext<TieDataNodeStd> context) {
        this.context = context;
    }

    public long getAttPersonId() {
        return this.context.getAttSubjectEntry().getAttPersonId();
    }

    public LocalDate getChainDate() {
        return this.context.getDataPackage().getChainDate();
    }

    public LocalDate getStartDate() {
        return this.context.getAttSubjectEntry().getStartDate();
    }

    public LocalDate getEndDate() {
        return this.context.getAttSubjectEntry().getEndDate();
    }

    public String getVersion() {
        return this.context.getDataPackage().getVersion();
    }

    @Override
    public AttSubject.AttSubjectEntry getAttSubjectEntry() {
        return this.context.getAttSubjectEntry();
    }

    @Override
    public TieRequest getRequest() {
        return this.context.getRequest();
    }

    @Override
    public DataPackage<TieDataNodeStd> getDataPackage() {
        return this.context.getDataPackage();
    }

    @Override
    public List<TieDataNodeStd> getAllDataNodes() {
        return this.context.getAllDataNodes();
    }

    @Override
    public TieVariable getTieVariable() {
        return this.context.getTieVariable();
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.context.getInitParams();
    }

    @Override
    public TieStepIdentity getTieStepIdentity() {
        return this.context.getTieStepIdentity();
    }

    public List<TieDataNodeStd> getRawTimeBuckets() {
        DataPackage<TieDataNodeStd> dataPackage = this.getDataPackage();
        if (dataPackage.getPhaseDataResults().isEmpty()) {
            return Collections.emptyList();
        }
        return CollectionUtils.unmodifiableList(dataPackage.getPhaseDataResults().get(0).getPhaseLeafDataNodes());
    }

    public Map<Long, AttItemValue> getAllHandleResultAttItemValueMap(List<TieDataNodeStd> dataNodes) {
        return TieContextUtil.getAllHandleResultAttItemValue(dataNodes, ContextUtil.getShiftSpec(this));
    }
}

