/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.std.datanode;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtes.business.core.datanode.TieDataNodeCore;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.model.rlra.CardExceptionTypeEnum;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPunchCardRelationEnum;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.common.pairtime.SourceCode;

public class TimeBucketStd
extends TieDataNodeStd
implements ITimeBucket {
    private final TimeBucket timeBucket;

    public TimeBucketStd(TieDataNodeCore<TieDataNodeStd> dataNodeCore) {
        super(dataNodeCore);
        this.timeBucket = (TimeBucket)dataNodeCore.getData();
    }

    @Override
    public LocalDate getOriginalDate() {
        return this.timeBucket.getOriginalDate();
    }

    @Override
    public LocalDateTime getStartTime() {
        return this.timeBucket.getStartTime();
    }

    @Override
    public LocalDateTime getEndTime() {
        return this.timeBucket.getEndTime();
    }

    @Override
    public int getTimeIntervalInSeconds() {
        return this.timeBucket.getTimeIntervalInSeconds();
    }

    @Override
    public Long getShiftTimeBucketSeqId() {
        return this.timeBucket.getShiftTimeBucketSeqId();
    }

    @Override
    public Long getShouldPunchCardSeqId() {
        return this.timeBucket.getShouldPunchCardSeqId();
    }

    @Override
    public SourceCode getStartTimePointSource() {
        return this.timeBucket.getStartTimePointSource();
    }

    @Override
    public SourceCode getEndTimePointSource() {
        return this.timeBucket.getEndTimePointSource();
    }

    @Override
    public AttendanceBillTag getAttendanceBillTag() {
        return this.timeBucket.getAttendanceBillTag();
    }

    @Override
    public ShiftTimeBucketPropertyEnum getShiftTimeBucketProperty() {
        return this.timeBucket.getShiftTimeBucketProperty();
    }

    @Override
    public TimeBucketPositionEnum getTimeBucketPosition() {
        return this.timeBucket.getTimeBucketPosition();
    }

    @Override
    public TimeBucketPunchCardRelationEnum getTimeBucketPunchCardRelation() {
        return this.timeBucket.getTimeBucketPunchCardRelation();
    }

    @Override
    public List<String> getAttendanceStatuses() {
        return this.timeBucket.getAttendanceStatuses();
    }

    @Override
    public List<String> getTimeBucketLabels() {
        return this.timeBucket.getTimeBucketLabels();
    }

    @Override
    public String getPunchCardTag() {
        return this.timeBucket.getPunchCardTag();
    }

    @Override
    public LocalDate getShiftDate() {
        return this.timeBucket.getShiftDate();
    }

    @Override
    public ShiftSpec getShiftSpec() {
        return this.timeBucket.getShiftSpec();
    }

    @Override
    public Roster getRoster() {
        return this.timeBucket.getRoster();
    }

    @Override
    public DateType getDateType() {
        return this.timeBucket.getDateType();
    }

    @Override
    public DateAttribute getDateAttribute() {
        return this.timeBucket.getDateAttribute();
    }

    @Override
    public List<String> getAttendanceStatusList() {
        return this.timeBucket.getAttendanceStatusList();
    }

    @Override
    public List<String> getTimeBucketLabelList() {
        return this.timeBucket.getTimeBucketLabelList();
    }

    @Override
    public String getAbsenceBillState() {
        return this.timeBucket.getAbsenceBillState();
    }

    @Override
    public String getTravelBillState() {
        return this.timeBucket.getTravelBillState();
    }

    @Override
    public String getAttMode() {
        return this.timeBucket.getAttMode();
    }

    @Override
    public CardExceptionTypeEnum getCardExceptionType() {
        return this.timeBucket.getCardExceptionType();
    }

    @Override
    public boolean isNonTime() {
        return this.timeBucket.getStartTime() == null || this.timeBucket.getEndTime() == null;
    }

    public int getDurationOfSecond() {
        if (this.isNonTime()) {
            return this.timeBucket.getDurationOfSecond();
        }
        Duration between = Duration.between(this.timeBucket.getStartTime(), this.timeBucket.getEndTime());
        return (int)between.getSeconds();
    }

    public BigDecimal getDurationOfDay() {
        if (this.getShiftSpec() == null) {
            return BigDecimal.ZERO;
        }
        return this.getShiftSpec().secondsToDays(this.getDurationOfSecond());
    }

    public TimeBucket unwrapAndCopy() {
        return this.timeBucket.clone();
    }

    public static TimeBucket.Builder<?, ?> withUnwrapAndCopy(TimeBucketStd timeBucket) {
        return timeBucket.unwrapAndCopy().toBuilder();
    }
}

