/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.DataPackageInfo;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.storage.StorageUtil;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;

public class AttIncrDecrServiceImpl
implements IDataPackageStoreService {
    private static HRBaseServiceHelper SERVICE_HELPER = WtesHRBaseTimeWatchUtil.create(AttIncrDecrServiceImpl.class.getName() + "." + "wtdtd_attincrdecr", "wtdtd_attincrdecr");

    @Override
    public void storeBatch(List<RecordAndPackageWrapper> recordAndPackageWrapperList) {
        DynamicObjectCollection recordList = new DynamicObjectCollection();
        for (RecordAndPackageWrapper packageWrapper : recordAndPackageWrapperList) {
            DataPackageInfo packageInfo = packageWrapper.getPackageInfo();
            this.buildInfo(packageInfo, recordList);
        }
        if (WTCCollections.isNotEmpty((Collection)recordList)) {
            SERVICE_HELPER.save(recordList);
        }
    }

    private void buildInfo(DataPackageInfo packageInfo, DynamicObjectCollection recordList) {
        List<AttItemInstance> incrDecrList = packageInfo.getIncrDecrItem();
        if (WTCCollections.isEmpty(incrDecrList)) {
            return;
        }
        List filterZeroList = incrDecrList.stream().filter(this::filterZero).collect(Collectors.toList());
        if (WTCCollections.isEmpty(filterZeroList)) {
            return;
        }
        Map<Long, List<AttItemInstance>> itemMap = filterZeroList.stream().collect(Collectors.groupingBy(instance -> instance.getAttItemSpec().getBid()));
        for (Map.Entry<Long, List<AttItemInstance>> entry : itemMap.entrySet()) {
            Long attItemId = entry.getKey();
            List<AttItemInstance> attItem = entry.getValue();
            DynamicObject attIncrDecr = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attincrdecr");
            attIncrDecr.set("attfileid", (Object)packageInfo.getAttFileid());
            attIncrDecr.set("attfilevid", (Object)packageInfo.getAttFileVid());
            attIncrDecr.set("personid", (Object)packageInfo.getAttPersonId());
            attIncrDecr.set("owndate", (Object)packageInfo.getOwnDate());
            attIncrDecr.set("attitemid", (Object)attItemId);
            attIncrDecr.set("attitemvid", (Object)attItem.get(0).getAttItemSpec().getTimeSeqInfo().getVid());
            attIncrDecr.set("creator", (Object)packageInfo.getCalculatorId());
            attIncrDecr.set("createtime", (Object)packageInfo.getCalculateDate());
            this.setRecordModelValue(attItem, attIncrDecr);
            recordList.add((Object)attIncrDecr);
        }
    }

    private boolean filterZero(AttItemInstance attItemInstance) {
        return BigDecimal.ZERO.compareTo(attItemInstance.getSecondDecimal()) != 0 || null != attItemInstance.getItemValue() && BigDecimal.ZERO.compareTo(attItemInstance.getItemValue()) != 0;
    }

    @Override
    public void deleteRecoredAfterErrorDate(Long attPersonId, Date errorDate) {
        QFilter qFilter = StorageUtil.generalErrorDateSql(attPersonId, errorDate, "personid", "owndate");
        if (qFilter != null) {
            SERVICE_HELPER.deleteByFilter(new QFilter[]{qFilter});
        }
    }

    @Override
    public void deleteRecordByAttFileBoIdAfterErrorDate(Long attFileBoId, Date errorDate) {
        QFilter qFilter = StorageUtil.generalErrorDateSql(attFileBoId, errorDate, "attfileid", "owndate");
        if (qFilter != null) {
            SERVICE_HELPER.deleteByFilter(new QFilter[]{qFilter});
        }
    }

    @Override
    public String getServiceReportNodeName() {
        return "AttIncrDecrServiceImpl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        QFilter[] filters = StorageUtil.transferClearQFilter(version, attSubjects, "attfileid", "owndate", null);
        if (null != filters) {
            try (TXHandle tx = TX.required();){
                for (QFilter filter : filters) {
                    SERVICE_HELPER.deleteByFilter(new QFilter[]{filter});
                }
            }
        }
    }

    private void setRecordModelValue(List<AttItemInstance> instances, DynamicObject attIncrDecr) {
        AttItemSpec attItemSpec = instances.get(0).getAttItemSpec();
        DataType dataType = attItemSpec.getDataType();
        BigDecimal value = BigDecimal.ZERO;
        BigDecimal valueSecond = BigDecimal.ZERO;
        switch (dataType) {
            case DURATION: {
                value = instances.stream().map(AttItemInstance::getDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                valueSecond = instances.stream().map(AttItemInstance::getSecondDecimal).reduce(BigDecimal.ZERO, BigDecimal::add);
                break;
            }
            case TIMES: {
                value = instances.stream().map(AttItemInstance::getItemValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                break;
            }
        }
        attIncrDecr.set("value", (Object)value);
        attIncrDecr.set("valuesecond", (Object)valueSecond);
        BigDecimal valueLong = this.getValueLong(value, valueSecond, attItemSpec);
        attIncrDecr.set("valuelong", (Object)valueLong);
        attIncrDecr.set("valuestring", (Object)valueLong.toPlainString());
    }

    private BigDecimal getValueLong(BigDecimal value, BigDecimal valueSecond, AttItemSpec attItemSpec) {
        String dataType = attItemSpec.getDataType().code;
        String unit = attItemSpec.getUnit();
        int dataAccuracy = attItemSpec.getDataAccuracy();
        String precisionTail = attItemSpec.getPrecisionTail();
        BigDecimal valueLong = BigDecimal.ZERO;
        if (HRStringUtils.equals((String)dataType, (String)"1")) {
            switch (unit) {
                case "day": {
                    valueLong = this.scale(value, dataAccuracy, 1, precisionTail);
                    break;
                }
                case "hour": {
                    valueLong = this.scale(valueSecond, dataAccuracy, 3600, precisionTail);
                    break;
                }
                case "minute": {
                    valueLong = this.scale(valueSecond, dataAccuracy, 60, precisionTail);
                    break;
                }
                case "second": {
                    valueLong = valueSecond;
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)dataType, (String)"0") && HRStringUtils.equals((String)unit, (String)"time")) {
            if (null == value) {
                return valueLong;
            }
            valueLong = this.scale(value, dataAccuracy, 1, precisionTail);
        }
        return valueLong;
    }

    private BigDecimal scale(BigDecimal value, int dataAccuracy, int scale, String precisionTail) {
        int precision = 4;
        switch (precisionTail) {
            case "2": {
                precision = 1;
                break;
            }
            case "3": {
                precision = 0;
                break;
            }
        }
        return value.divide(new BigDecimal(scale), dataAccuracy, precision);
    }
}

