/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.model.DataPackageInfo;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.storage.VersionDataPackageStore;

@SingletonBean
public class DataPackageStoreManager {
    private static Log logger = LogFactory.getLog(DataPackageStoreManager.class);
    private final Map<String, VersionDataPackageStore> versionMap = new ConcurrentHashMap<String, VersionDataPackageStore>(16);
    private final Map<String, ExecutorService> poolMap = new ConcurrentHashMap<String, ExecutorService>(16);
    private final int ENGINE_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("tie.data.package.pool.size", Runtime.getRuntime().availableProcessors() + 1);
    private final String ENGINE_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("tie.data.package.pool.name", "DataPackagePool");
    private static final DataPackageStoreManager instance = (DataPackageStoreManager)WTCAppContextHelper.getBean(DataPackageStoreManager.class);

    public DataPackageStoreManager() {
        logger.debug("cpu core: {}", (Object)Runtime.getRuntime().availableProcessors());
    }

    public static DataPackageStoreManager getInstance() {
        return instance;
    }

    public void store(RecordAndPackageWrapper recordAndPackageWrapper) {
        DataPackageInfo packageInfo = recordAndPackageWrapper.getPackageInfo();
        VersionDataPackageStore versionDataPackageStore = this.getVersionDataPackageStore(packageInfo.getVersion(), packageInfo.getShardingIndex());
        versionDataPackageStore.store(recordAndPackageWrapper);
    }

    public void storeImmediately(String version, int shardingIndex) {
        VersionDataPackageStore versionDataPackageStore = this.getVersionDataPackageStore(version, shardingIndex);
        versionDataPackageStore.storeImmediately();
    }

    public void clearVersionStoreInstance(String version, int shardingIndex) {
        String key = this.getKey(version, shardingIndex);
        logger.debug("clearVersionStoreInstance key={}", (Object)key);
        this.versionMap.remove(key);
        ExecutorService executorService = this.poolMap.remove(key);
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    private String getKey(String version, int shardingIndex) {
        return RequestContext.get().getAccountId() + '_' + version + '_' + shardingIndex;
    }

    public VersionDataPackageStore getVersionDataPackageStore(String versionId, int shardingIndex) {
        String key = this.getKey(versionId, shardingIndex);
        logger.debug("getVersionDataPackageStore key={}", (Object)key);
        return this.versionMap.computeIfAbsent(key, value -> new VersionDataPackageStore());
    }

    public ExecutorService getExecutorService(String versionId, int shardingIndex) {
        String key = this.getKey(versionId, shardingIndex);
        logger.debug("getVersionDataPackageStore key={}", (Object)key);
        return this.poolMap.computeIfAbsent(key, value -> ThreadPools.newExecutorService((String)(this.ENGINE_POOL_NAME + key), (int)this.ENGINE_POOL_SIZE));
    }

    public void clearAfterErrorDate(Long attFileBoId, Date errorDate) {
        VersionDataPackageStore versionDataPackageStore = new VersionDataPackageStore();
        versionDataPackageStore.clearAfterError(attFileBoId, errorDate);
    }

    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        VersionDataPackageStore versionDataPackageStore = new VersionDataPackageStore();
        versionDataPackageStore.doCalDataClean(attSubjects, version);
    }
}

