/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.util.Tuples;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.Strings;

public class StorageUtil {
    public static final String DEFAULT_KEY_ATTPERSON = "personid";
    public static final String DEFAULT_KEY_CALCULATE_DATE = "owndate";
    public static final String KEY_VERSIONID = "versionid";

    private StorageUtil() {
    }

    public static QFilter generalErrorDateSql(long attPersonId, Date errorDate, String attpersonKey, String calculateDateKey) {
        QFilter qFilter = new QFilter(attpersonKey, "=", (Object)attPersonId).and(calculateDateKey, ">=", (Object)errorDate);
        return qFilter;
    }

    public static Map<String, Map<String, Tuple<QFilter, List<Long>>>> genralNeedClearMapWithPackList(List<RecordAndPackageWrapper> recordAndPackageWrapperList, String calDateKey) {
        HashMap<String, Map<String, Tuple<QFilter, List<Long>>>> needClearMap = new HashMap<String, Map<String, Tuple<QFilter, List<Long>>>>(16);
        for (RecordAndPackageWrapper recordAndPackageWrapper : recordAndPackageWrapperList) {
            Tuple personIdList;
            String version = recordAndPackageWrapper.getPackageInfo().getVersion();
            LocalDate startDate = recordAndPackageWrapper.getExtendDataInfo().getStartDate();
            LocalDate endDate = recordAndPackageWrapper.getExtendDataInfo().getEndDate();
            Long personId = recordAndPackageWrapper.getPackageInfo().getAttPersonId();
            QFilter qFilterKey = startDate.compareTo(endDate) == 0 ? new QFilter(calDateKey, "=", (Object)WTCDateUtils.toDate((LocalDate)startDate)) : new QFilter(calDateKey, ">=", (Object)WTCDateUtils.toDate((LocalDate)startDate)).and(calDateKey, "<=", (Object)WTCDateUtils.toDate((LocalDate)endDate));
            HashMap<String, Tuple> qFilterListMap = (HashMap<String, Tuple>)needClearMap.get(version);
            if (qFilterListMap == null) {
                qFilterListMap = new HashMap<String, Tuple>(16);
            }
            if ((personIdList = (Tuple)qFilterListMap.get(qFilterKey.toString())) == null) {
                personIdList = new Tuple((Object)qFilterKey, new ArrayList());
            }
            ((List)personIdList.getValue()).add(personId);
            qFilterListMap.put(qFilterKey.toString(), personIdList);
            needClearMap.put(version, qFilterListMap);
        }
        return needClearMap;
    }

    public static Map<String, Map<String, Tuple<QFilter, List<Long>>>> genNeedClearMapWithAttSubject(List<AttSubject> attSubjects, String calDateKey, String version) {
        HashMap<String, Map<String, Tuple<QFilter, List<Long>>>> needClearMap = new HashMap<String, Map<String, Tuple<QFilter, List<Long>>>>(16);
        for (AttSubject attSubject : attSubjects) {
            Tuple personIdList;
            LocalDate startDate = attSubject.getStartDate();
            LocalDate endDate = attSubject.getEndDate();
            long personId = attSubject.getAttPersonId();
            QFilter qFilterKey = startDate.compareTo(endDate) == 0 ? new QFilter(calDateKey, "=", (Object)WTCDateUtils.toDate((LocalDate)startDate)) : new QFilter(calDateKey, ">=", (Object)WTCDateUtils.toDate((LocalDate)startDate)).and(calDateKey, "<=", (Object)WTCDateUtils.toDate((LocalDate)endDate));
            HashMap<String, Tuple> qFilterListMap = (HashMap<String, Tuple>)needClearMap.get(version);
            if (qFilterListMap == null) {
                qFilterListMap = new HashMap<String, Tuple>(16);
            }
            if ((personIdList = (Tuple)qFilterListMap.get(qFilterKey.toString())) == null) {
                personIdList = new Tuple((Object)qFilterKey, new ArrayList());
            }
            ((List)personIdList.getValue()).add(personId);
            qFilterListMap.put(qFilterKey.toString(), personIdList);
            needClearMap.put(version, qFilterListMap);
        }
        return needClearMap;
    }

    public static List<QFilter> transferQFilterList(Map<String, Map<String, Tuple<QFilter, List<Long>>>> needClearMap, String attpersonKey, String versionKey) {
        ArrayList<QFilter> resultList = new ArrayList<QFilter>(16);
        if (null != needClearMap && !needClearMap.isEmpty()) {
            for (Map.Entry<String, Map<String, Tuple<QFilter, List<Long>>>> dateRangeEntry : needClearMap.entrySet()) {
                Map<String, Tuple<QFilter, List<Long>>> versonMap = dateRangeEntry.getValue();
                for (Map.Entry<String, Tuple<QFilter, List<Long>>> entry : versonMap.entrySet()) {
                    QFilter result = ((List)entry.getValue().getValue()).size() == 1 ? ((QFilter)entry.getValue().getKey()).and(attpersonKey, "=", ((List)entry.getValue().getValue()).get(0)) : ((QFilter)entry.getValue().getKey()).and(attpersonKey, "in", entry.getValue().getValue());
                    if (Strings.isNotEmpty((String)versionKey)) {
                        result.and(versionKey, "!=", (Object)dateRangeEntry.getKey());
                    }
                    resultList.add(result);
                }
            }
        }
        return resultList;
    }

    private static String convert2DateGroupKey(LocalDate start, LocalDate end) {
        return start.getYear() + "-" + start.getMonthValue() + "-" + start.getDayOfMonth() + "-" + end.getYear() + "-" + end.getMonthValue() + "-" + end.getDayOfMonth();
    }

    public static QFilter[] transferClearQFilter(String version, List<AttSubject> attSubjects, String attfileBoidKey, String ownDateKey, String versionKey) {
        if (CollectionUtils.isEmpty(attSubjects)) {
            return null;
        }
        HashMap attfileBoidGroupByDateMap = new HashMap();
        for (AttSubject attSubject : attSubjects) {
            if (CollectionUtils.isEmpty((Collection)attSubject.getAttFileBos())) continue;
            for (AttSubject.AttFileBo attFileBo : attSubject.getAttFileBos()) {
                if (CollectionUtils.isEmpty((Collection)attFileBo.getAttFileVersions())) continue;
                for (AttSubject.AttFileVersion attFileVersion : attFileBo.getAttFileVersions()) {
                    LocalDate endDate;
                    LocalDate startDate = attFileVersion.getStartDate();
                    String dateKey = StorageUtil.convert2DateGroupKey(startDate, endDate = attFileVersion.getEndDate());
                    Tuples.Tuple3 dateRangePart = (Tuples.Tuple3)attfileBoidGroupByDateMap.get(dateKey);
                    if (dateRangePart == null) {
                        dateRangePart = new Tuples.Tuple3(startDate, endDate, new HashSet(attSubjects.size()));
                        attfileBoidGroupByDateMap.put(dateKey, dateRangePart);
                    }
                    ((HashSet)dateRangePart.item3).add(attFileBo);
                }
            }
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(attfileBoidGroupByDateMap.size());
        for (Map.Entry entry : attfileBoidGroupByDateMap.entrySet()) {
            Tuples.Tuple3 dateRangePart = (Tuples.Tuple3)entry.getValue();
            List attfileIds = ((HashSet)dateRangePart.item3).stream().map(AttSubject.AttFileBo::getAttFileBoid).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(attfileIds)) continue;
            QFilter filter = ((LocalDate)dateRangePart.item1).compareTo((ChronoLocalDate)dateRangePart.item2) == 0 ? new QFilter(ownDateKey, "=", (Object)WTCDateUtils.toDate((LocalDate)((LocalDate)dateRangePart.item1))) : new QFilter(ownDateKey, ">=", (Object)WTCDateUtils.toDate((LocalDate)((LocalDate)dateRangePart.item1))).and(ownDateKey, "<=", (Object)WTCDateUtils.toDate((LocalDate)((LocalDate)dateRangePart.item2)));
            filter.and(new QFilter(attfileBoidKey, "in", attfileIds));
            filters.add(filter);
        }
        if (filters.size() == 0) {
            return null;
        }
        if (versionKey != null) {
            for (QFilter filter : filters) {
                filter.and(versionKey, "!=", (Object)version);
            }
        }
        return filters.toArray(new QFilter[0]);
    }
}

