/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.DataPackageInfo;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.storage.DataPackageStoreExecutor;
import kd.wtc.wtes.business.storage.DataPackageStoreManager;
import kd.wtc.wtes.business.storage.DataPackageStoreResult;
import kd.wtc.wtes.business.storage.PriorityExecutorService;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class VersionDataPackageStore {
    private static Log logger = LogFactory.getLog(VersionDataPackageStore.class);
    private static final int THRESHOLD = WTCAppContextHelper.getProjectParams().getInteger("tie.dataPackage.store.threshold", Integer.valueOf(600));
    private List<RecordAndPackageWrapper> localItemCache = new ArrayList<RecordAndPackageWrapper>(10);
    private List<IDataPackageStoreService> serviceList;
    private List<Future<DataPackageStoreResult>> storeResult = new ArrayList<Future<DataPackageStoreResult>>(16);
    private int storeBatchNum;
    private int storeTotalCount;
    private long firstStartTime;
    private final boolean usePriorityService = WTCAppContextHelper.getProjectParams().getBoolean("tie.data.package.pool.usepriority", Boolean.valueOf(false));

    public synchronized void store(RecordAndPackageWrapper recordAndPackageWrapper) {
        logger.debug("size before {}", (Object)this.localItemCache.size());
        this.toLocalChe(recordAndPackageWrapper);
        if (this.localItemCache.size() >= THRESHOLD) {
            this.storeImmediately();
        }
        logger.debug("size after {}", (Object)this.localItemCache.size());
    }

    private void toLocalChe(RecordAndPackageWrapper recordAndPackageWrapper) {
        this.localItemCache.add(recordAndPackageWrapper);
    }

    public synchronized void storeImmediately() {
        if (this.isNotEmpty()) {
            if (this.firstStartTime == 0L) {
                this.firstStartTime = System.currentTimeMillis();
            }
            List<IDataPackageStoreService> storeServices = this.getStoreServices();
            List list = (List)((ArrayList)this.localItemCache).clone();
            DataPackageInfo packageInfo = ((RecordAndPackageWrapper)list.get(0)).getPackageInfo();
            try {
                this.storeTotalCount += this.localItemCache.size();
                if (storeServices != null) {
                    if (!this.usePriorityService) {
                        ExecutorService executorService = DataPackageStoreManager.getInstance().getExecutorService(packageInfo.getVersion(), packageInfo.getShardingIndex());
                        this.storeResult.add(executorService.submit(TaskTracer.wrap((Callable)new DataPackageStoreExecutor(storeServices, list, RequestContext.get()))));
                    } else {
                        PriorityExecutorService executorService = PriorityExecutorService.getStoreInstance();
                        this.storeResult.add(executorService.submit(TaskTracer.wrap((Callable)new DataPackageStoreExecutor(storeServices, list, RequestContext.get())), packageInfo.getPriority()));
                    }
                }
            }
            catch (Exception ex) {
                logger.warn("storeBatch error", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
            }
            finally {
                this.clear();
                ++this.storeBatchNum;
            }
        }
    }

    public synchronized void clearAfterError(Long attFileBoId, Date errorDate) {
        List<IDataPackageStoreService> storeServices = this.getStoreServices();
        logger.warn("clearAfterError attFileBoId={}, errorDate={}", (Object)attFileBoId, (Object)errorDate);
        try {
            if (storeServices != null) {
                for (IDataPackageStoreService service : storeServices) {
                    long startTime = System.currentTimeMillis();
                    logger.debug("storeServices: {} clearAfterError start ", service.getClass());
                    service.deleteRecordByAttFileBoIdAfterErrorDate(attFileBoId, errorDate);
                    logger.debug("storeServices:{} clearAfterError end ,cost time :{} ", service.getClass(), (Object)(System.currentTimeMillis() - startTime));
                }
            }
        }
        catch (Exception ex) {
            logger.warn("clearAfterError error", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    private void clear() {
        this.localItemCache.clear();
    }

    private List<IDataPackageStoreService> getStoreServices() {
        Object initialises;
        if (this.serviceList == null && (initialises = WTCAppContextHelper.getProjectParams().get("tie.init.dataPackageStoreList")) != null) {
            ArrayList<String> initializerList = new ArrayList<String>((List)initialises);
            initializerList.add("kd.wtc.wtes.business.storage.TieDataPackageStoreExtServiceImpl");
            this.serviceList = initializerList.stream().map(initializerBeanName -> (IDataPackageStoreService)WTCAppContextHelper.getBean((String)initializerBeanName, IDataPackageStoreService.class)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(this.serviceList)) {
            throw new WtesException("count not get store service by param:tie.init.dataPackageStoreList");
        }
        return this.serviceList;
    }

    public synchronized Map<String, Object> getCostData() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        if (this.firstStartTime == 0L) {
            map.put("startTime", new Date().getTime());
        } else {
            map.put("startTime", this.firstStartTime);
        }
        map.put("storeBatchNum", this.storeBatchNum);
        map.put("storeTotalCount", this.storeTotalCount);
        return map;
    }

    private boolean isNotEmpty() {
        return this.localItemCache.size() > 0;
    }

    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        block13: {
            List<IDataPackageStoreService> storeServices = this.getStoreServices();
            try {
                if (storeServices == null) break block13;
                for (IDataPackageStoreService service : storeServices) {
                    String callbackTag = service.getClass().getName();
                    Span callbackTagSpan = TaskTracer.newSpan((String)callbackTag);
                    Throwable throwable = null;
                    try {
                        service.doCalDataClean(attSubjects, version);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (callbackTagSpan == null) continue;
                        if (throwable != null) {
                            try {
                                callbackTagSpan.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        callbackTagSpan.close();
                    }
                }
            }
            catch (Exception ex) {
                logger.warn("doCalDataClean error", (Throwable)ex);
                throw ex;
            }
        }
    }

    public List<Future<DataPackageStoreResult>> getStoreResult() {
        return this.storeResult;
    }
}

