/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage.countmsg;

import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.sdk.wtc.wtes.business.tie.task.AfterTieTaskEndEvent;
import kd.sdk.wtc.wtes.business.tie.task.TieTaskEndExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtes.business.storage.countmsg.CountMsgObject;
import kd.wtc.wtes.business.storage.countmsg.CountMsgService;

public class CountMsgConsumer
implements MessageConsumer {
    private static final Log LOG = LogFactory.getLog(CountMsgConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object object, String messageId, boolean retryFlag, MessageAcker messageAcker) {
        CountMsgObject countMsgObject = (CountMsgObject)object;
        try {
            LOG.debug("countMsg save start:versionId->{} messageId->{},subTaskId->{}", new Object[]{countMsgObject.getVersionId(), messageId, countMsgObject.getSubTaskId()});
            CountMsgService.getInstance().saveMsg(countMsgObject);
        }
        catch (Exception exp) {
            LOG.warn("consumer except:", (Throwable)exp);
        }
        finally {
            messageAcker.ack(messageId);
            this.afterTieTaskEndExt(countMsgObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterTieTaskEndExt(CountMsgObject countMsgObject) {
        long start = System.currentTimeMillis();
        try {
            WTCPluginProxyFactory.create(TieTaskEndExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.task.TieTaskEndExtPlugin").invokeReplace(instance -> {
                Set<Long> attFileBoIds = CountMsgService.getInstance().queryAttFileBoId(countMsgObject);
                AfterTieTaskEndEvent afterTieTaskEndEvent = new AfterTieTaskEndEvent(countMsgObject.getTaskId(), countMsgObject.getSubTaskId(), countMsgObject.getVersionId(), attFileBoIds);
                instance.afterTieTaskEnd(afterTieTaskEndEvent);
            });
        }
        catch (Exception e) {
            LOG.warn("TieTaskEndExtPlugin.afterTieTaskEnd error", (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.info("TieTaskEndExtPlugin.afterTieTaskEnd\u8017\u65f6:{}ms", (Object)(end - start));
        }
    }
}

