/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.sdk.wtc.wtes.business.tie.init.accountplan.TieSchemeExtPlugin;
import kd.sdk.wtc.wtes.business.tie.model.accountplan.TieSchemeExt;
import kd.wtc.wtbs.business.accountplan.AccountPlanBuryPointUtil;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountPlan;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountStageType;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtes.business.builder.DetectableBuilder;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.TiePointer;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.enums.AccountStageTypeEnum;
import kd.wtc.wtes.common.enums.AccountStepEnum;
import kd.wtc.wtes.common.enums.CalculRuleTypeEnum;
import kd.wtc.wtes.common.enums.TiePhaseRusultEnum;

public class AccountSchemeUtil {
    private static final Log LOG = LogFactory.getLog(AccountSchemeUtil.class);

    public static List<TieScheme> listByAttPersonIdAndRangeDate(LocalDate fromDate, LocalDate toDate, Long accountPlanBid, AttPeriodTable attPeriodTable) {
        return AccountSchemeUtil.listAccountPlan(fromDate, toDate, accountPlanBid, attPeriodTable);
    }

    private static List<TieScheme> listAccountPlan(LocalDate fromDate, LocalDate toDate, Long accountPlanBid, AttPeriodTable attPeriodTable) {
        Object[] qFilter;
        QFilter[] qFilters;
        Map dynamicObjectsMap;
        LocalDate periodStartDate = fromDate;
        LocalDate periodEndDate = toDate;
        if (attPeriodTable != null) {
            Optional<PerAttPeriod> optionalMax;
            Optional<PerAttPeriod> optionalMin = attPeriodTable.getAccountMinAttPeriodBeginDate();
            if (optionalMin.isPresent()) {
                periodStartDate = WTCDateUtils.toLocalDate((Date)optionalMin.get().getPerAttBeginDate());
            }
            if ((optionalMax = attPeriodTable.getAccountMaxAttPeriodEndDate()).isPresent()) {
                periodEndDate = WTCDateUtils.toLocalDate((Date)optionalMax.get().getPerAttEndDate());
            }
        }
        if ((dynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)"wtp_accountplan", (QFilter[])(qFilters = (QFilter[])HRArrayUtils.insertElement((Object[])(qFilter = TimeSeqEntityGenerateUtils.getQueryCondition(periodStartDate, periodEndDate)), (int)qFilter.length, (Object)new QFilter("boid", "=", (Object)accountPlanBid))))) != null && dynamicObjectsMap.size() > 0) {
            List<DynamicObject> accountStepList = AccountSchemeUtil.queryAccountStepList(dynamicObjectsMap.values(), periodStartDate, periodEndDate);
            ArrayList tieSchemeList = Lists.newArrayListWithExpectedSize((int)16);
            for (Map.Entry entry : dynamicObjectsMap.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                tieSchemeList.add(AccountSchemeUtil.genAccountPlan(dynamicObject, accountStepList));
            }
            return tieSchemeList;
        }
        return Collections.emptyList();
    }

    private static List<DynamicObject> queryAccountStepList(Collection<DynamicObject> dynamicObjects, LocalDate fromDate, LocalDate toDate) {
        HashSet stepIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Set<Long> stepSet;
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)collection) || CollectionUtils.isEmpty(stepSet = AccountSchemeUtil.getStepIdSet(collection))) continue;
            stepIdSet.addAll(stepSet);
        }
        return AccountSchemeUtil.getStepDyList(stepIdSet, fromDate, toDate);
    }

    private static Set<Long> getStepIdSet(DynamicObjectCollection collection) {
        HashSet stepIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dyn : collection) {
            DynamicObjectCollection dynCollect = dyn.getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)dynCollect)) continue;
            stepIdSet.addAll(dynCollect.stream().map(ob -> ob.getLong("stepid.id")).collect(Collectors.toSet()));
        }
        return stepIdSet;
    }

    private static List<DynamicObject> getStepDyList(Set<Long> stepIdSet, LocalDate fromDate, LocalDate toDate) {
        QFilter idQFilter;
        if (CollectionUtils.isEmpty(stepIdSet)) {
            return Collections.emptyList();
        }
        Object[] qFilter = TimeSeqEntityGenerateUtils.getQueryCondition(fromDate, toDate);
        QFilter[] stepQFilter = (QFilter[])ArrayUtils.add((Object[])qFilter, (Object)(idQFilter = new QFilter("boid", "in", stepIdSet)));
        Map dynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)"wtp_accountsteps", (QFilter[])stepQFilter);
        if (dynamicObjectsMap == null || dynamicObjectsMap.size() == 0) {
            return Collections.emptyList();
        }
        return dynamicObjectsMap.values().stream().collect(Collectors.toList());
    }

    private static TieScheme genAccountPlan(DynamicObject dynamicObject, List<DynamicObject> accountStepList) {
        WTCPluginProxy wtcPluginProxy;
        ArrayList phaseDecisions = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList phaseProperties = Lists.newArrayListWithExpectedSize((int)16);
        TieScheme planProperties = (TieScheme)((TieScheme.Builder)((Object)((TieScheme.Builder)((Object)((TieScheme.Builder)((Object)TieScheme.withTimeSeq((TimeSeqInfo)new TimeSeqInfoImpl(dynamicObject.getLong("id"), dynamicObject.getLong("boid"), dynamicObject.getString("number"), WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsed")), WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsled")))).phaseDecisions(phaseDecisions))).phaseProperties(phaseProperties))).accountType(dynamicObject.getString("accountType")))).accountMode(dynamicObject.getString("accountmode")).build();
        DynamicObjectCollection phaseCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        if (phaseCollection == null) {
            return planProperties;
        }
        TieSchemeExt callBackDayParam = new TieSchemeExt();
        TieSchemeExt callBackTotalParam = new TieSchemeExt();
        if (planProperties.getBid() == PreDataAccountPlan.PD_1010_S.longValue() && (wtcPluginProxy = WTCPluginProxyFactory.create(TieSchemeExtPlugin.class, (String)TieSchemeExtPlugin.class.getName())).hasPlugin()) {
            wtcPluginProxy.invokeReplace(wtcPlugin -> {
                LOG.debug("\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u6784\u5efa\u57cb\u70b9\u6838\u7b97\u65b9\u6848\u4fe1\u606f\u6269\u5c55\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)wtcPlugin.getClass().getName());
                wtcPlugin.onBuildDailyChain(callBackDayParam);
                wtcPlugin.onBuildPeriodChain(callBackTotalParam);
            });
        }
        int phaseIndex = 0;
        boolean isElastictityOpen = WTCGrayscaleUtils.isElastictityOpen();
        for (DynamicObject phaseObject : phaseCollection) {
            if (phaseObject.getLong("phasetype.id") == PreDataAccountStageType.PD_1100_S.longValue() && !phaseObject.getBoolean("del") && callBackDayParam.getEvaluatorName() != null) {
                AccountSchemeUtil.doDayBuryPoint(callBackDayParam, phaseProperties, phaseDecisions, planProperties, phaseIndex);
                ++phaseIndex;
            }
            phaseDecisions.add(new DecisionConfig(AccountStageTypeEnum.from((Long)phaseObject.getLong("phasetype.id")).getPhaseCode(), TieStatus.EXCLUSION, AccountSchemeUtil.getTiePointer(phaseObject.getString("noreturnhandler"))));
            TiePhaseConfig tiePhase = AccountSchemeUtil.genTiePhase(planProperties, phaseObject, phaseIndex, accountStepList, isElastictityOpen);
            phaseProperties.add(tiePhase);
            ++phaseIndex;
        }
        if (callBackTotalParam.getEvaluatorName() != null) {
            AccountSchemeUtil.doTotalBuryPoint(callBackTotalParam, phaseProperties, phaseDecisions, planProperties);
        }
        return planProperties;
    }

    private static void doDayBuryPoint(TieSchemeExt callBackDayParam, List<TiePhaseConfig> phasePropertieList, List<DecisionConfig> phaseDecisions, TieScheme tieScheme, int index) {
        String evaluatorName = callBackDayParam.getEvaluatorName();
        if (evaluatorName != null) {
            phaseDecisions.add(new DecisionConfig(AccountPlanBuryPointUtil.getPointPhaseNum((boolean)true), TieStatus.EXCLUSION, TiePointer.CONTINUE));
            ArrayList<TimeSeqBo<TieStepConfig>> executorProperties = new ArrayList<TimeSeqBo<TieStepConfig>>();
            ArrayList executorDecisions = Lists.newArrayListWithExpectedSize((int)16);
            TiePhaseConfig phaseProperties = AccountSchemeUtil.getBuryPointTiePhaseConfig(index, tieScheme, executorDecisions, executorProperties, true);
            phasePropertieList.add(phaseProperties);
            executorDecisions.add(new DecisionConfig(AccountPlanBuryPointUtil.getPointStepNum((boolean)true), TieStatus.EXCLUSION, TiePointer.CONTINUE));
            List<TieStepConfig> tieStepConfigList = AccountSchemeUtil.getBuryPointTieStepConfigList(phaseProperties, true, callBackDayParam);
            if (!WTCCollections.isEmpty(tieStepConfigList)) {
                executorProperties.add((TimeSeqBo<TieStepConfig>)TimeSeqBo.ofMultiTimeSeq(tieStepConfigList));
            }
        }
    }

    private static void doTotalBuryPoint(TieSchemeExt callBackTotalParam, List<TiePhaseConfig> phasePropertieList, List<DecisionConfig> phaseDecisions, TieScheme tieScheme) {
        String evaluatorName = callBackTotalParam.getEvaluatorName();
        if (evaluatorName != null) {
            phaseDecisions.add(new DecisionConfig(AccountPlanBuryPointUtil.getPointPhaseNum((boolean)false), TieStatus.EXCLUSION, TiePointer.CONTINUE));
            ArrayList<TimeSeqBo<TieStepConfig>> executorProperties = new ArrayList<TimeSeqBo<TieStepConfig>>();
            ArrayList executorDecisions = Lists.newArrayListWithExpectedSize((int)16);
            TiePhaseConfig phaseProperties = AccountSchemeUtil.getBuryPointTiePhaseConfig(phasePropertieList.size(), tieScheme, executorDecisions, executorProperties, false);
            phasePropertieList.add(phaseProperties);
            executorDecisions.add(new DecisionConfig(AccountPlanBuryPointUtil.getPointStepNum((boolean)false), TieStatus.EXCLUSION, TiePointer.CONTINUE));
            List<TieStepConfig> tieStepConfigList = AccountSchemeUtil.getBuryPointTieStepConfigList(phaseProperties, false, callBackTotalParam);
            if (!WTCCollections.isEmpty(tieStepConfigList)) {
                executorProperties.add((TimeSeqBo<TieStepConfig>)TimeSeqBo.ofMultiTimeSeq(tieStepConfigList));
            }
        }
    }

    private static TiePhaseConfig getBuryPointTiePhaseConfig(int index, TieScheme tieScheme, List<DecisionConfig> executorDecisions, List<TimeSeqBo<TieStepConfig>> executorProperties, boolean isDayDetail) {
        return (TiePhaseConfig)((DetectableBuilder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)TiePhaseConfig.with().number(AccountPlanBuryPointUtil.getPointPhaseNum((boolean)isDayDetail))).name(AccountPlanBuryPointUtil.getPointPhaseName((boolean)isDayDetail))).executorDecision(executorDecisions)).executorProperties(executorProperties)).planProperties(tieScheme)).saveFlag(true)).result(TiePhaseRusultEnum.OVERROAD)).id(AccountPlanBuryPointUtil.getPointPhaseId((boolean)isDayDetail))).index(index)).delete(true)).phaseTypeId(AccountPlanBuryPointUtil.getPointPhaseId((boolean)isDayDetail))).build();
    }

    private static List<TieStepConfig> getBuryPointTieStepConfigList(TiePhaseConfig phaseProperties, boolean isDayDetail, TieSchemeExt callBackTotalParam) {
        ArrayList tieStepConfigList = Lists.newArrayListWithExpectedSize((int)16);
        TieStepConfig executorProperties = (TieStepConfig)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)TieStepConfig.withTimeSeq((TimeSeqInfo)new TimeSeqInfoImpl(AccountPlanBuryPointUtil.getPointStepId((boolean)isDayDetail).longValue(), AccountPlanBuryPointUtil.getPointStepId((boolean)isDayDetail).longValue(), AccountPlanBuryPointUtil.getPointStepNum((boolean)isDayDetail), WTCDateUtils.toLocalDate((Date)WTCHisServiceHelper.getMinEndDate()), WTCDateUtils.toLocalDate((Date)WTCHisServiceHelper.getMaxEndDate()))).tieUnitType(CalculRuleTypeEnum.CLASS.getValue()))).evaluatorName(callBackTotalParam.getEvaluatorName()))).name(AccountPlanBuryPointUtil.getPointStepName((boolean)isDayDetail)))).number(AccountPlanBuryPointUtil.getPointStepNum((boolean)isDayDetail)))).phaseProperties(phaseProperties))).stepEntryId(AccountPlanBuryPointUtil.getPointStepId((boolean)isDayDetail)).build();
        tieStepConfigList.add(executorProperties);
        return tieStepConfigList;
    }

    private static TiePointer getTiePointer(String hander) {
        TiePointer tiePointer;
        switch (hander) {
            case "0": {
                tiePointer = TiePointer.NEXT;
                break;
            }
            case "1": {
                tiePointer = TiePointer.CONTINUE;
                break;
            }
            case "2": {
                tiePointer = TiePointer.BREAK;
                break;
            }
            case "3": {
                tiePointer = TiePointer.TERMINATE;
                break;
            }
            case "4": {
                tiePointer = TiePointer.ERROR;
                break;
            }
            default: {
                tiePointer = TiePointer.ERROR;
            }
        }
        return tiePointer;
    }

    private static TiePhaseConfig genTiePhase(TieScheme planProperties, DynamicObject dynamicObject, int index, List<DynamicObject> accountStepList, boolean isElastictityOpen) {
        ArrayList<TimeSeqBo> executorProperties = new ArrayList<TimeSeqBo>();
        ArrayList executorDecisions = Lists.newArrayListWithExpectedSize((int)16);
        TiePhaseConfig phaseProperties = (TiePhaseConfig)((DetectableBuilder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)((TiePhaseConfig.Builder)TiePhaseConfig.with().number(AccountStageTypeEnum.from((Long)dynamicObject.getLong("phasetype.id")).getPhaseCode())).name(dynamicObject.getString("phasenamelang"))).executorDecision(executorDecisions)).executorProperties(executorProperties)).planProperties(planProperties)).saveFlag(dynamicObject.getBoolean("phasesave"))).result(TiePhaseRusultEnum.from((String)dynamicObject.getString("phaseresultdeal")))).id(dynamicObject.getLong("id"))).index(index)).delete(dynamicObject.getBoolean("del"))).phaseTypeId(dynamicObject.getLong("phasetype.id"))).build();
        DynamicObjectCollection stepCollect = dynamicObject.getDynamicObjectCollection("subentryentity");
        if (CollectionUtils.isEmpty((Collection)stepCollect)) {
            return phaseProperties;
        }
        for (DynamicObject stepObject : stepCollect) {
            List<DynamicObject> boidDys;
            DynamicObject dy = stepObject.getDynamicObject("stepid");
            if (dy == null || CollectionUtils.isEmpty(boidDys = accountStepList.stream().filter(ob -> ob.getLong("boid") == dy.getLong("id")).collect(Collectors.toList()))) continue;
            AccountStepEnum accountStepEnum = AccountStepEnum.from((Long)dy.getLong("id"));
            List<TieStepConfig> tieStepConfigList = AccountSchemeUtil.getTieStepConfigList(stepObject.getLong("id"), boidDys, phaseProperties, isElastictityOpen);
            if (CollectionUtils.isEmpty(tieStepConfigList)) continue;
            executorDecisions.add(new DecisionConfig(accountStepEnum == AccountStepEnum.UNKNOWN ? stepObject.getString("stepid.number") : accountStepEnum.getCode(), TieStatus.EXCLUSION, AccountSchemeUtil.getTiePointer(stepObject.getString("stepnoreturnhandler"))));
            executorProperties.add(TimeSeqBo.ofMultiTimeSeq(tieStepConfigList));
        }
        return phaseProperties;
    }

    private static List<TieStepConfig> getTieStepConfigList(Long stepEntryId, List<DynamicObject> boidDys, TiePhaseConfig phaseProperties, boolean isElastictityOpen) {
        ArrayList tieStepConfigList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dy : boidDys) {
            String tieUnitType = CalculRuleTypeEnum.from((String)dy.getString("calrule")).getValue();
            if (!isElastictityOpen && WTCGrayscaleUtils.ELASTIC_SET.contains(dy.getLong("boid"))) continue;
            String evaluatorName = null;
            DynamicObject calImpClassDy = dy.getDynamicObject("calimpclass");
            Long evaluatorId = null;
            if (calImpClassDy != null) {
                evaluatorName = calImpClassDy.getString("classpath");
                evaluatorId = calImpClassDy.getLong("id");
            }
            DynamicObject filterClass = dy.getDynamicObject("filtertrueclass");
            String filterName = null;
            if (filterClass != null) {
                filterName = filterClass.getString("classpath");
            }
            AccountStepEnum accountStepEnum = AccountStepEnum.from((Long)dy.getLong("boid"));
            TieStepConfig executorProperties = (TieStepConfig)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)((TieStepConfig.Builder)((Object)TieStepConfig.withTimeSeq((TimeSeqInfo)new TimeSeqInfoImpl(dy.getLong("id"), dy.getLong("boid"), accountStepEnum.getCode(), WTCDateUtils.toLocalDate((Date)dy.getDate("bsed")), WTCDateUtils.toLocalDate((Date)dy.getDate("bsled")))).tieUnitType(tieUnitType))).evaluatorName(evaluatorName))).evaluatorId(evaluatorId))).filterName(filterName))).name(dy.getString("name")))).number(dy.getString("number")))).phaseProperties(phaseProperties))).stepEntryId(stepEntryId).build();
            tieStepConfigList.add(executorProperties);
        }
        return tieStepConfigList;
    }
}

