/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.std.TieRequestStd;
import kd.wtc.wtes.business.util.Tuples;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;

public class AttCalTaskUtils {
    private static final Log logger = LogFactory.getLog(AttCalTaskUtils.class);
    private static final int MAX_RANGE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtes.tie.subject.maxRange", 3);
    private static final int MAX_ATT_FILE_BO_NUM = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtes.tie.subject.maxAttFileBoNum", 50);

    public static List<AttPersonRange> getAttPersonRangeNew(List<Long> attFileBoIds, Date startDate, Date endDate, TieRequestStd request) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)attFileBoIds.size());
        List<AttPersonRange> discardAttFileRanges = AttCalTaskUtils.discardAttFile(attFileBoIds, endDate);
        if (WTCCollections.isNotEmpty(discardAttFileRanges)) {
            result.addAll(discardAttFileRanges);
        }
        List attFileDyList = request.isCheckAuth() ? AttCalTaskUtils.getAuthAttPersonRange(attFileBoIds, endDate) : WTCAttFileService.queryAttFilesByAttFileBoIdsWithOutAuthCheck(attFileBoIds, (Date)endDate);
        Map<Long, List<DynamicObject>> boId2VersionMap = attFileDyList.stream().collect(Collectors.groupingBy(e -> e.getLong("boid")));
        if (request.isCheckAuth()) {
            List haveAuthList;
            List notContainsBoIds = attFileBoIds.stream().filter(boId -> !boId2VersionMap.containsKey(boId)).collect(Collectors.toList());
            if (logger.isDebugEnabled()) {
                logger.debug("AttCalTaskUtils.getAttPersonRangeNew notContainsBoIds:{}", (Object)JSONObject.toJSONString(notContainsBoIds));
            }
            if (!notContainsBoIds.isEmpty() && WTCCollections.isNotEmpty((Collection)(haveAuthList = WTCAttFileService.queryAttFilesByAttFileBoIdsWithOutAuthCheck(notContainsBoIds, (Date)endDate)))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("AttCalTaskUtils.getAttPersonRangeNew haveAuthList.size:{}", (Object)haveAuthList.size());
                }
                for (DynamicObject dy : haveAuthList) {
                    AttPersonRange range = AttCalTaskUtils.getAttPersonRange(dy, Boolean.FALSE, ValiteKDStringUtil.noAttFileAuth());
                    result.add(range);
                }
            }
        }
        if (WTCCollections.isEmpty(boId2VersionMap)) {
            return result;
        }
        for (Map.Entry<Long, List<DynamicObject>> attFileBoEntry : boId2VersionMap.entrySet()) {
            DynamicObject dynamicObject = attFileBoEntry.getValue().get(0);
            Date attFileStartDate = dynamicObject.getDate("startdate");
            Date attFileEndDate = dynamicObject.getDate("enddate");
            Object info = dynamicObject.get("wtteinfo");
            Date calculateTo = null;
            Date reCalDate = null;
            Date lockTo = null;
            if (!HRObjectUtils.isEmpty((Object)info)) {
                reCalDate = dynamicObject.getDate("wtteinfo.allowreaccounttime");
                lockTo = dynamicObject.getDate("wtteinfo.lockto");
                calculateTo = dynamicObject.getDate("wtteinfo.accountto");
            }
            if (startDate == null && calculateTo == null && reCalDate == null && lockTo == null) {
                AttPersonRange range = AttCalTaskUtils.getAttPersonRange(dynamicObject, Boolean.FALSE, ValiteKDStringUtil.allowReAccountTimeErr());
                result.add(range);
                continue;
            }
            Tuples.Tuple2<Date, Date> dateDateTuple = AttCalTaskUtils.genRealCalRange(calculateTo, reCalDate, lockTo, startDate, endDate, attFileStartDate, attFileEndDate);
            Date realStartDate = (Date)dateDateTuple.item1;
            Date realEndDate = (Date)dateDateTuple.item2;
            if (attFileBoIds.size() > MAX_ATT_FILE_BO_NUM && WTCDateUtils.getCustomMouth((Date)realStartDate, (Integer)MAX_RANGE).before(realEndDate)) {
                AttPersonRange range = AttCalTaskUtils.getAttPersonRange(dynamicObject, Boolean.FALSE, ValiteKDStringUtil.attRangeOverErr(WTCDateUtils.date2Str((Date)realStartDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)realEndDate, (String)"yyyy-MM-dd")));
                result.add(range);
                continue;
            }
            if (realStartDate.after(realEndDate)) {
                StringBuilder errMsg = AttCalTaskUtils.genErrMsg(calculateTo, reCalDate, lockTo, startDate, endDate, attFileStartDate, attFileEndDate, dateDateTuple);
                if (HRStringUtils.isEmpty((String)errMsg.toString())) {
                    errMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u81f4\u4f7f\u63a8\u7b97\u6838\u7b97\u5f00\u59cb\u65e5{0}\u665a\u4e8e\u63a8\u7b97\u6838\u7b97\u7ed3\u675f\u65e5{1}\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AttCalTaskUtils_error_09", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)realStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)realEndDate)}));
                }
                AttPersonRange range = AttCalTaskUtils.getAttPersonRange(dynamicObject, Boolean.FALSE, errMsg.toString());
                result.add(range);
                continue;
            }
            List<DynamicObject> fileBoEntryValue = attFileBoEntry.getValue();
            for (DynamicObject dy : fileBoEntryValue) {
                Date attFileEffect = dy.getDate("bsed");
                Date attFileEnd = dy.getDate("bsled");
                if (logger.isDebugEnabled()) {
                    logger.debug("attFileEffect:{}, attFileEnd:{}, realStartDate:{}, realEndDate:{}", new Object[]{WTCDateUtils.date2Str((Date)attFileEffect, (String)"yyyy-MM-dd HH:mm:ss"), WTCDateUtils.date2Str((Date)attFileEnd, (String)"yyyy-MM-dd HH:mm:ss"), WTCDateUtils.date2Str((Date)realStartDate, (String)"yyyy-MM-dd HH:mm:ss"), WTCDateUtils.date2Str((Date)realEndDate, (String)"yyyy-MM-dd HH:mm:ss")});
                }
                if (attFileEffect.getTime() > realEndDate.getTime() || attFileEnd.getTime() < realStartDate.getTime()) {
                    AttPersonRange range = AttCalTaskUtils.getAttPersonRange(dy, Boolean.FALSE, ValiteKDStringUtil.notNeedCal());
                    result.add(range);
                    continue;
                }
                Date attFileVersionStartDate = attFileEffect.after(realStartDate) ? attFileEffect : realStartDate;
                Date attFileVersionEndDate = attFileEnd.after(realEndDate) ? realEndDate : attFileEnd;
                AttPersonRange range = new AttPersonRange();
                range.setPersonId(dy.getLong("attperson.id"));
                range.setAttFileBaseId(dy.getLong("id"));
                range.setAttFileBaseBoId(dy.getLong("boid"));
                range.setLegal(Boolean.TRUE);
                range.setStartDate(attFileVersionStartDate);
                range.setEndDate(attFileVersionEndDate);
                range.buildCurCalDate(dynamicObject);
                result.add(range);
            }
        }
        return result;
    }

    private static AttPersonRange getAttPersonRange(DynamicObject dynamicObject, Boolean legal, String message) {
        AttPersonRange range = new AttPersonRange();
        range.setAttFileBaseId(dynamicObject.getLong("id"));
        range.setPersonId(dynamicObject.getLong("attperson.id"));
        range.setAttFileBaseBoId(dynamicObject.getLong("boid"));
        range.setStartDate(dynamicObject.getDate("bsed"));
        range.setEndDate(dynamicObject.getDate("bsled"));
        range.buildCurCalDate(dynamicObject);
        range.setLegal(legal);
        range.setMessage(message);
        return range;
    }

    private static List<DynamicObject> getAuthAttPersonRange(List<Long> attFileBoIds, Date endDate) {
        logger.debug("AttCalTaskUtils.getAuthAttPersonRange,endDate={}", (Object)endDate);
        List allAttFileDyList = WTCAttFileService.queryAttFilesByAttFileBoIdsWithOutAuthCheck(attFileBoIds, (Date)endDate);
        if (CollectionUtils.isEmpty((Collection)allAttFileDyList)) {
            return allAttFileDyList;
        }
        Set mayNeedTieFileIdSet = allAttFileDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Date minDate = allAttFileDyList.stream().map(dy -> dy.getDate("bsed")).distinct().sorted().findFirst().get();
        Date maxDate = allAttFileDyList.stream().map(dy -> dy.getDate("bsled")).max(Comparator.comparing(Date::getTime)).get();
        PerAttPeriodQueryServiceImpl instance = PerAttPeriodQueryServiceImpl.getInstance();
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(new HashSet<Long>(attFileBoIds));
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        logger.debug("AttCalTaskUtils.getAuthAttPersonRange getPerAttPeriodReport minDate={}, maxDate={}", (Object)minDate, (Object)maxDate);
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttFileBoIdSet(new HashSet<Long>(attFileBoIds));
        queryParam.setStartDate(minDate);
        queryParam.setEndDate(maxDate);
        List perAttPeriodReportList = instance.queryPerAttPeriodEntity(queryParam);
        Set<Long> tieRangeAttFileDy = AttCalTaskUtils.getTieRangeAttFileDy(allAttFileDyList, perAttPeriodReportList);
        if (logger.isDebugEnabled()) {
            logger.debug("AttCalTaskUtils.getAuthAttPersonRange getPerAttPeriodReport tieRangeAttFileDy:{},mayNeedTieFileIdSet;{}", (Object)tieRangeAttFileDy.toString(), mayNeedTieFileIdSet);
        }
        mayNeedTieFileIdSet.retainAll(tieRangeAttFileDy);
        return allAttFileDyList.stream().filter(dy -> mayNeedTieFileIdSet.contains(dy.getLong("id"))).collect(Collectors.toList());
    }

    private static Set<Long> getTieRangeAttFileDy(List<DynamicObject> allAttFileDyList, List<PerAttPeriod> perAttPeriodReportList) {
        if (logger.isDebugEnabled()) {
            logger.debug("AttCalTaskUtils.getTieRangeAttFileDy,perAttPeriodReportList={} ", (Object)JSON.toJSONString(perAttPeriodReportList));
        }
        Map<Long, List<PerAttPeriod>> map = perAttPeriodReportList.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
        HashMap attPeriodToFileIdListMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<Long> fileIds = new ArrayList<Long>();
        ArrayList<Long> withoutPeriodIdList = new ArrayList<Long>();
        for (DynamicObject fileVersionDy : allAttFileDyList) {
            long fileBoId = fileVersionDy.getLong("boid");
            long fileId = fileVersionDy.getLong("id");
            Date bsed = fileVersionDy.getDate("bsed");
            Date bsled = fileVersionDy.getDate("bsled");
            Map longSetMap = attPeriodToFileIdListMap.computeIfAbsent(fileBoId, k -> new HashMap());
            List<PerAttPeriod> list = map.get(fileBoId);
            if (CollectionUtils.isEmpty(list)) {
                fileIds.add(fileId);
                withoutPeriodIdList.add(fileId);
                continue;
            }
            for (PerAttPeriod report : list) {
                boolean hasIntersection;
                boolean bl = hasIntersection = report.getPerAttBeginDate() != null && report.getPerAttEndDate() != null && WTCDateUtils.hasIntersectionLCRC((Date)report.getPerAttBeginDate(), (Date)report.getPerAttEndDate(), (Date)bsed, (Date)bsled);
                if (report.getFileId() != fileId && !hasIntersection) continue;
                Long attPeriodId = report.getAttPeriodId();
                HashSet<Long> set = (HashSet<Long>)longSetMap.get(attPeriodId);
                if (CollectionUtils.isEmpty((Collection)set)) {
                    set = new HashSet<Long>();
                    longSetMap.put(attPeriodId, set);
                }
                set.add(fileId);
                fileIds.add(fileId);
            }
        }
        AttFileQueryParam param = new AttFileQueryParam();
        param.setProperties(AttFileQueryParam.attCalProperties);
        param.setAuthCheck(Boolean.FALSE);
        QFilter filter = new QFilter("id", "in", fileIds);
        filter.and(WTCAttFileService.getPermRuleQFilter());
        param.setqFilter(filter);
        List dynamicObjectList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        Set hasAuthFileIdSet = dynamicObjectList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet needTieFileIdSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry mapEntry : attPeriodToFileIdListMap.entrySet()) {
            block3: for (Map.Entry entry : ((Map)mapEntry.getValue()).entrySet()) {
                Set value = (Set)entry.getValue();
                for (Long fileId : value) {
                    if (!hasAuthFileIdSet.contains(fileId)) continue;
                    needTieFileIdSet.addAll(value);
                    continue block3;
                }
            }
        }
        if (!CollectionUtils.isEmpty(withoutPeriodIdList)) {
            for (Long fileId : withoutPeriodIdList) {
                if (!hasAuthFileIdSet.contains(fileId)) continue;
                needTieFileIdSet.add(fileId);
            }
        }
        return needTieFileIdSet;
    }

    private static StringBuilder genErrMsg(Date calculateTo, Date reCalDate, Date lockTo, Date startDate, Date endDate, Date attFileStartDate, Date attFileEndDate, Tuples.Tuple2<Date, Date> dateDateTuple) {
        Date realStartDate = (Date)dateDateTuple.item1;
        Date realEndDate = (Date)dateDateTuple.item2;
        logger.debug("realStartDate={},realEndDate={},calculateTo={}, reCalDate={},lockTo={},startDate={},endDate={}", new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)realStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)realEndDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calculateTo), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)reCalDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)lockTo), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate)});
        if (realEndDate.equals(endDate)) {
            return AttCalTaskUtils.geneEndDateErrMsg(calculateTo, reCalDate, lockTo, startDate, realStartDate, attFileStartDate);
        }
        if (realEndDate.equals(attFileEndDate)) {
            return AttCalTaskUtils.geneAttFileEndDateErrMsg(calculateTo, reCalDate, lockTo, startDate, endDate, realStartDate, attFileStartDate, attFileEndDate);
        }
        return new StringBuilder();
    }

    private static StringBuilder geneAttFileEndDateErrMsg(Date calculateTo, Date reCalDate, Date lockTo, Date startDate, Date endDate, Date realStartDate, Date attFileStartDate, Date attFileEndDate) {
        StringBuilder errMsg = new StringBuilder();
        Date calculateToAddOne = WTCDateUtils.addDays((Date)calculateTo, (int)1);
        Date lockToAddOne = WTCDateUtils.addDays((Date)lockTo, (int)1);
        if (realStartDate.equals(startDate)) {
            errMsg.append(ResManager.loadKDString((String)"\u6863\u6848\u7ed3\u675f\u65e5\u671f\u4e3a{0}\uff0c\u5728\u6b64\u4e4b\u540e\u7684\u65e5\u671f\u65e0\u6cd5\u6838\u7b97\uff0c\u8bf7\u6838\u7b97\u6863\u6848\u7ed3\u675f\u4e4b\u524d\u7684\u65e5\u671f\u3002", (String)"AttCalTaskUtils_error_06", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileEndDate)}));
            return errMsg;
        }
        if (realStartDate.equals(calculateToAddOne)) {
            if (startDate == null) {
                errMsg.append(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6838\u7b97\u5f00\u59cb\u65e5\u671f\uff0c\u4e14\u6838\u7b97\u7ed3\u675f\u65e5\u671f{0}\u665a\u4e8e\u6863\u6848\u7ed3\u675f\u65e5\u671f{1}\uff0c\u8bf7\u6307\u5b9a\u6838\u7b97\u5f00\u59cb\u65e5\u671f\u3002", (String)"AttCalTaskUtils_error_05", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileEndDate)}));
                return errMsg;
            }
            errMsg.append(ResManager.loadKDString((String)"\u6863\u6848\u7ed3\u675f\u65e5\u671f\u4e3a{0}\uff0c\u5728\u6b64\u4e4b\u540e\u7684\u65e5\u671f\u65e0\u6cd5\u6838\u7b97\uff0c\u8bf7\u6838\u7b97\u6863\u6848\u7ed3\u675f\u4e4b\u524d\u7684\u65e5\u671f\u3002", (String)"AttCalTaskUtils_error_06", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileEndDate)}));
            return errMsg;
        }
        if (realStartDate.equals(lockToAddOne)) {
            errMsg.append(ResManager.loadKDString((String)"\u6863\u6848\u5f00\u59cb\u65e5\u671f{0}\u81f3\u6863\u6848\u7ed3\u675f\u65e5\u671f{1}\u5df2\u5168\u90e8\u88ab\u9501\u5b9a\uff0c\u8bf7\u5148\u89e3\u9501\u518d\u91cd\u7b97\u3002", (String)"AttCalTaskUtils_error_07", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileEndDate)}));
            return errMsg;
        }
        if (realStartDate.equals(reCalDate)) {
            errMsg.append(ResManager.loadKDString((String)"\u6863\u6848\u6700\u65e9\u5141\u8bb8\u91cd\u7b97\u65e5\u671f{0}\u665a\u4e8e\u6863\u6848\u7ed3\u675f\u65e5\u671f{1}\uff0c\u8bf7\u8c03\u6574\u6863\u6848\u6700\u65e9\u5141\u8bb8\u91cd\u7b97\u65e5\u671f\u3002", (String)"AttCalTaskUtils_error_08", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)reCalDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileEndDate)}));
            return errMsg;
        }
        return errMsg;
    }

    private static StringBuilder geneEndDateErrMsg(Date calculateTo, Date reCalDate, Date lockTo, Date startDate, Date realStartDate, Date attFileStartDate) {
        StringBuilder errMsg = new StringBuilder();
        Date calculateToAddOne = WTCDateUtils.addDays((Date)calculateTo, (int)1);
        Date lockToAddOne = WTCDateUtils.addDays((Date)lockTo, (int)1);
        if (startDate == null && realStartDate.equals(calculateToAddOne)) {
            errMsg.append(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6838\u7b97\u5f00\u59cb\u65e5\u671f\uff0c\u5df2\u6838\u7b97\u7684\u65e5\u671f\u65e0\u6cd5\u6838\u7b97\uff0c\u8be5\u6863\u6848\u5df2\u6838\u7b97\u81f3{0}\uff0c\u8bf7\u6307\u5b9a\u6838\u7b97\u5f00\u59cb\u65e5\u671f\u3002", (String)"AttCalTaskUtils_error_01", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calculateTo)}));
            return errMsg;
        }
        if (realStartDate.equals(lockToAddOne)) {
            errMsg.append(ResManager.loadKDString((String)"\u5df2\u9501\u5b9a\u81f3{0}\uff0c\u5728\u6b64\u4e4b\u524d\u7684\u65e5\u671f\u65e0\u6cd5\u6838\u7b97\uff0c\u8bf7\u4ece\u9501\u5b9a\u65e5\u671f\u4e4b\u540e\u8fdb\u884c\u8003\u52e4\u6838\u7b97\u3002", (String)"AttCalTaskUtils_error_02", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)lockTo)}));
            return errMsg;
        }
        if (realStartDate.equals(reCalDate)) {
            errMsg.append(ResManager.loadKDString((String)"\u6863\u6848\u6700\u65e9\u5141\u8bb8\u91cd\u7b97\u65e5\u671f\u4e3a{0}\uff0c\u5728\u6b64\u4e4b\u524d\u7684\u65e5\u671f\u65e0\u6cd5\u6838\u7b97\uff0c\u8bf7\u4ece\u6863\u6848\u6700\u65e9\u5141\u8bb8\u91cd\u7b97\u65e5\u671f\u6216\u4e4b\u540e\u5f00\u59cb\u8fdb\u884c\u8003\u52e4\u6838\u7b97\u3002", (String)"AttCalTaskUtils_error_03", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)reCalDate)}));
            return errMsg;
        }
        if (realStartDate.equals(attFileStartDate)) {
            errMsg.append(ResManager.loadKDString((String)"\u6863\u6848\u5f00\u59cb\u65e5\u671f\u4e3a{0}\uff0c\u5728\u6b64\u4e4b\u524d\u7684\u65e5\u671f\u65e0\u6cd5\u6838\u7b97\uff0c\u8bf7\u4ece\u6863\u6848\u5f00\u59cb\u65e5\u671f\u6216\u4e4b\u540e\u5f00\u59cb\u8fdb\u884c\u8003\u52e4\u6838\u7b97\u3002", (String)"AttCalTaskUtils_error_04", (String)"wtc-wtes-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attFileStartDate)}));
            return errMsg;
        }
        return errMsg;
    }

    private static Tuples.Tuple2<Date, Date> genRealCalRange(Date calculateTo, Date reCalDate, Date lockTo, Date startDate, Date endDate, Date attFileStartDate, Date attFileEndDate) {
        long maxStart = 0L;
        if (startDate != null) {
            maxStart = startDate.getTime();
            if (calculateTo != null) {
                maxStart = Math.min(maxStart, WTCDateUtils.addDays((Date)calculateTo, (int)1).getTime());
            } else if (attFileStartDate != null) {
                maxStart = Math.min(maxStart, attFileStartDate.getTime());
            }
        } else if (calculateTo != null) {
            maxStart = WTCDateUtils.addDays((Date)calculateTo, (int)1).getTime();
        }
        if (lockTo != null) {
            maxStart = Math.max(WTCDateUtils.addDays((Date)lockTo, (int)1).getTime(), maxStart);
        }
        if (attFileStartDate != null) {
            maxStart = Math.max(attFileStartDate.getTime(), maxStart);
        }
        if (reCalDate != null) {
            maxStart = Math.max(reCalDate.getTime(), maxStart);
        }
        Date realStartDate = new Date(maxStart);
        long maxEnd = Math.min(attFileEndDate.getTime(), endDate.getTime());
        Date realEndDate = new Date(maxEnd);
        return new Tuples.Tuple2<Date, Date>(realStartDate, realEndDate);
    }

    public static List<AttPersonRange> getAttPersonRangeForBill(List<Long> personIds, Date startDate, Date endDate, TieRequestStd request) {
        ArrayList<AttPersonRange> result = new ArrayList<AttPersonRange>(CollectionUtils.isEmpty(personIds) ? 16 : personIds.size());
        DynamicObjectCollection list = WTCAttFileService.queryAttFilesWithOutAuthCheck(personIds, (Date)startDate, (Date)endDate);
        for (DynamicObject dy : list) {
            AttPersonRange range = new AttPersonRange();
            long personId = dy.getLong("attperson.id");
            range.setPersonId(personId);
            range.setAttFileBaseId(dy.getLong("id"));
            range.setAttFileBaseBoId(dy.getLong("boid"));
            Date attFileEffect = dy.getDate("bsed");
            Date attFileEnd = dy.getDate("bsled");
            long start = Math.max(attFileEffect.getTime(), startDate.getTime());
            long end = Math.min(attFileEnd.getTime(), endDate.getTime());
            range.setStartDate(new Date(start));
            range.setEndDate(new Date(end));
            Date fileEndDate = dy.getDate("enddate");
            if (fileEndDate.compareTo(range.getStartDate()) < 0) {
                logger.warn("fileEndDate [{}] is before startDate [{}]", (Object)fileEndDate, (Object)range.getStartDate());
                continue;
            }
            if (fileEndDate.compareTo(range.getEndDate()) < 0) {
                range.setEndDate(fileEndDate);
            }
            if (range.getStartDate().compareTo(range.getEndDate()) > 0) {
                logger.warn("realStartDate [{}] is after realEndDate [{}]", (Object)range.getStartDate(), (Object)range.getEndDate());
                continue;
            }
            result.add(range);
        }
        return result;
    }

    private static List<AttPersonRange> discardAttFile(List<Long> attFileBoIds, Date endDate) {
        List discardAttFiles = WTCAttFileService.queryDiscardAttFilesByAttFileBoIds(attFileBoIds, (Date)endDate);
        if (WTCCollections.isNotEmpty((Collection)discardAttFiles)) {
            Map<Long, List<DynamicObject>> attFile = discardAttFiles.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
            ArrayList result = Lists.newArrayListWithExpectedSize((int)attFileBoIds.size());
            for (Map.Entry<Long, List<DynamicObject>> entry : attFile.entrySet()) {
                DynamicObject dynamicObject = entry.getValue().get(0);
                AttPersonRange range = AttCalTaskUtils.getAttPersonRange(dynamicObject, Boolean.FALSE, ValiteKDStringUtil.discardAttFile());
                result.add(range);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

