/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.wtc.wtes.business.tie.init.attitemspec.OnQueryInitParamOfAttItemSpecEvent;
import kd.sdk.wtc.wtes.business.tie.init.attitemspec.TieInitAttItemSpecExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.ext.utils.TieInitExtUtil;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttItemSpecUtil {
    private static Log logger = LogFactory.getLog(AttItemSpecUtil.class);
    private static final String WTBD_ATTITEM = "wtbd_attitem";
    private static final String ATTRECORD_ATTITEMID = "attitemid";

    public static List<AttItemSpec> listValidHisVersionsInRangeDate(LocalDate fromDate, LocalDate toDate) {
        List<AttItemSpec> attItemSpecList = AttItemSpecUtil.listAttItemSpec(WTBD_ATTITEM, fromDate, toDate, Boolean.TRUE, null);
        return CollectionUtils.isEmpty(attItemSpecList) ? Collections.emptyList() : attItemSpecList;
    }

    private static AttItemSpec getAttItemSpecEntity(DynamicObject dynamicObject, Boolean isTimeSeq) {
        if (isTimeSeq.booleanValue()) {
            TimeSeqInfoImpl timeSeqEntity = AttItemSpecUtil.getTimeSeqEntity(dynamicObject);
            return AttItemSpecUtil.builtAttItemSpecEntity(dynamicObject, AttItemSpec.withTimeSeq((TimeSeqInfo)timeSeqEntity));
        }
        return AttItemSpecUtil.builtAttItemSpecEntity(dynamicObject, AttItemSpec.withNonTimeSeq(0L, ""));
    }

    private static AttItemSpec builtAttItemSpecEntity(DynamicObject dynamicObject, AttItemSpec.Builder<?, ?> builter) {
        return (AttItemSpec)((AttItemSpec.Builder)((Object)((AttItemSpec.Builder)((Object)((AttItemSpec.Builder)((Object)((AttItemSpec.Builder)((Object)((AttItemSpec.Builder)((AttItemSpec.Builder)((AttItemSpec.Builder)((Object)builter.dataAccuracy(dynamicObject.getInt("dataaccuracy")))).dataType(DataType.of(dynamicObject.getString("datatype"))).id(dynamicObject.getLong("id"))).itemType(dynamicObject.getString("itemtype")).number(dynamicObject.getString("number"))).originalItem(dynamicObject.getBoolean("isorginattitem")))).persistence(dynamicObject.getBoolean("issave")))).precisionTail(dynamicObject.getString("precisiontail")))).unit(dynamicObject.getString("unit")))).name(dynamicObject.getLocaleString("name").getLocaleValue()).build();
    }

    private static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject dynamicObject) {
        LocalDate bsled = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsled"));
        LocalDate bsed = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsed"));
        return (TimeSeqInfoImpl)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().blsed(bsled).bsed(bsed).number(dynamicObject.getString("number"))).id(dynamicObject.getLong("id"))).bid(dynamicObject.getLong("boid")).build();
    }

    private static List<AttItemSpec> listAttItemSpec(String entityName, LocalDate fromDate, LocalDate toDate, Boolean isTimeSeq, List<Long> bidList) {
        ArrayList<AttItemSpec> attItemSpecList = new ArrayList<AttItemSpec>();
        QFilter[] qFilter = isTimeSeq != false ? TimeSeqEntityGenerateUtils.getQueryCondition(fromDate, toDate) : AttItemSpecUtil.getPrecutQueryCondition(fromDate, toDate, bidList);
        HashSet extKeys = Sets.newHashSetWithExpectedSize((int)16);
        Set<String> propertiesSet = AttItemSpecUtil.getDefaultPropertied();
        AttItemSpecUtil.invokeAttItemSpecInitExtPlugin(extKeys, propertiesSet);
        Map map = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)WTCStringUtils.join(new ArrayList<String>(propertiesSet), (String)","), (QFilter[])qFilter);
        if (map != null && map.size() > 0) {
            for (Map.Entry entrySet : map.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entrySet.getValue();
                AttItemSpec attItemSpec = AttItemSpecUtil.getAttItemSpecEntity(dynamicObject, isTimeSeq);
                attItemSpec.setExtAttribute(TieInitExtUtil.buildDataAttribute(dynamicObject, extKeys));
                attItemSpecList.add(attItemSpec);
            }
        }
        return attItemSpecList;
    }

    private static QFilter[] getPrecutQueryCondition(LocalDate fromDate, LocalDate toDate, List<Long> bidList) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter[] queryCondition = TimeSeqEntityGenerateUtils.getQueryCondition(fromDate, toDate);
        qFilters.addAll(Arrays.asList(queryCondition));
        QFilter notHisFilter = new QFilter("id", "not in", bidList);
        qFilters.add(notHisFilter);
        return qFilters.toArray(new QFilter[0]);
    }

    private static void invokeAttItemSpecInitExtPlugin(Set<String> extKeys, Set<String> propertiesSet) {
        WTCPluginProxy tieInitParamExtPluginProxy = WTCPluginProxyFactory.create(TieInitAttItemSpecExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.attitemspec.TieInitAttItemSpecExtPlugin");
        tieInitParamExtPluginProxy.invokeReplace(plugin -> {
            OnQueryInitParamOfAttItemSpecEvent event = new OnQueryInitParamOfAttItemSpecEvent();
            plugin.onQueryAttItemSpec(event);
            if (WTCCollections.isNotEmpty((Collection)event.getExtKeys())) {
                extKeys.addAll(event.getExtKeys());
                propertiesSet.addAll(event.getExtKeys());
            }
        });
    }

    private static Set<String> getDefaultPropertied() {
        HashSet<String> propertied = new HashSet<String>(30);
        propertied.add("entryentity.attitemid");
        propertied.add("dataaccuracy");
        propertied.add("datatype");
        propertied.add("id");
        propertied.add("itemtype");
        propertied.add("number");
        propertied.add("isorginattitem");
        propertied.add("issave");
        propertied.add("precisiontail");
        propertied.add("isnewbo");
        propertied.add("boid");
        propertied.add("datastatus");
        propertied.add("unit");
        propertied.add("bsled");
        propertied.add("bsed");
        propertied.add("name");
        return propertied;
    }
}

