/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.retrieval.service.RetrievalAttFileDateDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchService;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchType;
import kd.wtc.wtbd.business.retrieval.service.RetrievalService;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.retrieval.RetrievalTypeEnum;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.OtAttPackage;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.retrieval.BillRetrievalDimensionResult;
import kd.wtc.wtes.business.model.retrieval.BillRetrievalResult;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalConfig;
import kd.wtc.wtes.business.model.rlotcal.OtRulePackage;
import kd.wtc.wtes.business.model.rlotcal.TimeCut;
import kd.wtc.wtes.business.model.rlotcal.TimeCutConfig;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.common.lang.WtesBizException;

public class BillTieRetrievalUtil {
    private static final Log LOG = LogFactory.getLog(BillTieRetrievalUtil.class);
    private LocalDate chainStartDate;
    private LocalDate chainEndDate;
    private AttFileCabinet attFileCabinet;
    private Map<Long, Map<LocalDate, List<AttBillTimeBucket>>> attPersonId2DailyBtb;
    private Map<String, List<RetrievalRuleMatchDimension>> matchDimensionsMap = Maps.newHashMapWithExpectedSize((int)16);
    private Set<String> billItemUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
    private Set<String> timeCutUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
    private BillRetrievalResult billRetrievalResult = new BillRetrievalResult(null);
    Set<Long> otRuleIds = Sets.newHashSetWithExpectedSize((int)16);
    Set<Long> timeCutIds = Sets.newHashSetWithExpectedSize((int)16);

    public static Set<BillRetrievalDimensionResult> getBillRetrievalResultOfDate(TieContextStd context, boolean isDirectSetRule, OtRulePackage ruleConfig) {
        BillRetrievalResult retrievalResult = (BillRetrievalResult)context.getInitParam("RETRIEVEL");
        Set<BillRetrievalDimensionResult> result = new HashSet<BillRetrievalDimensionResult>(0);
        long attPersonId = context.getAttPersonId();
        LocalDate chainDate = context.getChainDate();
        if (isDirectSetRule) {
            if (retrievalResult != null) {
                result = retrievalResult.getByPersonAndDate(attPersonId, chainDate);
            }
        } else if (ruleConfig != null) {
            boolean containsRuleId = false;
            if (retrievalResult != null) {
                long ruleId = ruleConfig.getTimeSeqInfo().getVid();
                containsRuleId = retrievalResult.containsOtRuleId(ruleId);
            }
            if (containsRuleId) {
                result = retrievalResult.getByPersonAndDate(attPersonId, chainDate);
            } else {
                List<OtRuleCalConfig> otRuleCalConfigList = ruleConfig.getOtRuleCalConfigList();
                if (WTCCollections.isNotEmpty(otRuleCalConfigList)) {
                    AttBillTimeBucketData attBillTimeBucketData;
                    BillTieRetrievalUtil billTieRetrievalUtil = new BillTieRetrievalUtil();
                    for (OtRuleCalConfig otRuleCalConfig : otRuleCalConfigList) {
                        billTieRetrievalUtil.billItemUniqueCodes.addAll(billTieRetrievalUtil.getConfigRetrievalItemCode(otRuleCalConfig.getDateConditionAccessDto()));
                        billTieRetrievalUtil.billItemUniqueCodes.addAll(billTieRetrievalUtil.getConfigRetrievalItemCode(otRuleCalConfig.getLimitConditionAccessDto()));
                    }
                    if (WTCCollections.isNotEmpty(billTieRetrievalUtil.billItemUniqueCodes) && (attBillTimeBucketData = (AttBillTimeBucketData)context.getInitParams().get("BILL_TIME_BUCKET")) != null) {
                        billTieRetrievalUtil.attPersonId2DailyBtb = attBillTimeBucketData.getAttPersonId2DailyBtb();
                        if (WTCCollections.isEmpty(billTieRetrievalUtil.attPersonId2DailyBtb)) {
                            billTieRetrievalUtil.attPersonId2DailyBtb = new HashMap<Long, Map<LocalDate, List<AttBillTimeBucket>>>(0);
                        }
                        List<AttBillTimeBucket> billTimeBuckets = attBillTimeBucketData.getBillTimeBuckets(attPersonId, chainDate);
                        List<AttBillTimeBucket> timeBucketList = billTimeBuckets.stream().filter(item -> "OT".equals(item.getBillTypeBig())).collect(Collectors.toList());
                        billTieRetrievalUtil.attFileCabinet = (AttFileCabinet)context.getInitParams().get("ATT_FILE");
                        AttFileModel attFileModel = billTieRetrievalUtil.attFileCabinet.getByAttPersonIdAndDate(attPersonId, chainDate);
                        if (WTCCollections.isNotEmpty(timeBucketList) && attFileModel != null) {
                            billTieRetrievalUtil.initOtRetrievalDimension(timeBucketList, attFileModel, chainDate);
                            Map<String, RetrievalRuleMatchDimension> matchDimensionMap = billTieRetrievalUtil.beginRetrieval();
                            Set<BillRetrievalDimensionResult> billRetrievalResults = billTieRetrievalUtil.handleOtRetrievalResult(matchDimensionMap);
                            if (retrievalResult == null) {
                                retrievalResult = new BillRetrievalResult(null);
                            }
                            retrievalResult.addBillRetrievalResult(billRetrievalResults);
                            result = retrievalResult.getByPersonAndDate(attPersonId, chainDate);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static Tuples.Tuple3<BillRetrievalDimensionResult, BillRetrievalDimensionResult, BillRetrievalDimensionResult> getTimeCutRetrievalResultOfDate(TieContextStd context, boolean isDirectSetRule, TimeCut timeCut) {
        Tuples.Tuple3<BillRetrievalDimensionResult, BillRetrievalDimensionResult, BillRetrievalDimensionResult> tuple3 = new Tuples.Tuple3<BillRetrievalDimensionResult, BillRetrievalDimensionResult, BillRetrievalDimensionResult>(null, null, null);
        BillRetrievalResult retrievalResult = (BillRetrievalResult)context.getInitParam("RETRIEVEL");
        if (isDirectSetRule) {
            if (retrievalResult != null) {
                tuple3 = BillTieRetrievalUtil.getTimeCutRetrievalResultOfDate(context, retrievalResult);
            }
        } else if (timeCut != null) {
            boolean containsTimeCutId = false;
            if (retrievalResult != null) {
                containsTimeCutId = retrievalResult.containsTimeCutId(timeCut.getId());
            }
            if (containsTimeCutId) {
                tuple3 = BillTieRetrievalUtil.getTimeCutRetrievalResultOfDate(context, retrievalResult);
            } else {
                List<TimeCutConfig> timeCutConfigs = timeCut.getTimeCutConfigs();
                if (WTCCollections.isNotEmpty(timeCutConfigs)) {
                    BillTieRetrievalUtil billTieRetrievalUtil = new BillTieRetrievalUtil();
                    for (TimeCutConfig timeCutConfig : timeCutConfigs) {
                        billTieRetrievalUtil.timeCutUniqueCodes.addAll(billTieRetrievalUtil.getConfigRetrievalItemCode(timeCutConfig.getPreDateConditionAccessDto()));
                        billTieRetrievalUtil.timeCutUniqueCodes.addAll(billTieRetrievalUtil.getConfigRetrievalItemCode(timeCutConfig.getDateConditionAccessDto()));
                        billTieRetrievalUtil.timeCutUniqueCodes.addAll(billTieRetrievalUtil.getConfigRetrievalItemCode(timeCutConfig.getAfterDateConditionAccessDto()));
                    }
                    if (WTCCollections.isNotEmpty(billTieRetrievalUtil.timeCutUniqueCodes)) {
                        LocalDate chainDate = context.getChainDate();
                        long attPersonId = context.getAttPersonId();
                        ArrayList<RetrievalAttFileDateDimension> dimensions = new ArrayList<RetrievalAttFileDateDimension>(timeCutConfigs.size());
                        billTieRetrievalUtil.chainStartDate = context.getStartDate();
                        billTieRetrievalUtil.chainEndDate = context.getEndDate();
                        billTieRetrievalUtil.attFileCabinet = (AttFileCabinet)context.getInitParams().get("ATT_FILE");
                        billTieRetrievalUtil.buildTimeCutRetrievalDimension(attPersonId, chainDate, dimensions);
                        if (WTCCollections.isNotEmpty(dimensions)) {
                            HashSet results = Sets.newHashSetWithExpectedSize((int)dimensions.size());
                            billTieRetrievalUtil.beginTimeCutRetrieval(dimensions, results);
                            if (WTCCollections.isNotEmpty((Collection)results)) {
                                if (retrievalResult == null) {
                                    retrievalResult = new BillRetrievalResult(null);
                                }
                                retrievalResult.addTimeCutRetrievalResult(results);
                                tuple3 = BillTieRetrievalUtil.getTimeCutRetrievalResultOfDate(context, retrievalResult);
                            }
                        }
                    }
                }
            }
        }
        return tuple3;
    }

    private static Tuples.Tuple3<BillRetrievalDimensionResult, BillRetrievalDimensionResult, BillRetrievalDimensionResult> getTimeCutRetrievalResultOfDate(TieContextStd context, BillRetrievalResult retrievalResult) {
        long attPersonId = context.getAttPersonId();
        LocalDate chainDate = context.getChainDate();
        LocalDate preChainDate = chainDate.plusDays(-1L);
        LocalDate nextChainDate = chainDate.plusDays(1L);
        Set<BillRetrievalDimensionResult> chainDateResults = retrievalResult.getByPersonAndDate(attPersonId, chainDate, "time_cut");
        Set<BillRetrievalDimensionResult> preChainDateResults = retrievalResult.getByPersonAndDate(attPersonId, preChainDate, "time_cut");
        Set<BillRetrievalDimensionResult> nextChainDateResults = retrievalResult.getByPersonAndDate(attPersonId, nextChainDate, "time_cut");
        BillRetrievalDimensionResult chainDateResult = chainDateResults.stream().findFirst().orElse(null);
        BillRetrievalDimensionResult preChainDateResult = preChainDateResults.stream().findFirst().orElse(null);
        BillRetrievalDimensionResult nextChainDateResult = nextChainDateResults.stream().findFirst().orElse(null);
        return new Tuples.Tuple3((Object)preChainDateResult, (Object)chainDateResult, (Object)nextChainDateResult);
    }

    public static ConditionDto wtesDtoToWtbsDto(kd.wtc.wtes.business.model.access.ConditionDto dto) {
        ConditionDto conditionDto = new ConditionDto();
        conditionDto.setUniqueCode(dto.getUniqueCode());
        conditionDto.setParamType(dto.getParamType());
        conditionDto.setParam(dto.getParam());
        conditionDto.setName(dto.getName());
        conditionDto.setDisplayParam(dto.getDisplayParam());
        conditionDto.setDisplayValue(dto.getDisplayValue());
        conditionDto.setOperators(dto.getOperators());
        conditionDto.setValueType(dto.getValueType());
        conditionDto.setTarget(dto.getTarget());
        conditionDto.setIndex(dto.getIndex());
        conditionDto.setRetrievalWay(dto.getRetrievalWay());
        conditionDto.setValue(dto.getValue());
        return conditionDto;
    }

    private BillTieRetrievalUtil() {
    }

    public BillTieRetrievalUtil(InitParam initRequest) {
        LOG.info("BillTieRetrievalUtil.init begin");
        Map<String, Object> initParams = initRequest.getInitParams();
        this.chainStartDate = initRequest.getStartDate();
        this.chainEndDate = initRequest.getEndDate();
        AttBillTimeBucketData attBillTimeBucketData = (AttBillTimeBucketData)initParams.get("BILL_TIME_BUCKET");
        if (attBillTimeBucketData != null) {
            this.attPersonId2DailyBtb = attBillTimeBucketData.getAttPersonId2DailyBtb();
            if (WTCCollections.isEmpty(this.attPersonId2DailyBtb)) {
                this.attPersonId2DailyBtb = new HashMap<Long, Map<LocalDate, List<AttBillTimeBucket>>>(0);
            }
            this.attFileCabinet = (AttFileCabinet)initParams.get("ATT_FILE");
            this.initAllItemUniqueCodes();
            Set<BillRetrievalDimensionResult> dimensionResults = this.billTieBatchRetrieval();
            HashMap billRetrievalResultsMap = Maps.newHashMapWithExpectedSize((int)4);
            billRetrievalResultsMap.put("OT", dimensionResults);
            Set<BillRetrievalDimensionResult> billRetrievalDimensionResults = this.timeCutBatchRetrieval();
            billRetrievalResultsMap.put("time_cut", billRetrievalDimensionResults);
            this.billRetrievalResult = new BillRetrievalResult(billRetrievalResultsMap);
            this.billRetrievalResult.setOtRuleIds(this.otRuleIds);
            this.billRetrievalResult.setTimeCutIds(this.timeCutIds);
        }
        LOG.info("BillTieRetrievalUtil.init end");
    }

    private void initAllItemUniqueCodes() {
        for (Map.Entry<Long, Map<LocalDate, List<AttBillTimeBucket>>> personIdDateEntry : this.attPersonId2DailyBtb.entrySet()) {
            long attPersonId = personIdDateEntry.getKey();
            Map<LocalDate, List<AttBillTimeBucket>> dateBucketMap = personIdDateEntry.getValue();
            if (WTCCollections.isEmpty(dateBucketMap)) continue;
            for (Map.Entry<LocalDate, List<AttBillTimeBucket>> dateBucketEntry : dateBucketMap.entrySet()) {
                LocalDate rosterDate = dateBucketEntry.getKey();
                AttFileModel attFileModel = this.attFileCabinet.getByAttPersonIdAndDate(attPersonId, rosterDate);
                if (attFileModel == null) continue;
                this.collectRuleAndTimeCutIds(attFileModel);
            }
        }
        this.initOtRuleAllItemUniqueCodes();
        this.initTimeCutAllItemUniqueCodes();
    }

    private void collectRuleAndTimeCutIds(AttFileModel attFileModel) {
        List<AttFileScheduleEntity<TimeSeqBo<OtAttPackage>>> attOtPackageList = attFileModel.getAttOtPackageList();
        for (AttFileScheduleEntity<TimeSeqBo<OtAttPackage>> attFileScheduleEntity : attOtPackageList) {
            List otAttPackages;
            if (attFileScheduleEntity == null || attFileScheduleEntity.getEntity() == null || !WTCCollections.isNotEmpty((Collection)(otAttPackages = ((TimeSeqBo)attFileScheduleEntity.getEntity()).getVersions()))) continue;
            for (OtAttPackage otAttPackage : otAttPackages) {
                TimeCut timeCut;
                if (otAttPackage == null || !"1".equals(otAttPackage.getRuleWay())) continue;
                TimeSeqAvailableBo<OtRulePackage> rule = otAttPackage.getRuleList();
                List otRulePackages = rule.getVersions();
                if (WTCCollections.isNotEmpty((Collection)otRulePackages)) {
                    Set collect = otRulePackages.stream().map(item -> item.getTimeSeqInfo().getVid()).collect(Collectors.toSet());
                    this.otRuleIds.addAll(collect);
                }
                if ((timeCut = otAttPackage.getTimeCut()) == null) continue;
                long timeCutId = timeCut.getId();
                this.timeCutIds.add(timeCutId);
            }
        }
    }

    private void initOtRuleAllItemUniqueCodes() {
        if (WTCCollections.isNotEmpty(this.otRuleIds)) {
            DynamicObject[] otRules;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_overworkrule");
            QFilter qFilter = WTCHisServiceHelper.validWithoutEnableQFilter();
            qFilter.and("id", "in", this.otRuleIds);
            for (DynamicObject otRule : otRules = serviceHelper.loadDynamicObjectArray(qFilter.toArray())) {
                DynamicObjectCollection otCalEntry = otRule.getDynamicObjectCollection("overworkcalentry");
                for (DynamicObject otCal : otCalEntry) {
                    String limitScope = otCal.getString("limitscope");
                    this.billItemUniqueCodes.addAll(this.getConfigRetrievalItemCode(limitScope));
                    String dateRangeCondition = otCal.getString("daterangecondition");
                    this.billItemUniqueCodes.addAll(this.getConfigRetrievalItemCode(dateRangeCondition));
                }
            }
        }
        LOG.info("BillTieRetrievalUtil.initOtRuleAllItemUniqueCodes,allOtCalItemUniqueCodes.size:{},", (Object)this.billItemUniqueCodes.size());
    }

    private void initTimeCutAllItemUniqueCodes() {
        if (WTCCollections.isNotEmpty(this.timeCutIds)) {
            DynamicObject[] timeCuts;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_timecut");
            QFilter qFilter = new QFilter("id", "in", this.timeCutIds);
            for (DynamicObject timeCut : timeCuts = serviceHelper.loadDynamicObjectArray(qFilter.toArray())) {
                DynamicObjectCollection otCalEntry = timeCut.getDynamicObjectCollection("timecutentry");
                for (DynamicObject otCal : otCalEntry) {
                    String beforeDayCond = otCal.getString("beforedaycond");
                    this.timeCutUniqueCodes.addAll(this.getConfigRetrievalItemCode(beforeDayCond));
                    String dayCond = otCal.getString("daycond");
                    this.timeCutUniqueCodes.addAll(this.getConfigRetrievalItemCode(dayCond));
                    String afterDayCond = otCal.getString("afterdaycond");
                    this.timeCutUniqueCodes.addAll(this.getConfigRetrievalItemCode(afterDayCond));
                }
            }
        }
        LOG.info("BillTieRetrievalUtil.initTimeCutAllItemUniqueCodes,allTimeCutItemUniqueCodes.size:{},", (Object)this.timeCutUniqueCodes.size());
    }

    private Set<String> getConfigRetrievalItemCode(String ruleCondition) {
        AccessDto dateConditionAccessDto = this.getRuleConditionInfo(ruleCondition);
        return this.getConfigRetrievalItemCode(dateConditionAccessDto);
    }

    private Set<String> getConfigRetrievalItemCode(AccessDto accessDto) {
        HashSet itemUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
        if (accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
            for (kd.wtc.wtes.business.model.access.ConditionDto conditionDto : accessDto.getConditionList()) {
                String retrievalWay = conditionDto.getRetrievalWay();
                if (!HRStringUtils.isNotEmpty((String)retrievalWay) || !RetrievalTypeEnum.CONFIG.getValue().equals(retrievalWay)) continue;
                itemUniqueCodes.add(conditionDto.getUniqueCode());
            }
        }
        return itemUniqueCodes;
    }

    public BillRetrievalResult getBillRetrievalResult() {
        return this.billRetrievalResult;
    }

    private Set<BillRetrievalDimensionResult> billTieBatchRetrieval() {
        if (WTCCollections.isEmpty(this.billItemUniqueCodes)) {
            return new HashSet<BillRetrievalDimensionResult>(0);
        }
        for (Map.Entry<Long, Map<LocalDate, List<AttBillTimeBucket>>> personIdDateEntry : this.attPersonId2DailyBtb.entrySet()) {
            long attPersonId = personIdDateEntry.getKey();
            Map<LocalDate, List<AttBillTimeBucket>> dateBucketMap = personIdDateEntry.getValue();
            if (WTCCollections.isEmpty(dateBucketMap)) continue;
            for (Map.Entry<LocalDate, List<AttBillTimeBucket>> dateBucketEntry : dateBucketMap.entrySet()) {
                AttFileModel attFileModel;
                LocalDate rosterDate = dateBucketEntry.getKey();
                List<AttBillTimeBucket> allBucketList = dateBucketEntry.getValue();
                List<AttBillTimeBucket> otBucketList = allBucketList.stream().filter(item -> "OT".equals(item.getBillTypeBig())).collect(Collectors.toList());
                if (!WTCCollections.isNotEmpty(otBucketList) || (attFileModel = this.attFileCabinet.getByAttPersonIdAndDate(attPersonId, rosterDate)) == null) continue;
                this.initOtRetrievalDimension(otBucketList, attFileModel, rosterDate);
            }
        }
        Map<String, RetrievalRuleMatchDimension> retrievalRuleMatchDimensionMap = this.beginRetrieval();
        Set<BillRetrievalDimensionResult> billRetrievalResults = this.handleOtRetrievalResult(retrievalRuleMatchDimensionMap);
        return billRetrievalResults;
    }

    private void initOtRetrievalDimension(List<AttBillTimeBucket> otBucketList, AttFileModel attFileModel, LocalDate rosterDate) {
        ArrayList<RetrievalRuleMatchDimension> otMatchDimensions = new ArrayList<RetrievalRuleMatchDimension>(otBucketList.size());
        for (AttBillTimeBucket timeBucket : otBucketList) {
            String entryKey;
            DynamicObjectCollection entryColl;
            DynamicObject otpBillDyn = timeBucket.getOtpBillDyn();
            if (otpBillDyn == null || (entryColl = otpBillDyn.getDynamicObjectCollection(entryKey = this.getOtBillDyEntryKey(otpBillDyn))) == null) continue;
            for (int index = 0; index < entryColl.size(); ++index) {
                DynamicObject entryDy = (DynamicObject)entryColl.get(index);
                long entryId = entryDy.getLong("id");
                if (timeBucket.getId() != entryId) continue;
                long attFileVId = otpBillDyn.getLong("attfilebasef7.id");
                long attFileBoId = otpBillDyn.getLong("attfile.boid");
                RetrievalRuleMatchDimension matchDimension = new RetrievalRuleMatchDimension();
                matchDimension.setAttPersonId(attFileModel.getAttPersonId());
                matchDimension.setAttFileId(attFileVId);
                matchDimension.setAttFileBoId(attFileBoId);
                matchDimension.setPersonBoId(attFileModel.getPersonBoid().longValue());
                matchDimension.setEmployeeBoId(attFileModel.getEmployeeId().longValue());
                matchDimension.setDepempBoId(attFileModel.getDepempBoid().longValue());
                matchDimension.setOwnDate(WTCDateUtils.toDate((LocalDate)rosterDate));
                matchDimension.setContext(otpBillDyn);
                matchDimension.setType(RetrievalRuleMatchType.entry);
                matchDimension.setEntryKey(entryKey);
                matchDimension.setIndex(index);
                matchDimension.setDimensionKey(String.valueOf(entryId));
                otMatchDimensions.add(matchDimension);
            }
        }
        List matchDimensions = this.matchDimensionsMap.computeIfAbsent("OT", item -> new ArrayList(16));
        matchDimensions.addAll(otMatchDimensions);
    }

    private String getOtBillDyEntryKey(DynamicObject otpBillDyn) {
        String otApplyType = otpBillDyn.getString("otapplytype");
        String entryKey = "1".equals(otApplyType) ? "sdentry" : "scentry";
        return entryKey;
    }

    private Map<String, RetrievalRuleMatchDimension> beginRetrieval() {
        try {
            HashSet allMatchDimension = Sets.newHashSetWithExpectedSize((int)16);
            HashSet allItemUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
            this.matchDimensionsMap.values().forEach(allMatchDimension::addAll);
            allItemUniqueCodes.addAll(this.billItemUniqueCodes);
            LOG.info("BillTieRetrievalUtil.beginRetrieval,allItemUniqueCodes.size:{},allMatchDimension.size:{}", (Object)allItemUniqueCodes.size(), (Object)allMatchDimension.size());
            if (WTCCollections.isNotEmpty((Collection)allMatchDimension) && WTCCollections.isNotEmpty((Collection)allItemUniqueCodes)) {
                RetrievalRuleMatchService retrievalService = new RetrievalRuleMatchService();
                retrievalService.addRetrievalUnicode((Set)allItemUniqueCodes);
                retrievalService.addRetrievalDimension((List)Lists.newArrayList((Iterable)allMatchDimension));
                retrievalService.retrievalData();
                return allMatchDimension.stream().collect(Collectors.toMap(RetrievalRuleMatchDimension::getDimensionKey, Function.identity(), (o1, o2) -> o1));
            }
        }
        catch (KDBizException exception) {
            throw new WtesBizException(exception.getMessage());
        }
        catch (Exception exception) {
            LOG.warn("BillTieRetrievalUtil.beginRetrieval exception", (Throwable)exception);
            String msg = ResManager.loadKDString((String)"\u5355\u636e\u89c4\u5219\u53d6\u6570\u5f02\u5e38\u3002", (String)"BillTieRetrievalUtil_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
            throw new WtesBizException(msg);
        }
        return Collections.emptyMap();
    }

    private Set<BillRetrievalDimensionResult> handleOtRetrievalResult(Map<String, RetrievalRuleMatchDimension> retrievalRuleMatchDimensionMap) {
        HashSet billRetrievalResults = Sets.newHashSetWithExpectedSize((int)16);
        if (WTCCollections.isEmpty(retrievalRuleMatchDimensionMap)) {
            return billRetrievalResults;
        }
        for (Map.Entry<Long, Map<LocalDate, List<AttBillTimeBucket>>> personIdDateEntry : this.attPersonId2DailyBtb.entrySet()) {
            Long attPersonId = personIdDateEntry.getKey();
            Map<LocalDate, List<AttBillTimeBucket>> dateBucketMap = personIdDateEntry.getValue();
            for (Map.Entry<LocalDate, List<AttBillTimeBucket>> dateBucketEntry : dateBucketMap.entrySet()) {
                LocalDate rosterDate = dateBucketEntry.getKey();
                List<AttBillTimeBucket> allBucketList = dateBucketEntry.getValue();
                List<AttBillTimeBucket> otBucketList = allBucketList.stream().filter(item -> "OT".equals(item.getBillTypeBig())).collect(Collectors.toList());
                if (WTCCollections.isEmpty(otBucketList)) continue;
                List<BillRetrievalDimensionResult> dimensionResults = this.buildRetrievalDimensionResult(retrievalRuleMatchDimensionMap, otBucketList, attPersonId, rosterDate);
                billRetrievalResults.addAll(dimensionResults);
            }
        }
        return billRetrievalResults;
    }

    private List<BillRetrievalDimensionResult> buildRetrievalDimensionResult(Map<String, RetrievalRuleMatchDimension> retrievalRuleMatchDimensionMap, List<AttBillTimeBucket> otBucketList, Long attPersonId, LocalDate rosterDate) {
        ArrayList<BillRetrievalDimensionResult> billRetrievalDimensionResults = new ArrayList<BillRetrievalDimensionResult>(16);
        for (AttBillTimeBucket timeBucket : otBucketList) {
            long id = timeBucket.getId();
            String dimensionKey = String.valueOf(id);
            RetrievalRuleMatchDimension entryMatchDimensions = retrievalRuleMatchDimensionMap.get(dimensionKey);
            if (entryMatchDimensions == null) continue;
            BillRetrievalDimensionResult billRetrievalDimensionResult = new BillRetrievalDimensionResult();
            billRetrievalDimensionResult.setDimensionKey(dimensionKey);
            billRetrievalDimensionResult.setAttPersonId(attPersonId);
            billRetrievalDimensionResult.setRosterDate(rosterDate);
            billRetrievalDimensionResult.setRetrievalDimension((RuleConditionValues)entryMatchDimensions);
            billRetrievalDimensionResults.add(billRetrievalDimensionResult);
        }
        return billRetrievalDimensionResults;
    }

    private Set<BillRetrievalDimensionResult> timeCutBatchRetrieval() {
        HashSet retrievalDimensionResults = Sets.newHashSetWithExpectedSize((int)16);
        if (WTCCollections.isNotEmpty(this.timeCutUniqueCodes)) {
            ArrayList<RetrievalAttFileDateDimension> retrievalAttfileDateDimensions = new ArrayList<RetrievalAttFileDateDimension>(16);
            for (Map.Entry<Long, Map<LocalDate, List<AttBillTimeBucket>>> personIdDateEntry : this.attPersonId2DailyBtb.entrySet()) {
                long attPersonId = personIdDateEntry.getKey();
                Map<LocalDate, List<AttBillTimeBucket>> dateBucketMap = personIdDateEntry.getValue();
                for (Map.Entry<LocalDate, List<AttBillTimeBucket>> dateBucketEntry : dateBucketMap.entrySet()) {
                    LocalDate rosterDate = dateBucketEntry.getKey();
                    this.buildTimeCutRetrievalDimension(attPersonId, rosterDate, retrievalAttfileDateDimensions);
                }
            }
            this.beginTimeCutRetrieval(retrievalAttfileDateDimensions, retrievalDimensionResults);
        }
        return retrievalDimensionResults;
    }

    private void beginTimeCutRetrieval(List<RetrievalAttFileDateDimension> dimensions, Set<BillRetrievalDimensionResult> results) {
        try {
            if (WTCCollections.isNotEmpty(dimensions)) {
                RetrievalService retrievalService = new RetrievalService();
                retrievalService.addRetrievalUnicode(this.timeCutUniqueCodes);
                retrievalService.addRetrievalDimension(dimensions);
                retrievalService.retrievalData();
                for (RetrievalAttFileDateDimension dimension : dimensions) {
                    BillRetrievalDimensionResult billRetrievalDimensionResult = new BillRetrievalDimensionResult();
                    billRetrievalDimensionResult.setAttPersonId(dimension.getAttPersonId());
                    billRetrievalDimensionResult.setRosterDate(WTCDateUtils.toLocalDate((Date)dimension.getOwnDate()));
                    billRetrievalDimensionResult.setRetrievalDimension((RuleConditionValues)dimension);
                    results.add(billRetrievalDimensionResult);
                }
            }
        }
        catch (KDBizException exception) {
            throw new WtesBizException(exception.getMessage());
        }
        catch (Exception exception) {
            LOG.warn("BillTieRetrievalUtil.beginTimeCutRetrieval exception", (Throwable)exception);
            String msg = ResManager.loadKDString((String)"\u5de5\u65f6\u5207\u5206\u53d6\u6570\u5f02\u5e38\u3002", (String)"BillTieRetrievalUtil_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
            throw new WtesBizException(msg);
        }
    }

    private void buildTimeCutRetrievalDimension(long attPersonId, LocalDate rosterDate, List<RetrievalAttFileDateDimension> dimensions) {
        LocalDate nextDay;
        RetrievalAttFileDateDimension nextDimension;
        LocalDate beforeDay;
        RetrievalAttFileDateDimension beforeDimension;
        RetrievalAttFileDateDimension todayDimension = this.buildTimeCutRetrievalDimension(attPersonId, rosterDate);
        if (todayDimension != null) {
            dimensions.add(todayDimension);
        }
        if ((beforeDimension = this.buildTimeCutRetrievalDimension(attPersonId, beforeDay = rosterDate.plusDays(-1L))) != null) {
            dimensions.add(beforeDimension);
        }
        if ((nextDimension = this.buildTimeCutRetrievalDimension(attPersonId, nextDay = rosterDate.plusDays(1L))) != null) {
            dimensions.add(nextDimension);
        }
    }

    private RetrievalAttFileDateDimension buildTimeCutRetrievalDimension(long attPersonId, LocalDate rosterDate) {
        AttFileModel attFileModel = this.attFileCabinet.getByAttPersonIdAndDate(attPersonId, rosterDate);
        if (attFileModel == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("BillTieRetrievalUtil.buildRetrievalAttfileDateDimension attFileModel is null");
            }
            return null;
        }
        RetrievalAttFileDateDimension retrievalAttfileDateDimension = new RetrievalAttFileDateDimension();
        retrievalAttfileDateDimension.setAttPersonId(attFileModel.getAttPersonId());
        retrievalAttfileDateDimension.setAttFileId(attFileModel.getId());
        retrievalAttfileDateDimension.setAttFileBoId(attFileModel.getBid());
        retrievalAttfileDateDimension.setPersonBoId(attFileModel.getPersonBoid().longValue());
        retrievalAttfileDateDimension.setEmployeeBoId(attFileModel.getEmployeeId().longValue());
        retrievalAttfileDateDimension.setDepempBoId(attFileModel.getDepempBoid().longValue());
        retrievalAttfileDateDimension.setOwnDate(WTCDateUtils.toDate((LocalDate)rosterDate));
        return retrievalAttfileDateDimension;
    }

    private AccessDto getRuleConditionInfo(String condition) {
        try {
            if (HRStringUtils.isEmpty((String)condition)) {
                return new AccessDto();
            }
            return (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
        }
        catch (Exception exception) {
            LOG.warn("BillTieRetrievalUtil.getRuleConditionInfo exception", (Throwable)exception);
            return new AccessDto();
        }
    }
}

