/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtes.business.builder.DetectableAndCleanableBuilder;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.business.util.WTESDateUtils;
import kd.wtc.wtes.common.enums.RefDateType;
import kd.wtc.wtes.common.enums.ShiftType;

public final class ShiftSwitchUtil {
    private ShiftSwitchUtil() {
    }

    public static ShiftSpec toShiftSpec(Shift shift) {
        ShiftSpec shiftSpec = (ShiftSpec)((Object)((DetectableAndCleanableBuilder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)((ShiftSpec.Builder)ShiftSpec.withNonTimeSeq(shift.getId(), null).shiftType(ShiftType.from((String)shift.getShiftType()))).shiftSessions(ShiftSwitchUtil.getShiftSession(shift))).off(shift.isOff())).name(shift.getName())).chineseName(shift.getChineseName())).offNonPlan(shift.getOffNonPlan())).build());
        return shiftSpec;
    }

    public static List<ShiftSession> getShiftSession(Shift shift) {
        List shiftDetailList = shift.getShiftDetailList();
        ArrayList<ShiftSession> shiftSessions = new ArrayList<ShiftSession>(shiftDetailList.size());
        int workTime = 0;
        int breakTime = 0;
        int otTime = 0;
        for (ShiftDetail shiftDetail : shiftDetailList) {
            long id = shiftDetail.getShiftPeriodId();
            String outworktype = shiftDetail.getOutWorkType();
            String refstartday = shiftDetail.getRefStartDay();
            String refendday = shiftDetail.getRefEndDay();
            RefDateType startRef = RefDateType.from((String)refstartday);
            RefDateType endRef = RefDateType.from((String)refendday);
            int shiftstartdate = shiftDetail.getShiftStartDate();
            int shiftenddate = shiftDetail.getShiftEndDate();
            LocalTime localShiftstartdate = LocalTime.ofSecondOfDay(shiftstartdate);
            LocalTime localShiftenddate = LocalTime.ofSecondOfDay(shiftenddate);
            int shiftstartdate1 = shiftstartdate;
            int shiftenddate1 = shiftenddate;
            if (startRef == RefDateType.NEXTDAY) {
                shiftstartdate1 += 86400;
            }
            if (endRef == RefDateType.NEXTDAY) {
                shiftenddate1 += 86400;
            }
            OutWorkType outWorkType = OutWorkType.from(outworktype);
            switch (outWorkType) {
                case WORK: {
                    workTime += shiftenddate1 - shiftstartdate1;
                    break;
                }
                case BREAK: {
                    breakTime += shiftenddate1 - shiftstartdate1;
                    break;
                }
                case OT: {
                    otTime += shiftenddate1 - shiftstartdate1;
                    break;
                }
            }
            ShiftSession shiftSession = ShiftSession.with().id(id).startRefDateType(startRef).endRefDateType(endRef).startTime(localShiftstartdate).endTime(localShiftenddate).outWorkType(outWorkType).requiredPunchIn(shiftDetail.isWorkTimeStart()).requiredPunchOut(shiftDetail.isWorkTimeEnd()).durationInSeconds(WTESDateUtils.durationBetweenRefTimePoints(localShiftstartdate, startRef, localShiftenddate, endRef)).build();
            shiftSessions.add(shiftSession);
        }
        return shiftSessions;
    }

    public static Roster toRoster(Shift shift, LocalDate rosterLocalDate) {
        ShiftSpec shiftSpec = ShiftSwitchUtil.toShiftSpec(shift);
        TimeSeqBo shiftSpecTimeSeqBo = TimeSeqBo.ofNonTimeSeq((TimeSeqVersion)shiftSpec);
        Roster.Builder builder = Roster.with().rosterDate(rosterLocalDate).shiftSpecTimeSeqBo((TimeSeqBo<ShiftSpec>)shiftSpecTimeSeqBo);
        return builder.build();
    }
}

