/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.core.datanode.TieDataNodeCore;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.engine.TieEngineConfigs;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.AttItemValueStd;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeWrapperStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.TieContextUtilForDayDetail;

public final class TieContextUtil {
    private static final Log LOG = LogFactory.getLog(TieContextUtil.class);

    private TieContextUtil() {
    }

    public static Map<Long, AttItemValue> getAllHandleResultAndAttItemValue(List<TieDataNodeStd> dataNodes, ShiftSpec shiftSpec, List<? extends TieDataNode> tieDataNodeList, TieStepIdentity stepIdentity) {
        if (WTCCollections.isEmpty(dataNodes) && WTCCollections.isEmpty(tieDataNodeList)) {
            return Collections.emptyMap();
        }
        ArrayList tieDataNodeStdList = Lists.newArrayListWithExpectedSize((int)dataNodes.size());
        if (!WTCCollections.isEmpty(dataNodes)) {
            tieDataNodeStdList.addAll(dataNodes);
        }
        if (!WTCCollections.isEmpty(tieDataNodeList)) {
            long[] ids = TieEngineConfigs.DEFAULT.getIdService().genLongIds(tieDataNodeList.size());
            TieContextUtil.addTieDataNode(tieDataNodeStdList, ids, tieDataNodeList, stepIdentity);
        }
        return TieContextUtil.getAllHandleResultAttItemValue(tieDataNodeStdList, shiftSpec);
    }

    private static void addTieDataNode(List<TieDataNodeStd> tieDataNodeStdList, long[] ids, List<? extends TieDataNode> tieDataNodeList, TieStepIdentity stepIdentity) {
        TieDataNodeWrapperStd tieDataNodeWrapperStd = new TieDataNodeWrapperStd();
        int index = 0;
        for (TieDataNode tieDataNode : tieDataNodeList) {
            TieDataNodeCore<TieDataNodeStd> dataNodeCore = new TieDataNodeCore<TieDataNodeStd>();
            dataNodeCore.setId(ids[index++]);
            dataNodeCore.setData(tieDataNode);
            dataNodeCore.setStepIdentity(stepIdentity);
            if (tieDataNode instanceof AttItemValue) {
                AttItemValueStd attItemValueStd = new AttItemValueStd(dataNodeCore);
                tieDataNodeStdList.add(attItemValueStd);
            } else if (tieDataNode instanceof TimeBucket) {
                TimeBucketStd timeBucketStd = new TimeBucketStd(dataNodeCore);
                tieDataNodeStdList.add(timeBucketStd);
            }
            List<TieDataNodeStd> parentDataNode = tieDataNode.parentDataNodes();
            List<TieDataNodeCore<TieDataNodeStd>> parentDataNodeCodes = tieDataNodeWrapperStd.unwrap(parentDataNode);
            for (TieDataNodeCore<TieDataNodeStd> parentDataNodeCore : parentDataNodeCodes) {
                if (parentDataNodeCore.getStepIdentity().getPhaseIdentity().getId() != stepIdentity.getPhaseIdentity().getId()) continue;
                parentDataNodeCore.setLeafInPhase(false);
            }
        }
    }

    public static Map<Long, AttItemValue> getCurPhaseHandleResultAndAttItemValue(List<TieDataNodeStd> dataNodes, ShiftSpec shiftSpec, List<? extends TieDataNode> tieDataNodeList, TieStepIdentity stepIdentity) {
        if (WTCCollections.isEmpty(dataNodes) && WTCCollections.isEmpty(tieDataNodeList)) {
            return Collections.emptyMap();
        }
        List<TieDataNodeStd> curPhaseTieDataNodeStdList = WTCCollections.isEmpty(dataNodes) ? dataNodes : dataNodes.stream().filter(ob -> ob.getStepIdentity().getPhaseIdentity().getId() == stepIdentity.getPhaseIdentity().getId()).collect(Collectors.toList());
        return TieContextUtil.getAllHandleResultAndAttItemValue(curPhaseTieDataNodeStdList, shiftSpec, tieDataNodeList, stepIdentity);
    }

    public static Map<Long, AttItemValue> getAllHandleResultAttItemValue(List<TieDataNodeStd> dataNodes, ShiftSpec shiftSpec) {
        if (WTCCollections.isEmpty(dataNodes)) {
            return Collections.emptyMap();
        }
        return TieContextUtilForDayDetail.getAllHandleResultAttItemValue(dataNodes, shiftSpec);
    }

    public static List<TieDataNodeStd> reverseNodeList(List<TieDataNodeStd> dataNodeStdList) {
        ArrayList tieDataNodeStdList = Lists.newArrayListWithExpectedSize((int)dataNodeStdList.size());
        for (int i = dataNodeStdList.size() - 1; i >= 0; --i) {
            tieDataNodeStdList.add(dataNodeStdList.get(i));
        }
        return tieDataNodeStdList;
    }
}

