/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.wtteinfo;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.engine.TieEngineCallbackEvent;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.service.ICalFinishAfterProcessService;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class WtteInfoUpdateCallback
implements ICalFinishAfterProcessService {
    private static final Log log = LogFactory.getLog(WtteInfoUpdateCallback.class);

    @Override
    public void completedCallback(TieEngineCallbackEvent callbackEvent) {
        Map<AttSubject.AttFileBo, LocalDate> lastTieDateMap = callbackEvent.getLastTieDateMap();
        Map<AttSubject.AttFileBo, LocalDate> errorDateMap = callbackEvent.getErrorDateMap();
        if (WTCMaps.isEmpty(lastTieDateMap) && WTCMaps.isEmpty(errorDateMap)) {
            log.debug("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u6838\u7b97\u4fe1\u606f\u7684\u8003\u52e4\u4e3b\u4f53\uff0c\u8ba1\u7b97\u7248\u672c={}", (Object)callbackEvent.getRequest().getVersion());
            return;
        }
        HashMap successMap = Maps.newHashMapWithExpectedSize((int)lastTieDateMap.size());
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)errorDateMap.size());
        AttFileCabinet attFileCabinet = (AttFileCabinet)callbackEvent.getInitParams().get("ATT_FILE");
        lastTieDateMap.forEach((attFileBo, localDate) -> successMap.put(attFileBo.getAttFileBoid(), WTCDateUtils.toDate((LocalDate)localDate)));
        log.debug("TieEngine completedCallback try to update wtp_attstateInfo lastTieDateMap={}\uff0cerrorDateMap={}", lastTieDateMap, errorDateMap);
        errorDateMap.forEach((attFileBo, localDate) -> {
            errorMap.put(attFileBo.getAttFileBoid(), WTCDateUtils.toDate((LocalDate)localDate));
            List<TimeSeqBo<AttFileModel>> attFileModelList = attFileCabinet.getByAttPersonId(attFileBo.getAttSubject().getAttPersonId());
            LocalDate startDate = this.getStartDate(attFileModelList, attFileBo.getAttFileBoid());
            if (localDate != null && startDate != null && startDate.compareTo((ChronoLocalDate)localDate) >= 0) {
                errorMap.put(attFileBo.getAttFileBoid(), null);
            }
        });
        this.updateAccountToDate(successMap, errorMap);
    }

    private LocalDate getStartDate(List<TimeSeqBo<AttFileModel>> attFileModelList, long attFileBoid) {
        if (!CollectionUtils.isEmpty(attFileModelList)) {
            for (TimeSeqBo<AttFileModel> attFileModel : attFileModelList) {
                Optional<AttFileModel> optional;
                if (attFileModel.getBid() != attFileBoid || !(optional = attFileModel.getVersions().stream().min(Comparator.comparing(AttFileModel::getStartDate))).isPresent()) continue;
                return optional.get().getStartDate().plusDays(-1L);
            }
        }
        return null;
    }

    private void updateAccountToDate(Map<Long, Date> successMap, Map<Long, Date> errorMap) {
        AttStateInfoService instance = AttStateInfoService.getInstance();
        List infoBOS = instance.queryAttStateInfoByBoid(new ArrayList<Long>(successMap.keySet()));
        for (AttStateInfoBO infoBO : infoBOS) {
            Long fileBoId = infoBO.getFileBoid();
            Date date = successMap.get(fileBoId);
            if (infoBO.getAccountTo() == null || date == null || !date.before(infoBO.getAccountTo())) continue;
            successMap.remove(fileBoId);
        }
        successMap.putAll(errorMap);
        log.debug("TieEngine try to update wtp_attstateInfo accountTo successMap={},errorMap={}", successMap, errorMap);
        instance.accountTo(successMap);
    }
}

