/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.opplugin.coordination;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtis.business.coordination.PersonInfoReviseLogService;
import kd.wtc.wtis.enums.ReviseHandlingStatusEnum;
import kd.wtc.wtis.opplugin.coordination.validator.PersonInfoReviseLogValidator;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class PersonInfoReviseLogOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().add("eventstatus");
        args.getFieldKeys().add("handlingstatus");
        args.getFieldKeys().add("person");
        args.getFieldKeys().add("empposorgrel");
        args.getFieldKeys().add("revisetype");
        args.getFieldKeys().add("revisenumber");
        args.getFieldKeys().add("failmsg");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new PersonInfoReviseLogValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        String operationKey = beginOperationTransactionArgs.getOperationKey();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_personreviselog");
        if ("processed".equals(operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("handlingstatus", (Object)ReviseHandlingStatusEnum.PROCESSED.getCode());
            }
            hrBaseServiceHelper.update(dataEntities);
        } else if ("processing".equals(operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("handlingstatus", (Object)ReviseHandlingStatusEnum.PROCESSING.getCode());
            }
            hrBaseServiceHelper.update(dataEntities);
        } else if ("run".equals(operationKey)) {
            List<DynamicObject> collect = Arrays.stream(dataEntities).collect(Collectors.toList());
            try (TXHandle h = TX.requiresNew();){
                try {
                    PersonInfoReviseLogService.getInstance().synAttPersonAndUpdatePersonInfoReviseLog(collect);
                }
                catch (Exception exception) {
                    h.markRollback();
                    throw new KDBizException(AttFileKDString.personSynEx());
                }
            }
            hrBaseServiceHelper.update(collect.toArray(new DynamicObject[0]));
        }
    }
}

