/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.opplugin.coordination.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class CoordinationLogReCreateValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        try {
            Future submit = CoordinationHelper.THREAD_POOL.submit(() -> this.doSingleThread(this.getDataEntities()));
            submit.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private ExtendedDataEntity[] doSingleThread(ExtendedDataEntity[] dataEntities) {
        HashSet allNumber = Sets.newHashSetWithExpectedSize((int)16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            HashMap runResultMap = Maps.newHashMapWithExpectedSize((int)16);
            String msg = CoordinationHelper.getInstance().createExecute(dy, true, (Map)runResultMap);
            if (WTCCollections.isNotEmpty((Map)runResultMap) && runResultMap.get("rollbackFileOnly") != null) {
                allNumber.add(runResultMap.get("rollbackFileOnly").toString());
            }
            if (!WTCStringUtils.isNotEmpty((String)msg)) continue;
            this.addFatalErrorMessage(dataEntity, msg);
        }
        if (WTCCollections.isNotEmpty((Collection)allNumber)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String fileNumber : allNumber) {
                stringBuilder.append(fileNumber);
            }
            this.getOption().setVariableValue("rollbackFileOnly", AttFileKDString.fileRollbackOnly((String)stringBuilder.toString()));
        }
        return dataEntities;
    }
}

