/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodAndStateInfo;
import kd.wtc.wtbs.common.model.wtteinfo.AttStateInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtis.business.attdata.impl.AttRecordServiceImpl;
import kd.wtc.wtis.business.attdata.impl.QTDataServiceImpl;
import kd.wtc.wtis.business.attdata.service.AbsAttDataGenService;
import kd.wtc.wtis.business.attdata.service.IAttRecordService;
import kd.wtc.wtis.business.attdata.service.IQTDataService;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.common.model.AttDetailsDto;
import kd.wtc.wtis.common.model.AttFileGroupDto;

public class AttDataGenServiceImpl
extends AbsAttDataGenService {
    private static final Log log = LogFactory.getLog(AttDataGenServiceImpl.class);
    private String version;
    private Set<Long> attFileBoIds;
    private List<Long> attItemsIds;
    private Long periodId;
    private Date periodStartDate;
    private Date periodEndDate;
    private String attPeriodName;
    private Boolean isBatchGeneration;
    private String dataSource;
    private boolean isSumComp;
    private boolean isSendQtData;
    private Map<Long, DynamicObject> attItemMap;
    private String attItemName = "";
    private IAttRecordService attRecordService;
    private IQTDataService qtDateService;

    public AttDataGenServiceImpl(DynamicObject taskDyn, List<Long> attFileBoIds) {
        this.version = taskDyn.getString("version");
        this.periodId = taskDyn.getLong("attperiodentry.id");
        this.attPeriodName = taskDyn.getString("attperiodentry.name");
        this.periodStartDate = taskDyn.getDate("attperiodentry.begindate");
        this.periodEndDate = taskDyn.getDate("attperiodentry.enddate");
        DynamicObject rule = taskDyn.getDynamicObject("integrationrule");
        DynamicObjectCollection attItems = rule.getDynamicObjectCollection("entryentity");
        this.attItemsIds = attItems.stream().map(dynamicObject -> dynamicObject.getLong("attitemld.id")).collect(Collectors.toList());
        this.attItemMap = attItems.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("attitemld.id"), Function.identity(), (key1, key2) -> key1));
        this.isBatchGeneration = rule.getBoolean("checkbatch");
        this.isSendQtData = rule.getBoolean("issendqtdata");
        this.dataSource = rule.getString("datasource");
        this.isSumComp = rule.getBoolean("issumcomp");
        this.attFileBoIds = new HashSet<Long>(attFileBoIds);
        this.initQueryService();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AttFileGroupDto> getAttDataList() {
        try (Span initSpan = TaskTracer.newSpan((String)IntegrationKDString.spanQuery());){
            List<AttFileGroupDto> list = this.getDataInfo();
            return list;
        }
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public Set<Long> getAttFileBoIds() {
        return this.attFileBoIds;
    }

    public List<Long> getAttItemsIds() {
        return this.attItemsIds;
    }

    @Override
    public Long getPeriodId() {
        return this.periodId;
    }

    @Override
    public String getAttPeriodName() {
        return this.attPeriodName;
    }

    @Override
    public String getAttItemName() {
        return this.attItemName;
    }

    @Override
    public Date getPeriodStartDate() {
        return this.periodStartDate;
    }

    @Override
    public Date getPeriodEndDate() {
        return this.periodEndDate;
    }

    private void initQueryService() {
        Set<Long> authAttFileBoIds = this.getAuthAttFileBoIds();
        this.attRecordService = new AttRecordServiceImpl(authAttFileBoIds, this.getAttItemsIds(), this.getPeriodId(), this.periodStartDate, this.periodEndDate);
        this.qtDateService = new QTDataServiceImpl(authAttFileBoIds, this.getAttItemsIds(), this.periodStartDate, this.periodEndDate);
    }

    private boolean overlapCheck(List<AttDetailsDto> attDetails, List<AttDetailsDto> qtDetail) {
        if (WTCCollections.isEmpty(attDetails) || WTCCollections.isEmpty(qtDetail)) {
            return false;
        }
        Set attItems = attDetails.stream().map(AttDetailsDto::getAttItemId).collect(Collectors.toSet());
        for (AttDetailsDto dto : qtDetail) {
            if (!attItems.contains(dto.getAttItemId())) continue;
            DynamicObject attItem = this.attItemMap.get(dto.getAttItemId());
            if (null != attItem) {
                this.attItemName = attItem.getString("attitemld.name");
            }
            return true;
        }
        return false;
    }

    private boolean isEmpty(List<AttDetailsDto> ... attDetails) {
        for (List<AttDetailsDto> attDetail : attDetails) {
            if (!WTCCollections.isNotEmpty(attDetail)) continue;
            return false;
        }
        return true;
    }

    private List<AttDetailsDto> filterDetails(AttFileGroupDto attFileGroupDto, List<AttDetailsDto> attDetails) {
        List<AttDetailsDto> filterDetails = attDetails.stream().filter(AttDetailsDto::isStorage).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterDetails)) {
            attFileGroupDto.setMsgWithStatus(this.allSealError(), 2);
            return null;
        }
        if (!this.isBatchGeneration.booleanValue() && filterDetails.size() != attDetails.size()) {
            attFileGroupDto.setMsgWithStatus(this.sealError(), 2);
            return null;
        }
        return filterDetails;
    }

    private List<AttDetailsDto> mergeData(List<AttDetailsDto> attDetails, List<AttDetailsDto> qtDetails) {
        if (WTCCollections.isNotEmpty(attDetails)) {
            if (WTCCollections.isNotEmpty(qtDetails)) {
                attDetails.addAll(qtDetails);
            }
            return attDetails;
        }
        return qtDetails;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AttDetailsDto> getAttDataInfo() {
        try (Span initSpan = TaskTracer.newSpan((String)IntegrationKDString.spanAttRecordQuery());){
            if ("A".equals(this.dataSource)) {
                List<AttDetailsDto> attRecordData = this.attRecordService.getAttRecordData();
                this.recordBeforeOperate(attRecordData, false);
                List<AttDetailsDto> list = attRecordData;
                return list;
            }
            if ("B".equals(this.dataSource)) {
                List<AttDetailsDto> attPeriodSumData = this.attRecordService.getAttPeriodSumData();
                this.periodSumBeforeOperate(attPeriodSumData);
                List<AttDetailsDto> list = attPeriodSumData;
                return list;
            }
            List<AttDetailsDto> list = Collections.emptyList();
            return list;
        }
    }

    private void periodSumBeforeOperate(List<AttDetailsDto> attPeriodSumData) {
        if (WTCCollections.isNotEmpty(attPeriodSumData)) {
            for (AttDetailsDto attDetailsDto : attPeriodSumData) {
                PerAttPeriodAndStateInfo periodAndStateInfo = this.getPeriodAndStateInfo(attDetailsDto.getAttFileBoId());
                if (null == periodAndStateInfo) {
                    log.warn("AttDataGenServiceImpl_getTargetPerAttPeriod_null_version_{}_boId_{}", (Object)this.getVersion(), (Object)attDetailsDto.getAttFileBoId());
                    continue;
                }
                attDetailsDto.setIsAccount(attDetailsDto.getSumEndDate(), periodAndStateInfo.getStorageTo());
                AttStateInfo attStateInfo = this.getTargetPerAttPeriod((List<AttStateInfo>)periodAndStateInfo.getAttStateInfoList(), attDetailsDto.getAttPerAttPeriodPk());
                if (null == attStateInfo) {
                    log.warn("AttDataGenServiceImpl_getTargetPerAttPeriod_null_version_{}_boId_{}_ownDate_{}", new Object[]{this.getVersion(), attDetailsDto.getAttFileBoId(), attDetailsDto.getOwnDate()});
                    continue;
                }
                attDetailsDto.setSettleInfoId(attStateInfo.getId());
                attDetailsDto.setStorageDate(attStateInfo.getStorageTime());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AttDetailsDto> getQtDataInfo() {
        try (Span initSpan = TaskTracer.newSpan((String)IntegrationKDString.spanQtRecordQuery());){
            if (this.isSendQtData) {
                List<AttDetailsDto> qtDateInfo = this.qtDateService.getQtDataInfo();
                this.recordBeforeOperate(qtDateInfo, true);
                List<AttDetailsDto> list = qtDateInfo;
                return list;
            }
            List<AttDetailsDto> list = Collections.emptyList();
            return list;
        }
    }

    private void recordBeforeOperate(List<AttDetailsDto> dataInfo, boolean isQtData) {
        if (WTCCollections.isNotEmpty(dataInfo)) {
            for (AttDetailsDto attDetailsDto : dataInfo) {
                PerAttPeriodAndStateInfo periodAndStateInfo = this.getPeriodAndStateInfo(attDetailsDto.getAttFileBoId());
                if (null == periodAndStateInfo) {
                    log.warn("AttDataGenServiceImpl_getTargetPerAttPeriod_null_version_{}_boId_{}", (Object)this.getVersion(), (Object)attDetailsDto.getAttFileBoId());
                    continue;
                }
                attDetailsDto.setIsAccount(attDetailsDto.getOwnDate(), periodAndStateInfo.getStorageTo());
                AttStateInfo attStateInfo = this.getTargetPerAttPeriod((List<AttStateInfo>)periodAndStateInfo.getAttStateInfoList(), attDetailsDto.getOwnDate());
                if (null == attStateInfo) {
                    log.warn("AttDataGenServiceImpl_getTargetPerAttPeriod_null_version_{}_boid_{}_ownDate_{}", new Object[]{this.getVersion(), attDetailsDto.getAttFileBoId(), attDetailsDto.getOwnDate()});
                    continue;
                }
                PerAttPeriod perAttPeriod = attStateInfo.getPerAttPeriod();
                attDetailsDto.setAttPerAttPeriodPk(perAttPeriod.getPrimaryId());
                attDetailsDto.setSumBeginDate(perAttPeriod.getPerAttBeginDate());
                attDetailsDto.setSumEndDate(perAttPeriod.getPerAttEndDate());
                attDetailsDto.setSettleInfoId(attStateInfo.getId());
                attDetailsDto.setStorageDate(attStateInfo.getStorageTime());
                if (!isQtData) continue;
                attDetailsDto.setAttFileId(perAttPeriod.getFileId());
            }
        }
    }

    private List<AttFileGroupDto> getDataInfo() {
        ArrayList groupDtoList = Lists.newArrayListWithExpectedSize((int)this.attFileBoIds.size());
        List<AttDetailsDto> attDetailsLists = this.getAttDataInfo();
        List<AttDetailsDto> qtDateInfo = this.getQtDataInfo();
        Set<Long> discardAttFileBoIds = this.getDiscardAttFileBoIds();
        Map<Long, List<AttDetailsDto>> attDetailMap = attDetailsLists.stream().collect(Collectors.groupingBy(AttDetailsDto::getAttFileBoId));
        Map<Long, List<AttDetailsDto>> qtDetailMap = qtDateInfo.stream().collect(Collectors.groupingBy(AttDetailsDto::getAttFileBoId));
        for (Long attFileBoId : this.attFileBoIds) {
            List<AttDetailsDto> qtDetails;
            AttFileGroupDto attFileGroupDto = new AttFileGroupDto();
            attFileGroupDto.setAttfileid(attFileBoId);
            if (discardAttFileBoIds.contains(attFileBoId)) {
                attFileGroupDto.setMsgWithStatus(this.attFileDiscardError(), 2);
                groupDtoList.add(attFileGroupDto);
                continue;
            }
            List<AttDetailsDto> attDetails = attDetailMap.get(attFileBoId);
            if (this.isEmpty(attDetails, qtDetails = qtDetailMap.get(attFileBoId))) {
                attFileGroupDto.setMsgWithStatus(this.notResultError(), 2);
                groupDtoList.add(attFileGroupDto);
                continue;
            }
            if (this.overlapCheck(attDetails, qtDetails)) {
                attFileGroupDto.setMsgWithStatus(this.overlapError(), 2);
                groupDtoList.add(attFileGroupDto);
                continue;
            }
            List<AttDetailsDto> allDetails = this.mergeData(attDetails, qtDetails);
            List<AttDetailsDto> filterDetails = this.filterDetails(attFileGroupDto, allDetails);
            if (!attFileGroupDto.isSuccess() || WTCCollections.isEmpty(filterDetails)) {
                groupDtoList.add(attFileGroupDto);
                continue;
            }
            attFileGroupDto.setStatus(1);
            attFileGroupDto.setAttDetails(this.dataOperate(filterDetails));
            groupDtoList.add(attFileGroupDto);
        }
        return groupDtoList;
    }

    private List<AttDetailsDto> dataOperate(List<AttDetailsDto> filterDetails) {
        if ("A".equals(this.dataSource)) {
            if (this.isSumComp) {
                return this.attFileVIdSumValue(filterDetails);
            }
            return this.detailOperate(filterDetails);
        }
        if ("B".equals(this.dataSource)) {
            return this.periodSumValue(filterDetails);
        }
        return Collections.emptyList();
    }

    private List<AttDetailsDto> detailOperate(List<AttDetailsDto> filterDetails) {
        for (AttDetailsDto attDetailsDto : filterDetails) {
            attDetailsDto.setSumBeginDate(attDetailsDto.getOwnDate());
            attDetailsDto.setSumEndDate(attDetailsDto.getOwnDate());
            attDetailsDto.setValue(this.scale(attDetailsDto.getValue(), attDetailsDto.getDataAccuracy(), attDetailsDto.getPrecisionTail()));
        }
        return filterDetails;
    }
}

