/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.attdata.service.IAttDataPushService;
import kd.wtc.wtis.business.attdata.service.IntegrationService;
import kd.wtc.wtis.business.punchcarddata.WTISSystemParamQueryUtil;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.entity.AttPushAndValidResp;

@SingletonBean
public class AttDataPushServiceImpl
implements IAttDataPushService {
    private final HRBaseServiceHelper attDataGenerateServiceHelper = new HRBaseServiceHelper("wtis_payattpushtask");

    @Override
    public void dispatch(AbstractFormPlugin abstractFormPlugin, DynamicObject[] attDatas, List<Long> attFileList) {
        IListView listView = (IListView)abstractFormPlugin.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            idList.add(selectedRow.getPrimaryKeyValue());
        }
        if (attDatas == null || attDatas.length == 0) {
            return;
        }
        if (idList.size() != 1 || attDatas.length != 1) {
            listView.showTipNotification(IntegrationKDString.pushSingleError());
            return;
        }
        DynamicObject attData = attDatas[0];
        AttPushAndValidResp pushResp = this.dispatch(attData.getString("version"), null);
        if (!pushResp.isSuccess()) {
            listView.showTipNotification(pushResp.getErrMsg());
            return;
        }
        Map formCache = pushResp.getFormCache();
        formCache.forEach((key, value) -> abstractFormPlugin.getPageCache().put(key, value));
        if (WTCStringUtils.isNotEmpty((String)((String)formCache.get(AttDataIntegrateConstants.ATTFILE_ERR_IDSET_STR)))) {
            this.openStorageConfirm((String)formCache.get(AttDataIntegrateConstants.ATTFILE_ERR_IDSET_STR), pushResp.getAllAttfileBid(), abstractFormPlugin);
        } else {
            this.openPushScopeConfirm(abstractFormPlugin);
        }
    }

    @Override
    public AttPushAndValidResp dispatch(String version, String pushType) {
        if (WTCStringUtils.isEmpty((String)version)) {
            return new AttPushAndValidResp(IntegrationKDString.paramNotValidError());
        }
        DynamicObject attData = this.attDataGenerateServiceHelper.loadDynamicObject(new QFilter("version", "=", (Object)version).toArray());
        AttPushAndValidResp pushResp = this.getErrPushList(attData);
        if (!pushResp.isSuccess()) {
            return pushResp;
        }
        ArrayList allAttfileBid = Lists.newArrayListWithExpectedSize((int)16);
        HashMap<String, String> formCache = new HashMap<String, String>(5);
        Set<String> attfileErrorIdSet = this.getErrorStorageDateAttfile(attData, allAttfileBid);
        pushResp.setAttfileErrorIdSet(attfileErrorIdSet);
        pushResp.setAllAttfileBid((List)allAttfileBid);
        formCache.put(AttDataIntegrateConstants.TASK_ID, attData.getString("id"));
        formCache.put(AttDataIntegrateConstants.TASK_VERSION, attData.getString("version"));
        formCache.put("specialset", attData.getString("integrationrule.specialset"));
        formCache.put(AttDataIntegrateConstants.INTEGRATIONRULE_DATASOURCE, HRStringUtils.equals((String)attData.getString(AttDataIntegrateConstants.INTEGRATIONRULE_DATASOURCE), (String)"A") && !attData.getBoolean(AttDataIntegrateConstants.IS_SUM_COMP) ? "2" : "1");
        formCache.put(AttDataIntegrateConstants.ATTFILE_ERR_IDSET_STR, WTCCollections.isNotEmpty(attfileErrorIdSet) ? WTCStringUtils.join(new ArrayList<String>(attfileErrorIdSet), (String)",") : null);
        pushResp.setFormCache(formCache);
        if (WTCStringUtils.isNotEmpty((String)pushType)) {
            IntegrationService.getInstance().dispatch(this.builtParamsMap(pushType, (String)formCache.get(AttDataIntegrateConstants.TASK_ID), (String)formCache.get(AttDataIntegrateConstants.TASK_VERSION), (String)formCache.get(AttDataIntegrateConstants.ATTFILE_ERR_IDSET_STR), (String)formCache.get("specialset"), (String)formCache.get(AttDataIntegrateConstants.INTEGRATIONRULE_DATASOURCE)), null);
        }
        return pushResp;
    }

    @Override
    public void closeBack(AbstractFormPlugin abstractFormPlugin, ClosedCallBackEvent closedCallBackEvent) {
        if (AttDataIntegrateConstants.PAGE_WTIS_PUSHCONFIRM.equals(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() != null) {
                IntegrationService.getInstance().dispatch(this.builtParamsMap(closedCallBackEvent.getReturnData(), abstractFormPlugin.getPageCache().get(AttDataIntegrateConstants.TASK_ID), abstractFormPlugin.getPageCache().get(AttDataIntegrateConstants.TASK_VERSION), abstractFormPlugin.getPageCache().get(AttDataIntegrateConstants.ATTFILE_ERR_IDSET_STR), abstractFormPlugin.getPageCache().get("specialset"), abstractFormPlugin.getPageCache().get(AttDataIntegrateConstants.INTEGRATIONRULE_DATASOURCE)), abstractFormPlugin);
            }
        } else if (AttDataIntegrateConstants.PAGE_WTIS_STORAGE_CONFIRM.equals(closedCallBackEvent.getActionId())) {
            if ("success".equals(closedCallBackEvent.getReturnData())) {
                this.openPushScopeConfirm(abstractFormPlugin);
            }
        } else if (WTCStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData(), abstractFormPlugin);
        }
    }

    private void taskCallBack(Object returnData, AbstractFormPlugin abstractFormPlugin) {
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            Object taskInfoStringResult = result.get("taskinfo");
            if (taskInfoStringResult == null) {
                return;
            }
            if (taskInfoStringResult instanceof String) {
                this.openPushResultView(taskInfoStringResult, abstractFormPlugin);
            }
        }
    }

    private void openPushResultView(Object taskInfoStringResult, AbstractFormPlugin abstractFormPlugin) {
        IListView listView = (IListView)abstractFormPlugin.getView();
        String taskInfoStr = (String)taskInfoStringResult;
        if (WTCStringUtils.isNotEmpty((String)taskInfoStr)) {
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (TaskClientProxy.isExistTask((String)taskInfo.getId())) {
                listView.invokeOperation("refresh");
                return;
            }
            if (taskInfo.isTaskEnd()) {
                this.openPushResult(taskInfo.getData(), abstractFormPlugin);
                listView.invokeOperation("refresh");
            }
        }
    }

    private void openPushResult(String data, AbstractFormPlugin abstractFormPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtis_pushresult");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)abstractFormPlugin, "wtis_pushresult"));
        formShowParameter.setCustomParam("data", (Object)data);
        IListView listView = (IListView)abstractFormPlugin.getView();
        listView.showForm(formShowParameter);
    }

    private Map<String, Object> builtParamsMap(Object pushType, String taskId, String taskVersion, String attFileErrIdSetStr, String specialSet, String dataSource) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        params.put(AttDataIntegrateConstants.TASK_ID, taskId);
        params.put("currentUserId", currentUserId);
        params.put(AttDataIntegrateConstants.ATTFILE_ERR_IDSET_STR, attFileErrIdSetStr);
        params.put(AttDataIntegrateConstants.TASK_VERSION, taskVersion);
        params.put("pushType", pushType);
        params.put("specialSet", specialSet);
        params.put(AttDataIntegrateConstants.INTEGRATIONRULE_DATASOURCE, dataSource);
        params.put(AttDataIntegrateConstants.TASK_CLASS_NAME, "kd.wtc.wtis.business.attdata.task.AttDataPushTask");
        params.put(AttDataIntegrateConstants.CLICK_CLASS_NAME, "kd.wtc.wtis.business.attdata.task.click.PushTaskClick");
        params.put(AttDataIntegrateConstants.ACTION_ID, "taskcloseback");
        params.put(AttDataIntegrateConstants.TITLE_NAME, IntegrationKDString.pushGenerateData((String)((String)params.get(AttDataIntegrateConstants.TASK_VERSION))));
        return params;
    }

    private void openStorageConfirm(String attfileErrorIdSet, List<Object> allAttfileBid, AbstractFormPlugin abstractFormPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(AttDataIntegrateConstants.PAGE_WTIS_STORAGE_CONFIRM);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(AttDataIntegrateConstants.ATTFILE_ERR_IDSET_STR, (Object)attfileErrorIdSet);
        formShowParameter.setCustomParam("allAttfileNum", (Object)String.valueOf(allAttfileBid.size()));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)abstractFormPlugin, AttDataIntegrateConstants.PAGE_WTIS_STORAGE_CONFIRM));
        IListView listView = (IListView)abstractFormPlugin.getView();
        listView.showForm(formShowParameter);
    }

    private void openPushScopeConfirm(AbstractFormPlugin abstractFormPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(AttDataIntegrateConstants.PAGE_WTIS_PUSHCONFIRM);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)abstractFormPlugin, AttDataIntegrateConstants.PAGE_WTIS_PUSHCONFIRM));
        IListView listView = (IListView)abstractFormPlugin.getView();
        listView.showForm(formShowParameter);
    }

    private AttPushAndValidResp getErrPushList(DynamicObject attData) {
        String integrateBusStatus;
        Long taskId;
        List<Long> cacheList;
        if (null == attData) {
            return new AttPushAndValidResp(IntegrationKDString.taskNotExistError());
        }
        if (attData.getInt("succeedattperson") <= 0) {
            return new AttPushAndValidResp(IntegrationKDString.noSucceedAttPersonError());
        }
        HashSet errMsg = Sets.newHashSetWithExpectedSize((int)16);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String version = attData.getString("version");
        long creatorId = attData.getLong("creator.id");
        if (creatorId != currentUserId) {
            errMsg.add(IntegrationKDString.pushMySelfIntegrate((String)version));
        }
        if ((cacheList = IntegrationService.getInstance().getCacheList()).contains(taskId = Long.valueOf(attData.getLong("id")))) {
            errMsg.add(IntegrationKDString.pushCom((String)version));
        }
        if (AttDataIntegrateConstants.RUNNING.equals(integrateBusStatus = attData.getString(AttDataIntegrateConstants.INTEGRATEBUSSTATUS))) {
            Date lastPushTime = attData.getDate(AttDataIntegrateConstants.LAST_PUSH_TIME);
            int pushLapse = WTISSystemParamQueryUtil.getPushLapse();
            if (lastPushTime != null && HRDateTimeUtils.addMinute((Date)lastPushTime, (long)pushLapse).compareTo(HRDateTimeUtils.getNowDateTime()) >= 0) {
                errMsg.add(IntegrationKDString.resetPushSplit((String)version, (int)pushLapse));
            }
        } else if (!AttDataIntegrateConstants.NOTEXECUTE.equals(integrateBusStatus)) {
            errMsg.add(IntegrationKDString.pushCom((String)version));
        }
        if (WTCCollections.isNotEmpty((Collection)errMsg)) {
            return new AttPushAndValidResp(this.getErrorMsg(errMsg));
        }
        return new AttPushAndValidResp(attData.getLong("id"));
    }

    private String getErrorMsg(Set<String> errorMsgList) {
        StringBuilder msg = new StringBuilder();
        for (String errorMsg : errorMsgList) {
            msg.append(errorMsg).append("\r\n");
        }
        return msg.toString();
    }

    private Set<String> getErrorStorageDateAttfile(DynamicObject attData, List<Object> allAttfileBid) {
        HashSet attfileErrorId = Sets.newHashSetWithExpectedSize((int)16);
        if (this.isExistSpecal(attData, AttDataIntegrateConstants.SPECIAL_SET_D)) {
            QFilter idfilter;
            HRBaseServiceHelper settleInfoServiceHelper;
            DynamicObject[] settleInfos;
            String version = attData.getString("version");
            QFilter filter = new QFilter("number", "=", (Object)version);
            filter.and(new QFilter("generstatus", "=", (Object)AttDataIntegrateConstants.GENSTATU_ONE));
            HRBaseServiceHelper attDataInfoServiceHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
            DynamicObject[] attDataDets = attDataInfoServiceHelper.queryOriginalArray("settleinfo,attfilebase,sealopertime", filter.toArray());
            if (attDataDets != null && attDataDets.length != 0 && (settleInfos = (settleInfoServiceHelper = new HRBaseServiceHelper("wtte_settleinfo")).queryOriginalArray("id,busstatus,storagedate", new QFilter[]{idfilter = new QFilter("id", "in", Arrays.asList(attDataDets).stream().map(ob -> ob.getLong("settleinfo")).collect(Collectors.toSet()))})) != null && settleInfos.length != 0) {
                Map<Long, List<DynamicObject>> settleInfosMap = Arrays.asList(settleInfos).stream().collect(Collectors.groupingBy(ob -> ob.getLong("id")));
                Map<Long, List<DynamicObject>> attfileDeatilMap = Arrays.asList(attDataDets).stream().collect(Collectors.groupingBy(ob -> ob.getLong("attfilebase")));
                allAttfileBid.addAll(attfileDeatilMap.keySet());
                this.builtAttfileErrorIds(attfileDeatilMap, attfileErrorId, settleInfosMap);
            }
        }
        return attfileErrorId;
    }

    private boolean isExistSpecal(DynamicObject attData, String matchValue) {
        String matchStr = attData.getString("integrationrule.specialset");
        if (matchStr == null) {
            return false;
        }
        return matchStr.contains(matchValue);
    }

    private void builtAttfileErrorIds(Map<Long, List<DynamicObject>> attfileDeatilMap, Set<String> attfileErrorId, Map<Long, List<DynamicObject>> settleInfosMap) {
        for (Map.Entry<Long, List<DynamicObject>> detail : attfileDeatilMap.entrySet()) {
            DynamicObject dynamicObject;
            if (WTCCollections.isEmpty((Collection)detail.getValue()) || (dynamicObject = detail.getValue().get(0)) == null) continue;
            String attfileId = String.valueOf(dynamicObject.get("attfilebase"));
            List<DynamicObject> settleDynamicObjectList = settleInfosMap.get(dynamicObject.getLong("settleinfo"));
            if (WTCCollections.isEmpty(settleDynamicObjectList)) {
                attfileErrorId.add(attfileId);
                break;
            }
            DynamicObject settleDynamicObject = settleDynamicObjectList.get(0);
            String busStatus = settleDynamicObject.getString("busstatus");
            Date sealOperTime = dynamicObject.getDate("sealopertime");
            Date storageDate = settleDynamicObject.getDate("storagedate");
            if (!HRStringUtils.equals((String)busStatus, (String)"0") && this.isMatchOperTime(sealOperTime, storageDate)) continue;
            attfileErrorId.add(attfileId);
        }
    }

    private boolean isMatchOperTime(Date sealOperTime, Date storageDate) {
        if (sealOperTime == null || storageDate == null) {
            return false;
        }
        return sealOperTime.compareTo(storageDate) == 0;
    }
}

