/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtis.business.attdata.service.IAttDataPushService;
import kd.wtc.wtis.business.attdata.service.IntegrationService;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;

@SingletonBean
public class AttDataWithDrawServiceImpl
implements IAttDataPushService {
    @Override
    public void dispatch(AbstractFormPlugin abstractFormPlugin, DynamicObject[] attDatas, List<Long> attFileList) {
        if (!this.checkWithDraw(attDatas, abstractFormPlugin, attFileList)) {
            return;
        }
        this.withDraw(attDatas[0], abstractFormPlugin, attFileList);
    }

    @Override
    public void closeBack(AbstractFormPlugin abstractFormPlugin, ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)AttDataIntegrateConstants.WITH_DRAW_TASK_CLOSEBACK)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map) {
                Map result = (Map)returnData;
                Object taskInfoStringResult = result.get(AttDataIntegrateConstants.TASKINFO);
                if (taskInfoStringResult == null) {
                    return;
                }
                if (taskInfoStringResult instanceof String) {
                    this.openResultView(taskInfoStringResult, abstractFormPlugin);
                }
            }
        }
    }

    private void openResultView(Object taskInfoStringResult, AbstractFormPlugin abstractFormPlugin) {
        IFormView iFormView = abstractFormPlugin.getView();
        String taskInfoStr = (String)taskInfoStringResult;
        if (StringUtils.isNotBlank((CharSequence)taskInfoStr)) {
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (TaskClientProxy.isExistTask((String)taskInfo.getId())) {
                iFormView.invokeOperation("refresh");
                return;
            }
            if (taskInfo.isTaskEnd()) {
                String data = taskInfo.getData();
                if (!WTCStringUtils.isEmpty((String)data)) {
                    Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                    if (WTCCollections.isEmpty((Map)dataMap)) {
                        iFormView.showErrorNotification(IntegrationKDString.withDrawDataError());
                        return;
                    }
                    HRBaseServiceHelper withDrawTaskHelper = new HRBaseServiceHelper(AttDataIntegrateConstants.PAGE_WTIS_WITHDRAWTASK);
                    withDrawTaskHelper.deleteOne(dataMap.get(AttDataIntegrateConstants.SUBTASKID));
                }
                IntegrationService.getInstance().openResultView(taskInfo.getData(), abstractFormPlugin.getView());
                iFormView.invokeOperation("refresh");
            }
        }
    }

    private boolean checkWithDraw(DynamicObject[] attDatas, AbstractFormPlugin abstractFormPlugin, List<Long> attFileList) {
        int successNum;
        if (attDatas == null || attDatas.length == 0) {
            return false;
        }
        IFormView iFormView = abstractFormPlugin.getView();
        if (iFormView instanceof IListView && attDatas.length != 1) {
            iFormView.showTipNotification(IntegrationKDString.withDrawSingleError());
            return false;
        }
        DynamicObject attData = attDatas[0];
        long currentUserId = UserServiceHelper.getCurrentUserId();
        long creatorId = attData.getLong("creator.id");
        if (creatorId != currentUserId) {
            iFormView.showTipNotification(IntegrationKDString.drawMySelfIntegrate());
            return false;
        }
        String integrateStatus = attData.getString("integratestatus");
        String integRateBusStatus = attData.getString(AttDataIntegrateConstants.INTEGRATEBUSSTATUS);
        if ("B".equals(integrateStatus) || "A".equals(integrateStatus) || WTCStringUtils.equals((String)integRateBusStatus, (String)WTCTaskBusinessStatusEnum.FAILED.getSign()) || WTCStringUtils.equals((String)integRateBusStatus, (String)WTCTaskBusinessStatusEnum.UNEXECUTED.getSign())) {
            iFormView.showTipNotification(IntegrationKDString.WithDrawOfSuccess());
            return false;
        }
        if (!(iFormView instanceof IListView) && WTCCollections.isEmpty(attFileList)) {
            iFormView.showTipNotification(IntegrationKDString.leastOne());
            return false;
        }
        if (HRStringUtils.equals((String)"C", (String)integrateStatus) && (successNum = attData.getInt("insuccessnum")) == 0) {
            if (attFileList != null) {
                iFormView.showTipNotification(IntegrationKDString.withDrawError());
            } else {
                iFormView.showTipNotification(IntegrationKDString.notValiteDrawDataError());
            }
            return false;
        }
        return true;
    }

    private List<Long> getIntegrateSuccessFile(Long taskId, List<Long> attFileList, IFormView iFormView) {
        QFilter taskIdQFilter = new QFilter("taskid", "=", (Object)taskId);
        if (attFileList != null) {
            taskIdQFilter.and(new QFilter("attfileboid", "in", attFileList));
        }
        QFilter statueQFilter = new QFilter("integrstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{AttDataIntegrateConstants.INTEGRATESTATU_TWO, AttDataIntegrateConstants.INTEGRATESTATU_FOUR}));
        HRBaseServiceHelper attDataDetServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject[] integratestatuses = attDataDetServiceHelper.queryOriginalArray("integrstatus,attfileboid", new QFilter[]{taskIdQFilter, statueQFilter});
        List<Long> detailList = Arrays.stream(integratestatuses).map(dyn -> dyn.getLong("attfileboid")).collect(Collectors.toList());
        if (WTCCollections.isEmpty(detailList)) {
            if (attFileList != null) {
                iFormView.showTipNotification(IntegrationKDString.withDrawError());
            } else {
                iFormView.showTipNotification(IntegrationKDString.notValiteDrawDataError());
            }
        }
        return detailList;
    }

    private void withDraw(DynamicObject attData, AbstractFormPlugin abstractFormPlugin, List<Long> attFileList) {
        Long taskId = attData.getLong("id");
        IFormView iFormView = abstractFormPlugin.getView();
        List<Long> detailList = this.getIntegrateSuccessFile(taskId, attFileList, abstractFormPlugin.getView());
        if (WTCCollections.isEmpty(detailList)) {
            return;
        }
        if (!WTCCollections.isEmpty(attFileList) && attFileList.size() != detailList.size()) {
            iFormView.showTipNotification(IntegrationKDString.withDrawError());
            return;
        }
        List<Long> cacheList = IntegrationService.getInstance().getCacheList();
        ArrayList commonList = Lists.newArrayListWithExpectedSize((int)1);
        this.dealCommonNUmber(taskId, cacheList, commonList);
        IntegrationService.getInstance().refreshCache(cacheList);
        if (!WTCCollections.isEmpty((Collection)commonList)) {
            iFormView.showSuccessNotification(IntegrationKDString.allWithDraw());
            return;
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put(AttDataIntegrateConstants.TASK_CLASS_NAME, "kd.wtc.wtis.business.attdata.task.WithDrawAttDataTask");
        params.put(AttDataIntegrateConstants.CLICK_CLASS_NAME, "kd.wtc.wtis.business.attdata.task.click.WithDrawTaskClick");
        params.put(AttDataIntegrateConstants.ACTION_ID, AttDataIntegrateConstants.WITH_DRAW_TASK_CLOSEBACK);
        params.put(AttDataIntegrateConstants.TITLE_NAME, IntegrationKDString.withDrawData((String)attData.getString("version")));
        params.put(AttDataIntegrateConstants.TASK_ID, String.valueOf(taskId));
        params.put("version", attData.getString("version"));
        params.put(AttDataIntegrateConstants.SUBTASKID, DB.genLongId((String)AttDataIntegrateConstants.PAGE_WTIS_WITHDRAWTASK));
        if (!WTCCollections.isEmpty(detailList)) {
            params.put(AttDataIntegrateConstants.ATTFILE\uff3fLIST\uff3fSTR, SerializationUtils.toJsonString(detailList));
        }
        IntegrationService.getInstance().dispatch(params, abstractFormPlugin);
    }

    private void dealCommonNUmber(Long taskId, List<Long> cacheList, List<Long> commonList) {
        if (cacheList.contains(taskId)) {
            commonList.add(taskId);
        } else {
            cacheList.add(taskId);
        }
    }
}

